/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk;

import com.sun.glass.ui.gtk.DesktopEnvironment;
import com.sun.javafx.application.PlatformImpl;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

enum WindowDecorationTheme {
    GNOME("WindowDecorationGnome.css"),
    KDE("WindowDecorationKDE.css");

    private static final String THEME_NAME_KEY = "GTK.theme_name";
    private static final Map<String, WindowDecorationTheme> SIMILAR_THEMES;
    private final String stylesheet;

    private WindowDecorationTheme(String string2) {
        this.stylesheet = string2;
    }

    public static WindowDecorationTheme findBestTheme() {
        Optional<WindowDecorationTheme> optional = PlatformImpl.getPlatformPreferences().getString(THEME_NAME_KEY).map(string -> {
            for (Map.Entry<String, WindowDecorationTheme> entry : SIMILAR_THEMES.entrySet()) {
                if (!string.toLowerCase(Locale.ROOT).startsWith(entry.getKey())) continue;
                return entry.getValue();
            }
            return null;
        });
        return optional.orElse(switch (DesktopEnvironment.current()) {
            case DesktopEnvironment.GNOME -> GNOME;
            case DesktopEnvironment.KDE -> KDE;
            default -> GNOME;
        });
    }

    public String getStylesheet() {
        URL uRL = ((Object)((Object)this)).getClass().getResource(this.stylesheet);
        if (uRL == null) {
            throw new RuntimeException("Resource not found: " + this.stylesheet);
        }
        return uRL.toExternalForm();
    }

    static {
        SIMILAR_THEMES = Map.of("adwaita", GNOME, "yaru", GNOME, "breeze", KDE);
    }
}

