/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.javafx.print.PrintHelper;
import com.sun.javafx.print.PrinterImpl;
import com.sun.javafx.print.PrinterJobImpl;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.PrintPipeline;
import com.sun.prism.j2d.PrismPrintGraphics;
import com.sun.prism.j2d.print.J2DPrinter;
import com.sun.prism.j2d.print.J2DPrinterJob;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.print.Printer;
import javafx.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public final class PrismPrintPipeline
extends PrintPipeline {
    private static Printer defaultPrinter = null;
    private static final NameComparator nameComparator = new NameComparator();
    private static HashMap<PrintService, Printer> pMap = new HashMap();
    private static long lastTime = 0L;
    private static ObservableSet<Printer> printerSet = null;
    private static ObservableSet<Printer> returnedPrinterSet = null;

    public static PrintPipeline getInstance() {
        return new PrismPrintPipeline();
    }

    public boolean printNode(NGNode nGNode, int n, int n2, Graphics graphics) {
        PrismPrintGraphics prismPrintGraphics = new PrismPrintGraphics((Graphics2D)graphics, n, n2);
        nGNode.render(prismPrintGraphics);
        return true;
    }

    @Override
    public PrinterJobImpl createPrinterJob(PrinterJob printerJob) {
        return new J2DPrinterJob(printerJob);
    }

    @Override
    public synchronized Printer getDefaultPrinter() {
        if (defaultPrinter == null) {
            PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
            if (printService == null) {
                defaultPrinter = null;
            } else if (printerSet == null) {
                J2DPrinter j2DPrinter = new J2DPrinter(printService);
                defaultPrinter = PrintHelper.createPrinter(j2DPrinter);
            } else {
                for (Printer printer : printerSet) {
                    PrinterImpl printerImpl = PrintHelper.getPrinterImpl(printer);
                    J2DPrinter j2DPrinter = (J2DPrinter)printerImpl;
                    if (!j2DPrinter.getService().equals(printService)) continue;
                    defaultPrinter = printer;
                    break;
                }
            }
        }
        return defaultPrinter;
    }

    @Override
    public synchronized ObservableSet<Printer> getAllPrinters() {
        if (returnedPrinterSet == null) {
            PrintService[] printServiceArray;
            TreeSet<Printer> treeSet = new TreeSet<Printer>(nameComparator);
            Printer printer = this.getDefaultPrinter();
            PrintService printService = null;
            if (printer != null) {
                printServiceArray = (PrintService[])PrintHelper.getPrinterImpl(printer);
                printService = printServiceArray.getService();
            }
            printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
            for (int i = 0; i < printServiceArray.length; ++i) {
                if (printService != null && printService.equals(printServiceArray[i])) {
                    treeSet.add(printer);
                    pMap.put(printService, printer);
                    continue;
                }
                this.addNew(printServiceArray[i], treeSet);
            }
            printerSet = FXCollections.observableSet(treeSet);
            returnedPrinterSet = FXCollections.unmodifiableObservableSet(printerSet);
            lastTime = System.currentTimeMillis();
        } else {
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
            if (printServiceArray.length != printerSet.size() || lastTime + 120000L < System.currentTimeMillis()) {
                this.updatePrinters(printServiceArray);
                lastTime = System.currentTimeMillis();
            }
        }
        return returnedPrinterSet;
    }

    private void addNew(PrintService printService, Set<Printer> set) {
        J2DPrinter j2DPrinter = new J2DPrinter(printService);
        Printer printer = PrintHelper.createPrinter(j2DPrinter);
        j2DPrinter.setPrinter(printer);
        set.add(printer);
        pMap.put(printService, printer);
    }

    private void updatePrinters(PrintService[] printServiceArray) {
        PrintService[] printServiceArray2;
        Set<PrintService> set = pMap.keySet();
        for (PrintService printService : printServiceArray2 = set.toArray(new PrintService[0])) {
            boolean bl = false;
            for (PrintService printService2 : printServiceArray) {
                if (!printService.equals(printService2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            Printer printer = pMap.get(printService);
            pMap.remove(printService);
            printerSet.remove((Object)printer);
        }
        for (PrintService printService : printServiceArray) {
            if (pMap.containsKey(printService)) continue;
            this.addNew(printService, (Set<Printer>)printerSet);
        }
        PrintService[] printServiceArray3 = defaultPrinter == null ? null : ((J2DPrinter)PrintHelper.getPrinterImpl(defaultPrinter)).getService();
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        if (printService != null) {
            if (printServiceArray3 == null || !printServiceArray3.equals(printService)) {
                defaultPrinter = PrismPrintPipeline.findDefaultPrinter(printerSet, printService);
            }
        } else {
            defaultPrinter = null;
        }
    }

    private static Printer findDefaultPrinter(Set<Printer> set, PrintService printService) {
        for (Printer printer : set) {
            PrintService printService2 = ((J2DPrinter)PrintHelper.getPrinterImpl(printer)).getService();
            if (!printService2.getName().equals(printService.getName())) continue;
            return printer;
        }
        return null;
    }

    static class NameComparator
    implements Comparator<Printer> {
        NameComparator() {
        }

        @Override
        public int compare(Printer printer, Printer printer2) {
            return printer.getName().compareTo(printer2.getName());
        }
    }
}

