/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.SubPropertyConverter;
import com.sun.javafx.scene.layout.region.BorderImageSlices;
import com.sun.javafx.scene.layout.region.Margins;
import com.sun.javafx.scene.layout.region.RepeatStruct;
import java.util.List;
import java.util.Map;
import javafx.animation.Interpolatable;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.scene.image.Image;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderImage;
import javafx.scene.layout.BorderRepeat;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

class BorderConverter
extends StyleConverter<ParsedValue[], Border>
implements SubPropertyConverter<Border> {
    private static final BorderConverter BORDER_IMAGE_CONVERTER = new BorderConverter();

    public static BorderConverter getInstance() {
        return BORDER_IMAGE_CONVERTER;
    }

    private BorderConverter() {
    }

    @Override
    public Border convert(Map<CssMetaData<? extends Styleable, ?>, Object> map) {
        BorderWidths borderWidths;
        Interpolatable<Insets> interpolatable;
        Object object;
        Object object2;
        Object object3;
        int n;
        int n2;
        Insets[] insetsArray;
        int n3;
        Interpolatable<CornerRadii>[] interpolatableArray;
        int n4;
        Interpolatable<Margins>[] interpolatableArray2;
        boolean bl;
        Paint[][] paintArray = (Paint[][])map.get(Border.BORDER_COLOR);
        BorderStrokeStyle[][] borderStrokeStyleArray = (BorderStrokeStyle[][])map.get(Border.BORDER_STYLE);
        Object[] objectArray = (Object[])map.get(Border.BORDER_IMAGE_SOURCE);
        boolean bl2 = paintArray != null && paintArray.length > 0 || borderStrokeStyleArray != null && borderStrokeStyleArray.length > 0;
        boolean bl3 = bl = objectArray != null && objectArray.length > 0;
        if (!bl2 && !bl) {
            return null;
        }
        BorderStroke[] borderStrokeArray = null;
        if (bl2) {
            int n5 = paintArray != null ? paintArray.length - 1 : -1;
            int n6 = borderStrokeStyleArray != null ? borderStrokeStyleArray.length - 1 : -1;
            int n7 = (n5 >= n6 ? n5 : n6) + 1;
            Object object4 = map.get(Border.BORDER_WIDTH);
            interpolatableArray2 = object4 == null ? new Margins[]{} : (Margins[])object4;
            n4 = interpolatableArray2.length - 1;
            object4 = map.get(Border.BORDER_RADIUS);
            interpolatableArray = object4 == null ? new CornerRadii[]{} : (CornerRadii[])object4;
            n3 = interpolatableArray.length - 1;
            object4 = map.get(Border.BORDER_INSETS);
            insetsArray = object4 == null ? new Insets[]{} : (Insets[])object4;
            n2 = insetsArray.length - 1;
            for (n = 0; n < n7; ++n) {
                if (n6 < 0) {
                    object3 = new BorderStrokeStyle[4];
                    object3[2] = object3[3] = BorderStrokeStyle.SOLID;
                    object3[1] = object3[3];
                    object3[0] = object3[3];
                } else {
                    object3 = borderStrokeStyleArray[n <= n6 ? n : n6];
                }
                if (object3[0] == BorderStrokeStyle.NONE && object3[1] == BorderStrokeStyle.NONE && object3[2] == BorderStrokeStyle.NONE && object3[3] == BorderStrokeStyle.NONE) continue;
                if (n5 < 0) {
                    object2 = new Paint[4];
                    object2[2] = object2[3] = Color.BLACK;
                    object2[1] = object2[3];
                    object2[0] = object2[3];
                } else {
                    object2 = paintArray[n <= n5 ? n : n5];
                }
                if (borderStrokeArray == null) {
                    borderStrokeArray = new BorderStroke[n7];
                }
                Object object5 = interpolatableArray2.length == 0 ? null : (object = interpolatableArray2[n <= n4 ? n : n4]);
                Interpolatable<CornerRadii> interpolatable2 = interpolatableArray.length == 0 ? CornerRadii.EMPTY : (interpolatable = interpolatableArray[n <= n3 ? n : n3]);
                borderWidths = insetsArray.length == 0 ? null : insetsArray[n <= n2 ? n : n2];
                borderStrokeArray[n] = new BorderStroke(object2[0], object2[1], object2[2], object2[3], object3[0], object3[1], object3[2], object3[3], (CornerRadii)interpolatable, object == null ? BorderStroke.DEFAULT_WIDTHS : new BorderWidths(((Margins)object).getTop(), ((Margins)object).getRight(), ((Margins)object).getBottom(), ((Margins)object).getLeft()), (Insets)((Object)borderWidths));
            }
        }
        BorderImage[] borderImageArray = null;
        if (bl) {
            borderImageArray = new BorderImage[objectArray.length];
            Object object6 = map.get(Border.BORDER_IMAGE_REPEAT);
            RepeatStruct[] repeatStructArray = object6 == null ? new RepeatStruct[]{} : (RepeatStruct[])object6;
            int n8 = repeatStructArray.length - 1;
            object6 = map.get(Border.BORDER_IMAGE_SLICE);
            interpolatableArray2 = object6 == null ? new BorderImageSlices[]{} : (BorderImageSlices[])object6;
            n4 = interpolatableArray2.length - 1;
            object6 = map.get(Border.BORDER_IMAGE_WIDTH);
            interpolatableArray = object6 == null ? new BorderWidths[]{} : (BorderWidths[])object6;
            n3 = interpolatableArray.length - 1;
            object6 = map.get(Border.BORDER_IMAGE_INSETS);
            insetsArray = object6 == null ? new Insets[]{} : (Insets[])object6;
            n2 = insetsArray.length - 1;
            for (n = 0; n < objectArray.length; ++n) {
                Image image;
                if (objectArray[n] == null) continue;
                object3 = BorderRepeat.STRETCH;
                object2 = BorderRepeat.STRETCH;
                if (repeatStructArray.length > 0) {
                    object = repeatStructArray[n <= n8 ? n : n8];
                    object3 = this.convertToBorderRepeat(((RepeatStruct)object).repeatX);
                    object2 = this.convertToBorderRepeat(((RepeatStruct)object).repeatY);
                }
                Object object7 = interpolatableArray2.length > 0 ? interpolatableArray2[n <= n4 ? n : n4] : (object = BorderImageSlices.DEFAULT);
                Insets insets = insetsArray.length > 0 ? insetsArray[n <= n2 ? n : n2] : (interpolatable = Insets.EMPTY);
                borderWidths = interpolatableArray.length > 0 ? interpolatableArray[n <= n3 ? n : n3] : BorderWidths.DEFAULT;
                Object object8 = objectArray[n];
                if (object8 instanceof String) {
                    String string = (String)object8;
                    image = StyleManager.getInstance().getCachedImage(string);
                } else {
                    object8 = objectArray[n];
                    if (object8 instanceof Image) {
                        Image image2;
                        image = image2 = (Image)object8;
                    } else {
                        throw new IllegalArgumentException("Unexpected type: " + objectArray[n].getClass().getName());
                    }
                }
                borderImageArray[n] = new BorderImage(image, borderWidths, (Insets)interpolatable, ((BorderImageSlices)object).widths, ((BorderImageSlices)object).filled, (BorderRepeat)((Object)object3), (BorderRepeat)((Object)object2));
            }
        }
        return borderStrokeArray == null && borderImageArray == null ? null : new Border(borderStrokeArray, borderImageArray);
    }

    @Override
    public Map<CssMetaData<? extends Styleable, ?>, Object> convertBack(Border border) {
        Object object;
        List<BorderStroke> list = border.getStrokes();
        int n = list.size();
        Paint[][] paintArrayArray = new Paint[n][];
        BorderStrokeStyle[][] borderStrokeStyleArrayArray = new BorderStrokeStyle[n][];
        Margins[] marginsArray = new Margins[n];
        CornerRadii[] cornerRadiiArray = new CornerRadii[n];
        Insets[] insetsArray = new Insets[n];
        for (int i = 0; i < n; ++i) {
            BorderStroke borderStroke = list.get(i);
            paintArrayArray[i] = new Paint[4];
            paintArrayArray[i][0] = borderStroke.getTopStroke();
            paintArrayArray[i][1] = borderStroke.getRightStroke();
            paintArrayArray[i][2] = borderStroke.getBottomStroke();
            paintArrayArray[i][3] = borderStroke.getLeftStroke();
            borderStrokeStyleArrayArray[i] = new BorderStrokeStyle[4];
            borderStrokeStyleArrayArray[i][0] = borderStroke.getTopStyle();
            borderStrokeStyleArrayArray[i][1] = borderStroke.getRightStyle();
            borderStrokeStyleArrayArray[i][2] = borderStroke.getBottomStyle();
            borderStrokeStyleArrayArray[i][3] = borderStroke.getLeftStyle();
            object = borderStroke.getWidths();
            marginsArray[i] = new Margins(((BorderWidths)object).getTop(), ((BorderWidths)object).getRight(), ((BorderWidths)object).getBottom(), ((BorderWidths)object).getLeft(), false);
            cornerRadiiArray[i] = borderStroke.getRadii();
            insetsArray[i] = borderStroke.getInsets();
        }
        List<BorderImage> list2 = border.getImages();
        int n2 = list2.size();
        object = new Image[n2];
        RepeatStruct[] repeatStructArray = new RepeatStruct[n2];
        BorderImageSlices[] borderImageSlicesArray = new BorderImageSlices[n2];
        BorderWidths[] borderWidthsArray = new BorderWidths[n2];
        Insets[] insetsArray2 = new Insets[n2];
        for (int i = 0; i < n2; ++i) {
            BorderImage borderImage = list2.get(i);
            object[i] = borderImage.getImage();
            repeatStructArray[i] = new RepeatStruct(this.convertToBackgroundRepeat(borderImage.getRepeatX()), this.convertToBackgroundRepeat(borderImage.getRepeatY()));
            borderImageSlicesArray[i] = new BorderImageSlices(borderImage.getSlices(), borderImage.isFilled());
            borderWidthsArray[i] = borderImage.getWidths();
            insetsArray2[i] = borderImage.getInsets();
        }
        return Map.of(Border.BORDER_COLOR, paintArrayArray, Border.BORDER_STYLE, borderStrokeStyleArrayArray, Border.BORDER_WIDTH, marginsArray, Border.BORDER_RADIUS, cornerRadiiArray, Border.BORDER_INSETS, insetsArray, Border.BORDER_IMAGE_SOURCE, object, Border.BORDER_IMAGE_REPEAT, repeatStructArray, Border.BORDER_IMAGE_SLICE, borderImageSlicesArray, Border.BORDER_IMAGE_WIDTH, borderWidthsArray, Border.BORDER_IMAGE_INSETS, insetsArray2);
    }

    private BackgroundRepeat convertToBackgroundRepeat(BorderRepeat borderRepeat) {
        return switch (borderRepeat) {
            default -> throw new MatchException(null, null);
            case BorderRepeat.REPEAT -> BackgroundRepeat.REPEAT;
            case BorderRepeat.ROUND -> BackgroundRepeat.ROUND;
            case BorderRepeat.SPACE -> BackgroundRepeat.SPACE;
            case BorderRepeat.STRETCH -> BackgroundRepeat.NO_REPEAT;
        };
    }

    private BorderRepeat convertToBorderRepeat(BackgroundRepeat backgroundRepeat) {
        return switch (backgroundRepeat) {
            default -> throw new MatchException(null, null);
            case BackgroundRepeat.REPEAT -> BorderRepeat.REPEAT;
            case BackgroundRepeat.ROUND -> BorderRepeat.ROUND;
            case BackgroundRepeat.SPACE -> BorderRepeat.SPACE;
            case BackgroundRepeat.NO_REPEAT -> BorderRepeat.STRETCH;
        };
    }

    public String toString() {
        return "BorderConverter";
    }
}

