/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk;

import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.HeaderButtonMetrics;
import com.sun.glass.ui.HeaderButtonOverlay;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.gtk.PlatformThemeObserver;
import com.sun.javafx.tk.HeaderAreaType;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;

class GtkWindow
extends Window {
    public GtkWindow(Window window, Screen screen, int n) {
        super(window, screen, n);
        if (this.isExtendedWindow()) {
            this.prefHeaderButtonHeightProperty().subscribe(this::onPrefHeaderButtonHeightChanged);
        }
    }

    @Override
    protected native long _createWindow(long var1, long var3, int var5);

    @Override
    protected native boolean _close(long var1);

    @Override
    protected native boolean _setView(long var1, View var3);

    @Override
    protected native void _updateViewSize(long var1);

    @Override
    protected boolean _setMenubar(long l, long l2) {
        return true;
    }

    private native void minimizeImpl(long var1, boolean var3);

    private native void maximizeImpl(long var1, boolean var3, boolean var4);

    private native void setVisibleImpl(long var1, boolean var3);

    @Override
    protected native boolean _setResizable(long var1, boolean var3);

    @Override
    protected native boolean _requestFocus(long var1, int var3);

    @Override
    protected native void _setFocusable(long var1, boolean var3);

    @Override
    protected native boolean _grabFocus(long var1);

    @Override
    protected native void _ungrabFocus(long var1);

    @Override
    protected native boolean _setTitle(long var1, String var3);

    @Override
    protected native void _setLevel(long var1, int var3);

    @Override
    protected native void _setAlpha(long var1, float var3);

    @Override
    protected native boolean _setBackground(long var1, float var3, float var4, float var5);

    @Override
    protected native void _setEnabled(long var1, boolean var3);

    private native boolean _setSystemMinimumSize(long var1, int var3, int var4);

    @Override
    protected native boolean _setMinimumSize(long var1, int var3, int var4);

    @Override
    protected native boolean _setMaximumSize(long var1, int var3, int var4);

    @Override
    protected native void _setIcon(long var1, Pixels var3);

    @Override
    protected native void _toFront(long var1);

    @Override
    protected native void _toBack(long var1);

    @Override
    protected native void _enterModal(long var1);

    @Override
    protected native void _enterModalWithWindow(long var1, long var3);

    @Override
    protected native void _exitModal(long var1);

    protected native long _getNativeWindowImpl(long var1);

    private native void _showSystemMenu(long var1, int var3, int var4);

    private native boolean isVisible(long var1);

    @Override
    protected boolean _setVisible(long l, boolean bl) {
        this.setVisibleImpl(l, bl);
        return this.isVisible(l);
    }

    @Override
    protected boolean _minimize(long l, boolean bl) {
        this.minimizeImpl(l, bl);
        this.notifyStateChanged(531);
        return bl;
    }

    @Override
    protected boolean _maximize(long l, boolean bl, boolean bl2) {
        this.maximizeImpl(l, bl, bl2);
        this.notifyStateChanged(532);
        return bl;
    }

    protected void notifyStateChanged(int n) {
        switch (n) {
            case 531: 
            case 532: 
            case 533: {
                this.notifyResize(n, this.getWidth(), this.getHeight());
                break;
            }
            default: {
                System.err.println("Unknown window state: " + n);
            }
        }
    }

    @Override
    protected void _setCursor(long l, Cursor cursor) {
        if (cursor.getType() == 0) {
            this._setCustomCursor(l, cursor);
        } else {
            this._setCursorType(l, cursor.getType());
        }
    }

    private native void _setCursorType(long var1, int var3);

    private native void _setCustomCursor(long var1, Cursor var3);

    @Override
    public long getNativeWindow() {
        return this._getNativeWindowImpl(super.getNativeWindow());
    }

    @Override
    protected native void _setBounds(long var1, int var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, float var11, float var12);

    @Override
    protected void _requestInput(long l, String string, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void _releaseInput(long l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long getRawHandle() {
        long l = super.getRawHandle();
        return l == 0L ? 0L : this._getNativeWindowImpl(l);
    }

    public void showSystemMenu(int n, int n2) {
        this._showSystemMenu(super.getRawHandle(), n, n2);
    }

    private void onPrefHeaderButtonHeightChanged(Number number) {
        HeaderButtonOverlay headerButtonOverlay;
        if (number.doubleValue() != 0.0 && this.headerButtonOverlay.get() != null) {
            return;
        }
        Object object = this.headerButtonOverlay.get();
        if (object instanceof HeaderButtonOverlay) {
            headerButtonOverlay = (HeaderButtonOverlay)object;
            headerButtonOverlay.dispose();
        }
        if (number.doubleValue() == 0.0) {
            this.headerButtonOverlay.set(null);
            this.headerButtonMetrics.set((Object)HeaderButtonMetrics.EMPTY);
        } else {
            headerButtonOverlay = this.createHeaderButtonOverlay();
            headerButtonOverlay.metricsProperty().subscribe(arg_0 -> ((ObjectProperty)this.headerButtonMetrics).set(arg_0));
            this.headerButtonOverlay.set((Object)headerButtonOverlay);
        }
    }

    private HeaderButtonOverlay createHeaderButtonOverlay() {
        HeaderButtonOverlay headerButtonOverlay = new HeaderButtonOverlay((ObservableValue<String>)PlatformThemeObserver.getInstance().stylesheetProperty(), this.isUtilityWindow(), (this.getStyleMask() & 0x100) != 0);
        headerButtonOverlay.metricsProperty().subscribe(headerButtonMetrics -> {
            int n = (int)(headerButtonMetrics.totalInsetWidth() * (double)this.platformScaleX);
            int n2 = (int)(headerButtonMetrics.maxInsetHeight() * (double)this.platformScaleY);
            this._setSystemMinimumSize(super.getRawHandle(), n, n2);
        });
        headerButtonOverlay.prefButtonHeightProperty().bind((ObservableValue)this.prefHeaderButtonHeightProperty());
        return headerButtonOverlay;
    }

    private boolean dragAreaHitTest(int n, int n2) {
        Object object;
        if (this.view == null || this.view.isInFullscreen() || !this.isExtendedWindow()) {
            return false;
        }
        double d = (float)n / this.platformScaleX;
        double d2 = (float)n2 / this.platformScaleY;
        Object object2 = this.headerButtonOverlay.get();
        if (object2 instanceof HeaderButtonOverlay && ((HeaderButtonOverlay)(object = (HeaderButtonOverlay)object2)).buttonAt(d, d2) != null) {
            return false;
        }
        object = this.view.getEventHandler();
        if (object == null) {
            return false;
        }
        return ((View.EventHandler)object).pickHeaderArea(d, d2) == HeaderAreaType.DRAGBAR;
    }
}

