/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext;

import java.util.HashMap;
import jfx.incubator.scene.control.richtext.RichTextArea;
import jfx.incubator.scene.control.richtext.StyleAttributeHandler;
import jfx.incubator.scene.control.richtext.model.StyleAttribute;
import jfx.incubator.scene.control.richtext.skin.CellContext;

public class StyleHandlerRegistry {
    private final HashMap<StyleAttribute, StyleAttributeHandler> parStyleHandlerMap;
    private final HashMap<StyleAttribute, StyleAttributeHandler> segStyleHandlerMap;

    private StyleHandlerRegistry(HashMap<StyleAttribute, StyleAttributeHandler> hashMap, HashMap<StyleAttribute, StyleAttributeHandler> hashMap2) {
        this.parStyleHandlerMap = hashMap;
        this.segStyleHandlerMap = hashMap2;
    }

    public static Builder builder(StyleHandlerRegistry styleHandlerRegistry) {
        Builder builder = new Builder();
        if (styleHandlerRegistry != null) {
            builder.parStyleHandlerMap.putAll(styleHandlerRegistry.parStyleHandlerMap);
            builder.segStyleHandlerMap.putAll(styleHandlerRegistry.segStyleHandlerMap);
        }
        return builder;
    }

    public <C extends RichTextArea, T> void process(C c, boolean bl, CellContext cellContext, StyleAttribute<T> styleAttribute, T t) {
        StyleAttributeHandler styleAttributeHandler = (bl ? this.parStyleHandlerMap : this.segStyleHandlerMap).get(styleAttribute);
        if (styleAttributeHandler != null) {
            styleAttributeHandler.apply(c, cellContext, t);
        }
    }

    public static class Builder {
        private HashMap<StyleAttribute, StyleAttributeHandler> parStyleHandlerMap = new HashMap();
        private HashMap<StyleAttribute, StyleAttributeHandler> segStyleHandlerMap = new HashMap();

        Builder() {
        }

        public <C extends RichTextArea, T> void setParHandler(StyleAttribute<T> styleAttribute, StyleAttributeHandler<C, T> styleAttributeHandler) {
            this.parStyleHandlerMap.put(styleAttribute, styleAttributeHandler);
        }

        public <C extends RichTextArea, T> void setSegHandler(StyleAttribute<T> styleAttribute, StyleAttributeHandler<C, T> styleAttributeHandler) {
            this.segStyleHandlerMap.put(styleAttribute, styleAttributeHandler);
        }

        public StyleHandlerRegistry build() {
            return new StyleHandlerRegistry(this.parStyleHandlerMap, this.segStyleHandlerMap);
        }
    }
}

