/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.headless;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.PlatformFactory;
import com.sun.glass.ui.SystemClipboard;
import com.sun.glass.ui.delegate.ClipboardDelegate;
import com.sun.glass.ui.delegate.MenuBarDelegate;
import com.sun.glass.ui.delegate.MenuDelegate;
import com.sun.glass.ui.delegate.MenuItemDelegate;
import com.sun.glass.ui.headless.HeadlessApplication;
import java.util.HashMap;

public class HeadlessPlatformFactory
extends PlatformFactory {
    @Override
    public Application createApplication() {
        return new HeadlessApplication();
    }

    @Override
    public MenuBarDelegate createMenuBarDelegate(MenuBar menuBar) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MenuDelegate createMenuDelegate(Menu menu) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MenuItemDelegate createMenuItemDelegate(MenuItem menuItem) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ClipboardDelegate createClipboardDelegate() {
        return string -> {
            if ("SYSTEM".equals(string)) {
                return new HeadlessSystemClipboard();
            }
            if ("DND".equals(string)) {
                return new HeadlessDnDClipboard();
            }
            throw new IllegalArgumentException("No support for " + string + " clipboard in headless");
        };
    }

    static class HeadlessSystemClipboard
    extends SystemClipboard {
        HashMap<String, Object> cacheData;
        int supportedActions;

        HeadlessSystemClipboard() {
            super("SYSTEM");
        }

        @Override
        protected boolean isOwner() {
            return true;
        }

        @Override
        protected void pushToSystem(HashMap<String, Object> hashMap, int n) {
            this.cacheData = hashMap;
            this.supportedActions = n;
        }

        @Override
        protected void pushTargetActionToSystem(int n) {
        }

        @Override
        protected Object popFromSystem(String string) {
            return null;
        }

        @Override
        protected int supportedSourceActionsFromSystem() {
            return 0;
        }

        @Override
        protected String[] mimesFromSystem() {
            return new String[0];
        }
    }

    static class HeadlessDnDClipboard
    extends SystemClipboard {
        HeadlessDnDClipboard() {
            super("DND");
        }

        @Override
        protected boolean isOwner() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void pushToSystem(HashMap<String, Object> hashMap, int n) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void pushTargetActionToSystem(int n) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected Object popFromSystem(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected int supportedSourceActionsFromSystem() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String[] mimesFromSystem() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

