/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.headless;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.headless.HeadlessCursor;
import com.sun.glass.ui.headless.HeadlessPixels;
import com.sun.glass.ui.headless.HeadlessRobot;
import com.sun.glass.ui.headless.HeadlessTimer;
import com.sun.glass.ui.headless.HeadlessView;
import com.sun.glass.ui.headless.HeadlessWindow;
import com.sun.glass.ui.headless.HeadlessWindowManager;
import com.sun.glass.ui.headless.NestedRunnableProcessor;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class HeadlessApplication
extends Application {
    private final NestedRunnableProcessor processor = new NestedRunnableProcessor();
    private final HeadlessWindowManager windowManager = new HeadlessWindowManager();
    private Screen[] screens;
    private HeadlessRobot activeRobot = null;
    ByteBuffer frameBuffer;
    private static final int MULTICLICK_MAX_X = 20;
    private static final int MULTICLICK_MAX_Y = 20;
    private static final long MULTICLICK_TIME = 500L;

    @Override
    protected void runLoop(Runnable runnable) {
        this.processor.invokeLater(runnable);
        Thread thread = new Thread(this.processor);
        HeadlessApplication.setEventThread(thread);
        thread.start();
    }

    @Override
    protected void _invokeAndWait(Runnable runnable) {
        this.processor.invokeAndWait(runnable);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        this.processor.invokeLater(runnable);
    }

    @Override
    protected Object _enterNestedEventLoop() {
        return this.processor.newRunLoop();
    }

    @Override
    protected void _leaveNestedEventLoop(Object object) {
        this.processor.leaveCurrentLoop(object);
    }

    @Override
    protected void finishTerminating() {
        this.processor.stopProcessing();
        HeadlessApplication.setEventThread(null);
        super.finishTerminating();
    }

    @Override
    protected int _isKeyLocked(int n) {
        return 0;
    }

    @Override
    public Window createWindow(Window window, Screen screen, int n) {
        HeadlessWindow headlessWindow = new HeadlessWindow(this.windowManager, window, screen, this.frameBuffer, n);
        if (this.activeRobot != null) {
            this.activeRobot.windowAdded(headlessWindow);
            headlessWindow.setRobot(this.activeRobot);
        }
        return headlessWindow;
    }

    @Override
    public View createView() {
        return new HeadlessView();
    }

    @Override
    public Cursor createCursor(int n) {
        return new HeadlessCursor(n);
    }

    @Override
    public Cursor createCursor(int n, int n2, Pixels pixels) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void staticCursor_setVisible(boolean bl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected Size staticCursor_getBestSize(int n, int n2) {
        return new Size(16, 16);
    }

    @Override
    public Pixels createPixels(int n, int n2, ByteBuffer byteBuffer) {
        return new HeadlessPixels(n, n2, byteBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, ByteBuffer byteBuffer, float f, float f2) {
        return new HeadlessPixels(n, n2, byteBuffer, f, f2);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer) {
        return new HeadlessPixels(n, n2, intBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer, float f, float f2) {
        return new HeadlessPixels(n, n2, intBuffer, f, f2);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return 1;
    }

    @Override
    public GlassRobot createRobot() {
        this.activeRobot = new HeadlessRobot(this);
        return this.activeRobot;
    }

    @Override
    protected double staticScreen_getVideoRefreshPeriod() {
        return 0.0;
    }

    @Override
    protected Screen[] staticScreen_getScreens() {
        if (this.screens == null) {
            float f = 1.0f;
            float f2 = 1.0f;
            Screen screen = new Screen(0L, 32, 0, 0, 1000, 1000, 0, 0, 1000, 1000, 0, 0, 1000, 1000, 100, 100, 1.0f, 1.0f, f, f2);
            this.screens = new Screen[1];
            this.screens[0] = screen;
            this.frameBuffer = ByteBuffer.allocate(screen.getWidth() * screen.getHeight() * 4);
        }
        return this.screens;
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new HeadlessTimer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return 0;
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return 1000000;
    }

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window window, String string, String string2, String string3, int n, boolean bl, CommonDialogs.ExtensionFilter[] extensionFilterArray, int n2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window window, String string, String string2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return 500L;
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return 20;
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return 20;
    }

    @Override
    protected boolean _supportsTransparentWindows() {
        return false;
    }

    @Override
    protected boolean _supportsUnifiedWindows() {
        return false;
    }

    @Override
    protected boolean _supportsExtendedWindows() {
        return false;
    }

    @Override
    protected int _getKeyCodeForChar(char c, int n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

