/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import com.sun.jfx.incubator.scene.control.richtext.FxPathBuilder;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;

public class SelectionHelper {
    private final FxPathBuilder pathBuilder;
    private final double left;
    private final double right;
    private double topUp = Double.POSITIVE_INFINITY;
    private double topDn = Double.POSITIVE_INFINITY;
    private double topLeft = Double.POSITIVE_INFINITY;
    private double topRight = Double.NEGATIVE_INFINITY;
    private double bottomUp = Double.NEGATIVE_INFINITY;
    private double bottomDn = Double.NEGATIVE_INFINITY;
    private double bottomLeft = Double.POSITIVE_INFINITY;
    private double bottomRight = Double.NEGATIVE_INFINITY;
    private static final double EPSILON = 0.001;

    public SelectionHelper(FxPathBuilder fxPathBuilder, double d, double d2) {
        this.pathBuilder = fxPathBuilder;
        this.left = d;
        this.right = d2;
    }

    public String toString() {
        return "topUp=" + this.topUp + " topDn=" + this.topDn + " botUp=" + this.bottomUp + " botDn=" + this.bottomDn;
    }

    private void process(PathElement[] pathElementArray, PathHandler pathHandler) {
        if (pathElementArray != null) {
            for (PathElement pathElement : pathElementArray) {
                if (pathElement instanceof LineTo) {
                    LineTo lineTo = (LineTo)pathElement;
                    pathHandler.processPoint(lineTo.getX(), lineTo.getY());
                    continue;
                }
                if (pathElement instanceof MoveTo) {
                    MoveTo moveTo = (MoveTo)pathElement;
                    pathHandler.processPoint(moveTo.getX(), moveTo.getY());
                    continue;
                }
                throw new Error("?" + String.valueOf(pathElement));
            }
        }
    }

    private void generateMiddle(boolean bl, boolean bl2, double d) {
        if (Double.isNaN(this.topUp)) {
            return;
        }
        double d2 = this.topDn + d;
        double d3 = this.bottomDn + d;
        if (this.bottomUp > this.topDn) {
            if (bl) {
                this.pathBuilder.moveto(this.topRight, this.topUp);
                this.pathBuilder.lineto(this.right, this.topUp);
                this.pathBuilder.lineto(this.right, d2);
                this.pathBuilder.lineto(this.topRight, d2);
                this.pathBuilder.lineto(this.topRight, this.topUp);
            }
            this.pathBuilder.moveto(this.left, d2);
            this.pathBuilder.lineto(this.right, d2);
            this.pathBuilder.lineto(this.right, this.bottomUp);
            this.pathBuilder.lineto(this.left, this.bottomUp);
            this.pathBuilder.lineto(this.left, d2);
            if (bl2) {
                this.pathBuilder.moveto(this.left, this.bottomUp);
                this.pathBuilder.lineto(this.bottomLeft, this.bottomUp);
                this.pathBuilder.lineto(this.bottomLeft, d3);
                this.pathBuilder.lineto(this.left, d3);
                this.pathBuilder.lineto(this.left, this.bottomUp);
            }
        }
    }

    private boolean isNear(double d, double d2) {
        return Math.abs(d - d2) < 0.001;
    }

    private void determineTopYLimits(double d, double d2) {
        if (d2 < this.topUp) {
            this.topUp = d2;
        }
    }

    private void determineTopXLimits(double d, double d2) {
        if (this.isNear(d2, this.topUp)) {
            if (d < this.topLeft) {
                this.topLeft = d;
            }
            if (d > this.topRight) {
                this.topRight = d;
            }
        } else if (d2 < this.topDn) {
            this.topDn = d2;
        }
    }

    private void determineBottomYLimits(double d, double d2) {
        if (d2 > this.bottomDn) {
            this.bottomDn = d2;
        }
    }

    private void determineBottomXLimits(double d, double d2) {
        if (this.isNear(d2, this.bottomDn)) {
            if (d < this.bottomLeft) {
                this.bottomLeft = d;
            }
            if (d > this.bottomRight) {
                this.bottomRight = d;
            }
        } else if (d2 > this.bottomUp) {
            this.bottomUp = d2;
        }
    }

    private void adjust(PathElement[] pathElementArray, double d, double d2, double d3, double d4) {
        if (pathElementArray != null) {
            for (PathElement pathElement : pathElementArray) {
                double d5;
                double d6;
                if (pathElement instanceof LineTo) {
                    LineTo lineTo = (LineTo)pathElement;
                    d6 = lineTo.getX();
                    if (this.isNear(d6, d)) {
                        // empty if block
                    }
                    if (!this.isNear(d5 = lineTo.getY(), d2)) continue;
                    lineTo.setY(d5 + d4);
                    continue;
                }
                if (!(pathElement instanceof MoveTo)) continue;
                MoveTo moveTo = (MoveTo)pathElement;
                d6 = moveTo.getX();
                if (this.isNear(d6, d)) {
                    // empty if block
                }
                if (!this.isNear(d5 = moveTo.getY(), d2)) continue;
                moveTo.setY(d5 + d4);
            }
        }
    }

    public void generate(PathElement[] pathElementArray, PathElement[] pathElementArray2, boolean bl, boolean bl2, double d, double d2) {
        this.process(pathElementArray, this::determineTopYLimits);
        this.process(pathElementArray, this::determineTopXLimits);
        if (pathElementArray2 == null) {
            this.adjust(pathElementArray, this.topLeft, this.topDn, d, d2);
            this.pathBuilder.addAll(pathElementArray);
        } else {
            this.process(pathElementArray2, this::determineBottomYLimits);
            this.process(pathElementArray2, this::determineBottomXLimits);
            this.adjust(pathElementArray, this.topLeft, this.topDn, d, d2);
            this.adjust(pathElementArray2, this.bottomLeft, this.bottomDn, d, d2);
            this.pathBuilder.addAll(pathElementArray);
            this.generateMiddle(bl, bl2, d2);
            this.pathBuilder.addAll(pathElementArray2);
        }
    }

    @FunctionalInterface
    protected static interface PathHandler {
        public void processPoint(double var1, double var3);
    }
}

