/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.text;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLine;
import com.sun.javafx.text.PrismCaretInfo;
import com.sun.javafx.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.geometry.Rectangle2D;
import javafx.scene.text.CaretInfo;
import javafx.scene.text.LayoutInfo;
import javafx.scene.text.TextLineInfo;

public abstract non-sealed class PrismLayoutInfo
extends LayoutInfo {
    private final TextLayout layout;

    protected abstract double lineSpacing();

    protected abstract double dx();

    protected abstract double dy();

    public PrismLayoutInfo(TextLayout textLayout) {
        this.layout = textLayout;
    }

    @Override
    public Rectangle2D getLogicalBounds(boolean bl) {
        BaseBounds baseBounds = this.layout.getBounds();
        double d = this.dx();
        double d2 = this.dy();
        double d3 = bl ? this.lineSpacing() : 0.0;
        return TextUtils.toRectangle2D(baseBounds, d, d2, d3);
    }

    @Override
    public int getTextLineCount() {
        return this.layout.getLines().length;
    }

    @Override
    public List<TextLineInfo> getTextLines(boolean bl) {
        TextLine[] textLineArray = this.layout.getLines();
        double d = this.dx();
        double d2 = this.dy();
        double d3 = bl ? this.lineSpacing() : 0.0;
        int n = textLineArray.length;
        ArrayList<TextLineInfo> arrayList = new ArrayList<TextLineInfo>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(TextUtils.toLineInfo(textLineArray[i], d, d2, d3));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public TextLineInfo getTextLine(int n, boolean bl) {
        TextLine[] textLineArray = this.layout.getLines();
        Objects.checkIndex(n, textLineArray.length);
        double d = this.dx();
        double d2 = this.dy();
        double d3 = bl ? this.lineSpacing() : 0.0;
        return TextUtils.toLineInfo(textLineArray[n], d, d2, d3);
    }

    @Override
    public List<Rectangle2D> getSelectionGeometry(int n, int n2, boolean bl) {
        double d = bl ? this.lineSpacing() : 0.0;
        return this.getGeometry(n, n2, 1, d);
    }

    @Override
    public List<Rectangle2D> getStrikeThroughGeometry(int n, int n2) {
        return this.getGeometry(n, n2, 4, 0.0);
    }

    @Override
    public List<Rectangle2D> getUnderlineGeometry(int n, int n2) {
        return this.getGeometry(n, n2, 2, 0.0);
    }

    private List<Rectangle2D> getGeometry(int n, int n2, int n3, double d) {
        double d2 = this.dx();
        double d3 = this.dy();
        ArrayList arrayList = new ArrayList();
        this.layout.getRange(n, n2, n3, (f, f2, f3, f4) -> {
            if (f < f3) {
                arrayList.add(new Rectangle2D((double)f + d2, (double)f2 + d3, f3 - f, (double)(f4 - f2) + d));
            } else {
                arrayList.add(new Rectangle2D((double)f3 + d2, (double)f2 + d3, f - f3, (double)(f4 - f2) + d));
            }
        });
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public CaretInfo caretInfoAt(int n, boolean bl) {
        TextLayout.CaretGeometry caretGeometry = this.layout.getCaretGeometry(n, bl);
        double d = this.dx();
        double d2 = this.dy();
        Rectangle2D[] rectangle2DArray = TextUtils.getCaretRectangles(caretGeometry, d, d2);
        return new PrismCaretInfo(rectangle2DArray);
    }
}

