/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.prism.MediaFrame;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.impl.BaseTexture;
import com.sun.prism.mtl.MTLContext;
import com.sun.prism.mtl.MTLTextureData;
import com.sun.prism.mtl.MTLTextureResource;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

class MTLTexture<T extends MTLTextureData>
extends BaseTexture<MTLTextureResource<T>> {
    private final MTLContext context;
    private final long texPtr;

    MTLTexture(MTLContext mTLContext, MTLTextureResource<T> mTLTextureResource, PixelFormat pixelFormat, Texture.WrapMode wrapMode, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super(mTLTextureResource, pixelFormat, wrapMode, n, n2, n3, n4, n5, n6, bl);
        this.context = mTLContext;
        this.texPtr = ((MTLTextureData)mTLTextureResource.getResource()).getResource();
    }

    MTLTexture(MTLContext mTLContext, MTLTextureResource<T> mTLTextureResource, PixelFormat pixelFormat, Texture.WrapMode wrapMode, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        super(mTLTextureResource, pixelFormat, wrapMode, n, n2, n3, n4, n5, n6, n7, n8, bl);
        this.context = mTLContext;
        this.texPtr = ((MTLTextureData)mTLTextureResource.getResource()).getResource();
    }

    public long getNativeHandle() {
        return this.texPtr;
    }

    public MTLContext getContext() {
        return this.context;
    }

    private MTLTexture(MTLTexture<T> mTLTexture, Texture.WrapMode wrapMode) {
        super(mTLTexture, wrapMode, false);
        this.context = mTLTexture.context;
        this.texPtr = mTLTexture.texPtr;
    }

    @Override
    protected Texture createSharedTexture(Texture.WrapMode wrapMode) {
        return new MTLTexture<T>(this, wrapMode);
    }

    private void updateTextureInt(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (pixelFormat != PixelFormat.INT_ARGB_PRE) {
            throw new IllegalArgumentException("Unsupported INT PixelFormat: " + String.valueOf((Object)pixelFormat));
        }
        IntBuffer intBuffer = (IntBuffer)buffer;
        int[] nArray = intBuffer.hasArray() ? intBuffer.array() : null;
        MTLTexture.nUpdateInt(this.getNativeHandle(), intBuffer, nArray, n, n2, n3, n4, n5, n6, n7);
    }

    private void updateTextureFloat(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (pixelFormat != PixelFormat.FLOAT_XYZW) {
            throw new IllegalArgumentException("Unsupported FLOAT PixelFormat: " + String.valueOf((Object)pixelFormat));
        }
        FloatBuffer floatBuffer = (FloatBuffer)buffer;
        float[] fArray = floatBuffer.hasArray() ? floatBuffer.array() : null;
        MTLTexture.nUpdateFloat(this.getNativeHandle(), floatBuffer, fArray, n, n2, n3, n4, n5, n6, n7);
    }

    private void updateTextureByte(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        ByteBuffer byteBuffer = (ByteBuffer)buffer;
        byteBuffer.rewind();
        byte[] byArray = byteBuffer.hasArray() ? byteBuffer.array() : null;
        switch (pixelFormat) {
            case BYTE_BGRA_PRE: 
            case BYTE_ALPHA: {
                MTLTexture.nUpdate(this.getNativeHandle(), byteBuffer, byArray, n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case BYTE_RGB: {
                if (byArray == null) {
                    byArray = new byte[byteBuffer.remaining()];
                    byteBuffer.get(byArray);
                }
                byte[] byArray2 = new byte[n5 * n6 * 4];
                int n8 = 0;
                int n9 = 0;
                int n10 = n5 * 3;
                int n11 = n6 * n10;
                for (int i = 0; i < n11; i += n10) {
                    for (int j = 0; j < n10; j += 3) {
                        n9 = i + j;
                        byArray2[n8++] = byArray[n9 + 2];
                        byArray2[n8++] = byArray[n9 + 1];
                        byArray2[n8++] = byArray[n9];
                        byArray2[n8++] = -1;
                    }
                }
                MTLTexture.nUpdate(this.getNativeHandle(), null, byArray2, n, n2, n3, n4, n5, n6, n5 * 4);
                break;
            }
            case BYTE_GRAY: {
                if (byArray == null) {
                    byArray = new byte[byteBuffer.remaining()];
                    byteBuffer.get(byArray);
                }
                byte[] byArray3 = new byte[n5 * n6 * 4];
                int n12 = 0;
                int n13 = 0;
                int n14 = n6 * n5;
                for (int i = 0; i < n14; i += n5) {
                    for (int j = 0; j < n5; ++j) {
                        n13 = i + j;
                        byArray3[n12++] = byArray[n13];
                        byArray3[n12++] = byArray[n13];
                        byArray3[n12++] = byArray[n13];
                        byArray3[n12++] = -1;
                    }
                }
                MTLTexture.nUpdate(this.getNativeHandle(), null, byArray3, n, n2, n3, n4, n5, n6, n5 * 4);
                break;
            }
            case MULTI_YCbCr_420: 
            case BYTE_APPLE_422: {
                throw new IllegalArgumentException("Unsupported PixelFormat " + String.valueOf((Object)pixelFormat));
            }
        }
    }

    @Override
    public void update(Buffer buffer, PixelFormat pixelFormat, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        if (!((MTLTextureResource)this.resource).isValid()) {
            return;
        }
        switch (pixelFormat.getDataType()) {
            case INT: {
                this.updateTextureInt(buffer, pixelFormat, n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case FLOAT: {
                this.updateTextureFloat(buffer, pixelFormat, n, n2, n3, n4, n5, n6, n7);
                break;
            }
            case BYTE: {
                this.updateTextureByte(buffer, pixelFormat, n, n2, n3, n4, n5, n6, n7);
            }
        }
    }

    @Override
    public void update(MediaFrame mediaFrame, boolean bl) {
        byte[] byArray;
        if (mediaFrame.getPixelFormat() == PixelFormat.MULTI_YCbCr_420 || mediaFrame.getPixelFormat() != PixelFormat.BYTE_APPLE_422) {
            throw new IllegalArgumentException("Unsupported format: " + String.valueOf((Object)mediaFrame.getPixelFormat()));
        }
        mediaFrame.holdFrame();
        ByteBuffer byteBuffer = mediaFrame.getBufferForPlane(0);
        byte[] byArray2 = byArray = byteBuffer.hasArray() ? byteBuffer.array() : null;
        if (byArray == null) {
            byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
        }
        MTLTexture.nUpdateYUV422(this.getNativeHandle(), byArray, 0, 0, 0, 0, mediaFrame.getEncodedWidth(), mediaFrame.getEncodedHeight(), mediaFrame.strideForPlane(0));
        mediaFrame.releaseFrame();
    }

    private static native void nUpdate(long var0, ByteBuffer var2, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private static native void nUpdateFloat(long var0, FloatBuffer var2, float[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private static native void nUpdateInt(long var0, IntBuffer var2, int[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private static native void nUpdateYUV422(long var0, byte[] var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);
}

