/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.PreviewFeature;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.css.converter.StringConverter;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HeaderBar;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

@DefaultProperty(value="buttonTypes")
public class DialogPane
extends Pane {
    private final GridPane headerTextPanel;
    private final Label contentLabel;
    private final StackPane graphicContainer;
    private final Node buttonBar;
    private final ObservableList<ButtonType> buttons = FXCollections.observableArrayList();
    private final Map<ButtonType, Node> buttonNodes = new WeakHashMap<ButtonType, Node>();
    private Node detailsButton;
    private Dialog<?> dialog;
    private final ObjectProperty<Node> graphicProperty = new StyleableObjectProperty<Node>(){
        WeakReference<Node> graphicRef = new WeakReference<Object>(null);

        public CssMetaData getCssMetaData() {
            return StyleableProperties.GRAPHIC;
        }

        public Object getBean() {
            return DialogPane.this;
        }

        public String getName() {
            return "graphic";
        }

        protected void invalidated() {
            Node node = (Node)this.graphicRef.get();
            if (node != null) {
                DialogPane.this.getChildren().remove((Object)node);
            }
            Node node2 = DialogPane.this.getGraphic();
            this.graphicRef = new WeakReference<Node>(node2);
            DialogPane.this.updateHeaderArea();
        }
    };
    private StyleableStringProperty imageUrl = null;
    private ObjectProperty<HeaderBar> headerBar;
    private final ObjectProperty<Node> header = new SimpleObjectProperty<Node>(null){
        WeakReference<Node> headerRef;
        {
            this.headerRef = new WeakReference<Object>(null);
        }

        protected void invalidated() {
            Node node = (Node)this.headerRef.get();
            if (node != null) {
                DialogPane.this.getChildren().remove((Object)node);
            }
            Node node2 = DialogPane.this.getHeader();
            this.headerRef = new WeakReference<Node>(node2);
            DialogPane.this.updateHeaderArea();
        }
    };
    private final StringProperty headerText = new SimpleStringProperty((Object)this, "headerText"){

        protected void invalidated() {
            DialogPane.this.updateHeaderArea();
            DialogPane.this.requestLayout();
        }
    };
    private final ObjectProperty<Node> content = new SimpleObjectProperty<Node>(null){
        WeakReference<Node> contentRef;
        {
            this.contentRef = new WeakReference<Object>(null);
        }

        protected void invalidated() {
            Node node = (Node)this.contentRef.get();
            if (node != null) {
                DialogPane.this.getChildren().remove((Object)node);
            }
            Node node2 = DialogPane.this.getContent();
            this.contentRef = new WeakReference<Node>(node2);
            DialogPane.this.updateContentArea();
        }
    };
    private final StringProperty contentText = new SimpleStringProperty((Object)this, "contentText"){

        protected void invalidated() {
            DialogPane.this.updateContentArea();
            DialogPane.this.requestLayout();
        }
    };
    private final ObjectProperty<Node> expandableContentProperty = new SimpleObjectProperty<Node>(null){
        WeakReference<Node> expandableContentRef;
        {
            this.expandableContentRef = new WeakReference<Object>(null);
        }

        protected void invalidated() {
            Node node = (Node)this.expandableContentRef.get();
            if (node != null) {
                DialogPane.this.getChildren().remove((Object)node);
            }
            Node node2 = DialogPane.this.getExpandableContent();
            this.expandableContentRef = new WeakReference<Node>(node2);
            if (node2 != null) {
                node2.setVisible(DialogPane.this.isExpanded());
                node2.setManaged(DialogPane.this.isExpanded());
                if (!node2.getStyleClass().contains((Object)"expandable-content")) {
                    node2.getStyleClass().add((Object)"expandable-content");
                }
                DialogPane.this.getChildren().add((Object)node2);
            }
        }
    };
    private final BooleanProperty expandedProperty = new SimpleBooleanProperty((Object)this, "expanded", false){

        protected void invalidated() {
            Node node = DialogPane.this.getExpandableContent();
            if (node != null) {
                node.setVisible(DialogPane.this.isExpanded());
            }
            DialogPane.this.requestLayout();
        }
    };
    private double oldHeight = -1.0;

    static Label createContentLabel(String string) {
        Label label = new Label(string);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMaxHeight(Double.MAX_VALUE);
        label.getStyleClass().add((Object)"content");
        label.setWrapText(true);
        label.setPrefWidth(360.0);
        return label;
    }

    public DialogPane() {
        this.getStyleClass().add((Object)"dialog-pane");
        this.setAccessibleRole(AccessibleRole.DIALOG);
        this.headerTextPanel = new GridPane();
        this.getChildren().add((Object)this.headerTextPanel);
        this.graphicContainer = new StackPane();
        this.contentLabel = DialogPane.createContentLabel("");
        this.getChildren().add((Object)this.contentLabel);
        this.buttons.addListener(change -> {
            while (change.next()) {
                if (change.wasRemoved()) {
                    for (ButtonType buttonType : change.getRemoved()) {
                        this.buttonNodes.remove(buttonType);
                    }
                }
                if (!change.wasAdded()) continue;
                for (ButtonType buttonType : change.getAddedSubList()) {
                    if (this.buttonNodes.containsKey(buttonType)) continue;
                    this.buttonNodes.put(buttonType, this.createButton(buttonType));
                }
            }
        });
        this.buttonBar = this.createButtonBar();
        if (this.buttonBar != null) {
            this.getChildren().add((Object)this.buttonBar);
        }
    }

    public final ObjectProperty<Node> graphicProperty() {
        return this.graphicProperty;
    }

    public final Node getGraphic() {
        return (Node)this.graphicProperty.get();
    }

    public final void setGraphic(Node node) {
        this.graphicProperty.set((Object)node);
    }

    private StyleableStringProperty imageUrlProperty() {
        if (this.imageUrl == null) {
            this.imageUrl = new StyleableStringProperty(){
                StyleOrigin origin = StyleOrigin.USER;

                public void applyStyle(StyleOrigin styleOrigin, String string) {
                    this.origin = styleOrigin;
                    if (DialogPane.this.graphicProperty == null || !DialogPane.this.graphicProperty.isBound()) {
                        super.applyStyle(styleOrigin, string);
                    }
                    this.origin = StyleOrigin.USER;
                }

                protected void invalidated() {
                    String string = super.get();
                    if (string == null) {
                        ((StyleableProperty)DialogPane.this.graphicProperty()).applyStyle(this.origin, null);
                    } else {
                        String string2;
                        ImageView imageView;
                        Image image;
                        Node node = DialogPane.this.getGraphic();
                        if (node instanceof ImageView && (image = (imageView = (ImageView)node).getImage()) != null && string.equals(string2 = image.getUrl())) {
                            return;
                        }
                        imageView = StyleManager.getInstance().getCachedImage(string);
                        if (imageView != null) {
                            ((StyleableProperty)DialogPane.this.graphicProperty()).applyStyle(this.origin, (Object)new ImageView((Image)imageView));
                        }
                    }
                }

                public String get() {
                    Image image;
                    Node node = DialogPane.this.getGraphic();
                    if (node instanceof ImageView && (image = ((ImageView)node).getImage()) != null) {
                        return image.getUrl();
                    }
                    return null;
                }

                public StyleOrigin getStyleOrigin() {
                    return DialogPane.this.graphicProperty != null ? ((StyleableProperty)DialogPane.this.graphicProperty).getStyleOrigin() : null;
                }

                public Object getBean() {
                    return DialogPane.this;
                }

                public String getName() {
                    return "imageUrl";
                }

                public CssMetaData<DialogPane, String> getCssMetaData() {
                    return StyleableProperties.GRAPHIC;
                }
            };
        }
        return this.imageUrl;
    }

    @Deprecated(since="26")
    public final ObjectProperty<HeaderBar> headerBarProperty() {
        if (this.headerBar == null) {
            PreviewFeature.HEADER_BAR.checkEnabled();
            this.headerBar = new SimpleObjectProperty<HeaderBar>((Object)this, "headerBar"){
                WeakReference<HeaderBar> wref;
                {
                    this.wref = new WeakReference<Object>(null);
                }

                protected void invalidated() {
                    HeaderBar headerBar;
                    HeaderBar headerBar2 = (HeaderBar)this.wref.get();
                    if (headerBar2 != null) {
                        DialogPane.this.getChildren().remove((Object)headerBar2);
                    }
                    if ((headerBar = (HeaderBar)this.get()) != null) {
                        DialogPane.this.getChildren().add((Object)headerBar);
                    }
                    this.wref = new WeakReference<HeaderBar>(headerBar);
                }
            };
        }
        return this.headerBar;
    }

    @Deprecated(since="26")
    public final HeaderBar getHeaderBar() {
        PreviewFeature.HEADER_BAR.checkEnabled();
        return this.headerBar != null ? (HeaderBar)this.headerBar.get() : null;
    }

    @Deprecated(since="26")
    public final void setHeaderBar(HeaderBar headerBar) {
        PreviewFeature.HEADER_BAR.checkEnabled();
        if (this.headerBar != null || headerBar != null) {
            this.headerBarProperty().set((Object)headerBar);
        }
    }

    private HeaderBar getHeaderBarInternal() {
        return this.headerBar != null ? (HeaderBar)this.headerBar.get() : null;
    }

    public final Node getHeader() {
        return (Node)this.header.get();
    }

    public final void setHeader(Node node) {
        this.header.setValue((Object)node);
    }

    public final ObjectProperty<Node> headerProperty() {
        return this.header;
    }

    public final void setHeaderText(String string) {
        this.headerText.set((Object)string);
    }

    public final String getHeaderText() {
        return (String)this.headerText.get();
    }

    public final StringProperty headerTextProperty() {
        return this.headerText;
    }

    public final Node getContent() {
        return (Node)this.content.get();
    }

    public final void setContent(Node node) {
        this.content.setValue((Object)node);
    }

    public final ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public final void setContentText(String string) {
        this.contentText.set((Object)string);
    }

    public final String getContentText() {
        return (String)this.contentText.get();
    }

    public final StringProperty contentTextProperty() {
        return this.contentText;
    }

    public final ObjectProperty<Node> expandableContentProperty() {
        return this.expandableContentProperty;
    }

    public final Node getExpandableContent() {
        return (Node)this.expandableContentProperty.get();
    }

    public final void setExpandableContent(Node node) {
        this.expandableContentProperty.set((Object)node);
    }

    public final BooleanProperty expandedProperty() {
        return this.expandedProperty;
    }

    public final boolean isExpanded() {
        return this.expandedProperty().get();
    }

    public final void setExpanded(boolean bl) {
        this.expandedProperty().set(bl);
    }

    public final ObservableList<ButtonType> getButtonTypes() {
        return this.buttons;
    }

    public final Node lookupButton(ButtonType buttonType) {
        return this.buttonNodes.get(buttonType);
    }

    protected Node createButtonBar() {
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setMaxWidth(Double.MAX_VALUE);
        this.updateButtons(buttonBar);
        this.getButtonTypes().addListener(change -> this.updateButtons(buttonBar));
        this.expandableContentProperty().addListener(observable -> this.updateButtons(buttonBar));
        return buttonBar;
    }

    protected Node createButton(ButtonType buttonType) {
        Button button = new Button(buttonType.getText());
        ButtonBar.ButtonData buttonData = buttonType.getButtonData();
        ButtonBar.setButtonData((Node)button, buttonData);
        button.setDefaultButton(buttonData.isDefaultButton());
        button.setCancelButton(buttonData.isCancelButton());
        button.addEventHandler(ActionEvent.ACTION, actionEvent -> {
            if (actionEvent.isConsumed()) {
                return;
            }
            if (this.dialog != null) {
                this.dialog.setResultAndClose(buttonType, true);
            }
        });
        return button;
    }

    protected Node createDetailsButton() {
        Hyperlink hyperlink = new Hyperlink();
        String string = ControlResources.getString("Dialog.detail.button.more");
        String string2 = ControlResources.getString("Dialog.detail.button.less");
        InvalidationListener invalidationListener = observable -> {
            boolean bl = this.isExpanded();
            hyperlink.setText(bl ? string2 : string);
            hyperlink.getStyleClass().setAll((Object[])new String[]{"details-button", bl ? "less" : "more"});
        };
        invalidationListener.invalidated(null);
        this.expandedProperty().addListener(invalidationListener);
        hyperlink.setOnAction((EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.setExpanded(!this.isExpanded())));
        return hyperlink;
    }

    protected void layoutChildren() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        boolean bl = this.hasHeader();
        double d6 = Math.max(this.minWidth(-1.0), this.getWidth());
        double d7 = this.minHeight(d6);
        double d8 = this.prefHeight(d6);
        double d9 = this.maxHeight(d6);
        double d10 = this.getHeight();
        double d11 = d5 = this.dialog == null ? 0.0 : this.dialog.dialog.getSceneHeight();
        if (d8 > d10 && d8 > d7 && (d8 <= d5 || d5 == 0.0)) {
            d4 = Utils.boundedSize(d8, d7, d9);
            this.resize(d6, d4);
        } else {
            boolean bl2;
            boolean bl3 = bl2 = d10 > this.oldHeight;
            if (bl2) {
                double d12 = d10 < d8 ? Math.min(d8, d10) : Math.max(d8, d5);
                d4 = Utils.boundedSize(d12, d7, d9);
            } else {
                d4 = Utils.boundedSize(Math.min(d10, d5), d7, d9);
            }
            this.resize(d6, d4);
        }
        this.oldHeight = d4 -= this.snappedTopInset() + this.snappedBottomInset();
        double d13 = this.snappedLeftInset();
        double d14 = this.snappedTopInset();
        double d15 = this.snappedRightInset();
        Node node = this.getActualHeader();
        Node node2 = this.getActualContent();
        Node node3 = this.getActualGraphic();
        Node node4 = this.getExpandableContent();
        HeaderBar headerBar = this.getHeaderBarInternal();
        double d16 = bl || node3 == null ? 0.0 : node3.prefWidth(-1.0);
        double d17 = bl ? node.prefHeight(d6) : 0.0;
        double d18 = this.buttonBar == null ? 0.0 : this.buttonBar.prefHeight(d6);
        double d19 = bl || node3 == null ? 0.0 : node3.prefHeight(-1.0);
        double d20 = headerBar != null ? Utils.boundedSize(headerBar.prefHeight(d6), headerBar.minHeight(d6), headerBar.maxHeight(d6)) : 0.0;
        double d21 = d6 - d16 - d13 - d15;
        if (this.isExpanded()) {
            d3 = this.isExpanded() ? node2.prefHeight(d21) : 0.0;
            d2 = bl ? d3 : Math.max(d19, d3);
            d = d4 - (d20 + d17 + d2 + d18);
        } else {
            d = this.isExpanded() ? node4.prefHeight(d6) : 0.0;
            d3 = d4 - (d20 + d17 + d + d18);
            double d22 = d2 = bl ? d3 : Math.max(d19, d3);
        }
        if (headerBar != null) {
            this.layoutInArea((Node)headerBar, 0.0, 0.0, d6, d20, 0.0, HPos.LEFT, VPos.TOP);
        }
        double d23 = d13;
        double d24 = d14 + d20;
        if (!bl) {
            if (node3 != null) {
                node3.resizeRelocate(d23, d24, d16, d19);
                d23 += d16;
            }
        } else {
            node.resizeRelocate(d23, d24, d6 - (d13 + d15), d17);
            d24 += d17;
        }
        node2.resizeRelocate(d23, d24, d21, d3);
        d24 += bl ? d3 : d2;
        if (node4 != null) {
            node4.resizeRelocate(d13, d24, d6 - d15, d);
            d24 += d;
        }
        if (this.buttonBar != null) {
            this.buttonBar.resizeRelocate(d13, d24, d6 - (d13 + d15), d18);
        }
    }

    protected double computeMinWidth(double d) {
        double d2;
        HeaderBar headerBar = this.getHeaderBarInternal();
        if (headerBar instanceof HeaderBar) {
            HeaderBar headerBar2 = headerBar;
            d2 = headerBar2.minWidth(d);
        } else {
            d2 = 0.0;
        }
        double d3 = d2;
        double d4 = this.hasHeader() ? this.getActualHeader().minWidth(d) + 10.0 : 0.0;
        double d5 = this.getActualContent().minWidth(d);
        double d6 = this.buttonBar == null ? 0.0 : this.buttonBar.minWidth(d);
        double d7 = this.getActualGraphic().minWidth(d);
        double d8 = 0.0;
        Node node = this.getExpandableContent();
        if (this.isExpanded() && node != null) {
            d8 = node.minWidth(d);
        }
        double d9 = this.snappedLeftInset() + (this.hasHeader() ? 0.0 : d7) + Math.max(Math.max(d4, d8), Math.max(d5, d6)) + this.snappedRightInset();
        return this.snapSizeX(Math.max(d9, d3));
    }

    protected double computeMinHeight(double d) {
        double d2;
        boolean bl = this.hasHeader();
        HeaderBar headerBar = this.getHeaderBarInternal();
        if (headerBar instanceof HeaderBar) {
            HeaderBar headerBar2 = headerBar;
            d2 = headerBar2.minHeight(d);
        } else {
            d2 = 0.0;
        }
        double d3 = d2;
        double d4 = bl ? this.getActualHeader().minHeight(d) : 0.0;
        double d5 = this.buttonBar == null ? 0.0 : this.buttonBar.minHeight(d);
        Node node = this.getActualGraphic();
        double d6 = bl ? 0.0 : node.minWidth(-1.0);
        double d7 = bl ? 0.0 : node.minHeight(d);
        Node node2 = this.getActualContent();
        double d8 = d == -1.0 ? -1.0 : (bl ? d : d - d6);
        double d9 = node2.minHeight(d8);
        double d10 = 0.0;
        Node node3 = this.getExpandableContent();
        if (this.isExpanded() && node3 != null) {
            d10 = node3.minHeight(d);
        }
        double d11 = this.snappedTopInset() + d3 + d4 + Math.max(d7, d9) + d10 + d5 + this.snappedBottomInset();
        return this.snapSizeY(d11);
    }

    protected double computePrefWidth(double d) {
        double d2;
        double d3 = this.hasHeader() ? this.getActualHeader().prefWidth(d) + 10.0 : 0.0;
        double d4 = this.getActualContent().prefWidth(d);
        double d5 = this.buttonBar == null ? 0.0 : this.buttonBar.prefWidth(d);
        double d6 = this.getActualGraphic().prefWidth(d);
        HeaderBar headerBar = this.getHeaderBarInternal();
        if (headerBar instanceof HeaderBar) {
            HeaderBar headerBar2 = headerBar;
            d2 = Utils.boundedSize(headerBar2.prefWidth(d), headerBar2.minWidth(d), headerBar2.maxWidth(d));
        } else {
            d2 = 0.0;
        }
        double d7 = d2;
        double d8 = 0.0;
        Node node = this.getExpandableContent();
        if (this.isExpanded() && node != null) {
            d8 = node.prefWidth(d);
        }
        double d9 = this.snappedLeftInset() + (this.hasHeader() ? 0.0 : d6) + Math.max(Math.max(d3, d8), Math.max(d4, d5)) + this.snappedRightInset();
        return this.snapSizeX(Math.max(d9, d7));
    }

    protected double computePrefHeight(double d) {
        double d2;
        HeaderBar headerBar;
        boolean bl = this.hasHeader();
        double d3 = bl ? this.getActualHeader().prefHeight(d) : 0.0;
        double d4 = this.buttonBar == null ? 0.0 : this.buttonBar.prefHeight(d);
        HeaderBar headerBar2 = this.getHeaderBarInternal();
        if (headerBar2 instanceof HeaderBar) {
            headerBar = headerBar2;
            d2 = Utils.boundedSize(headerBar.prefHeight(d), headerBar.minHeight(d), headerBar.maxHeight(d));
        } else {
            d2 = 0.0;
        }
        double d5 = d2;
        headerBar = this.getActualGraphic();
        double d6 = bl ? 0.0 : headerBar.prefWidth(-1.0);
        double d7 = bl ? 0.0 : headerBar.prefHeight(d);
        Node node = this.getActualContent();
        double d8 = d == -1.0 ? -1.0 : (bl ? d : d - d6);
        double d9 = node.prefHeight(d8);
        double d10 = 0.0;
        Node node2 = this.getExpandableContent();
        if (this.isExpanded() && node2 != null) {
            d10 = node2.prefHeight(d);
        }
        double d11 = this.snappedTopInset() + d5 + d3 + Math.max(d7, d9) + d10 + d4 + this.snappedBottomInset();
        return this.snapSizeY(d11);
    }

    private void updateButtons(ButtonBar buttonBar) {
        buttonBar.getButtons().clear();
        if (this.hasExpandableContent()) {
            if (this.detailsButton == null) {
                this.detailsButton = this.createDetailsButton();
            }
            ButtonBar.setButtonData(this.detailsButton, ButtonBar.ButtonData.HELP_2);
            buttonBar.getButtons().add((Object)this.detailsButton);
            ButtonBar.setButtonUniformSize(this.detailsButton, false);
        }
        boolean bl = false;
        for (ButtonType buttonType : this.getButtonTypes()) {
            Node node = this.buttonNodes.get(buttonType);
            if (node instanceof Button) {
                ButtonBar.ButtonData buttonData = buttonType.getButtonData();
                ((Button)node).setDefaultButton(!bl && buttonData != null && buttonData.isDefaultButton());
                ((Button)node).setCancelButton(buttonData != null && buttonData.isCancelButton());
                bl |= buttonData != null && buttonData.isDefaultButton();
            }
            buttonBar.getButtons().add((Object)node);
        }
    }

    private Node getActualContent() {
        Node node = this.getContent();
        return node == null ? this.contentLabel : node;
    }

    private Node getActualHeader() {
        Node node = this.getHeader();
        return node == null ? this.headerTextPanel : node;
    }

    private Node getActualGraphic() {
        return this.headerTextPanel;
    }

    private void updateHeaderArea() {
        Node node = this.getHeader();
        if (node != null) {
            if (!this.getChildren().contains((Object)node)) {
                this.getChildren().add((Object)node);
            }
            this.headerTextPanel.setVisible(false);
            this.headerTextPanel.setManaged(false);
        } else {
            String string = this.getHeaderText();
            this.headerTextPanel.getChildren().clear();
            this.headerTextPanel.getStyleClass().clear();
            this.headerTextPanel.setMaxWidth(Double.MAX_VALUE);
            if (string != null && !string.isEmpty()) {
                this.headerTextPanel.getStyleClass().add((Object)"header-panel");
            }
            Label label = new Label(string);
            label.setWrapText(true);
            label.setAlignment(Pos.CENTER_LEFT);
            label.setMaxWidth(Double.MAX_VALUE);
            label.setMaxHeight(Double.MAX_VALUE);
            this.headerTextPanel.add((Node)label, 0, 0);
            this.graphicContainer.getChildren().clear();
            this.graphicContainer.getStyleClass().clear();
            Node node2 = this.getGraphic();
            if (node2 != null) {
                this.graphicContainer.getChildren().add((Object)node2);
                this.graphicContainer.getStyleClass().add((Object)"graphic-container");
            }
            this.headerTextPanel.add((Node)this.graphicContainer, 1, 0);
            ColumnConstraints columnConstraints = new ColumnConstraints();
            columnConstraints.setFillWidth(true);
            columnConstraints.setHgrow(Priority.ALWAYS);
            ColumnConstraints columnConstraints2 = new ColumnConstraints();
            columnConstraints2.setFillWidth(false);
            columnConstraints2.setHgrow(Priority.NEVER);
            this.headerTextPanel.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{columnConstraints, columnConstraints2});
            this.headerTextPanel.setVisible(true);
            this.headerTextPanel.setManaged(true);
        }
    }

    private void updateContentArea() {
        Node node = this.getContent();
        if (node != null) {
            if (!this.getChildren().contains((Object)node)) {
                this.getChildren().add((Object)node);
            }
            if (!node.getStyleClass().contains((Object)"content")) {
                node.getStyleClass().add((Object)"content");
            }
            this.contentLabel.setVisible(false);
            this.contentLabel.setManaged(false);
        } else {
            String string = this.getContentText();
            boolean bl = string != null && !string.isEmpty();
            this.contentLabel.setText(bl ? string : "");
            this.contentLabel.setVisible(bl);
            this.contentLabel.setManaged(bl);
        }
    }

    boolean hasHeader() {
        return this.getHeader() != null || this.isTextHeader();
    }

    private boolean isTextHeader() {
        String string = this.getHeaderText();
        return string != null && !string.isEmpty();
    }

    boolean hasExpandableContent() {
        return this.getExpandableContent() != null;
    }

    void setDialog(Dialog<?> dialog) {
        this.dialog = dialog;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return DialogPane.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<DialogPane, String> GRAPHIC = new CssMetaData<DialogPane, String>("-fx-graphic", StringConverter.getInstance()){

            public boolean isSettable(DialogPane dialogPane) {
                return dialogPane.graphicProperty == null || !dialogPane.graphicProperty.isBound();
            }

            public StyleableProperty<String> getStyleableProperty(DialogPane dialogPane) {
                return dialogPane.imageUrlProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(Region.getClassCssMetaData());
            Collections.addAll(arrayList, GRAPHIC);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

