/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import java.util.Objects;
import javafx.animation.Interpolatable;
import javafx.beans.NamedArg;
import javafx.scene.image.Image;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;

public final class BackgroundImage
implements Interpolatable<BackgroundImage> {
    private final Image image;
    final BackgroundRepeat repeatX;
    final BackgroundRepeat repeatY;
    final BackgroundPosition position;
    final BackgroundSize size;
    Boolean opaque = null;
    private final int hash;

    public final Image getImage() {
        return this.image;
    }

    public final BackgroundRepeat getRepeatX() {
        return this.repeatX;
    }

    public final BackgroundRepeat getRepeatY() {
        return this.repeatY;
    }

    public final BackgroundPosition getPosition() {
        return this.position;
    }

    public final BackgroundSize getSize() {
        return this.size;
    }

    public BackgroundImage(@NamedArg(value="image") Image image, @NamedArg(value="repeatX") BackgroundRepeat backgroundRepeat, @NamedArg(value="repeatY") BackgroundRepeat backgroundRepeat2, @NamedArg(value="position") BackgroundPosition backgroundPosition, @NamedArg(value="size") BackgroundSize backgroundSize) {
        if (image == null) {
            throw new NullPointerException("Image cannot be null");
        }
        this.image = image;
        this.repeatX = backgroundRepeat == null ? BackgroundRepeat.REPEAT : backgroundRepeat;
        this.repeatY = backgroundRepeat2 == null ? BackgroundRepeat.REPEAT : backgroundRepeat2;
        this.position = backgroundPosition == null ? BackgroundPosition.DEFAULT : backgroundPosition;
        this.size = backgroundSize == null ? BackgroundSize.DEFAULT : backgroundSize;
        int n = this.image.hashCode();
        n = 31 * n + this.repeatX.hashCode();
        n = 31 * n + this.repeatY.hashCode();
        n = 31 * n + this.position.hashCode();
        this.hash = n = 31 * n + this.size.hashCode();
    }

    @Override
    public BackgroundImage interpolate(BackgroundImage backgroundImage, double d) {
        Image image;
        BackgroundRepeat backgroundRepeat;
        BackgroundRepeat backgroundRepeat2;
        Objects.requireNonNull(backgroundImage, "endValue cannot be null");
        if (d == 0.0) {
            return this;
        }
        if (d == 1.0) {
            return backgroundImage;
        }
        BackgroundPosition backgroundPosition = this.position.interpolate(backgroundImage.position, d);
        BackgroundSize backgroundSize = this.size.interpolate(backgroundImage.size, d);
        if (d < 0.5) {
            backgroundRepeat2 = this.repeatX;
            backgroundRepeat = this.repeatY;
            image = this.image;
        } else {
            backgroundRepeat2 = backgroundImage.repeatX;
            backgroundRepeat = backgroundImage.repeatY;
            image = backgroundImage.image;
        }
        if (this.isSame(image, backgroundRepeat2, backgroundRepeat, backgroundPosition, backgroundSize)) {
            return this;
        }
        if (backgroundImage.isSame(image, backgroundRepeat2, backgroundRepeat, backgroundPosition, backgroundSize)) {
            return backgroundImage;
        }
        return new BackgroundImage(image, backgroundRepeat2, backgroundRepeat, backgroundPosition, backgroundSize);
    }

    private boolean isSame(Image image, BackgroundRepeat backgroundRepeat, BackgroundRepeat backgroundRepeat2, BackgroundPosition backgroundPosition, BackgroundSize backgroundSize) {
        return this.image == image && this.repeatX == backgroundRepeat && this.repeatY == backgroundRepeat2 && this.position == backgroundPosition && this.size == backgroundSize;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BackgroundImage backgroundImage = (BackgroundImage)object;
        if (this.hash != backgroundImage.hash) {
            return false;
        }
        if (!this.image.equals(backgroundImage.image)) {
            return false;
        }
        if (!this.position.equals(backgroundImage.position)) {
            return false;
        }
        if (this.repeatX != backgroundImage.repeatX) {
            return false;
        }
        if (this.repeatY != backgroundImage.repeatY) {
            return false;
        }
        return this.size.equals(backgroundImage.size);
    }

    public int hashCode() {
        return this.hash;
    }
}

