/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext.model;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.scene.layout.Region;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.HtmlExportFormatHandler;
import jfx.incubator.scene.control.richtext.model.PlainTextFormatHandler;
import jfx.incubator.scene.control.richtext.model.RichParagraph;
import jfx.incubator.scene.control.richtext.model.RichTextFormatHandler;
import jfx.incubator.scene.control.richtext.model.RtfFormatHandler;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledTextModel;

public class RichTextModel
extends StyledTextModel {
    private final ArrayList<RParagraph> paragraphs = new ArrayList();
    private final HashMap<StyleAttributeMap, StyleAttributeMap> styleCache = new HashMap();

    public RichTextModel() {
        this.registerDataFormatHandler(RichTextFormatHandler.getInstance(), true, true, 2000);
        this.registerDataFormatHandler(RtfFormatHandler.getInstance(), true, true, 1000);
        this.registerDataFormatHandler(HtmlExportFormatHandler.getInstance(), true, false, 100);
        this.registerDataFormatHandler(PlainTextFormatHandler.getInstance(), true, true, 0);
        this.paragraphs.add(new RParagraph());
    }

    @Override
    public final boolean isWritable() {
        return true;
    }

    @Override
    public int size() {
        return this.paragraphs.size();
    }

    @Override
    public String getPlainText(int n) {
        return this.paragraphs.get(n).getPlainText();
    }

    @Override
    public int getParagraphLength(int n) {
        return this.paragraphs.get(n).getTextLength();
    }

    @Override
    public RichParagraph getParagraph(int n) {
        RParagraph rParagraph = this.paragraphs.get(n);
        return rParagraph.createRichParagraph();
    }

    @Override
    protected int insertTextSegment(int n, int n2, String string, StyleAttributeMap styleAttributeMap) {
        styleAttributeMap = this.dedup(styleAttributeMap);
        RParagraph rParagraph = this.paragraphs.get(n);
        rParagraph.insertText(n2, string, styleAttributeMap);
        return string.length();
    }

    @Override
    protected void insertLineBreak(int n, int n2) {
        if (n >= this.size()) {
            RParagraph rParagraph = new RParagraph();
            this.paragraphs.add(rParagraph);
        } else {
            RParagraph rParagraph = this.paragraphs.get(n);
            RParagraph rParagraph2 = rParagraph.insertLineBreak(n2);
            this.paragraphs.add(n + 1, rParagraph2);
        }
    }

    @Override
    protected void removeRange(TextPos textPos, TextPos textPos2) {
        int n = textPos.index();
        RParagraph rParagraph = this.paragraphs.get(n);
        if (n == textPos2.index()) {
            rParagraph.removeSpan(textPos.offset(), textPos2.offset());
        } else {
            RParagraph rParagraph2 = this.paragraphs.get(textPos2.index());
            rParagraph2.removeSpan(0, textPos2.offset());
            rParagraph.removeSpan(textPos.offset(), Integer.MAX_VALUE);
            rParagraph.append(rParagraph2);
            int n2 = textPos2.index() - n;
            ++n;
            for (int i = 0; i < n2; ++i) {
                this.paragraphs.remove(n);
            }
        }
    }

    @Override
    protected void insertParagraph(int n, Supplier<Region> supplier) {
        throw new UnsupportedOperationException();
    }

    private StyleAttributeMap dedup(StyleAttributeMap styleAttributeMap) {
        StyleAttributeMap styleAttributeMap2 = this.styleCache.get(styleAttributeMap);
        if (styleAttributeMap2 != null) {
            return styleAttributeMap2;
        }
        this.styleCache.put(styleAttributeMap, styleAttributeMap);
        return styleAttributeMap;
    }

    @Override
    protected void setParagraphStyle(int n, StyleAttributeMap styleAttributeMap) {
        this.paragraphs.get(n).setParagraphAttributes(styleAttributeMap);
    }

    @Override
    protected void applyStyle(int n, int n2, int n3, StyleAttributeMap styleAttributeMap, boolean bl) {
        this.paragraphs.get(n).applyStyle(n2, n3, styleAttributeMap, bl, this::dedup);
    }

    @Override
    public StyleAttributeMap getStyleAttributeMap(StyleResolver styleResolver, TextPos textPos) {
        int n = textPos.index();
        if (n < this.paragraphs.size()) {
            int n2 = textPos.offset();
            RParagraph rParagraph = this.paragraphs.get(n);
            StyleAttributeMap styleAttributeMap = rParagraph.getParagraphAttributes();
            StyleAttributeMap styleAttributeMap2 = rParagraph.getStyleAttributeMap(n2);
            if (styleAttributeMap == null) {
                return styleAttributeMap2;
            }
            return styleAttributeMap.combine(styleAttributeMap2);
        }
        return StyleAttributeMap.EMPTY;
    }

    private static void dump(StyledTextModel styledTextModel, PrintStream printStream) {
        if (styledTextModel instanceof RichTextModel) {
            RichTextModel richTextModel = (RichTextModel)styledTextModel;
            richTextModel.dump(printStream);
        }
    }

    private void dump(PrintStream printStream) {
        printStream.println("[");
        for (RParagraph rParagraph : this.paragraphs) {
            this.dump(rParagraph, printStream);
        }
        printStream.println("]");
    }

    private void dump(RParagraph rParagraph, PrintStream printStream) {
        printStream.println("  {paragraphAttrs=" + String.valueOf(rParagraph.getParagraphAttributes()) + ", segments=[");
        for (RSegment rSegment : rParagraph) {
            printStream.println("    {text=\"" + rSegment.text() + "\", attr=" + String.valueOf(rSegment.getStyleAttributeMap()) + "},");
        }
        printStream.println("  ]}");
    }

    static class RParagraph
    extends ArrayList<RSegment> {
        private StyleAttributeMap paragraphAttrs;

        public StyleAttributeMap getParagraphAttributes() {
            return this.paragraphAttrs;
        }

        public void setParagraphAttributes(StyleAttributeMap styleAttributeMap) {
            this.paragraphAttrs = styleAttributeMap;
        }

        public String getPlainText() {
            StringBuilder stringBuilder = new StringBuilder();
            for (RSegment rSegment : this) {
                stringBuilder.append(rSegment.text());
            }
            return stringBuilder.toString();
        }

        public int getTextLength() {
            int n = 0;
            for (RSegment rSegment : this) {
                n += rSegment.getTextLength();
            }
            return n;
        }

        public StyleAttributeMap getStyleAttributeMap(int n) {
            int n2 = 0;
            int n3 = this.size();
            for (int i = 0; i < n3; ++i) {
                RSegment rSegment = (RSegment)this.get(i);
                int n4 = rSegment.getTextLength();
                if (n > (n2 += n4) && i + 1 != n3) continue;
                return rSegment.getStyleAttributeMap();
            }
            return StyleAttributeMap.EMPTY;
        }

        public void insertText(int n, String string, StyleAttributeMap styleAttributeMap) {
            int n2 = 0;
            int n3 = this.size();
            for (int i = 0; i < n3; ++i) {
                if (n == n2) {
                    this.insertSegment2(i, string, styleAttributeMap);
                    return;
                }
                RSegment rSegment = (RSegment)this.get(i);
                int n4 = rSegment.getTextLength();
                if (n > n2 && n <= n2 + n4) {
                    StyleAttributeMap styleAttributeMap2 = rSegment.attrs();
                    String string2 = rSegment.text();
                    int n5 = n - n2;
                    String string3 = string2.substring(0, n5);
                    this.set(i++, new RSegment(string3, styleAttributeMap2));
                    if (this.insertSegment2(i, string, styleAttributeMap)) {
                        ++i;
                    }
                    if (n5 < string2.length()) {
                        String string4 = string2.substring(n5);
                        this.insertSegment2(i, string4, styleAttributeMap2);
                    }
                    return;
                }
                n2 += n4;
            }
            this.insertSegment2(n3, string, styleAttributeMap);
        }

        private boolean insertSegment2(int n, String string, StyleAttributeMap styleAttributeMap) {
            RSegment rSegment;
            if (n == 0) {
                if (n < this.size()) {
                    rSegment = (RSegment)this.get(n);
                    if (rSegment.getTextLength() == 0) {
                        rSegment.setText(string);
                        rSegment.setAttrs(styleAttributeMap);
                        return false;
                    }
                    if (styleAttributeMap.equals(rSegment.attrs())) {
                        rSegment.setText(string + rSegment.text());
                        return false;
                    }
                }
            } else if (n > 0 && styleAttributeMap.equals((rSegment = (RSegment)this.get(n - 1)).attrs())) {
                rSegment.append(string);
                return false;
            }
            rSegment = new RSegment(string, styleAttributeMap);
            if (n < this.size()) {
                this.add(n, rSegment);
            } else {
                this.add(rSegment);
            }
            return true;
        }

        private boolean insertSegment(int n, String string, StyleAttributeMap styleAttributeMap) {
            RSegment rSegment;
            if (n > 0 && (rSegment = (RSegment)this.get(n - 1)).attrs().equals(styleAttributeMap)) {
                rSegment.append(string);
                return true;
            }
            rSegment = new RSegment(string, styleAttributeMap);
            if (n >= this.size()) {
                this.add(rSegment);
            } else {
                this.add(n, rSegment);
            }
            return false;
        }

        public RParagraph insertLineBreak(int n) {
            Object object;
            int n2;
            RParagraph rParagraph = new RParagraph();
            rParagraph.setParagraphAttributes(this.getParagraphAttributes());
            int n3 = 0;
            int n4 = this.size();
            for (n2 = 0; n2 < n4; ++n2) {
                object = (RSegment)this.get(n2);
                int n5 = ((RSegment)object).getTextLength();
                if (n < n3 + n5) {
                    if (n == n3) break;
                    StyleAttributeMap styleAttributeMap = ((RSegment)object).attrs();
                    String string = ((RSegment)object).text();
                    int n6 = n - n3;
                    String string2 = string.substring(0, n6);
                    String string3 = string.substring(n6);
                    this.set(n2, new RSegment(string2, styleAttributeMap));
                    rParagraph.add(new RSegment(string3, styleAttributeMap));
                    ++n2;
                    break;
                }
                n3 += n5;
            }
            while (n2 < this.size()) {
                object = (RSegment)this.remove(n2);
                rParagraph.add(object);
            }
            if (this.size() == 0 && rParagraph.size() > 0) {
                object = ((RSegment)rParagraph.get(0)).getStyleAttributeMap();
                this.add(new RSegment("", (StyleAttributeMap)object));
            }
            if (rParagraph.size() == 0 && this.size() > 0) {
                object = ((RSegment)this.get(this.size() - 1)).getStyleAttributeMap();
                rParagraph.add(new RSegment("", (StyleAttributeMap)object));
            }
            return rParagraph;
        }

        public void append(RParagraph rParagraph) {
            if (this.isMerge(rParagraph)) {
                int n = rParagraph.size();
                for (int i = 0; i < n; ++i) {
                    RSegment rSegment = (RSegment)rParagraph.get(i);
                    if (i == 0) {
                        RSegment rSegment2 = (RSegment)this.get(this.size() - 1);
                        rSegment2.append(rSegment.text());
                        continue;
                    }
                    this.add(rSegment);
                }
                return;
            }
            if (this.isZeroWidth()) {
                this.clear();
            }
            this.addAll(rParagraph);
        }

        private boolean isMerge(RParagraph rParagraph) {
            if (this.size() == 0) {
                return false;
            }
            if (rParagraph.size() == 0) {
                return false;
            }
            return ((RSegment)this.get(this.size() - 1)).getStyleAttributeMap().equals(((RSegment)rParagraph.get(0)).getStyleAttributeMap());
        }

        private boolean isZeroWidth() {
            return this.size() == 1 && ((RSegment)this.get(0)).getTextLength() == 0;
        }

        public void removeSpan(int n, int n2) {
            RSegment rSegment;
            int n3;
            int n4;
            if (n == n2) {
                return;
            }
            int n5 = -1;
            int n6 = 0;
            int n7 = 0;
            int n8 = this.size();
            for (n4 = 0; n4 < n8; ++n4) {
                RSegment rSegment2 = (RSegment)this.get(n4);
                n3 = rSegment2.getTextLength();
                if (n < n7 + n3) {
                    n5 = n4;
                    n6 = n - n7;
                    break;
                }
                n7 += n3;
            }
            if (n5 < 0) {
                return;
            }
            int n9 = -1;
            n3 = -1;
            while (n4 < n8) {
                rSegment = (RSegment)this.get(n4);
                int n10 = rSegment.getTextLength();
                if (n2 <= n7 + n10) {
                    n9 = n4;
                    n3 = n2 - n7;
                    break;
                }
                n7 += n10;
                ++n4;
            }
            if (n5 == n9) {
                rSegment = (RSegment)this.get(n5);
                if (rSegment.removeRegion(n6, n3)) {
                    this.remove(n5);
                    if (this.size() == 0) {
                        this.add(new RSegment("", rSegment.getStyleAttributeMap()));
                    }
                }
            } else {
                rSegment = (RSegment)this.get(n5);
                if (rSegment.removeRegion(n6, Integer.MAX_VALUE)) {
                    this.remove(n5);
                    --n9;
                    --n8;
                } else {
                    ++n5;
                }
                if (n9 < 0) {
                    n9 = n8;
                } else {
                    RSegment rSegment3 = (RSegment)this.get(n9);
                    if (rSegment3.removeRegion(0, n3)) {
                        this.remove(n9);
                    }
                }
                this.removeRange(n5, n9);
                if (this.size() == 0) {
                    this.add(new RSegment("", rSegment.getStyleAttributeMap()));
                }
            }
        }

        public void applyStyle(int n, int n2, StyleAttributeMap styleAttributeMap, boolean bl, Function<StyleAttributeMap, StyleAttributeMap> function) {
            int n3 = 0;
            for (int i = 0; i < this.size(); ++i) {
                RSegment rSegment = (RSegment)this.get(i);
                int n4 = rSegment.getTextLength();
                int n5 = RParagraph.whichCase(n3, n3 + n4, n, n2);
                switch (n5) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (!this.applyStyle(i, rSegment, styleAttributeMap, bl, function)) break;
                        --i;
                        break;
                    }
                    case 3: 
                    case 9: {
                        this.applyStyle(i, rSegment, styleAttributeMap, bl, function);
                        return;
                    }
                    case 4: 
                    case 8: {
                        StyleAttributeMap styleAttributeMap2 = rSegment.attrs();
                        StyleAttributeMap styleAttributeMap3 = function.apply(bl ? styleAttributeMap2.combine(styleAttributeMap) : styleAttributeMap);
                        int n6 = n2 - n3;
                        String string = rSegment.text().substring(0, n6);
                        String string2 = rSegment.text().substring(n6);
                        this.remove(i);
                        if (this.insertSegment(i++, string, styleAttributeMap3)) {
                            --i;
                        }
                        if (this.insertSegment(i, string2, styleAttributeMap2)) {
                            --i;
                        }
                        return;
                    }
                    case 5: 
                    case 6: {
                        StyleAttributeMap styleAttributeMap2 = rSegment.attrs();
                        StyleAttributeMap styleAttributeMap3 = function.apply(bl ? styleAttributeMap2.combine(styleAttributeMap) : styleAttributeMap);
                        int n6 = n - n3;
                        String string = rSegment.text().substring(0, n6);
                        String string2 = rSegment.text().substring(n6);
                        this.remove(i);
                        if (this.insertSegment(i++, string, styleAttributeMap2)) {
                            --i;
                        }
                        if (this.insertSegment(i, string2, styleAttributeMap3)) {
                            --i;
                        }
                        if (n5 != 6) break;
                        return;
                    }
                    case 7: {
                        StyleAttributeMap styleAttributeMap2 = rSegment.attrs();
                        StyleAttributeMap styleAttributeMap3 = function.apply(bl ? styleAttributeMap2.combine(styleAttributeMap) : styleAttributeMap);
                        String string = rSegment.text();
                        int n7 = n - n3;
                        int n8 = n2 - n3;
                        String string3 = string.substring(0, n7);
                        String string4 = string.substring(n7, n8);
                        String string5 = string.substring(n8);
                        this.remove(i);
                        if (this.insertSegment(i++, string3, styleAttributeMap2)) {
                            // empty if block
                        }
                        int n9 = --i;
                        ++i;
                        if (this.insertSegment(n9, string4, styleAttributeMap3)) {
                            --i;
                        }
                        if (this.insertSegment(i, string5, styleAttributeMap2)) {
                            --i;
                        }
                        return;
                    }
                    default: {
                        throw new Error("?" + n5);
                    }
                }
                n3 += n4;
            }
        }

        private boolean applyStyle(int n, RSegment rSegment, StyleAttributeMap styleAttributeMap, boolean bl, Function<StyleAttributeMap, StyleAttributeMap> function) {
            RSegment rSegment2;
            StyleAttributeMap styleAttributeMap2 = function.apply(bl ? rSegment.attrs().combine(styleAttributeMap) : styleAttributeMap);
            if (n > 0 && (rSegment2 = (RSegment)this.get(n - 1)).attrs().equals(styleAttributeMap2)) {
                rSegment2.append(rSegment.text());
                this.remove(n);
                return true;
            }
            rSegment.setAttrs(styleAttributeMap2);
            return false;
        }

        private static int whichCase(int n, int n2, int n3, int n4) {
            if (n3 >= n2) {
                if (n3 == n2 && n == n2) {
                    return 3;
                }
                return 0;
            }
            if (n3 < n) {
                if (n4 > n2) {
                    return 1;
                }
                if (n4 < n2) {
                    return 8;
                }
                return 9;
            }
            if (n3 > n) {
                if (n4 > n2) {
                    return 5;
                }
                if (n4 < n2) {
                    return 7;
                }
                return 6;
            }
            if (n4 > n2) {
                return 2;
            }
            if (n4 < n2) {
                return 4;
            }
            return 3;
        }

        private RichParagraph createRichParagraph() {
            RichParagraph.Builder builder = RichParagraph.builder();
            for (RSegment rSegment : this) {
                String string = rSegment.text();
                StyleAttributeMap styleAttributeMap = rSegment.attrs();
                builder.addSegment(string, styleAttributeMap);
            }
            builder.setParagraphAttributes(this.paragraphAttrs);
            return builder.build();
        }
    }

    private static class RSegment {
        private String text;
        private StyleAttributeMap attrs;

        public RSegment(String string, StyleAttributeMap styleAttributeMap) {
            this.text = string;
            this.attrs = styleAttributeMap;
        }

        public String text() {
            return this.text;
        }

        public StyleAttributeMap attrs() {
            return this.attrs;
        }

        public void setAttrs(StyleAttributeMap styleAttributeMap) {
            this.attrs = styleAttributeMap;
        }

        public StyleAttributeMap getStyleAttributeMap() {
            return this.attrs;
        }

        public int getTextLength() {
            return this.text.length();
        }

        public boolean removeRegion(int n, int n2) {
            int n3 = this.text.length();
            if (n2 > n3) {
                n2 = n3;
            }
            this.text = n == 0 ? (n2 < n3 ? this.text.substring(n2) : "") : (n2 < n3 ? this.text.substring(0, n) + this.text.substring(n2, n3) : this.text.substring(0, n));
            return this.text.length() == 0;
        }

        public void append(String string) {
            this.text = this.text + string;
        }

        public void setText(String string) {
            this.text = string;
        }
    }
}

