/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import jfx.incubator.scene.control.richtext.RichTextArea;
import jfx.incubator.scene.control.richtext.TextPos;

public class SelInfo {
    private final RichTextArea control;
    private final TextPos caret;
    private final TextPos anchor;
    private final boolean caretAtMin;

    public SelInfo(RichTextArea richTextArea, TextPos textPos, TextPos textPos2, boolean bl) {
        this.control = richTextArea;
        this.caret = textPos;
        this.anchor = textPos2;
        this.caretAtMin = bl;
    }

    public static SelInfo get(RichTextArea richTextArea) {
        if (richTextArea == null) {
            return null;
        }
        TextPos textPos = richTextArea.getCaretPosition();
        if (textPos == null) {
            return null;
        }
        TextPos textPos2 = richTextArea.getAnchorPosition();
        if (textPos2 == null) {
            textPos2 = textPos;
        }
        boolean bl = textPos.compareTo(textPos2) <= 0;
        return new SelInfo(richTextArea, textPos, textPos2, bl);
    }

    public TextPos getMin() {
        return this.caretAtMin ? this.caret : this.anchor;
    }

    public TextPos getMax() {
        return this.caretAtMin ? this.anchor : this.caret;
    }

    public TextPos getCaret() {
        return this.caret;
    }

    public TextPos getAnchor() {
        return this.anchor;
    }

    public boolean hasSelection() {
        return this.caret.compareTo(this.anchor) != 0;
    }
}

