/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import java.util.Arrays;
import java.util.Objects;
import javafx.animation.Interpolator;
import javafx.geometry.Point2D;

public final class LinearInterpolator
extends Interpolator {
    private final double[] controlPoints;

    public LinearInterpolator(Point2D[] point2DArray) {
        Objects.requireNonNull(point2DArray, "controlPoints cannot be null");
        if (point2DArray.length < 2) {
            throw new IllegalArgumentException("controlPoints must have at least two items");
        }
        int n = point2DArray.length;
        this.controlPoints = new double[n * 2];
        for (int i = 0; i < n; ++i) {
            Point2D point2D = point2DArray[i];
            this.controlPoints[2 * i] = point2D.getX();
            this.controlPoints[2 * i + 1] = point2D.getY();
        }
        LinearInterpolator.canonicalize(this.controlPoints, n);
    }

    private static void canonicalize(double[] dArray, int n) {
        int n2;
        int n3;
        if (Double.isNaN(dArray[0])) {
            dArray[0] = 0.0;
        }
        if (Double.isNaN(dArray[n3 = 2 * (n - 1)])) {
            dArray[n3] = 1.0;
        }
        double d = dArray[0];
        for (n2 = 1; n2 < n; ++n2) {
            double d2 = dArray[2 * n2];
            if (d2 < d) {
                dArray[2 * n2] = d;
                continue;
            }
            if (Double.isNaN(d2)) continue;
            d = d2;
        }
        for (n2 = 1; n2 < n; ++n2) {
            int n4;
            if (!Double.isNaN(dArray[2 * n2])) continue;
            for (n4 = n2; n4 < n && Double.isNaN(dArray[2 * n4]); ++n4) {
            }
            double d3 = dArray[2 * (n2 - 1)];
            double d4 = dArray[2 * n4];
            double d5 = (d4 - d3) / (double)(n4 - n2 + 1);
            double d6 = d3;
            for (int i = n2; i < n4; ++i) {
                dArray[2 * i] = d6 += d5;
            }
            n2 = n4;
        }
    }

    @Override
    public double curve(double d) {
        int n = this.controlPoints.length / 2;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n && this.controlPoints[2 * n3] <= d) {
            n2 = n3++;
        }
        if (n2 == n - 1) {
            --n2;
        }
        n3 = n2 * 2;
        double d2 = this.controlPoints[n3];
        double d3 = this.controlPoints[n3 + 1];
        double d4 = this.controlPoints[n3 + 2];
        double d5 = this.controlPoints[n3 + 3];
        if (d2 == d4) {
            return d5;
        }
        double d6 = d - d2;
        double d7 = d4 - d2;
        double d8 = d6 / d7;
        double d9 = d5 - d3;
        double d10 = d8 * d9;
        return d3 + d10;
    }

    public String toString() {
        return "LinearInterpolator " + Arrays.toString(this.controlPoints);
    }
}

