/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext.model;

import com.sun.jfx.incubator.scene.control.richtext.RichParagraphHelper;
import com.sun.jfx.incubator.scene.control.richtext.TextCell;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledOutput;
import jfx.incubator.scene.control.richtext.model.StyledSegment;

public abstract class RichParagraph {
    public static RichParagraph of(final Supplier<Region> supplier) {
        return new RichParagraph(){

            @Override
            public final Supplier<Region> getParagraphRegion() {
                return supplier;
            }

            @Override
            public final String getPlainText() {
                return "";
            }

            @Override
            public void export(int n, int n2, StyledOutput styledOutput) throws IOException {
                StyledSegment styledSegment = StyledSegment.ofRegion(supplier);
                styledOutput.consume(styledSegment);
            }

            @Override
            List<StyledSegment> getSegments() {
                return null;
            }
        };
    }

    public Supplier<Region> getParagraphRegion() {
        return null;
    }

    public abstract String getPlainText();

    abstract List<StyledSegment> getSegments();

    public StyleAttributeMap getParagraphAttributes() {
        return null;
    }

    List<Consumer<TextCell>> getHighlights() {
        return null;
    }

    void export(int n, int n2, StyledOutput styledOutput) throws IOException {
        List<StyledSegment> list = this.getSegments();
        if (list == null) {
            styledOutput.consume(StyledSegment.of(""));
        } else {
            int n3 = 0;
            int n4 = list.size();
            for (int i = 0; i < n4; ++i) {
                int n5;
                StyledSegment styledSegment = list.get(i);
                String string = styledSegment.getText();
                int n6 = n5 = string == null ? 0 : string.length();
                if (n <= n3 + n5) {
                    int n7 = Math.max(0, n - n3);
                    int n8 = Math.min(n5, n2 - n3);
                    if (n8 > n7) {
                        StyledSegment styledSegment2 = styledSegment.subSegment(n7, n8);
                        styledOutput.consume(styledSegment2);
                    }
                }
                if ((n3 += n5) < n2) continue;
                return;
            }
        }
    }

    private static void initAccessor() {
        RichParagraphHelper.setAccessor(new RichParagraphHelper.Accessor(){

            @Override
            public List<StyledSegment> getSegments(RichParagraph richParagraph) {
                return richParagraph.getSegments();
            }

            @Override
            public List<Consumer<TextCell>> getHighlights(RichParagraph richParagraph) {
                return richParagraph.getHighlights();
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        RichParagraph.initAccessor();
    }

    public static class Builder {
        private ArrayList<StyledSegment> segments;
        private ArrayList<Consumer<TextCell>> highlights;
        private StyleAttributeMap paragraphAttributes;

        Builder() {
        }

        public Builder addWavyUnderline(int n, int n2, Color color) {
            int n3 = n + n2;
            this.highlights().add(textCell -> textCell.addSquiggly(n, n3, color));
            return this;
        }

        public Builder addWavyUnderline(int n, int n2, String ... stringArray) {
            int n3 = n + n2;
            this.highlights().add(textCell -> textCell.addSquiggly(n, n3, stringArray));
            return this;
        }

        private List<Consumer<TextCell>> highlights() {
            if (this.highlights == null) {
                this.highlights = new ArrayList(4);
            }
            return this.highlights;
        }

        public Builder addSegment(String string) {
            StyledSegment styledSegment = StyledSegment.of(string);
            this.segments().add(styledSegment);
            return this;
        }

        public Builder addWithStyleNames(String string, String ... stringArray) {
            Objects.nonNull(string);
            Objects.nonNull(stringArray);
            StyleAttributeMap styleAttributeMap = StyleAttributeMap.fromStyles(null, stringArray);
            this.addSegment(string, styleAttributeMap);
            return this;
        }

        public Builder addWithInlineAndStyleNames(String string, String string2, String ... stringArray) {
            Objects.nonNull(string);
            StyleAttributeMap styleAttributeMap = StyleAttributeMap.fromStyles(string2, stringArray);
            this.addSegment(string, styleAttributeMap);
            return this;
        }

        public Builder addWithInlineStyle(String string, String string2) {
            Objects.nonNull(string);
            StyleAttributeMap styleAttributeMap = StyleAttributeMap.fromStyles(string2, new String[0]);
            this.addSegment(string, styleAttributeMap);
            return this;
        }

        public Builder addSegment(String string, StyleAttributeMap styleAttributeMap) {
            Objects.nonNull(string);
            Objects.nonNull(styleAttributeMap);
            StyledSegment styledSegment = StyledSegment.of(string, styleAttributeMap);
            this.segments().add(styledSegment);
            return this;
        }

        public Builder addSegment(String string, int n, int n2, StyleAttributeMap styleAttributeMap) {
            Objects.nonNull(string);
            String string2 = string.substring(n, n2);
            this.addSegment(string2, styleAttributeMap);
            return this;
        }

        public Builder addHighlight(int n, int n2, Color color) {
            int n3 = n + n2;
            this.highlights().add(textCell -> textCell.addHighlight(n, n3, color));
            return this;
        }

        public Builder addHighlight(int n, int n2, String ... stringArray) {
            int n3 = n + n2;
            this.highlights().add(textCell -> textCell.addHighlight(n, n3, stringArray));
            return this;
        }

        public Builder addInlineNode(Supplier<Node> supplier) {
            StyledSegment styledSegment = StyledSegment.ofInlineNode(supplier);
            this.segments().add(styledSegment);
            return this;
        }

        private List<StyledSegment> segments() {
            if (this.segments == null) {
                this.segments = new ArrayList(8);
            }
            return this.segments;
        }

        public Builder setParagraphAttributes(StyleAttributeMap styleAttributeMap) {
            this.paragraphAttributes = styleAttributeMap;
            return this;
        }

        public RichParagraph build() {
            final ArrayList<Consumer<TextCell>> arrayList = this.highlights;
            final StyleAttributeMap styleAttributeMap = this.paragraphAttributes == null ? StyleAttributeMap.EMPTY : this.paragraphAttributes;
            final List<StyledSegment> list = this.segments == null ? null : List.copyOf(this.segments);
            return new RichParagraph(this){

                @Override
                public StyleAttributeMap getParagraphAttributes() {
                    return styleAttributeMap;
                }

                @Override
                List<StyledSegment> getSegments() {
                    return list;
                }

                @Override
                public String getPlainText() {
                    if (list == null) {
                        return "";
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    for (StyledSegment styledSegment : list) {
                        stringBuilder.append(styledSegment.getText());
                    }
                    return stringBuilder.toString();
                }

                @Override
                List<Consumer<TextCell>> getHighlights() {
                    return arrayList;
                }
            };
        }
    }
}

