/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.glass.ui.Screen;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.EmbeddedStageInterface;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.embed.swing.SwingCursors;
import com.sun.javafx.embed.swing.SwingDnD;
import com.sun.javafx.embed.swing.SwingEvents;
import com.sun.javafx.embed.swing.SwingNodeHelper;
import com.sun.javafx.embed.swing.newimpl.JFXPanelInteropN;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.stage.EmbeddedWindow;
import com.sun.javafx.tk.Toolkit;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SecondaryLoop;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.IntBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.embed.swing.InputMethodSupport;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point2D;
import javafx.scene.Scene;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class JFXPanel
extends JComponent {
    private static final PlatformLogger log = PlatformLogger.getLogger((String)JFXPanel.class.getName());
    private static AtomicInteger instanceCount = new AtomicInteger(0);
    private static PlatformImpl.FinishListener finishListener;
    private transient HostContainer hostContainer;
    private volatile transient EmbeddedWindow fx_stage;
    private volatile transient Scene scene;
    private transient SwingDnD dnd;
    private transient EmbeddedStageInterface fx_stagePeer;
    private transient EmbeddedSceneInterface fx_scenePeer;
    private int pWidth;
    private int pHeight;
    private double scaleFactorX = 1.0;
    private double scaleFactorY = 1.0;
    private volatile int pPreferredWidth = -1;
    private volatile int pPreferredHeight = -1;
    private volatile int screenX = 0;
    private volatile int screenY = 0;
    private BufferedImage pixelsIm;
    private volatile float opacity = 1.0f;
    private AtomicInteger disableCount = new AtomicInteger(0);
    private boolean isCapturingMouse = false;
    private static boolean fxInitialized;
    private JFXPanelInteropN jfxPanelIOP;
    private transient AWTEventListener ungrabListener = aWTEvent -> {
        if (this.jfxPanelIOP.isUngrabEvent(aWTEvent)) {
            SwingNodeHelper.runOnFxThread(() -> {
                if (this.fx_stagePeer != null && this.getScene() != null && this.getScene().getFocusOwner() != null && this.getScene().getFocusOwner().isFocused()) {
                    this.fx_stagePeer.focusUngrab();
                }
            });
        }
        if (aWTEvent instanceof MouseEvent && aWTEvent.getID() == 501 && aWTEvent.getSource() instanceof Component) {
            Window window;
            Window window2 = SwingUtilities.getWindowAncestor(this);
            Component component = (Component)aWTEvent.getSource();
            Window window3 = window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
            if (window2 == window) {
                SwingNodeHelper.runOnFxThread(() -> {
                    if (this.fx_stagePeer != null) {
                        this.fx_stagePeer.focusUngrab();
                    }
                });
            }
        }
    };

    private synchronized void registerFinishListener() {
        if (instanceCount.getAndIncrement() > 0) {
            return;
        }
        finishListener = new PlatformImpl.FinishListener(this){

            public void idle(boolean bl) {
            }

            public void exitCalled() {
            }
        };
        PlatformImpl.addListener((PlatformImpl.FinishListener)finishListener);
    }

    private synchronized void deregisterFinishListener() {
        if (instanceCount.decrementAndGet() > 0) {
            return;
        }
        PlatformImpl.removeListener((PlatformImpl.FinishListener)finishListener);
        finishListener = null;
    }

    private static synchronized void initFx() {
        if (fxInitialized) {
            return;
        }
        EventQueue eventQueue = java.awt.Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (eventQueue.isDispatchThread()) {
            SecondaryLoop secondaryLoop = eventQueue.createSecondaryLoop();
            Throwable[] throwableArray = new Throwable[]{null};
            new Thread(() -> {
                try {
                    PlatformImpl.startup(() -> {});
                }
                catch (Throwable throwable) {
                    throwableArray[0] = throwable;
                }
                finally {
                    secondaryLoop.exit();
                }
            }).start();
            secondaryLoop.enter();
            if (throwableArray[0] != null) {
                if (throwableArray[0] instanceof RuntimeException) {
                    throw (RuntimeException)throwableArray[0];
                }
                if (throwableArray[0] instanceof Error) {
                    throw (Error)throwableArray[0];
                }
                throw new RuntimeException("FX initialization failed", throwableArray[0]);
            }
        } else {
            PlatformImpl.startup(() -> {});
        }
        fxInitialized = true;
    }

    public JFXPanel() {
        this.jfxPanelIOP = new JFXPanelInteropN();
        JFXPanel.initFx();
        this.hostContainer = new HostContainer();
        this.enableEvents(231485L);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
    }

    public Scene getScene() {
        return this.scene;
    }

    public void setScene(Scene scene) {
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.setSceneImpl(scene);
        } else {
            EventQueue eventQueue = java.awt.Toolkit.getDefaultToolkit().getSystemEventQueue();
            SecondaryLoop secondaryLoop = eventQueue.createSecondaryLoop();
            Platform.runLater(() -> {
                try {
                    this.setSceneImpl(scene);
                }
                finally {
                    secondaryLoop.exit();
                }
            });
            secondaryLoop.enter();
        }
    }

    private void setSceneImpl(Scene scene) {
        if (this.fx_stage != null && scene == null) {
            this.fx_stage.hide();
            this.fx_stage = null;
        }
        this.scene = scene;
        if (this.fx_stage == null && scene != null) {
            this.fx_stage = new EmbeddedWindow((HostInterface)this.hostContainer);
        }
        if (this.fx_stage != null) {
            this.fx_stage.setScene(scene);
            if (!this.fx_stage.isShowing()) {
                this.fx_stage.show();
            }
        }
    }

    @Override
    public final void setOpaque(boolean bl) {
        if (!bl) {
            super.setOpaque(bl);
        }
    }

    @Override
    public final boolean isOpaque() {
        return false;
    }

    private Screen findScreen(GraphicsConfiguration graphicsConfiguration) {
        Rectangle rectangle = graphicsConfiguration.getBounds();
        AffineTransform affineTransform = graphicsConfiguration.getDefaultTransform();
        for (Screen screen : Screen.getScreens()) {
            if (!(Math.abs((double)screen.getPlatformX() - rectangle.getX()) < 2.0) || !(Math.abs((double)screen.getPlatformY() - rectangle.getY()) < 2.0) || !(Math.abs((double)screen.getPlatformWidth() - affineTransform.getScaleX() * rectangle.getWidth()) < 2.0) || !(Math.abs((double)screen.getPlatformHeight() - affineTransform.getScaleY() * rectangle.getHeight()) < 2.0)) continue;
            return screen;
        }
        return null;
    }

    private Point2D convertSwingToFxPixel(GraphicsConfiguration graphicsConfiguration, double d, double d2) {
        double d3;
        double d4;
        Screen screen = this.findScreen(graphicsConfiguration);
        if (screen != null) {
            AffineTransform affineTransform = this.getGraphicsConfiguration().getDefaultTransform();
            float f = screen.getPlatformScaleX();
            float f2 = screen.getPlatformScaleY();
            int n = screen.getX();
            int n2 = screen.getY();
            double d5 = affineTransform.getScaleX();
            double d6 = affineTransform.getScaleY();
            int n3 = screen.getPlatformX();
            int n4 = screen.getPlatformY();
            d4 = (double)n + (d - (double)n3) * d5 / (double)f;
            d3 = (double)n2 + (d2 - (double)n4) * d6 / (double)f2;
        } else {
            d4 = d;
            d3 = d2;
        }
        return new Point2D(d4, d3);
    }

    private void sendMouseEventToFX(MouseEvent mouseEvent) {
        boolean bl;
        EmbeddedSceneInterface embeddedSceneInterface = this.fx_scenePeer;
        if (embeddedSceneInterface == null || !this.isFxEnabled()) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: 
            case 502: 
            case 506: {
                if (mouseEvent.getButton() <= 5) break;
                return;
            }
        }
        int n = mouseEvent.getModifiersEx();
        boolean bl2 = (n & 0x400) != 0;
        boolean bl3 = (n & 0x800) != 0;
        boolean bl4 = (n & 0x1000) != 0;
        boolean bl5 = (n & MouseEvent.getMaskForButton(4)) != 0;
        boolean bl6 = bl = (n & MouseEvent.getMaskForButton(5)) != 0;
        if (mouseEvent.getID() == 506) {
            if (!this.isCapturingMouse) {
                return;
            }
        } else if (mouseEvent.getID() == 501) {
            this.isCapturingMouse = true;
        } else if (mouseEvent.getID() == 502) {
            if (!this.isCapturingMouse) {
                return;
            }
            this.isCapturingMouse = bl2 || bl3 || bl4 || bl5 || bl;
        } else if (mouseEvent.getID() == 500) {
            return;
        }
        boolean bl7 = false;
        if (mouseEvent.getID() == 501 || mouseEvent.getID() == 502) {
            bl7 = mouseEvent.isPopupTrigger();
        }
        Point2D point2D = this.convertSwingToFxPixel(this.getGraphicsConfiguration(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen());
        int n2 = (int)Math.round(point2D.getX());
        int n3 = (int)Math.round(point2D.getY());
        if (mouseEvent.getID() == 507) {
            embeddedSceneInterface.scrollEvent(7, 0.0, (double)(-SwingEvents.getWheelRotation(mouseEvent)), 0.0, 0.0, 40.0, 40.0, (double)mouseEvent.getX(), (double)mouseEvent.getY(), (double)n2, (double)n3, (n & 0x40) != 0, (n & 0x80) != 0, (n & 0x200) != 0, (n & 0x100) != 0, false);
        } else {
            embeddedSceneInterface.mouseEvent(SwingEvents.mouseIDToEmbedMouseType(mouseEvent.getID()), SwingEvents.mouseButtonToEmbedMouseButton(mouseEvent.getButton(), n), bl2, bl3, bl4, bl5, bl, mouseEvent.getX(), mouseEvent.getY(), n2, n3, (n & 0x40) != 0, (n & 0x80) != 0, (n & 0x200) != 0, (n & 0x100) != 0, bl7);
        }
        if (mouseEvent.isPopupTrigger()) {
            embeddedSceneInterface.menuEvent(mouseEvent.getX(), mouseEvent.getY(), n2, n3, false);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        EmbeddedStageInterface embeddedStageInterface = this.fx_stagePeer;
        if (mouseEvent.getID() == 501 && mouseEvent.getButton() == 1 && this.isFocusable() && !this.hasFocus()) {
            this.requestFocus();
            if (embeddedStageInterface != null) {
                int n = 0;
                embeddedStageInterface.setFocused(true, n);
            }
        }
        this.sendMouseEventToFX(mouseEvent);
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.sendMouseEventToFX(mouseEvent);
        super.processMouseMotionEvent(mouseEvent);
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        this.sendMouseEventToFX(mouseWheelEvent);
        super.processMouseWheelEvent(mouseWheelEvent);
    }

    private void sendKeyEventToFX(KeyEvent keyEvent) {
        char[] cArray;
        EmbeddedSceneInterface embeddedSceneInterface = this.fx_scenePeer;
        if (embeddedSceneInterface == null || !this.isFxEnabled()) {
            return;
        }
        if (keyEvent.getKeyChar() == '\uffff') {
            cArray = new char[]{};
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = SwingEvents.keyCharToEmbedKeyChar(keyEvent.getKeyChar());
        }
        char[] cArray3 = cArray;
        embeddedSceneInterface.keyEvent(SwingEvents.keyIDToEmbedKeyType(keyEvent.getID()), keyEvent.getKeyCode(), cArray3, SwingEvents.keyModifiersToEmbedKeyModifiers(keyEvent.getModifiersEx()));
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        this.sendKeyEventToFX(keyEvent);
        super.processKeyEvent(keyEvent);
    }

    private void sendResizeEventToFX() {
        EmbeddedStageInterface embeddedStageInterface = this.fx_stagePeer;
        EmbeddedSceneInterface embeddedSceneInterface = this.fx_scenePeer;
        if (embeddedStageInterface != null) {
            embeddedStageInterface.setSize(this.pWidth, this.pHeight);
        }
        if (embeddedSceneInterface != null) {
            embeddedSceneInterface.setSize(this.pWidth, this.pHeight);
        }
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        switch (componentEvent.getID()) {
            case 101: {
                this.updateComponentSize();
                break;
            }
            case 100: {
                if (!this.updateScreenLocation()) break;
                this.sendMoveEventToFX();
                break;
            }
        }
        super.processComponentEvent(componentEvent);
    }

    private AffineTransform getCurrentTransform() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        return graphicsConfiguration.getDefaultTransform();
    }

    private void updateComponentSize() {
        Object object;
        int n = this.pWidth;
        int n2 = this.pHeight;
        if (this.getBorder() != null) {
            object = this.getBorder().getBorderInsets(this);
            this.pWidth -= ((Insets)object).left + ((Insets)object).right;
            this.pHeight -= ((Insets)object).top + ((Insets)object).bottom;
        }
        this.pWidth = Math.max(0, this.getWidth());
        this.pHeight = Math.max(0, this.getHeight());
        object = this.getGraphics();
        AffineTransform affineTransform = this.getCurrentTransform();
        double d = affineTransform.getScaleX();
        double d2 = affineTransform.getScaleY();
        if (n == 0 && n2 == 0 && this.pWidth == 0 && this.pHeight == 0) {
            return;
        }
        if (n != this.pWidth || n2 != this.pHeight || d != this.scaleFactorX || d2 != this.scaleFactorY) {
            this.createResizePixelBuffer(d, d2);
            EmbeddedSceneInterface embeddedSceneInterface = this.fx_scenePeer;
            if (embeddedSceneInterface != null) {
                embeddedSceneInterface.setPixelScaleFactors((float)d, (float)d2);
            }
            this.scaleFactorX = d;
            this.scaleFactorY = d2;
            this.sendResizeEventToFX();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateScreenLocation() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isShowing()) {
                Point point = this.getLocationOnScreen();
                Point2D point2D = this.convertSwingToFxPixel(this.getGraphicsConfiguration(), point.x, point.y);
                this.screenX = (int)Math.round(point2D.getX());
                this.screenY = (int)Math.round(point2D.getY());
                return true;
            }
        }
        return false;
    }

    private void sendMoveEventToFX() {
        EmbeddedStageInterface embeddedStageInterface = this.fx_stagePeer;
        if (embeddedStageInterface != null) {
            embeddedStageInterface.setLocation(this.screenX, this.screenY);
        }
    }

    @Override
    protected void processHierarchyBoundsEvent(HierarchyEvent hierarchyEvent) {
        if (hierarchyEvent.getID() == 1401 && this.updateScreenLocation()) {
            this.sendMoveEventToFX();
        }
        super.processHierarchyBoundsEvent(hierarchyEvent);
    }

    @Override
    protected void processHierarchyEvent(HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && this.updateScreenLocation()) {
            this.sendMoveEventToFX();
        }
        super.processHierarchyEvent(hierarchyEvent);
    }

    private void sendFocusEventToFX(FocusEvent focusEvent) {
        int n;
        EmbeddedStageInterface embeddedStageInterface = this.fx_stagePeer;
        if (this.fx_stage == null || embeddedStageInterface == null || !this.isFxEnabled()) {
            return;
        }
        boolean bl = focusEvent.getID() == 1004;
        int n2 = n = bl ? 0 : 3;
        if (bl) {
            if (focusEvent.getCause() == FocusEvent.Cause.TRAVERSAL_FORWARD) {
                n = 1;
            } else if (focusEvent.getCause() == FocusEvent.Cause.TRAVERSAL_BACKWARD) {
                n = 2;
            }
        }
        embeddedStageInterface.setFocused(bl, n);
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        this.sendFocusEventToFX(focusEvent);
        super.processFocusEvent(focusEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createResizePixelBuffer(double d, double d2) {
        EmbeddedSceneInterface embeddedSceneInterface = this.fx_scenePeer;
        if (embeddedSceneInterface == null || this.pWidth <= 0 || this.pHeight <= 0) {
            this.pixelsIm = null;
        } else {
            BufferedImage bufferedImage = this.pixelsIm;
            int n = (int)Math.ceil((double)this.pWidth * d);
            int n2 = (int)Math.ceil((double)this.pHeight * d2);
            this.pixelsIm = new BufferedImage(n, n2, SwingFXUtils.getBestBufferedImageType(embeddedSceneInterface.getPixelFormat(), null, false));
            if (bufferedImage != null) {
                double d3 = d / this.scaleFactorX;
                double d4 = d2 / this.scaleFactorY;
                int n3 = (int)Math.ceil((double)bufferedImage.getWidth() * d3);
                int n4 = (int)Math.ceil((double)bufferedImage.getHeight() * d4);
                Graphics graphics = this.pixelsIm.getGraphics();
                try {
                    graphics.drawImage(bufferedImage, 0, 0, n3, n4, null);
                }
                finally {
                    graphics.dispose();
                }
            }
        }
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (inputMethodEvent.getID() == 1100) {
            this.sendInputMethodEventToFX(inputMethodEvent);
        }
        super.processInputMethodEvent(inputMethodEvent);
    }

    private void sendInputMethodEventToFX(InputMethodEvent inputMethodEvent) {
        EmbeddedSceneInterface embeddedSceneInterface;
        String string = InputMethodSupport.getTextForEvent(inputMethodEvent);
        int n = 0;
        if (inputMethodEvent.getCaret() != null) {
            n = inputMethodEvent.getCaret().getInsertionIndex();
        }
        if ((embeddedSceneInterface = this.fx_scenePeer) != null) {
            embeddedSceneInterface.inputMethodEvent(javafx.scene.input.InputMethodEvent.INPUT_METHOD_TEXT_CHANGED, InputMethodSupport.inputMethodEventComposed(string, inputMethodEvent.getCommittedCharacterCount()), string.substring(0, inputMethodEvent.getCommittedCharacterCount()), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        DataBufferInt dataBufferInt;
        int[] nArray;
        IntBuffer intBuffer;
        EmbeddedSceneInterface embeddedSceneInterface = this.fx_scenePeer;
        EmbeddedWindow embeddedWindow = this.fx_stage;
        if (embeddedSceneInterface == null || embeddedWindow == null) {
            return;
        }
        if (this.pixelsIm == null) {
            this.createResizePixelBuffer(this.scaleFactorX, this.scaleFactorY);
            if (this.pixelsIm == null) {
                return;
            }
        }
        if (!embeddedSceneInterface.getPixels(intBuffer = IntBuffer.wrap(nArray = (dataBufferInt = (DataBufferInt)this.pixelsIm.getRaster().getDataBuffer()).getData()), this.pWidth, this.pHeight)) {
            // empty if block
        }
        Graphics graphics2 = null;
        try {
            Object object;
            ComponentOrientation componentOrientation = this.getComponentOrientation();
            boolean bl = ComponentOrientation.RIGHT_TO_LEFT.equals(componentOrientation);
            embeddedWindow.setNodeOrientation(bl ? NodeOrientation.RIGHT_TO_LEFT : NodeOrientation.LEFT_TO_RIGHT);
            graphics2 = graphics.create();
            if (this.opacity < 1.0f && graphics2 instanceof Graphics2D) {
                object = (Graphics2D)graphics2;
                AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
                ((Graphics2D)object).setComposite(alphaComposite);
            }
            if (this.getBorder() != null) {
                object = this.getBorder().getBorderInsets(this);
                graphics2.translate(((Insets)object).left, ((Insets)object).top);
            }
            graphics2.drawImage(this.pixelsIm, 0, 0, this.pWidth, this.pHeight, null);
            object = this.getCurrentTransform();
            double d = ((AffineTransform)object).getScaleX();
            double d2 = ((AffineTransform)object).getScaleY();
            if (this.scaleFactorX != d || this.scaleFactorY != d2) {
                this.createResizePixelBuffer(d, d2);
                embeddedSceneInterface.setPixelScaleFactors((float)d, (float)d2);
                this.scaleFactorX = d;
                this.scaleFactorY = d2;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet() || this.fx_scenePeer == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.pPreferredWidth, this.pPreferredHeight);
    }

    private boolean isFxEnabled() {
        return this.disableCount.get() == 0;
    }

    private void setFxEnabled(boolean bl) {
        if (!bl) {
            if (this.disableCount.incrementAndGet() == 1 && this.dnd != null) {
                this.dnd.removeNotify();
            }
        } else {
            if (this.disableCount.get() == 0) {
                return;
            }
            if (this.disableCount.decrementAndGet() == 0 && this.dnd != null) {
                this.dnd.addNotify();
            }
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.registerFinishListener();
        this.getToolkit().addAWTEventListener(this.ungrabListener, this.jfxPanelIOP.getMask());
        this.updateComponentSize();
        SwingNodeHelper.runOnFxThread(() -> {
            if (this.fx_stage != null && !this.fx_stage.isShowing()) {
                this.fx_stage.show();
                SwingNodeHelper.runOnEDT(() -> this.sendMoveEventToFX());
            }
        });
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        EmbeddedSceneInterface embeddedSceneInterface = this.fx_scenePeer;
        if (embeddedSceneInterface == null) {
            return new InputMethodSupport.InputMethodRequestsAdapter(null);
        }
        return new InputMethodSupport.InputMethodRequestsAdapter(embeddedSceneInterface.getInputMethodRequests());
    }

    @Override
    public void removeNotify() {
        SwingNodeHelper.runOnFxThread(() -> {
            if (this.fx_stage != null && this.fx_stage.isShowing()) {
                this.fx_stage.hide();
            }
        });
        this.pixelsIm = null;
        this.pWidth = 0;
        this.pHeight = 0;
        super.removeNotify();
        this.getToolkit().removeAWTEventListener(this.ungrabListener);
        this.getInputContext().removeNotify(this);
        this.deregisterFinishListener();
    }

    private void invokeOnClientEDT(Runnable runnable) {
        this.jfxPanelIOP.postEvent(this, new InvocationEvent((Object)this, runnable));
    }

    final BufferedImage test_getPixelsIm() {
        return this.pixelsIm;
    }

    private class HostContainer
    implements HostInterface {
        private HostContainer() {
        }

        public void setEmbeddedStage(EmbeddedStageInterface embeddedStageInterface) {
            JFXPanel.this.fx_stagePeer = embeddedStageInterface;
            EmbeddedStageInterface embeddedStageInterface2 = JFXPanel.this.fx_stagePeer;
            if (embeddedStageInterface2 == null) {
                return;
            }
            if (JFXPanel.this.pWidth > 0 && JFXPanel.this.pHeight > 0) {
                embeddedStageInterface2.setSize(JFXPanel.this.pWidth, JFXPanel.this.pHeight);
            }
            JFXPanel.this.invokeOnClientEDT(() -> {
                if (embeddedStageInterface2 != null && JFXPanel.this.isFocusOwner()) {
                    embeddedStageInterface2.setFocused(true, 0);
                }
                JFXPanel.this.sendMoveEventToFX();
            });
        }

        public void setEmbeddedScene(EmbeddedSceneInterface embeddedSceneInterface) {
            if (JFXPanel.this.fx_scenePeer == embeddedSceneInterface) {
                return;
            }
            JFXPanel.this.fx_scenePeer = embeddedSceneInterface;
            EmbeddedSceneInterface embeddedSceneInterface2 = JFXPanel.this.fx_scenePeer;
            if (embeddedSceneInterface2 == null) {
                JFXPanel.this.invokeOnClientEDT(() -> {
                    if (JFXPanel.this.dnd != null) {
                        JFXPanel.this.dnd.removeNotify();
                        JFXPanel.this.dnd = null;
                    }
                });
                return;
            }
            if (JFXPanel.this.pWidth > 0 && JFXPanel.this.pHeight > 0) {
                embeddedSceneInterface2.setSize(JFXPanel.this.pWidth, JFXPanel.this.pHeight);
            }
            embeddedSceneInterface2.setPixelScaleFactors((float)JFXPanel.this.scaleFactorX, (float)JFXPanel.this.scaleFactorY);
            JFXPanel.this.invokeOnClientEDT(() -> {
                JFXPanel.this.dnd = new SwingDnD(JFXPanel.this, embeddedSceneInterface2);
                JFXPanel.this.dnd.addNotify();
                embeddedSceneInterface2.setDragStartListener(JFXPanel.this.dnd.getDragStartListener());
            });
        }

        public boolean requestFocus() {
            return JFXPanel.this.requestFocusInWindow();
        }

        public boolean traverseFocusOut(boolean bl) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (bl) {
                keyboardFocusManager.focusNextComponent(JFXPanel.this);
            } else {
                keyboardFocusManager.focusPreviousComponent(JFXPanel.this);
            }
            return true;
        }

        public void setPreferredSize(int n, int n2) {
            JFXPanel.this.invokeOnClientEDT(() -> {
                JFXPanel.this.pPreferredWidth = n;
                JFXPanel.this.pPreferredHeight = n2;
                JFXPanel.this.revalidate();
            });
        }

        public void repaint() {
            JFXPanel.this.invokeOnClientEDT(() -> JFXPanel.this.repaint());
        }

        public void setEnabled(boolean bl) {
            JFXPanel.this.setFxEnabled(bl);
        }

        public void setCursor(CursorFrame cursorFrame) {
            Cursor cursor = this.getPlatformCursor(cursorFrame);
            JFXPanel.this.invokeOnClientEDT(() -> JFXPanel.this.setCursor(cursor));
        }

        private Cursor getPlatformCursor(CursorFrame cursorFrame) {
            Cursor cursor = (Cursor)cursorFrame.getPlatformCursor(Cursor.class);
            if (cursor != null) {
                return cursor;
            }
            Cursor cursor2 = SwingCursors.embedCursorToCursor(cursorFrame);
            cursorFrame.setPlatforCursor(Cursor.class, (Object)cursor2);
            return cursor2;
        }

        public boolean grabFocus() {
            if (PlatformUtil.isLinux()) {
                return true;
            }
            JFXPanel.this.invokeOnClientEDT(() -> {
                Window window = SwingUtilities.getWindowAncestor(JFXPanel.this);
                if (window != null) {
                    JFXPanel.this.jfxPanelIOP.grab(JFXPanel.this.getToolkit(), window);
                }
            });
            return true;
        }

        public void ungrabFocus() {
            if (PlatformUtil.isLinux()) {
                return;
            }
            JFXPanel.this.invokeOnClientEDT(() -> {
                Window window = SwingUtilities.getWindowAncestor(JFXPanel.this);
                if (window != null) {
                    JFXPanel.this.jfxPanelIOP.ungrab(JFXPanel.this.getToolkit(), window);
                }
            });
        }
    }
}

