/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.headless;

import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.headless.HeadlessRobot;
import com.sun.glass.ui.headless.HeadlessView;
import com.sun.glass.ui.headless.HeadlessWindowManager;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.concurrent.atomic.AtomicLong;
import javafx.scene.paint.Color;

public class HeadlessWindow
extends Window {
    private static final AtomicLong ptrCount = new AtomicLong(0L);
    private long ptr;
    private final HeadlessWindowManager windowManager;
    private int minWidth;
    private int minHeight;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private int originalX;
    private int originalY;
    private int originalWidth;
    private int originalHeight;
    private boolean visible;
    private final ByteBuffer frameBuffer;
    private HeadlessView currentView;
    private HeadlessRobot robot;
    private final int stride = 1000;

    public HeadlessWindow(HeadlessWindowManager headlessWindowManager, Window window, Screen screen, ByteBuffer byteBuffer, int n) {
        super(window, screen, n);
        this.frameBuffer = byteBuffer;
        this.windowManager = headlessWindowManager;
    }

    @Override
    protected long _createWindow(long l, long l2, int n) {
        this.ptr = ptrCount.incrementAndGet();
        return this.ptr;
    }

    @Override
    protected boolean _close(long l) {
        this.notifyDestroy();
        if (this.robot != null) {
            this.robot.windowRemoved(this);
        }
        return true;
    }

    @Override
    protected boolean _setView(long l, View view) {
        if (this.currentView != null) {
            this.currentView.notifyMouse(226, 211, 0, 0, 0, 0, 0, false, false);
        }
        this.currentView = (HeadlessView)view;
        if (this.currentView != null) {
            this.currentView.notifyMouse(225, 211, 0, 0, 0, 0, 0, false, false);
        }
        return true;
    }

    @Override
    protected void _updateViewSize(long l) {
        if (this.isVisible()) {
            this.currentView.notifyResize(this.width, this.height);
        }
    }

    @Override
    protected boolean _setMenubar(long l, long l2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected boolean _minimize(long l, boolean bl) {
        this.notifyResize(bl ? 531 : 533, this.width, this.height);
        this.windowManager.repaintAll();
        return true;
    }

    @Override
    protected boolean _maximize(long l, boolean bl, boolean bl2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (bl && !bl2) {
            this.originalHeight = this.height;
            this.originalWidth = this.width;
            this.originalX = this.x;
            this.originalY = this.y;
            n3 = this.screen.getWidth();
            n4 = this.screen.getHeight();
            this.setState(3);
        } else if (!bl && bl2) {
            n4 = this.originalHeight;
            n3 = this.originalWidth;
            n = this.originalX;
            n2 = this.originalY;
            this.setState(1);
        }
        this.notifyResizeAndMove(n, n2, n3, n4);
        if (bl) {
            this.notifyResize(532, n3, n4);
        }
        return bl;
    }

    @Override
    protected void _setBounds(long l, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, float f, float f2) {
        int n7;
        int n8;
        int n9 = n3 > 0 ? n3 : (n8 = n5 > 0 ? n5 : this.getWidth());
        int n10 = n4 > 0 ? n4 : (n7 = n6 > 0 ? n6 : this.getHeight());
        if (!bl) {
            n = this.getX();
        }
        if (!bl2) {
            n2 = this.getY();
        }
        if (this.maxWidth >= 0) {
            n8 = Math.min(n8, this.maxWidth);
        }
        if (this.maxHeight >= 0) {
            n7 = Math.min(n7, this.maxHeight);
        }
        n8 = Math.max(n8, this.minWidth);
        n7 = Math.max(n7, this.minHeight);
        if (n8 < this.getWidth()) {
            this.clearRect(this.getX() + n8, this.getWidth() - n8, this.getY(), this.getHeight());
        }
        if (n7 < this.getHeight()) {
            this.clearRect(this.getX(), this.getWidth(), this.getY() + n7, this.getHeight() - n7);
        }
        this.notifyResizeAndMove(n, n2, n8, n7);
    }

    @Override
    protected boolean _setVisible(long l, boolean bl) {
        this.visible = bl;
        return this.visible;
    }

    @Override
    protected boolean _setResizable(long l, boolean bl) {
        return true;
    }

    @Override
    protected boolean _requestFocus(long l, int n) {
        this.notifyFocus(n);
        return this.isFocused();
    }

    @Override
    protected void _setFocusable(long l, boolean bl) {
    }

    @Override
    protected boolean _grabFocus(long l) {
        return true;
    }

    @Override
    protected void _ungrabFocus(long l) {
    }

    @Override
    protected boolean _setTitle(long l, String string) {
        return true;
    }

    @Override
    protected void _setLevel(long l, int n) {
    }

    @Override
    protected void _setAlpha(long l, float f) {
    }

    @Override
    protected boolean _setBackground(long l, float f, float f2, float f3) {
        return true;
    }

    @Override
    protected void _setEnabled(long l, boolean bl) {
    }

    @Override
    protected boolean _setMinimumSize(long l, int n, int n2) {
        this.minWidth = n;
        this.minHeight = n2;
        return true;
    }

    @Override
    protected boolean _setMaximumSize(long l, int n, int n2) {
        this.maxWidth = n;
        this.maxHeight = n2;
        return true;
    }

    @Override
    protected void _setIcon(long l, Pixels pixels) {
    }

    @Override
    protected void _setCursor(long l, Cursor cursor) {
    }

    @Override
    protected void _toFront(long l) {
    }

    @Override
    protected void _toBack(long l) {
    }

    @Override
    protected void _requestInput(long l, String string, int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void _releaseInput(long l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    void setFullscreen(boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (bl) {
            this.originalHeight = this.height;
            this.originalWidth = this.width;
            this.originalX = this.x;
            this.originalY = this.y;
            n = 0;
            n2 = 0;
            n3 = this.screen.getWidth();
            n4 = this.screen.getHeight();
        } else {
            n4 = this.originalHeight;
            n3 = this.originalWidth;
            n = this.originalX;
            n2 = this.originalY;
        }
        this.notifyResizeAndMove(n, n2, n3, n4);
    }

    private void notifyResizeAndMove(int n, int n2, int n3, int n4) {
        HeadlessView headlessView = (HeadlessView)this.getView();
        this.notifyResize(511, n3, n4);
        if (headlessView != null) {
            headlessView.notifyResize(n3, n4);
        }
        if (this.getX() != n || this.getY() != n2) {
            this.notifyMove(n, n2);
        }
    }

    public Color getColor(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        int n5 = 1000 * n4 + n3;
        int n6 = this.frameBuffer.asIntBuffer().get(n5);
        int n7 = n6 >> 24 & 0xFF;
        int n8 = n6 >> 16 & 0xFF;
        int n9 = n6 >> 8 & 0xFF;
        int n10 = n6 & 0xFF;
        Color color = Color.rgb(n8, n9, n10, (double)n7 / 255.0);
        return color;
    }

    public void getScreenCapture(int n, int n2, int n3, int n4, int[] nArray, boolean bl) {
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n5;
                int n6 = i * n3 + j;
                int n7 = (n2 + i) * 1000 + n + j;
                nArray[n6] = n5 = this.frameBuffer.asIntBuffer().get(n7);
            }
        }
    }

    void blit(Pixels pixels) {
        int n = pixels.getWidth();
        int n2 = pixels.getHeight();
        int n3 = this.getX();
        int n4 = this.getY();
        IntBuffer intBuffer = (IntBuffer)pixels.getBuffer();
        for (int i = 0; i < pixels.getHeight(); ++i) {
            int n5 = n4 + i;
            for (int j = 0; j < pixels.getWidth(); ++j) {
                int n6 = n5 * 1000 + n3 + j;
                int n7 = intBuffer.get(i * pixels.getWidth() + j);
                this.frameBuffer.asIntBuffer().put(n6, n7);
            }
        }
    }

    void clearRect(int n, int n2, int n3, int n4) {
        for (int i = 0; i < n4; ++i) {
            int n5 = n3 + i;
            for (int j = 0; j < n2; ++j) {
                int n6 = n5 * 1000 + n + j;
                this.frameBuffer.asIntBuffer().put(n6, 0);
            }
        }
    }

    void setRobot(HeadlessRobot headlessRobot) {
        this.robot = headlessRobot;
    }
}

