/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk;

import com.sun.glass.ui.gtk.WindowDecorationTheme;
import com.sun.javafx.application.PlatformImpl;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.collections.MapChangeListener;

final class PlatformThemeObserver {
    private static final String THEME_NAME_KEY = "GTK.theme_name";
    private final ReadOnlyStringWrapper stylesheet = new ReadOnlyStringWrapper((Object)this, "stylesheet");

    private PlatformThemeObserver() {
        PlatformImpl.getPlatformPreferences().addListener((MapChangeListener<? super String, ? super Object>)((MapChangeListener)change -> {
            if (THEME_NAME_KEY.equals(change.getKey())) {
                this.updateThemeStylesheets();
            }
        }));
        this.updateThemeStylesheets();
    }

    public static PlatformThemeObserver getInstance() {
        class Holder {
            static final PlatformThemeObserver instance = new PlatformThemeObserver();

            Holder() {
            }
        }
        return Holder.instance;
    }

    public ReadOnlyStringProperty stylesheetProperty() {
        return this.stylesheet.getReadOnlyProperty();
    }

    private void updateThemeStylesheets() {
        this.stylesheet.set(WindowDecorationTheme.findBestTheme().getStylesheet());
    }
}

