/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.utils;

import com.sun.javafx.PlatformUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class NativeLibLoader {
    private static final HashSet<String> loaded = new HashSet();
    private static boolean verbose = false;
    private static File libDir = null;
    private static String libPrefix = "";
    private static String libSuffix = "";

    public static synchronized void loadLibrary(String string) {
        if (!loaded.contains(string)) {
            StackWalker stackWalker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
            Class<?> clazz = stackWalker.getCallerClass();
            NativeLibLoader.loadLibraryInternal(string, null, clazz);
            loaded.add(string);
        }
    }

    public static synchronized void loadLibrary(String string, List<String> list) {
        if (!loaded.contains(string)) {
            StackWalker stackWalker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
            Class<?> clazz = stackWalker.getCallerClass();
            NativeLibLoader.loadLibraryInternal(string, list, clazz);
            loaded.add(string);
        }
    }

    private static String[] initializePath(String string) {
        String string2 = System.getProperty(string, "");
        String string3 = File.pathSeparator;
        int n = string2.length();
        int n2 = string2.indexOf(string3);
        int n3 = 0;
        while (n2 >= 0) {
            ++n3;
            n2 = string2.indexOf(string3, n2 + 1);
        }
        String[] stringArray = new String[n3 + 1];
        n2 = 0;
        n3 = 0;
        int n4 = string2.indexOf(string3);
        while (n4 >= 0) {
            if (n4 - n2 > 0) {
                stringArray[n3++] = string2.substring(n2, n4);
            } else if (n4 - n2 == 0) {
                stringArray[n3++] = ".";
            }
            n2 = n4 + 1;
            n4 = string2.indexOf(string3, n2);
        }
        stringArray[n3] = string2.substring(n2, n);
        return stringArray;
    }

    private static void loadLibraryInternal(String string, List<String> list, Class clazz) {
        try {
            NativeLibLoader.loadLibraryFullPath(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (verbose) {
                System.err.println("WARNING: " + String.valueOf(unsatisfiedLinkError));
            }
            if (NativeLibLoader.loadLibraryFromResource(string, list, clazz)) {
                return;
            }
            String[] stringArray = NativeLibLoader.initializePath("java.library.path");
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    Object object = stringArray[i];
                    if (!((String)object).endsWith(File.separator)) {
                        object = (String)object + File.separator;
                    }
                    String string2 = System.mapLibraryName(string);
                    File file = new File((String)object + string2);
                    System.load(file.getAbsolutePath());
                    if (verbose) {
                        System.err.println("Loaded " + file.getAbsolutePath() + " from java.library.path");
                    }
                    return;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    continue;
                }
            }
            try {
                System.loadLibrary(string);
                if (verbose) {
                    System.err.println("System.loadLibrary(" + string + ") succeeded");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError3) {
                if (PlatformUtil.isIOS() && string.contains("-")) {
                    string = string.replace("-", "_");
                    System.loadLibrary(string);
                    return;
                }
                throw unsatisfiedLinkError3;
            }
        }
    }

    private static boolean loadLibraryFromResource(String string, List<String> list, Class clazz) {
        return NativeLibLoader.installLibraryFromResource(string, list, clazz, true);
    }

    private static boolean installLibraryFromResource(String string, List<String> list, Class clazz, boolean bl) {
        try {
            Object object;
            Object object2;
            if (list != null) {
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    boolean bl2 = NativeLibLoader.installLibraryFromResource((String)object, null, clazz, false);
                }
            }
            if ((object = clazz.getResourceAsStream((String)(object2 = "/" + System.mapLibraryName(string)))) != null) {
                String string2 = NativeLibLoader.cacheLibrary((InputStream)object, (String)object2, clazz);
                if (bl) {
                    System.load(string2);
                    if (verbose) {
                        System.err.println("Loaded library " + (String)object2 + " from resource");
                    }
                } else if (verbose) {
                    System.err.println("Unpacked library " + (String)object2 + " from resource");
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            System.err.println("Loading library " + string + " from resource failed: " + String.valueOf(throwable));
            throwable.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String cacheLibrary(InputStream inputStream, String string, Class clazz) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Closeable closeable;
        Object object4;
        String string2 = System.getProperty("javafx.runtime.version", "versionless");
        string2 = string2.replace(":", "-");
        Object object5 = System.getProperty("javafx.cachedir", "");
        String string3 = System.getProperty("os.arch");
        if (((String)object5).isEmpty()) {
            object5 = System.getProperty("user.home") + "/.openjfx/cache/" + string2 + "/" + string3;
        }
        File file = new File((String)object5);
        boolean bl = true;
        if (file.exists()) {
            if (!file.isDirectory()) {
                System.err.println("Cache exists but is not a directory: " + String.valueOf(file));
                bl = false;
            }
        } else if (!file.mkdirs()) {
            System.err.println("Can not create cache at " + String.valueOf(file));
            bl = false;
        }
        if (!file.canRead()) {
            bl = false;
        }
        if (!bl) {
            object4 = System.getProperty("user.name", "anonymous");
            String string4 = System.getProperty("java.io.tmpdir") + "/.openjfx_" + (String)object4 + "/cache/" + string2 + "/" + string3;
            file = new File(string4);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new IOException("Cache exists but is not a directory: " + String.valueOf(file));
                }
            } else if (!file.mkdirs()) {
                throw new IOException("Can not create cache at " + String.valueOf(file));
            }
        }
        object4 = new File(file, string);
        boolean bl2 = true;
        if (((File)object4).exists()) {
            try {
                closeable = new DigestInputStream(inputStream, MessageDigest.getInstance("MD5"));
                ((DigestInputStream)closeable).getMessageDigest().reset();
                object3 = new byte[4096];
                while (((FilterInputStream)closeable).read((byte[])object3) != -1) {
                }
                object2 = ((DigestInputStream)closeable).getMessageDigest().digest();
                inputStream.close();
                inputStream = clazz.getResourceAsStream(string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                object2 = new byte[1];
            }
            object = NativeLibLoader.calculateCheckSum((File)object4);
            if (!Arrays.equals((byte[])object2, object)) {
                Files.delete(((File)object4).toPath());
            } else {
                bl2 = false;
            }
        }
        if (bl2) {
            object2 = ((File)object4).toPath();
            object = new File(file, ".lock");
            try {
                closeable = new RandomAccessFile((File)object, "rw");
                try {
                    object3 = ((RandomAccessFile)closeable).getChannel();
                    try (FileLock fileLock = ((FileChannel)object3).lock();){
                        try {
                            if (!Files.exists((Path)object2, new LinkOption[0])) {
                                Files.copy(inputStream, (Path)object2, new CopyOption[0]);
                            }
                        }
                        finally {
                            if (fileLock != null) {
                                fileLock.release();
                            }
                        }
                    }
                    finally {
                        if (object3 != null) {
                            ((AbstractInterruptibleChannel)object3).close();
                        }
                    }
                }
                finally {
                    ((RandomAccessFile)closeable).close();
                }
            }
            catch (IOException iOException) {
                throw new IOException("Error copying library " + String.valueOf(object2) + " to cache: " + iOException.getMessage(), iOException);
            }
        }
        object2 = ((File)object4).getAbsolutePath();
        return object2;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static byte[] calculateCheckSum(File file) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] byArray;
            try (DigestInputStream digestInputStream = new DigestInputStream(fileInputStream, MessageDigest.getInstance("MD5"));){
                digestInputStream.getMessageDigest().reset();
                byte[] byArray2 = new byte[4096];
                while (digestInputStream.read(byArray2) != -1) {
                }
                byArray = digestInputStream.getMessageDigest().digest();
            }
            return byArray;
        }
        catch (IOException | IllegalArgumentException | SecurityException | NoSuchAlgorithmException exception) {
            return new byte[0];
        }
    }

    private static File libDirForJRT() {
        String string = System.getProperty("java.home");
        if (string == null || string.isEmpty()) {
            throw new UnsatisfiedLinkError("Cannot find java.home");
        }
        String string2 = null;
        if (PlatformUtil.isWindows()) {
            string2 = "bin/javafx";
        } else if (PlatformUtil.isMac()) {
            string2 = "lib";
        } else if (PlatformUtil.isLinux()) {
            string2 = "lib";
        }
        return new File(string + "/" + string2);
    }

    private static File libDirForJarFile(String string) throws Exception {
        String string2 = string.substring(4, string.lastIndexOf(33));
        int n = Math.max(string2.lastIndexOf(47), string2.lastIndexOf(92));
        String string3 = null;
        if (PlatformUtil.isWindows()) {
            string3 = "../bin";
        } else if (PlatformUtil.isMac()) {
            string3 = ".";
        } else if (PlatformUtil.isLinux()) {
            string3 = ".";
        }
        String string4 = string2.substring(0, n) + "/" + string3;
        return new File(new URI(string4).getPath());
    }

    private static void loadLibraryFullPath(String string) {
        try {
            Object object;
            Class<NativeLibLoader> clazz;
            if (libDir == null) {
                clazz = NativeLibLoader.class;
                object = "NativeLibLoader.class";
                String string2 = clazz.getResource((String)object).toString();
                if (string2.startsWith("jrt:")) {
                    libDir = NativeLibLoader.libDirForJRT();
                } else if (string2.startsWith("jar:file:") && string2.indexOf(33) > 0) {
                    libDir = NativeLibLoader.libDirForJarFile(string2);
                } else {
                    throw new UnsatisfiedLinkError("Invalid URL for class: " + string2);
                }
                if (PlatformUtil.isWindows()) {
                    libPrefix = "";
                    libSuffix = ".dll";
                } else if (PlatformUtil.isMac()) {
                    libPrefix = "lib";
                    libSuffix = ".dylib";
                } else if (PlatformUtil.isLinux()) {
                    libPrefix = "lib";
                    libSuffix = ".so";
                }
            }
            object = new File(libDir, libPrefix + string + libSuffix);
            clazz = ((File)object).getCanonicalPath();
            System.load((String)((Object)clazz));
            if (verbose) {
                System.err.println("Loaded " + ((File)object).getAbsolutePath() + " from relative path");
            }
        }
        catch (Exception exception) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError().initCause(exception);
        }
    }

    static {
        verbose = Boolean.getBoolean("javafx.verbose");
    }
}

