/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import java.io.IOException;
import jfx.incubator.scene.control.richtext.LineEnding;
import jfx.incubator.scene.control.richtext.model.StyledOutput;
import jfx.incubator.scene.control.richtext.model.StyledSegment;

public class StringBuilderStyledOutput
implements StyledOutput {
    private final int limit;
    private final StringBuilder sb;
    private final String newline;

    public StringBuilderStyledOutput(StringBuilder stringBuilder, LineEnding lineEnding, int n) {
        this.limit = n;
        this.sb = stringBuilder;
        this.newline = lineEnding.getText();
    }

    public StringBuilderStyledOutput(LineEnding lineEnding) {
        this(new StringBuilder(1024), lineEnding, Integer.MAX_VALUE);
    }

    @Override
    public void consume(StyledSegment styledSegment) throws IOException {
        switch (styledSegment.getType()) {
            case LINE_BREAK: {
                this.append(this.newline, false);
                break;
            }
            case TEXT: {
                String string = styledSegment.getText();
                this.append(string, true);
            }
        }
    }

    private void append(String string, boolean bl) throws IOException {
        if (this.limit < Integer.MAX_VALUE) {
            int n = this.limit - this.sb.length();
            if (string.length() > n) {
                if (bl) {
                    this.sb.append(string, 0, n);
                }
                throw new IOException("limit exceeded");
            }
        }
        this.sb.append(string);
    }

    public String toString() {
        return this.sb.toString();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

