/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media.expression;

import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.MediaQueryCache;
import com.sun.javafx.css.media.MediaQueryContext;
import java.util.Objects;

public final class NegationExpression
implements MediaQuery {
    private final MediaQuery expression;
    private final int contextAwareness;

    private NegationExpression(MediaQuery mediaQuery) {
        this.expression = Objects.requireNonNull(mediaQuery, "expression cannot be null");
        this.contextAwareness = mediaQuery.getContextAwareness();
    }

    public static NegationExpression of(MediaQuery mediaQuery) {
        return MediaQueryCache.getCachedMediaQuery(new NegationExpression(mediaQuery));
    }

    public MediaQuery getExpression() {
        return this.expression;
    }

    @Override
    public int getContextAwareness() {
        return this.contextAwareness;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof NegationExpression)) return false;
        NegationExpression negationExpression = (NegationExpression)object;
        if (!this.expression.equals(negationExpression.expression)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(NegationExpression.class, this.expression);
    }

    @Override
    public boolean evaluate(MediaQueryContext mediaQueryContext) {
        return !this.expression.evaluate(mediaQueryContext);
    }

    public String toString() {
        return "not " + String.valueOf(this.expression);
    }
}

