/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media;

import com.sun.javafx.css.media.MediaFeatures;
import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.SizeQueryType;
import com.sun.javafx.css.media.expression.ConjunctionExpression;
import com.sun.javafx.css.media.expression.ConstantExpression;
import com.sun.javafx.css.media.expression.DisjunctionExpression;
import com.sun.javafx.css.media.expression.EqualExpression;
import com.sun.javafx.css.media.expression.FunctionExpression;
import com.sun.javafx.css.media.expression.GreaterExpression;
import com.sun.javafx.css.media.expression.GreaterOrEqualExpression;
import com.sun.javafx.css.media.expression.LessExpression;
import com.sun.javafx.css.media.expression.LessOrEqualExpression;
import com.sun.javafx.css.media.expression.NegationExpression;
import com.sun.javafx.css.media.expression.RangeExpression;
import com.sun.javafx.css.parser.Token;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.BiFunction;
import javafx.css.Size;
import javafx.css.SizeUnits;
import javafx.css.StyleConverter;

public final class MediaQuerySerializer {
    private static final SizeUnits[] SIZE_UNITS = SizeUnits.values();

    private MediaQuerySerializer() {
    }

    public static void writeBinary(MediaQuery mediaQuery, DataOutputStream dataOutputStream, StyleConverter.StringStore stringStore) throws IOException {
        dataOutputStream.writeByte(QueryType.of((MediaQuery)mediaQuery).serializedId);
        MediaQuery mediaQuery2 = mediaQuery;
        Objects.requireNonNull(mediaQuery2);
        MediaQuery mediaQuery3 = mediaQuery2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantExpression.class, FunctionExpression.class, NegationExpression.class, ConjunctionExpression.class, DisjunctionExpression.class, RangeExpression.class}, (MediaQuery)mediaQuery3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ConstantExpression constantExpression = (ConstantExpression)mediaQuery3;
                dataOutputStream.writeBoolean(constantExpression.value());
                break;
            }
            case 1: {
                FunctionExpression functionExpression = (FunctionExpression)mediaQuery3;
                dataOutputStream.writeInt(stringStore.addString(functionExpression.getFeatureName()));
                if (functionExpression.getFeatureValue() != null) {
                    dataOutputStream.writeInt(stringStore.addString(functionExpression.getFeatureValue()));
                    break;
                }
                dataOutputStream.writeInt(-1);
                break;
            }
            case 2: {
                NegationExpression negationExpression = (NegationExpression)mediaQuery3;
                MediaQuerySerializer.writeBinary(negationExpression.getExpression(), dataOutputStream, stringStore);
                break;
            }
            case 3: {
                ConjunctionExpression conjunctionExpression = (ConjunctionExpression)mediaQuery3;
                MediaQuerySerializer.writeBinary(conjunctionExpression.getLeft(), dataOutputStream, stringStore);
                MediaQuerySerializer.writeBinary(conjunctionExpression.getRight(), dataOutputStream, stringStore);
                break;
            }
            case 4: {
                DisjunctionExpression disjunctionExpression = (DisjunctionExpression)mediaQuery3;
                MediaQuerySerializer.writeBinary(disjunctionExpression.getLeft(), dataOutputStream, stringStore);
                MediaQuerySerializer.writeBinary(disjunctionExpression.getRight(), dataOutputStream, stringStore);
                break;
            }
            case 5: {
                RangeExpression rangeExpression = (RangeExpression)mediaQuery3;
                dataOutputStream.writeInt(stringStore.addString(rangeExpression.getFeatureName()));
                dataOutputStream.writeDouble(rangeExpression.getFeatureValue());
                if (rangeExpression.getUnit() != null) {
                    dataOutputStream.writeByte(rangeExpression.getUnit().ordinal());
                    break;
                }
                dataOutputStream.writeByte(-1);
            }
        }
    }

    public static MediaQuery readBinary(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        return switch (QueryType.of(dataInputStream.readByte()).ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                String var2_2 = stringArray[dataInputStream.readInt()];
                int var3_3 = dataInputStream.readInt();
                String var4_4 = var3_3 >= 0 ? stringArray[var3_3] : null;
                yield MediaFeatures.discreteQueryExpression(var2_2, new Token(11, var4_4));
            }
            case 0 -> ConstantExpression.of(dataInputStream.readBoolean());
            case 4 -> NegationExpression.of(MediaQuerySerializer.readBinary(dataInputStream, stringArray));
            case 2 -> ConjunctionExpression.of(MediaQuerySerializer.readBinary(dataInputStream, stringArray), MediaQuerySerializer.readBinary(dataInputStream, stringArray));
            case 3 -> DisjunctionExpression.of(MediaQuerySerializer.readBinary(dataInputStream, stringArray), MediaQuerySerializer.readBinary(dataInputStream, stringArray));
            case 5 -> MediaQuerySerializer.readRangeExpression(dataInputStream, stringArray, EqualExpression::ofSize, EqualExpression::ofNumber);
            case 6 -> MediaQuerySerializer.readRangeExpression(dataInputStream, stringArray, GreaterExpression::ofSize, GreaterExpression::ofNumber);
            case 7 -> MediaQuerySerializer.readRangeExpression(dataInputStream, stringArray, GreaterOrEqualExpression::ofSize, GreaterOrEqualExpression::ofNumber);
            case 8 -> MediaQuerySerializer.readRangeExpression(dataInputStream, stringArray, LessExpression::ofSize, LessExpression::ofNumber);
            case 9 -> MediaQuerySerializer.readRangeExpression(dataInputStream, stringArray, LessOrEqualExpression::ofSize, LessOrEqualExpression::ofNumber);
        };
    }

    private static MediaQuery readRangeExpression(DataInputStream dataInputStream, String[] stringArray, BiFunction<SizeQueryType, Size, MediaQuery> biFunction, BiFunction<SizeQueryType, Double, MediaQuery> biFunction2) throws IOException {
        SizeQueryType sizeQueryType = SizeQueryType.of(stringArray[dataInputStream.readInt()]);
        double d = dataInputStream.readDouble();
        SizeUnits sizeUnits = MediaQuerySerializer.readUnit(dataInputStream);
        return sizeUnits != null ? biFunction.apply(sizeQueryType, new Size(d, sizeUnits)) : biFunction2.apply(sizeQueryType, d);
    }

    private static SizeUnits readUnit(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        return by < 0 ? null : SIZE_UNITS[by];
    }

    private static enum QueryType {
        CONSTANT(1),
        FUNCTION(2),
        CONJUNCTION(3),
        DISJUNCTION(4),
        NEGATION(5),
        EQUAL(6),
        GREATER(7),
        GREATER_OR_EQUAL(8),
        LESS(9),
        LESS_OR_EQUAL(10);

        private final int serializedId;
        private static final QueryType[] VALUES;

        static QueryType of(MediaQuery mediaQuery) {
            MediaQuery mediaQuery2 = mediaQuery;
            Objects.requireNonNull(mediaQuery2);
            MediaQuery mediaQuery3 = mediaQuery2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantExpression.class, FunctionExpression.class, ConjunctionExpression.class, DisjunctionExpression.class, NegationExpression.class, EqualExpression.class, GreaterExpression.class, GreaterOrEqualExpression.class, LessExpression.class, LessOrEqualExpression.class}, (MediaQuery)mediaQuery3, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> CONSTANT;
                case 1 -> FUNCTION;
                case 2 -> CONJUNCTION;
                case 3 -> DISJUNCTION;
                case 4 -> NEGATION;
                case 5 -> EQUAL;
                case 6 -> GREATER;
                case 7 -> GREATER_OR_EQUAL;
                case 8 -> LESS;
                case 9 -> LESS_OR_EQUAL;
            };
        }

        static QueryType of(int n) {
            for (QueryType queryType : VALUES) {
                if (queryType.serializedId != n) continue;
                return queryType;
            }
            throw new IllegalArgumentException("serializedId");
        }

        private QueryType(int n2) {
            this.serializedId = n2;
        }

        static {
            VALUES = QueryType.values();
        }
    }
}

