/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media.expression;

import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.MediaQueryCache;
import com.sun.javafx.css.media.MediaQueryContext;
import java.util.List;
import java.util.Objects;

public final class ConjunctionExpression
implements MediaQuery {
    private final MediaQuery left;
    private final MediaQuery right;
    private final int contextAwareness;

    private ConjunctionExpression(MediaQuery mediaQuery, MediaQuery mediaQuery2) {
        this.left = Objects.requireNonNull(mediaQuery, "left cannot be null");
        this.right = Objects.requireNonNull(mediaQuery2, "right cannot be null");
        this.contextAwareness = mediaQuery.getContextAwareness() | mediaQuery2.getContextAwareness();
    }

    public static ConjunctionExpression of(MediaQuery mediaQuery, MediaQuery mediaQuery2) {
        return MediaQueryCache.getCachedMediaQuery(new ConjunctionExpression(mediaQuery, mediaQuery2));
    }

    public static ConjunctionExpression of(List<MediaQuery> list) {
        if (list.size() < 2) {
            throw new IllegalArgumentException();
        }
        ConjunctionExpression conjunctionExpression = ConjunctionExpression.of(list.get(0), list.get(1));
        for (int i = 2; i < list.size(); ++i) {
            conjunctionExpression = ConjunctionExpression.of(conjunctionExpression, list.get(i));
        }
        return conjunctionExpression;
    }

    public MediaQuery getLeft() {
        return this.left;
    }

    public MediaQuery getRight() {
        return this.right;
    }

    @Override
    public int getContextAwareness() {
        return this.contextAwareness;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof ConjunctionExpression)) return false;
        ConjunctionExpression conjunctionExpression = (ConjunctionExpression)object;
        if (!this.left.equals(conjunctionExpression.left)) return false;
        if (!this.right.equals(conjunctionExpression.right)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(ConjunctionExpression.class, this.left, this.right);
    }

    @Override
    public boolean evaluate(MediaQueryContext mediaQueryContext) {
        return this.left.evaluate(mediaQueryContext) && this.right.evaluate(mediaQueryContext);
    }

    public String toString() {
        return "(" + String.valueOf(this.left) + " and " + String.valueOf(this.right) + ")";
    }
}

