/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media;

import com.sun.javafx.css.media.SizeQueryType;
import com.sun.javafx.css.media.expression.EqualExpression;
import com.sun.javafx.css.media.expression.GreaterExpression;
import com.sun.javafx.css.media.expression.GreaterOrEqualExpression;
import com.sun.javafx.css.media.expression.LessExpression;
import com.sun.javafx.css.media.expression.LessOrEqualExpression;
import com.sun.javafx.css.media.expression.RangeExpression;
import javafx.css.Size;

enum ComparisonOp {
    LESS(new RangeExpression.Supplier(){

        @Override
        public RangeExpression getSizeExpression(SizeQueryType sizeQueryType, Size size) {
            return LessExpression.ofSize(sizeQueryType, size);
        }

        @Override
        public RangeExpression getNumberExpression(SizeQueryType sizeQueryType, double d) {
            return LessExpression.ofNumber(sizeQueryType, d);
        }
    }),
    LESS_OR_EQUAL(new RangeExpression.Supplier(){

        @Override
        public RangeExpression getSizeExpression(SizeQueryType sizeQueryType, Size size) {
            return LessOrEqualExpression.ofSize(sizeQueryType, size);
        }

        @Override
        public RangeExpression getNumberExpression(SizeQueryType sizeQueryType, double d) {
            return LessOrEqualExpression.ofNumber(sizeQueryType, d);
        }
    }),
    GREATER(new RangeExpression.Supplier(){

        @Override
        public RangeExpression getSizeExpression(SizeQueryType sizeQueryType, Size size) {
            return GreaterExpression.ofSize(sizeQueryType, size);
        }

        @Override
        public RangeExpression getNumberExpression(SizeQueryType sizeQueryType, double d) {
            return GreaterExpression.ofNumber(sizeQueryType, d);
        }
    }),
    GREATER_OR_EQUAL(new RangeExpression.Supplier(){

        @Override
        public RangeExpression getSizeExpression(SizeQueryType sizeQueryType, Size size) {
            return GreaterOrEqualExpression.ofSize(sizeQueryType, size);
        }

        @Override
        public RangeExpression getNumberExpression(SizeQueryType sizeQueryType, double d) {
            return GreaterOrEqualExpression.ofNumber(sizeQueryType, d);
        }
    }),
    EQUAL(new RangeExpression.Supplier(){

        @Override
        public RangeExpression getSizeExpression(SizeQueryType sizeQueryType, Size size) {
            return EqualExpression.ofSize(sizeQueryType, size);
        }

        @Override
        public RangeExpression getNumberExpression(SizeQueryType sizeQueryType, double d) {
            return EqualExpression.ofNumber(sizeQueryType, d);
        }
    });

    private final RangeExpression.Supplier supplier;

    private ComparisonOp(RangeExpression.Supplier supplier) {
        this.supplier = supplier;
    }

    public RangeExpression.Supplier getExpressionSupplier() {
        return this.supplier;
    }

    public ComparisonOp flipped() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> GREATER;
            case 1 -> GREATER_OR_EQUAL;
            case 2 -> LESS;
            case 3 -> LESS_OR_EQUAL;
            case 4 -> EQUAL;
        };
    }

    public boolean isSameDirection(ComparisonOp comparisonOp) {
        return switch (this.ordinal()) {
            case 0, 1 -> {
                if (comparisonOp == LESS || comparisonOp == LESS_OR_EQUAL) {
                    yield true;
                }
                yield false;
            }
            case 2, 3 -> {
                if (comparisonOp == GREATER || comparisonOp == GREATER_OR_EQUAL) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

