/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.glass.ui.Screen;
import com.sun.glass.utils.NativeLibLoader;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.ResourceFactory;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.mtl.MTLResourceFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MTLPipeline
extends GraphicsPipeline {
    private static MTLPipeline theInstance;
    private static MTLResourceFactory mtlResourceFactory;

    private static native boolean nSupportsMTL();

    private MTLPipeline() {
    }

    public static MTLPipeline getInstance() {
        return theInstance;
    }

    @Override
    public boolean init() {
        if (!MTLPipeline.nSupportsMTL()) {
            return false;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("isVsyncEnabled", PrismSettings.isVsyncEnabled ? 1L : 0L);
        this.setDeviceDetails(hashMap);
        return true;
    }

    @Override
    public int getAdapterOrdinal(Screen screen) {
        return 0;
    }

    @Override
    public ResourceFactory getDefaultResourceFactory(List<Screen> list) {
        return this.getResourceFactory(Screen.getMainScreen());
    }

    @Override
    public ResourceFactory getResourceFactory(Screen screen) {
        if (mtlResourceFactory == null) {
            mtlResourceFactory = new MTLResourceFactory(screen);
            Map map = MTLPipeline.getInstance().getDeviceDetails();
            map.put("mtlCommandQueue", mtlResourceFactory.getContext().getMetalCommandQueue());
        }
        return mtlResourceFactory;
    }

    @Override
    public void dispose() {
        if (mtlResourceFactory != null) {
            mtlResourceFactory.dispose();
            mtlResourceFactory = null;
        }
        super.dispose();
    }

    @Override
    public boolean is3DSupported() {
        return true;
    }

    @Override
    public final boolean isMSAASupported() {
        return true;
    }

    @Override
    public boolean isVsyncSupported() {
        return true;
    }

    @Override
    public boolean supportsShaderType(GraphicsPipeline.ShaderType shaderType) {
        return switch (shaderType) {
            case GraphicsPipeline.ShaderType.MSL -> true;
            default -> false;
        };
    }

    @Override
    public boolean supportsShaderModel(GraphicsPipeline.ShaderModel shaderModel) {
        return switch (shaderModel) {
            case GraphicsPipeline.ShaderModel.SM3 -> true;
            default -> false;
        };
    }

    static {
        String string = "prism_mtl";
        if (PrismSettings.verbose) {
            System.err.println("Loading native metal library, named: " + string);
        }
        NativeLibLoader.loadLibrary(string);
        if (PrismSettings.verbose) {
            System.err.println("Succeeded: Loading native metal library.");
        }
        theInstance = new MTLPipeline();
    }
}

