/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.HeaderButtonMetrics;
import com.sun.glass.ui.HeaderButtonOverlayHelper;
import com.sun.javafx.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableIntegerProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.geometry.Dimension2D;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.layout.HeaderButtonType;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Subscription;

public class HeaderButtonOverlay
extends Region {
    private static final CssMetaData<HeaderButtonOverlay, Number> BUTTON_DEFAULT_HEIGHT_METADATA;
    private static final CssMetaData<HeaderButtonOverlay, ButtonPlacement> BUTTON_PLACEMENT_METADATA;
    private static final CssMetaData<HeaderButtonOverlay, ButtonVerticalAlignment> BUTTON_VERTICAL_ALIGNMENT_METADATA;
    private static final List<CssMetaData<?, ?>> METADATA;
    private static final PseudoClass HOVER_PSEUDOCLASS;
    private static final PseudoClass PRESSED_PSEUDOCLASS;
    private static final PseudoClass ACTIVE_PSEUDOCLASS;
    private static final String DARK_STYLE_CLASS = "dark";
    private static final String RESTORE_STYLE_CLASS = "restore";
    private static final String UTILITY_STYLE_CLASS = "utility";
    private final ObjectProperty<HeaderButtonMetrics> metrics;
    private final DoubleProperty prefButtonHeight;
    private final StyleableDoubleProperty buttonDefaultHeight;
    private final StyleableObjectProperty<ButtonPlacement> buttonPlacement;
    private final StyleableObjectProperty<ButtonVerticalAlignment> buttonVerticalAlignment;
    private final List<ButtonRegion> orderedButtons;
    private final ButtonLayoutInfo layoutInfo;
    private final ButtonRegion iconifyButton;
    private final ButtonRegion maximizeButton;
    private final ButtonRegion closeButton;
    private final Subscription subscriptions;
    private final boolean modalOrOwned;
    private final boolean utility;
    private final boolean rightToLeft;
    private Node buttonAtMouseDown;

    public HeaderButtonOverlay(ObservableValue<String> observableValue, boolean bl2, boolean bl3, boolean bl4) {
        HeaderButtonOverlayHelper.initHelper(this);
        this.metrics = new SimpleObjectProperty((Object)this, "metrics", (Object)new HeaderButtonMetrics(new Dimension2D(0.0, 0.0), new Dimension2D(0.0, 0.0), 0.0));
        this.prefButtonHeight = new SimpleDoubleProperty(this, "prefButtonHeight", -1.0){

            protected void invalidated() {
                HeaderButtonOverlay.this.updateButtonMetrics();
                HeaderButtonOverlay.this.requestLayout();
            }
        };
        this.buttonDefaultHeight = new SimpleStyleableDoubleProperty(BUTTON_DEFAULT_HEIGHT_METADATA, this, "buttonDefaultHeight"){

            protected void invalidated() {
                HeaderButtonOverlay.this.requestLayout();
            }
        };
        this.buttonPlacement = new SimpleStyleableObjectProperty<ButtonPlacement>(BUTTON_PLACEMENT_METADATA, (Object)this, "buttonPlacement", ButtonPlacement.RIGHT){

            protected void invalidated() {
                HeaderButtonOverlay.this.requestLayout();
            }
        };
        this.buttonVerticalAlignment = new SimpleStyleableObjectProperty<ButtonVerticalAlignment>(BUTTON_VERTICAL_ALIGNMENT_METADATA, (Object)this, "buttonVerticalAlignment", ButtonVerticalAlignment.CENTER){

            protected void invalidated() {
                HeaderButtonOverlay.this.requestLayout();
            }
        };
        this.orderedButtons = new ArrayList<ButtonRegion>(3);
        this.layoutInfo = new ButtonLayoutInfo();
        this.iconifyButton = new ButtonRegion(HeaderButtonType.ICONIFY, "-FX-INTERNAL-iconify-button", 0);
        this.maximizeButton = new ButtonRegion(HeaderButtonType.MAXIMIZE, "-FX-INTERNAL-maximize-button", 1);
        this.closeButton = new ButtonRegion(HeaderButtonType.CLOSE, "-FX-INTERNAL-close-button", 2);
        this.modalOrOwned = bl2;
        this.utility = bl3;
        this.rightToLeft = bl4;
        ObservableValue observableValue2 = this.sceneProperty().flatMap(Scene::windowProperty).map(window -> window instanceof Stage ? (Stage)window : null);
        Subscription subscription = observableValue2.flatMap(Window::focusedProperty).orElse((Object)true).subscribe(this::onFocusedChanged);
        Subscription subscription2 = observableValue2.flatMap(Stage::resizableProperty).orElse((Object)true).subscribe(this::onResizableChanged);
        Subscription subscription3 = observableValue2.flatMap(Stage::maximizedProperty).orElse((Object)false).subscribe(this::onMaximizedChanged);
        Subscription subscription4 = this.sceneProperty().flatMap(Scene::fillProperty).map(this::isDarkBackground).orElse((Object)false).subscribe(bl -> this.updateStyleClass());
        this.subscriptions = Subscription.combine((Subscription[])new Subscription[]{subscription, subscription2, subscription3, subscription4, observableValue.subscribe(this::updateStylesheet)});
        this.getStyleClass().setAll((Object[])new String[]{"-FX-INTERNAL-header-button-container"});
        if (bl3) {
            this.getChildren().add((Object)this.closeButton);
        } else {
            this.getChildren().addAll((Object[])new Node[]{this.iconifyButton, this.maximizeButton, this.closeButton});
        }
        this.updateButtonMetrics();
    }

    public void dispose() {
        this.subscriptions.unsubscribe();
    }

    public ReadOnlyObjectProperty<HeaderButtonMetrics> metricsProperty() {
        return this.metrics;
    }

    public DoubleProperty prefButtonHeightProperty() {
        return this.prefButtonHeight;
    }

    protected Region getButtonGlyph(HeaderButtonType headerButtonType) {
        return (Region)(switch (headerButtonType) {
            default -> throw new MatchException(null, null);
            case HeaderButtonType.ICONIFY -> this.iconifyButton;
            case HeaderButtonType.MAXIMIZE -> this.maximizeButton;
            case HeaderButtonType.CLOSE -> this.closeButton;
        }).getChildrenUnmodifiable().getFirst();
    }

    public HeaderButtonType buttonAt(double d, double d2) {
        if (!this.utility) {
            for (ButtonRegion buttonRegion : this.orderedButtons) {
                if (!buttonRegion.isVisible() || !buttonRegion.getBoundsInParent().contains(d, d2)) continue;
                return buttonRegion.getButtonType();
            }
        } else if (this.closeButton.isVisible() && this.closeButton.getBoundsInParent().contains(d, d2)) {
            return HeaderButtonType.CLOSE;
        }
        return null;
    }

    public boolean handleMouseEvent(int n, int n2, double d, double d2) {
        ButtonRegion buttonRegion;
        HeaderButtonType headerButtonType = this.buttonAt(d, d2);
        if (headerButtonType != null) {
            switch (headerButtonType) {
                default: {
                    throw new MatchException(null, null);
                }
                case ICONIFY: {
                    v0 = this.iconifyButton;
                    break;
                }
                case MAXIMIZE: {
                    v0 = this.maximizeButton;
                    break;
                }
                case CLOSE: {
                    v0 = this.closeButton;
                    break;
                }
            }
        } else {
            v0 = buttonRegion = null;
        }
        if (n == 225 || n == 224 || n == 223) {
            this.handleMouseOver(buttonRegion);
        } else if (n == 226) {
            this.handleMouseExit();
        } else if (n == 222 && n2 == 212) {
            this.handleMouseUp(buttonRegion, headerButtonType);
        } else if (buttonRegion != null && n == 221 && n2 == 212) {
            this.handleMouseDown(buttonRegion);
        }
        if (n == 225 || n == 226) {
            return false;
        }
        return buttonRegion != null || this.buttonAtMouseDown != null;
    }

    private void handleMouseOver(Node node) {
        this.iconifyButton.pseudoClassStateChanged(HOVER_PSEUDOCLASS, node == this.iconifyButton);
        this.maximizeButton.pseudoClassStateChanged(HOVER_PSEUDOCLASS, node == this.maximizeButton);
        this.closeButton.pseudoClassStateChanged(HOVER_PSEUDOCLASS, node == this.closeButton);
        if (this.buttonAtMouseDown != null && this.buttonAtMouseDown != node) {
            this.buttonAtMouseDown.pseudoClassStateChanged(PRESSED_PSEUDOCLASS, false);
        }
    }

    private void handleMouseExit() {
        this.buttonAtMouseDown = null;
        for (Node node : new Node[]{this.iconifyButton, this.maximizeButton, this.closeButton}) {
            node.pseudoClassStateChanged(HOVER_PSEUDOCLASS, false);
            node.pseudoClassStateChanged(PRESSED_PSEUDOCLASS, false);
        }
    }

    private void handleMouseDown(Node node) {
        this.buttonAtMouseDown = node;
        if (!node.isDisabled()) {
            node.pseudoClassStateChanged(PRESSED_PSEUDOCLASS, true);
        }
    }

    private void handleMouseUp(Node node, HeaderButtonType headerButtonType) {
        Window window;
        boolean bl = this.buttonAtMouseDown == node;
        this.buttonAtMouseDown = null;
        Scene scene = this.getScene();
        if (node == null || node.isDisabled() || scene == null || !((window = scene.getWindow()) instanceof Stage)) {
            return;
        }
        Stage stage = (Stage)window;
        node.pseudoClassStateChanged(PRESSED_PSEUDOCLASS, false);
        if (bl) {
            switch (headerButtonType) {
                case ICONIFY: {
                    stage.setIconified(true);
                    break;
                }
                case MAXIMIZE: {
                    stage.setMaximized(!stage.isMaximized());
                    break;
                }
                case CLOSE: {
                    Event.fireEvent((EventTarget)stage, (Event)new WindowEvent(stage, WindowEvent.WINDOW_CLOSE_REQUEST));
                }
            }
        }
    }

    private void onFocusedChanged(boolean bl) {
        this.iconifyButton.pseudoClassStateChanged(ACTIVE_PSEUDOCLASS, bl);
        this.maximizeButton.pseudoClassStateChanged(ACTIVE_PSEUDOCLASS, bl);
        this.closeButton.pseudoClassStateChanged(ACTIVE_PSEUDOCLASS, bl);
    }

    private void onResizableChanged(boolean bl) {
        boolean bl2 = this.utility || this.modalOrOwned && !bl;
        this.toggleStyleClass(this, UTILITY_STYLE_CLASS, bl2);
        this.iconifyButton.setDisable(this.utility || this.modalOrOwned);
        this.maximizeButton.setDisable(!bl);
    }

    private void onMaximizedChanged(boolean bl) {
        this.toggleStyleClass(this.maximizeButton, RESTORE_STYLE_CLASS, bl);
    }

    private void updateStyleClass() {
        boolean bl = this.isDarkBackground(this.getScene() != null ? this.getScene().getFill() : null);
        this.toggleStyleClass(this.iconifyButton, DARK_STYLE_CLASS, bl);
        this.toggleStyleClass(this.maximizeButton, DARK_STYLE_CLASS, bl);
        this.toggleStyleClass(this.closeButton, DARK_STYLE_CLASS, bl);
    }

    private void updateStylesheet(String string) {
        this.getStylesheets().setAll((Object[])new String[]{string});
    }

    private void toggleStyleClass(Node node, String string, boolean bl) {
        if (bl && !node.getStyleClass().contains((Object)string)) {
            node.getStyleClass().add((Object)string);
        } else if (!bl) {
            node.getStyleClass().remove((Object)string);
        }
    }

    private boolean isDarkBackground(Paint paint) {
        return paint != null && Utils.calculateAverageBrightness(paint) < 0.5;
    }

    private double getEffectiveButtonHeight() {
        double d = this.prefButtonHeight.get();
        return d >= 0.0 ? d : this.buttonDefaultHeight.get();
    }

    private double getButtonOffsetY(double d) {
        return switch (((ButtonVerticalAlignment)((Object)this.buttonVerticalAlignment.get())).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 0.0;
            case 1 -> (this.getEffectiveButtonHeight() - d) / 2.0;
        };
    }

    private void ensureRegionPrefHeight(Region region, double d) {
        StyleableDoubleProperty styleableDoubleProperty = (StyleableDoubleProperty)region.prefHeightProperty();
        if (styleableDoubleProperty.getStyleOrigin() == null) {
            styleableDoubleProperty.applyStyle((StyleOrigin)null, d);
        }
    }

    private boolean updateButtonLayoutInfo() {
        double d;
        boolean bl;
        Region region;
        Region region2;
        Region region3;
        if (this.rightToLeft) {
            region3 = this.orderedButtons.get(2);
            region2 = this.orderedButtons.get(1);
            region = this.orderedButtons.get(0);
            bl = this.buttonPlacement.get() != ButtonPlacement.LEFT;
        } else {
            region3 = this.orderedButtons.get(0);
            region2 = this.orderedButtons.get(1);
            region = this.orderedButtons.get(2);
            bl = this.buttonPlacement.get() == ButtonPlacement.LEFT;
        }
        double d2 = switch (((ButtonVerticalAlignment)((Object)this.buttonVerticalAlignment.get())).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.getEffectiveButtonHeight();
            case 1 -> this.buttonDefaultHeight.get();
        };
        this.ensureRegionPrefHeight(region3, d2);
        this.ensureRegionPrefHeight(region2, d2);
        this.ensureRegionPrefHeight(region, d2);
        double d3 = this.snapSizeX(HeaderButtonOverlay.boundedWidth(region3));
        double d4 = this.snapSizeX(HeaderButtonOverlay.boundedWidth(region2));
        double d5 = this.snapSizeX(HeaderButtonOverlay.boundedWidth(region));
        double d6 = this.snapSizeY(HeaderButtonOverlay.boundedHeight(region3));
        double d7 = this.snapSizeY(HeaderButtonOverlay.boundedHeight(region2));
        double d8 = this.snapSizeY(HeaderButtonOverlay.boundedHeight(region));
        double d9 = this.snapSizeX(d3 + d4 + d5);
        if (this.buttonVerticalAlignment.get() == ButtonVerticalAlignment.CENTER) {
            if (bl) {
                double d10 = this.getButtonOffsetY(d6);
                d9 = this.snapSizeX(d9 + d10 * 2.0);
            } else {
                double d11 = this.getButtonOffsetY(d8);
                d9 = this.snapSizeX(d9 + d11 * 2.0);
            }
            d = this.snapSizeY(this.getEffectiveButtonHeight());
        } else {
            d = this.snapSizeY(Math.max(d6, Math.max(d7, d8)));
        }
        return this.layoutInfo.update(region3, d3, d6, region2, d4, d7, region, d5, d8, d9, d, bl);
    }

    private void updateButtonMetrics() {
        Dimension2D dimension2D;
        if (!this.updateButtonLayoutInfo()) {
            return;
        }
        Dimension2D dimension2D2 = dimension2D = this.layoutInfo.left() ? ((HeaderButtonMetrics)this.metrics.get()).leftInset() : ((HeaderButtonMetrics)this.metrics.get()).rightInset();
        if (dimension2D.getWidth() != this.layoutInfo.totalWidth() || dimension2D.getHeight() != this.layoutInfo.totalHeight()) {
            Dimension2D dimension2D3 = new Dimension2D(0.0, 0.0);
            Dimension2D dimension2D4 = new Dimension2D(this.layoutInfo.totalWidth(), this.layoutInfo.totalHeight());
            HeaderButtonMetrics headerButtonMetrics = this.layoutInfo.left() ? new HeaderButtonMetrics(dimension2D4, dimension2D3, this.buttonDefaultHeight.get()) : new HeaderButtonMetrics(dimension2D3, dimension2D4, this.buttonDefaultHeight.get());
            this.metrics.set((Object)headerButtonMetrics);
        }
    }

    @Override
    protected void layoutChildren() {
        double[] dArray = this.layoutInfo.getLayoutOffsetsForWidth(this.getWidth());
        for (int i = 0; i < 3; ++i) {
            ButtonSizeInfo buttonSizeInfo = this.layoutInfo.buttonSizeAt(i);
            HeaderButtonOverlay.layoutInArea(buttonSizeInfo.button(), dArray[i], this.getButtonOffsetY(buttonSizeInfo.height()), buttonSizeInfo.width(), buttonSizeInfo.height(), Double.NEGATIVE_INFINITY, Insets.EMPTY, true, true, HPos.LEFT, VPos.TOP, false);
        }
    }

    @Override
    public boolean usesMirroring() {
        return false;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return METADATA;
    }

    private static double boundedWidth(Node node) {
        return node.isManaged() ? HeaderButtonOverlay.boundedSize(node.minWidth(-1.0), node.prefWidth(-1.0), node.maxWidth(-1.0)) : 0.0;
    }

    private static double boundedHeight(Node node) {
        return node.isManaged() ? HeaderButtonOverlay.boundedSize(node.minHeight(-1.0), node.prefHeight(-1.0), node.maxHeight(-1.0)) : 0.0;
    }

    private static double boundedSize(double d, double d2, double d3) {
        return Math.min(Math.max(d2, d), Math.max(d, d3));
    }

    static {
        HeaderButtonOverlayHelper.setAccessor(new HeaderButtonOverlayHelper.Accessor(){

            @Override
            public void afterProcessCSS(HeaderButtonOverlay headerButtonOverlay) {
                headerButtonOverlay.updateButtonMetrics();
            }
        });
        BUTTON_DEFAULT_HEIGHT_METADATA = new CssMetaData<HeaderButtonOverlay, Number>("-fx-button-default-height", StyleConverter.getSizeConverter()){

            @Override
            public boolean isSettable(HeaderButtonOverlay headerButtonOverlay) {
                return true;
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(HeaderButtonOverlay headerButtonOverlay) {
                return headerButtonOverlay.buttonDefaultHeight;
            }
        };
        BUTTON_PLACEMENT_METADATA = new CssMetaData<HeaderButtonOverlay, ButtonPlacement>("-fx-button-placement", StyleConverter.getEnumConverter(ButtonPlacement.class), ButtonPlacement.RIGHT){

            @Override
            public boolean isSettable(HeaderButtonOverlay headerButtonOverlay) {
                return true;
            }

            @Override
            public StyleableProperty<ButtonPlacement> getStyleableProperty(HeaderButtonOverlay headerButtonOverlay) {
                return headerButtonOverlay.buttonPlacement;
            }
        };
        BUTTON_VERTICAL_ALIGNMENT_METADATA = new CssMetaData<HeaderButtonOverlay, ButtonVerticalAlignment>("-fx-button-vertical-alignment", StyleConverter.getEnumConverter(ButtonVerticalAlignment.class), ButtonVerticalAlignment.CENTER){

            @Override
            public boolean isSettable(HeaderButtonOverlay headerButtonOverlay) {
                return true;
            }

            @Override
            public StyleableProperty<ButtonVerticalAlignment> getStyleableProperty(HeaderButtonOverlay headerButtonOverlay) {
                return headerButtonOverlay.buttonVerticalAlignment;
            }
        };
        METADATA = Stream.concat(HeaderButtonOverlay.getClassCssMetaData().stream(), Stream.of(BUTTON_DEFAULT_HEIGHT_METADATA, BUTTON_PLACEMENT_METADATA, BUTTON_VERTICAL_ALIGNMENT_METADATA)).toList();
        HOVER_PSEUDOCLASS = PseudoClass.getPseudoClass("hover");
        PRESSED_PSEUDOCLASS = PseudoClass.getPseudoClass("pressed");
        ACTIVE_PSEUDOCLASS = PseudoClass.getPseudoClass("active");
    }

    private static enum ButtonPlacement {
        LEFT,
        RIGHT;

    }

    private static enum ButtonVerticalAlignment {
        STRETCH,
        CENTER;

    }

    private final class ButtonLayoutInfo {
        private final double[] temp = new double[3];
        private final ButtonSizeInfo[] buttonSizes = new ButtonSizeInfo[]{new ButtonSizeInfo(), new ButtonSizeInfo(), new ButtonSizeInfo()};
        private boolean left;
        private double totalWidth;
        private double totalHeight;

        private ButtonLayoutInfo() {
        }

        public ButtonSizeInfo buttonSizeAt(int n) {
            return this.buttonSizes[n];
        }

        public boolean left() {
            return this.left;
        }

        public double totalWidth() {
            return this.totalWidth;
        }

        public double totalHeight() {
            return this.totalHeight;
        }

        public double[] getLayoutOffsetsForWidth(double d) {
            double d2 = HeaderButtonOverlay.this.snapPositionX(this.left ? 0.0 : d - this.buttonSizes[0].width - this.buttonSizes[1].width - this.buttonSizes[2].width);
            double d3 = HeaderButtonOverlay.this.snapPositionX(this.left ? this.buttonSizes[0].width : d - this.buttonSizes[2].width - this.buttonSizes[1].width);
            double d4 = HeaderButtonOverlay.this.snapPositionX(this.left ? this.buttonSizes[0].width + this.buttonSizes[1].width : d - this.buttonSizes[2].width);
            if (HeaderButtonOverlay.this.buttonVerticalAlignment.get() == ButtonVerticalAlignment.CENTER) {
                if (this.left) {
                    double d5 = HeaderButtonOverlay.this.getButtonOffsetY(this.buttonSizes[0].height);
                    d2 = HeaderButtonOverlay.this.snapPositionX(d2 + d5);
                    d3 = HeaderButtonOverlay.this.snapPositionX(d3 + d5);
                    d4 = HeaderButtonOverlay.this.snapPositionX(d4 + d5);
                } else {
                    double d6 = HeaderButtonOverlay.this.getButtonOffsetY(this.buttonSizes[2].height);
                    d2 = HeaderButtonOverlay.this.snapPositionX(d2 - d6);
                    d3 = HeaderButtonOverlay.this.snapPositionX(d3 - d6);
                    d4 = HeaderButtonOverlay.this.snapPositionX(d4 - d6);
                }
            }
            this.temp[0] = d2;
            this.temp[1] = d3;
            this.temp[2] = d4;
            return this.temp;
        }

        boolean update(Region region, double d, double d2, Region region2, double d3, double d4, Region region3, double d5, double d6, double d7, double d8, boolean bl) {
            boolean bl2 = this.buttonSizes[0].update(region, d, d2) | this.buttonSizes[1].update(region2, d3, d4) | this.buttonSizes[2].update(region3, d5, d6);
            if (this.totalWidth != d7 || this.totalHeight != d8 || this.left != bl || bl2) {
                this.totalWidth = d7;
                this.totalHeight = d8;
                this.left = bl;
                return true;
            }
            return false;
        }
    }

    private class ButtonRegion
    extends Region {
        private static final CssMetaData<ButtonRegion, Number> BUTTON_ORDER_METADATA = new CssMetaData<ButtonRegion, Number>("-fx-button-order", StyleConverter.getSizeConverter()){

            @Override
            public boolean isSettable(ButtonRegion buttonRegion) {
                return true;
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(ButtonRegion buttonRegion) {
                return buttonRegion.buttonOrder;
            }
        };
        private static final List<CssMetaData<?, ?>> METADATA = Stream.concat(ButtonRegion.getClassCssMetaData().stream(), Stream.of(BUTTON_ORDER_METADATA)).toList();
        private final StyleableIntegerProperty buttonOrder = new SimpleStyleableIntegerProperty(BUTTON_ORDER_METADATA, this, "buttonOrder"){

            protected void invalidated() {
                ButtonRegion.this.requestParentLayout();
                HeaderButtonOverlay.this.orderedButtons.sort(Comparator.comparing(ButtonRegion::getButtonOrder));
            }
        };
        private final Region glyph = new Region();
        private final HeaderButtonType type;

        ButtonRegion(HeaderButtonType headerButtonType, String string, int n) {
            this.type = headerButtonType;
            HeaderButtonOverlay.this.orderedButtons.add(this);
            this.buttonOrder.set(n);
            this.glyph.getStyleClass().setAll((Object[])new String[]{"-FX-INTERNAL-glyph"});
            this.getChildren().add((Object)this.glyph);
            this.getStyleClass().setAll((Object[])new String[]{"-FX-INTERNAL-header-button", string});
        }

        public HeaderButtonType getButtonType() {
            return this.type;
        }

        public int getButtonOrder() {
            return this.buttonOrder.get();
        }

        @Override
        protected void layoutChildren() {
            this.layoutInArea(this.glyph, 0.0, 0.0, this.getWidth(), this.getHeight(), 0.0, HPos.LEFT, VPos.TOP);
        }

        @Override
        public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
            return METADATA;
        }
    }

    private static final class ButtonSizeInfo {
        private Region button;
        private double width;
        private double height;

        private ButtonSizeInfo() {
        }

        public Region button() {
            return this.button;
        }

        public double width() {
            return this.width;
        }

        public double height() {
            return this.height;
        }

        boolean update(Region region, double d, double d2) {
            if (this.button != region || this.width != d || this.height != d2) {
                this.button = region;
                this.width = d;
                this.height = d2;
                return true;
            }
            return false;
        }
    }
}

