/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx;

import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;

public class UnmodifiableArrayList<T>
extends AbstractList<T>
implements RandomAccess {
    private T[] elements;
    private final int size;

    public UnmodifiableArrayList(T[] TArray, int n) {
        assert (TArray != null ? n <= TArray.length : n == 0);
        this.size = n;
        this.elements = TArray;
    }

    @Override
    public T get(int n) {
        return this.elements[n];
    }

    @Override
    public int size() {
        return this.size;
    }

    public static <T> UnmodifiableArrayList<T> copyOfNullFiltered(List<T> list) {
        Objects.requireNonNull(list, "list cannot be null");
        int n = 0;
        Object[] objectArray = new Object[list.size()];
        if (list instanceof RandomAccess) {
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                T t = list.get(i);
                if (t == null) continue;
                objectArray[n++] = t;
            }
        } else {
            for (T t : list) {
                if (t == null) continue;
                objectArray[n++] = t;
            }
        }
        return new UnmodifiableArrayList<Object>(objectArray, n);
    }

    public static <T> UnmodifiableArrayList<T> copyOfNullFiltered(T[] TArray) {
        Objects.requireNonNull(TArray, "elements cannot be null");
        int n = 0;
        Object[] objectArray = new Object[TArray.length];
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i] == null) continue;
            objectArray[n++] = TArray[i];
        }
        return new UnmodifiableArrayList<Object>(objectArray, n);
    }
}

