/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.util.InterpolationUtils;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.NamedArg;
import javafx.scene.image.Image;
import javafx.scene.paint.Paint;

public final class ImagePattern
extends Paint {
    private Image image;
    private double x;
    private double y;
    private double width = 1.0;
    private double height = 1.0;
    private boolean proportional = true;
    private Object platformPaint;
    private int hash;

    public final Image getImage() {
        return this.image;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public final boolean isProportional() {
        return this.proportional;
    }

    @Override
    public final boolean isOpaque() {
        return ((com.sun.prism.paint.ImagePattern)this.acc_getPlatformPaint()).isOpaque();
    }

    public ImagePattern(@NamedArg(value="image") Image image) {
        if (image == null) {
            throw new NullPointerException("Image must be non-null.");
        }
        if (image.getProgress() < 1.0) {
            throw new IllegalArgumentException("Image not yet loaded");
        }
        this.image = image;
    }

    public ImagePattern(@NamedArg(value="image") Image image, @NamedArg(value="x") double d, @NamedArg(value="y") double d2, @NamedArg(value="width") double d3, @NamedArg(value="height") double d4, @NamedArg(value="proportional") boolean bl) {
        if (image == null) {
            throw new NullPointerException("Image must be non-null.");
        }
        if (image.getProgress() < 1.0) {
            throw new IllegalArgumentException("Image not yet loaded");
        }
        this.image = image;
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
        this.proportional = bl;
    }

    @Override
    public ImagePattern interpolate(ImagePattern imagePattern, double d) {
        Objects.requireNonNull(imagePattern, "endValue cannot be null");
        if (d <= 0.0 || this.equals(imagePattern)) {
            return this;
        }
        if (d >= 1.0) {
            return imagePattern;
        }
        if (this.proportional != imagePattern.proportional) {
            return InterpolationUtils.interpolateDiscrete(this, imagePattern, d);
        }
        return new ImagePattern(InterpolationUtils.interpolateDiscrete(this.image, imagePattern.image, d), InterpolationUtils.interpolate(this.x, imagePattern.x, d), InterpolationUtils.interpolate(this.y, imagePattern.y, d), InterpolationUtils.interpolate(this.width, imagePattern.width, d), InterpolationUtils.interpolate(this.height, imagePattern.height, d), this.proportional);
    }

    @Override
    public Paint interpolate(Paint paint, double d) {
        return InterpolationUtils.interpolatePaint(this, paint, d);
    }

    public boolean equals(Object object) {
        if (object instanceof ImagePattern) {
            ImagePattern imagePattern = (ImagePattern)object;
            return this.proportional == imagePattern.proportional && this.x == imagePattern.x && this.y == imagePattern.y && this.width == imagePattern.width && this.height == imagePattern.height && this.image.equals(imagePattern.image);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long l = 17L;
            l = 37L * l + Double.doubleToLongBits(this.x);
            l = 37L * l + Double.doubleToLongBits(this.y);
            l = 37L * l + Double.doubleToLongBits(this.width);
            l = 37L * l + Double.doubleToLongBits(this.height);
            l = 37L * l + (this.proportional ? 1231L : 1237L);
            l = 37L * l + (long)this.image.hashCode();
            this.hash = (int)(l ^ l >> 32);
        }
        return this.hash;
    }

    @Override
    boolean acc_isMutable() {
        return Toolkit.getImageAccessor().isAnimation(this.image);
    }

    @Override
    void acc_addListener(AbstractNotifyListener abstractNotifyListener) {
        Toolkit.getImageAccessor().getImageProperty(this.image).addListener((InvalidationListener)abstractNotifyListener);
    }

    @Override
    void acc_removeListener(AbstractNotifyListener abstractNotifyListener) {
        Toolkit.getImageAccessor().getImageProperty(this.image).removeListener((InvalidationListener)abstractNotifyListener);
    }

    @Override
    Object acc_getPlatformPaint() {
        if (this.acc_isMutable() || this.platformPaint == null) {
            this.platformPaint = Toolkit.getToolkit().getPaint(this);
        }
        return this.platformPaint;
    }
}

