/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.NamedArg;
import javafx.scene.control.Control;
import javafx.scene.control.TableColumnBase;

public abstract class ResizeFeaturesBase<S> {
    private final TableColumnBase<S, ?> column;
    private final Double delta;

    public ResizeFeaturesBase(@NamedArg(value="column") TableColumnBase<S, ?> tableColumnBase, @NamedArg(value="delta") Double d) {
        this.column = tableColumnBase;
        this.delta = d;
    }

    public abstract double getContentWidth();

    public abstract Control getTableControl();

    public TableColumnBase<S, ?> getColumn() {
        return this.column;
    }

    public Double getDelta() {
        return this.delta;
    }

    public void setColumnWidth(TableColumnBase<S, ?> tableColumnBase, double d) {
        Control control = this.getTableControl();
        if (control.isSnapToPixel()) {
            double d2 = control.snapSizeX(tableColumnBase.getMinWidth());
            double d3 = control.snapSizeX(tableColumnBase.getMaxWidth());
            if (d < d2) {
                d = d2;
            } else if (d > d3) {
                d = d3;
                if (d < d2) {
                    d = d2;
                }
            } else {
                d = control.snapPositionX(d);
            }
            tableColumnBase.setWidth(d);
        } else {
            tableColumnBase.doSetWidth(d);
        }
    }
}

