/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsResource;
import com.sun.prism.Presentable;
import com.sun.prism.PresentableState;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.mtl.MTLContext;
import com.sun.prism.mtl.MTLGraphics;
import com.sun.prism.mtl.MTLRTTexture;
import com.sun.prism.mtl.MTLRenderTarget;

public class MTLSwapChain
implements MTLRenderTarget,
Presentable,
GraphicsResource {
    private final PresentableState pState;
    private final MTLContext pContext;
    private MTLRTTexture stableBackbuffer;
    private final float pixelScaleFactorX;
    private final float pixelScaleFactorY;
    private boolean needsResize;
    private int w;
    private int h;

    public MTLSwapChain(MTLContext mTLContext, PresentableState presentableState) {
        this.pContext = mTLContext;
        this.pState = presentableState;
        this.pixelScaleFactorX = presentableState.getRenderScaleX();
        this.pixelScaleFactorY = presentableState.getRenderScaleY();
        this.w = presentableState.getRenderWidth();
        this.h = presentableState.getRenderHeight();
    }

    @Override
    public boolean lockResources(PresentableState presentableState) {
        if (this.pState != presentableState || this.pixelScaleFactorX != presentableState.getRenderScaleX() || this.pixelScaleFactorY != presentableState.getRenderScaleY()) {
            return true;
        }
        boolean bl = this.needsResize = this.w != presentableState.getRenderWidth() || this.h != presentableState.getRenderHeight();
        if (this.stableBackbuffer != null && !this.needsResize) {
            this.stableBackbuffer.lock();
            if (this.stableBackbuffer.isSurfaceLost()) {
                this.stableBackbuffer = null;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean prepare(Rectangle rectangle) {
        MTLContext mTLContext = this.getContext();
        mTLContext.flushVertexBuffer();
        MTLGraphics mTLGraphics = MTLGraphics.create(mTLContext, this.stableBackbuffer);
        if (mTLGraphics == null) {
            return false;
        }
        this.stableBackbuffer.unlock();
        return true;
    }

    public MTLContext getContext() {
        return this.pContext;
    }

    @Override
    public boolean present() {
        MTLContext mTLContext = this.getContext();
        if (mTLContext.isDisposed()) {
            return false;
        }
        mTLContext.commitCurrentCommandBuffer();
        return true;
    }

    @Override
    public float getPixelScaleFactorX() {
        return this.pixelScaleFactorX;
    }

    @Override
    public float getPixelScaleFactorY() {
        return this.pixelScaleFactorY;
    }

    @Override
    public Screen getAssociatedScreen() {
        return null;
    }

    @Override
    public Graphics createGraphics() {
        MTLGraphics mTLGraphics;
        if (this.pState.getNativeFrameBuffer() == 0L) {
            System.err.println("Native backbuffer texture from Glass is nil.");
            return null;
        }
        boolean bl = this.needsResize = this.w != this.pState.getRenderWidth() || this.h != this.pState.getRenderHeight();
        if (this.stableBackbuffer == null || this.needsResize) {
            if (this.stableBackbuffer != null) {
                this.getContext().flushVertexBuffer();
                this.stableBackbuffer.dispose();
                this.stableBackbuffer = null;
            }
            this.w = this.pState.getRenderWidth();
            this.h = this.pState.getRenderHeight();
            long l = this.pState.getNativeFrameBuffer();
            this.stableBackbuffer = MTLRTTexture.create(this.getContext(), l, this.w, this.h, 0L);
            if (PrismSettings.dirtyOptsEnabled) {
                this.stableBackbuffer.contentsUseful();
            }
        }
        if ((mTLGraphics = MTLGraphics.create(this.getContext(), this.stableBackbuffer)) == null) {
            return null;
        }
        mTLGraphics.scale(this.pixelScaleFactorX, this.pixelScaleFactorY);
        return mTLGraphics;
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public void setOpaque(boolean bl) {
    }

    @Override
    public boolean isMSAA() {
        return false;
    }

    @Override
    public int getPhysicalWidth() {
        return this.pState.getOutputWidth();
    }

    @Override
    public int getPhysicalHeight() {
        return this.pState.getOutputHeight();
    }

    @Override
    public int getContentX() {
        return 0;
    }

    @Override
    public int getContentY() {
        return 0;
    }

    @Override
    public int getContentWidth() {
        return this.pState.getOutputWidth();
    }

    @Override
    public int getContentHeight() {
        return this.pState.getOutputHeight();
    }

    @Override
    public long getResourceHandle() {
        return 0L;
    }

    @Override
    public void dispose() {
        if (this.stableBackbuffer != null) {
            this.stableBackbuffer.dispose();
            this.stableBackbuffer = null;
        }
    }
}

