/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media;

import com.sun.javafx.css.media.ComparisonOp;
import com.sun.javafx.css.media.ContextAwareness;
import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.MediaQueryContext;
import com.sun.javafx.css.media.SizeQueryType;
import com.sun.javafx.css.media.expression.ConjunctionExpression;
import com.sun.javafx.css.media.expression.FunctionExpression;
import com.sun.javafx.css.media.expression.RangeExpression;
import com.sun.javafx.css.parser.Token;
import java.util.Locale;
import java.util.function.Function;
import javafx.application.ColorScheme;

final class MediaFeatures {
    private MediaFeatures() {
    }

    public static MediaQuery discreteQueryExpression(String string, Token token) {
        String string2;
        return switch (string2 = MediaFeatures.lowerCaseTextValue(string)) {
            case "min-width" -> MediaFeatures.rangeQueryExpression(SizeQueryType.WIDTH, token, ComparisonOp.GREATER_OR_EQUAL.getExpressionSupplier());
            case "max-width" -> MediaFeatures.rangeQueryExpression(SizeQueryType.WIDTH, token, ComparisonOp.LESS_OR_EQUAL.getExpressionSupplier());
            case "min-height" -> MediaFeatures.rangeQueryExpression(SizeQueryType.HEIGHT, token, ComparisonOp.GREATER_OR_EQUAL.getExpressionSupplier());
            case "max-height" -> MediaFeatures.rangeQueryExpression(SizeQueryType.HEIGHT, token, ComparisonOp.LESS_OR_EQUAL.getExpressionSupplier());
            case "min-aspect-ratio" -> MediaFeatures.rangeQueryExpression(SizeQueryType.ASPECT_RATIO, token, ComparisonOp.GREATER_OR_EQUAL.getExpressionSupplier());
            case "max-aspect-ratio" -> MediaFeatures.rangeQueryExpression(SizeQueryType.ASPECT_RATIO, token, ComparisonOp.LESS_OR_EQUAL.getExpressionSupplier());
            case "width", "height", "aspect-ratio" -> MediaFeatures.rangeQueryExpression(SizeQueryType.of(string2), token, ComparisonOp.EQUAL.getExpressionSupplier());
            case "orientation" -> {
                boolean v1 = switch (MediaFeatures.checkNotNullValue(string2, MediaFeatures.lowerCaseTextValue(token))) {
                    case "landscape" -> false;
                    case "portrait" -> true;
                    default -> throw MediaFeatures.unknownValue("orientation", token.getText());
                };
                boolean var5_9 = v1;
                yield FunctionExpression.of(string2, MediaFeatures.lowerCaseTextValue(token), mediaQueryContext -> var5_9 ? mediaQueryContext.getWidth() <= mediaQueryContext.getHeight() : mediaQueryContext.getWidth() > mediaQueryContext.getHeight(), true, ContextAwareness.VIEWPORT_SIZE);
            }
            case "display-mode" -> {
                boolean v2 = switch (MediaFeatures.checkNotNullValue(string2, MediaFeatures.lowerCaseTextValue(token))) {
                    case "standalone" -> false;
                    case "fullscreen" -> true;
                    default -> throw MediaFeatures.unknownValue("display-mode", token.getText());
                };
                boolean var5_10 = v2;
                yield FunctionExpression.of(string2, MediaFeatures.lowerCaseTextValue(token), mediaQueryContext -> mediaQueryContext.isFullScreen() == var5_10, true, ContextAwareness.FULLSCREEN);
            }
            case "prefers-color-scheme" -> FunctionExpression.of(string2, MediaFeatures.checkNotNullValue(string2, MediaFeatures.lowerCaseTextValue(token)), MediaQueryContext::getColorScheme, MediaFeatures.enumValue(ColorScheme::valueOf, string2, token.getText()), new ContextAwareness[0]);
            case "prefers-reduced-motion" -> MediaFeatures.booleanPreferenceExpression(string2, token, "reduce", MediaQueryContext::isReducedMotion);
            case "prefers-reduced-transparency" -> MediaFeatures.booleanPreferenceExpression(string2, token, "reduce", MediaQueryContext::isReducedTransparency);
            case "prefers-reduced-data" -> MediaFeatures.booleanPreferenceExpression(string2, token, "reduce", MediaQueryContext::isReducedData);
            case "-fx-prefers-persistent-scrollbars" -> MediaFeatures.booleanPreferenceExpression(string2, token, "persistent", MediaQueryContext::isPersistentScrollBars);
            default -> throw new IllegalArgumentException(String.format("Unknown media feature <%s>", string));
        };
    }

    public static MediaQuery rangeQueryExpression(String string, Token token, ComparisonOp comparisonOp) {
        return MediaFeatures.rangeQueryExpression(SizeQueryType.of(MediaFeatures.lowerCaseTextValue(string)), token, comparisonOp.getExpressionSupplier());
    }

    public static MediaQuery rangeQueryExpression(String string, Token token, Token token2, ComparisonOp comparisonOp, ComparisonOp comparisonOp2) {
        return ConjunctionExpression.of(MediaFeatures.rangeQueryExpression(string, token, comparisonOp.flipped()), MediaFeatures.rangeQueryExpression(string, token2, comparisonOp2));
    }

    private static MediaQuery rangeQueryExpression(SizeQueryType sizeQueryType, Token token, RangeExpression.Supplier supplier) {
        return sizeQueryType.getQueryExpression(MediaFeatures.checkNotNullValue(sizeQueryType.getFeatureName(), token), supplier);
    }

    private static MediaQuery booleanPreferenceExpression(String string, Token token, String string2, Function<MediaQueryContext, Boolean> function) {
        String string3 = MediaFeatures.lowerCaseTextValue(token);
        if ("no-preference".equals(string3)) {
            return FunctionExpression.of(string, string3, function, false, new ContextAwareness[0]);
        }
        if (string3 == null || string2.equals(string3)) {
            return FunctionExpression.of(string, string3, function, true, new ContextAwareness[0]);
        }
        throw MediaFeatures.unknownValue(string, token.getText());
    }

    private static <T> T checkNotNullValue(String string, T t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Media feature <%s> cannot be evaluated in a boolean context", string));
        }
        return t;
    }

    private static <T extends Enum<T>> T enumValue(Function<String, T> function, String string, String string2) {
        try {
            return (T)((Enum)function.apply(string2.toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MediaFeatures.unknownValue(string, string2);
        }
    }

    private static String lowerCaseTextValue(String string) {
        return string != null ? string.toLowerCase(Locale.ROOT) : null;
    }

    private static String lowerCaseTextValue(Token token) {
        return token != null ? MediaFeatures.lowerCaseTextValue(token.getText()) : null;
    }

    private static RuntimeException unknownValue(String string, String string2) {
        return new IllegalArgumentException(String.format("Unknown value <%s> for media feature <%s>", string2, string));
    }
}

