/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.StyleablePropertyHelper;
import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.tk.Toolkit;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableDoubleProperty
extends DoublePropertyBase
implements StyleableProperty<Number> {
    private StyleOrigin origin;
    private TransitionMediatorImpl mediator;

    public StyleableDoubleProperty() {
    }

    public StyleableDoubleProperty(double d) {
        super(d);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Number number) {
        double d;
        Node node;
        Object object = this.getBean();
        TransitionDefinition transitionDefinition = object instanceof Node && !NodeHelper.isInitialCssState(node = (Node)object) ? NodeHelper.findTransitionDefinition(node, this.getCssMetaData()) : null;
        double d2 = d = number != null ? number.doubleValue() : 0.0;
        if (transitionDefinition == null) {
            this.set(d);
        } else if (this.mediator == null || this.mediator.endValue != d) {
            this.mediator = new TransitionMediatorImpl(this.get(), d);
            this.mediator.run(transitionDefinition, this.getCssMetaData().getProperty(), Toolkit.getToolkit().getPrimaryTimer().nanos());
        }
        this.origin = styleOrigin;
    }

    public void bind(ObservableValue<? extends Number> observableValue) {
        super.bind(observableValue);
        this.onUserChange();
    }

    public void set(double d) {
        super.set(d);
        this.onUserChange();
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private void onUserChange() {
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel();
        }
    }

    private boolean equalsEndValue(Object object) {
        if (!(object instanceof Double)) {
            return false;
        }
        Double d = (Double)object;
        double d2 = this.mediator != null ? this.mediator.endValue : this.get();
        return Double.compare(d, d2) == 0;
    }

    static {
        StyleablePropertyHelper.setDoubleAccessor(new StyleablePropertyHelper.Accessor(){

            @Override
            public boolean equalsEndValue(StyleableProperty<?> styleableProperty, Object object) {
                return ((StyleableDoubleProperty)styleableProperty).equalsEndValue(object);
            }
        });
    }

    private class TransitionMediatorImpl
    extends TransitionMediator {
        private final double startValue;
        private final double endValue;
        private double reversingAdjustedStartValue;

        public TransitionMediatorImpl(double d, double d2) {
            this.startValue = d;
            this.endValue = d2;
            this.reversingAdjustedStartValue = d;
        }

        @Override
        public void onUpdate(double d) {
            StyleableDoubleProperty.super.set(d != 1.0 ? this.startValue + (this.endValue - this.startValue) * d : this.endValue);
        }

        @Override
        public void onStop() {
            StyleableDoubleProperty.this.mediator = null;
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableDoubleProperty.this;
        }

        @Override
        public boolean updateReversingAdjustedStartValue(TransitionMediator transitionMediator) {
            TransitionMediatorImpl transitionMediatorImpl = (TransitionMediatorImpl)transitionMediator;
            if (transitionMediatorImpl.reversingAdjustedStartValue == this.endValue) {
                this.reversingAdjustedStartValue = transitionMediatorImpl.endValue;
                return true;
            }
            return false;
        }
    }
}

