/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media;

import com.sun.javafx.css.media.ComparisonOp;
import com.sun.javafx.css.media.MediaFeatures;
import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.expression.ConjunctionExpression;
import com.sun.javafx.css.media.expression.ConstantExpression;
import com.sun.javafx.css.media.expression.DisjunctionExpression;
import com.sun.javafx.css.media.expression.NegationExpression;
import com.sun.javafx.css.parser.Token;
import com.sun.javafx.css.parser.TokenStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public final class MediaQueryParser {
    private static final Predicate<Token> IDENT = token -> token.getType() == 11;
    private static final Predicate<Token> LPAREN = token -> token.getType() == 34;
    private static final Predicate<Token> RPAREN = token -> token.getType() == 35;
    private static final Predicate<Token> COLON = token -> token.getType() == 31;
    private static final Predicate<Token> NOT_COMMA = token -> token.getType() != 36;
    private static final Predicate<Token> NOT_KEYWORD = token -> MediaQueryParser.equalsIdentIgnoreCase(token, "not");
    private static final Predicate<Token> AND_KEYWORD = token -> MediaQueryParser.equalsIdentIgnoreCase(token, "and");
    private static final Predicate<Token> OR_KEYWORD = token -> MediaQueryParser.equalsIdentIgnoreCase(token, "or");
    private static final Predicate<Token> GREATER = token -> token.getType() == 27;
    private static final Predicate<Token> LESS = token -> token.getType() == 48;
    private static final Predicate<Token> EQUALS = token -> token.getType() == 49;
    private static final Predicate<Token> GREATER_LESS_EQUALS = token -> switch (token.getType()) {
        case 27, 48, 49 -> true;
        default -> false;
    };
    private static final Predicate<Token> LENGTH = token -> switch (token.getType()) {
        case 13, 14, 15, 16, 17, 18, 19, 20, 21 -> true;
        default -> false;
    };
    private final BiConsumer<Token, String> errorHandler;

    public MediaQueryParser(BiConsumer<Token, String> biConsumer) {
        this.errorHandler = Objects.requireNonNull(biConsumer);
    }

    public List<MediaQuery> parseMediaQueryList(List<Token> list) {
        TokenStream tokenStream = new TokenStream(list);
        ArrayList<MediaQuery> arrayList = new ArrayList<MediaQuery>();
        boolean bl = false;
        block4: while (tokenStream.consume() != null) {
            switch (tokenStream.current().getType()) {
                case 36: {
                    if (bl || arrayList.isEmpty()) {
                        this.errorHandler.accept(tokenStream.current(), "Unexpected token");
                    }
                    bl = true;
                    continue block4;
                }
                case 11: 
                case 34: {
                    bl = false;
                    tokenStream.reconsume();
                    MediaQuery mediaQuery = this.parseMediaCondition(tokenStream);
                    if (mediaQuery != null) {
                        arrayList.add(mediaQuery);
                        continue block4;
                    }
                    while (tokenStream.consumeIf(NOT_COMMA) != null) {
                    }
                    arrayList.add(ConstantExpression.of(false));
                    continue block4;
                }
            }
            this.errorHandler.accept(tokenStream.current(), "Unexpected token");
            return arrayList;
        }
        return arrayList;
    }

    private MediaQuery parseMediaCondition(TokenStream tokenStream) {
        if (tokenStream.consumeIf(NOT_KEYWORD) != null) {
            MediaQuery mediaQuery = this.parseMediaInParens(tokenStream);
            return mediaQuery != null ? NegationExpression.of(mediaQuery) : null;
        }
        ArrayList<MediaQuery> arrayList = new ArrayList<MediaQuery>();
        MediaQuery mediaQuery = this.parseMediaInParens(tokenStream);
        if (mediaQuery == null) {
            return null;
        }
        arrayList.add(mediaQuery);
        if (!this.parseRepeatingMediaCondition(tokenStream, arrayList, AND_KEYWORD, OR_KEYWORD)) {
            return null;
        }
        if (arrayList.size() >= 2) {
            return ConjunctionExpression.of(arrayList);
        }
        if (!this.parseRepeatingMediaCondition(tokenStream, arrayList, OR_KEYWORD, AND_KEYWORD)) {
            return null;
        }
        if (arrayList.size() >= 2) {
            return DisjunctionExpression.of(arrayList);
        }
        return (MediaQuery)arrayList.getFirst();
    }

    private boolean parseRepeatingMediaCondition(TokenStream tokenStream, List<MediaQuery> list, Predicate<Token> predicate, Predicate<Token> predicate2) {
        Object object;
        while (tokenStream.consumeIf(predicate) != null) {
            object = this.parseMediaInParens(tokenStream);
            if (object == null) {
                return false;
            }
            list.add((MediaQuery)object);
        }
        if (list.size() >= 2 && (object = tokenStream.peek()) != null && predicate2.test((Token)object)) {
            this.errorHandler.accept(tokenStream.consume(), "Unexpected token");
            return false;
        }
        return true;
    }

    private MediaQuery parseMediaInParens(TokenStream tokenStream) {
        if (tokenStream.matches(LPAREN, IDENT, RPAREN) || tokenStream.matches(LPAREN, IDENT, COLON)) {
            return this.parseDiscreteMediaFeature(tokenStream);
        }
        if (tokenStream.matches(LPAREN, LENGTH) || tokenStream.matches(LPAREN, IDENT, GREATER_LESS_EQUALS)) {
            return this.parseRangeMediaFeature(tokenStream);
        }
        if (tokenStream.consumeIf(LPAREN) != null) {
            MediaQuery mediaQuery = this.parseMediaCondition(tokenStream);
            if (tokenStream.consumeIf(RPAREN) == null) {
                this.errorHandler.accept(tokenStream.consume(), "Expected RPAREN");
                return null;
            }
            return mediaQuery;
        }
        this.errorHandler.accept(tokenStream.consume(), "Expected LPAREN");
        return null;
    }

    private MediaQuery parseDiscreteMediaFeature(TokenStream tokenStream) {
        if (tokenStream.consumeIf(LPAREN) == null) {
            this.errorHandler.accept(tokenStream.consume(), "Expected LPAREN");
            return null;
        }
        Token token = tokenStream.consumeIf(IDENT);
        if (token == null) {
            this.errorHandler.accept(tokenStream.consume(), "Expected IDENT");
            return null;
        }
        Token token2 = null;
        if (tokenStream.consumeIf(COLON) != null && (token2 = tokenStream.consume()) == null) {
            while (tokenStream.peek() != null) {
                tokenStream.consume();
            }
            this.errorHandler.accept(tokenStream.current(), "Expected token");
            return null;
        }
        if (tokenStream.consumeIf(RPAREN) == null) {
            this.errorHandler.accept(tokenStream.consume(), "Expected RPAREN");
            return null;
        }
        try {
            return MediaFeatures.discreteQueryExpression(token.getText(), token2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.errorHandler.accept(token2, illegalArgumentException.getMessage());
            return null;
        }
    }

    private MediaQuery parseRangeMediaFeature(TokenStream tokenStream) {
        MediaQuery mediaQuery;
        if (tokenStream.consumeIf(LPAREN) == null) {
            this.errorHandler.accept(tokenStream.consume(), "Expected LPAREN");
            return null;
        }
        class LocalMethods {
            LocalMethods(MediaQueryParser mediaQueryParser) {
            }

            static MediaQuery parseNameFirst(TokenStream tokenStream, BiConsumer<Token, String> biConsumer) {
                Token token = tokenStream.consumeIf(IDENT);
                if (token == null) {
                    biConsumer.accept(tokenStream.consume(), "Expected IDENT");
                    return null;
                }
                ComparisonOp comparisonOp = LocalMethods.parseComparisonOp(tokenStream);
                if (comparisonOp == null) {
                    biConsumer.accept(tokenStream.consume(), "Expected <comparison>");
                    return null;
                }
                Token token2 = tokenStream.consumeIf(LENGTH);
                if (token2 == null) {
                    biConsumer.accept(tokenStream.consume(), "Expected <length>");
                    return null;
                }
                try {
                    return MediaFeatures.rangeQueryExpression(token.getText(), token2, comparisonOp);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    biConsumer.accept(tokenStream.consume(), illegalArgumentException.getMessage());
                    return null;
                }
            }

            static MediaQuery parseValueFirst(TokenStream tokenStream, BiConsumer<Token, String> biConsumer) {
                ComparisonOp comparisonOp;
                Token token = tokenStream.consumeIf(LENGTH);
                if (token == null) {
                    biConsumer.accept(tokenStream.consume(), "Expected <length>");
                    return null;
                }
                ComparisonOp comparisonOp2 = LocalMethods.parseComparisonOp(tokenStream);
                if (comparisonOp2 == null) {
                    biConsumer.accept(tokenStream.consume(), "Expected <comparison>");
                    return null;
                }
                Token token2 = tokenStream.consumeIf(IDENT);
                if (token2 == null) {
                    biConsumer.accept(tokenStream.consume(), "Expected IDENT");
                    return null;
                }
                ComparisonOp comparisonOp3 = comparisonOp = comparisonOp2 == ComparisonOp.EQUAL ? null : LocalMethods.parseComparisonOp(tokenStream);
                if (comparisonOp == null || !comparisonOp.isSameDirection(comparisonOp2)) {
                    try {
                        return MediaFeatures.rangeQueryExpression(token2.getText(), token, comparisonOp2.flipped());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        biConsumer.accept(tokenStream.consume(), illegalArgumentException.getMessage());
                        return null;
                    }
                }
                Token token3 = tokenStream.consumeIf(LENGTH);
                if (token3 == null) {
                    biConsumer.accept(tokenStream.consume(), "Expected <length>");
                    return null;
                }
                try {
                    return MediaFeatures.rangeQueryExpression(token2.getText(), token, token3, comparisonOp2, comparisonOp);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    biConsumer.accept(tokenStream.consume(), illegalArgumentException.getMessage());
                    return null;
                }
            }

            static ComparisonOp parseComparisonOp(TokenStream tokenStream) {
                if (tokenStream.consumeIf(GREATER) != null) {
                    return tokenStream.consumeIf(EQUALS) != null ? ComparisonOp.GREATER_OR_EQUAL : ComparisonOp.GREATER;
                }
                if (tokenStream.consumeIf(LESS) != null) {
                    return tokenStream.consumeIf(EQUALS) != null ? ComparisonOp.LESS_OR_EQUAL : ComparisonOp.LESS;
                }
                if (tokenStream.consumeIf(EQUALS) != null) {
                    return ComparisonOp.EQUAL;
                }
                return null;
            }
        }
        MediaQuery mediaQuery2 = mediaQuery = tokenStream.matches(LENGTH) ? LocalMethods.parseValueFirst(tokenStream, this.errorHandler) : LocalMethods.parseNameFirst(tokenStream, this.errorHandler);
        if (mediaQuery != null && tokenStream.consumeIf(RPAREN) == null) {
            this.errorHandler.accept(tokenStream.consume(), "Expected RPAREN");
            return null;
        }
        return mediaQuery;
    }

    private static boolean equalsIdentIgnoreCase(Token token, String string) {
        return token.getType() == 11 && string.equalsIgnoreCase(token.getText());
    }
}

