/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.glass.ui.Screen;
import com.sun.prism.MediaFrame;
import com.sun.prism.Mesh;
import com.sun.prism.MeshView;
import com.sun.prism.MultiTexture;
import com.sun.prism.PhongMaterial;
import com.sun.prism.PixelFormat;
import com.sun.prism.Presentable;
import com.sun.prism.PresentableState;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.TextureResourcePool;
import com.sun.prism.impl.ps.BaseShaderFactory;
import com.sun.prism.mtl.MTLContext;
import com.sun.prism.mtl.MTLMesh;
import com.sun.prism.mtl.MTLMeshView;
import com.sun.prism.mtl.MTLPhongMaterial;
import com.sun.prism.mtl.MTLRTTexture;
import com.sun.prism.mtl.MTLShader;
import com.sun.prism.mtl.MTLSwapChain;
import com.sun.prism.mtl.MTLTexture;
import com.sun.prism.mtl.MTLTextureData;
import com.sun.prism.mtl.MTLTextureResource;
import com.sun.prism.mtl.MTLVramPool;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

class MTLResourceFactory
extends BaseShaderFactory {
    private final MTLContext context;

    MTLResourceFactory(Screen screen) {
        this.context = new MTLContext(screen, this);
        this.context.initState();
        if (PrismSettings.noClampToZero && PrismSettings.verbose) {
            System.err.println("prism.noClampToZero not supported by MTL");
        }
    }

    static int nextPowerOfTwo(int n, int n2) {
        int n3;
        if (n > n2) {
            return 0;
        }
        if ((n & n - 1) == 0) {
            return n;
        }
        for (n3 = 1; n3 < n; n3 <<= 1) {
        }
        return n3;
    }

    public MTLContext getContext() {
        return this.context;
    }

    private void checkTextureSize(int n, int n2) {
        int n3 = this.getMaximumTextureSize();
        if (n <= 0 || n2 <= 0 || n > n3 || n2 > n3) {
            throw new RuntimeException("Illegal texture dimensions (" + n + "x" + n2 + ")");
        }
    }

    @Override
    public Shader createShader(String string, InputStream inputStream, Map<String, Integer> map, Map<String, Integer> map2, int n, boolean bl, boolean bl2) {
        try {
            return this.createShader(string, map, map2, n, bl, bl2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new UnsupportedOperationException("Failed to create a prism shader");
        }
    }

    @Override
    public Shader createShader(String string, Map<String, Integer> map, Map<String, Integer> map2, int n, boolean bl, boolean bl2) {
        return MTLShader.createShader(this.getContext(), string, map, map2, n, bl, bl2);
    }

    @Override
    public Shader createStockShader(String string) {
        Objects.requireNonNull(string, "Shader name not be null");
        try {
            if (PrismSettings.verbose) {
                System.err.println("MTLResourceFactory: Prism - createStockShader: " + string);
            }
            Class<?> clazz = Class.forName("com.sun.prism.shader." + string + "_Loader");
            Method method = clazz.getMethod("loadShader", ShaderFactory.class, String.class, InputStream.class);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            return (Shader)method.invoke(null, this, string, byteArrayInputStream);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new InternalError("Error loading stock shader " + string);
        }
    }

    @Override
    public TextureResourcePool<?> getTextureResourcePool() {
        return MTLVramPool.getInstance();
    }

    @Override
    public Texture createTexture(PixelFormat pixelFormat, Texture.Usage usage, Texture.WrapMode wrapMode, int n, int n2) {
        return this.createTexture(pixelFormat, usage, wrapMode, n, n2, false);
    }

    @Override
    public Texture createTexture(PixelFormat pixelFormat, Texture.Usage usage, Texture.WrapMode wrapMode, int n, int n2, boolean bl) {
        long l;
        int n3;
        int n4;
        if (this.checkDisposed()) {
            return null;
        }
        if (!this.isFormatSupported(pixelFormat)) {
            throw new UnsupportedOperationException("Pixel format " + String.valueOf((Object)pixelFormat) + " not supported on this device");
        }
        if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            throw new UnsupportedOperationException("MULTI_YCbCr_420 textures require a MediaFrame");
        }
        if (PrismSettings.forcePow2) {
            n4 = MTLResourceFactory.nextPowerOfTwo(n, Integer.MAX_VALUE);
            n3 = MTLResourceFactory.nextPowerOfTwo(n2, Integer.MAX_VALUE);
        } else {
            n4 = n;
            n3 = n2;
        }
        this.checkTextureSize(n4, n3);
        int n5 = pixelFormat.getBytesPerPixelUnit();
        if (n4 >= Integer.MAX_VALUE / n3 / n5) {
            throw new RuntimeException("Illegal texture dimensions (" + n4 + "x" + n3 + ")");
        }
        MTLVramPool mTLVramPool = MTLVramPool.getInstance();
        if (!mTLVramPool.prepareForAllocation(l = mTLVramPool.estimateTextureSize(n4, n3, pixelFormat))) {
            return null;
        }
        long l2 = MTLResourceFactory.nCreateTexture(this.context.getContextHandle(), pixelFormat.ordinal(), usage.ordinal(), false, n4, n3, 0, bl);
        if (l2 == 0L) {
            return null;
        }
        MTLTextureData mTLTextureData = new MTLTextureData(this.context, l2, l);
        MTLTextureResource<MTLTextureData> mTLTextureResource = new MTLTextureResource<MTLTextureData>(mTLTextureData, true);
        return new MTLTexture<MTLTextureData>(this.getContext(), mTLTextureResource, pixelFormat, wrapMode, n4, n3, 0, 0, n4, n3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Texture createTexture(MediaFrame mediaFrame) {
        mediaFrame.holdFrame();
        try {
            Texture texture;
            int n = mediaFrame.getWidth();
            int n2 = mediaFrame.getHeight();
            int n3 = mediaFrame.getEncodedWidth();
            int n4 = mediaFrame.getEncodedHeight();
            PixelFormat pixelFormat = mediaFrame.getPixelFormat();
            this.checkTextureSize(n3, n4);
            int n5 = pixelFormat.getBytesPerPixelUnit();
            if (n3 >= Integer.MAX_VALUE / n4 / n5) {
                throw new RuntimeException("Illegal texture dimensions (" + n3 + "x" + n4 + ")");
            }
            if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
                MultiTexture multiTexture = new MultiTexture(pixelFormat, Texture.WrapMode.CLAMP_TO_EDGE, n, n2);
                for (int i = 0; i < mediaFrame.planeCount(); ++i) {
                    Texture texture2;
                    int n6 = n3;
                    int n7 = n4;
                    if (i == 2 || i == 1) {
                        n6 /= 2;
                        n7 /= 2;
                    }
                    if ((texture2 = this.createTexture(PixelFormat.BYTE_ALPHA, Texture.Usage.DYNAMIC, Texture.WrapMode.CLAMP_TO_EDGE, n6, n7)) == null) {
                        multiTexture.dispose();
                        Texture texture3 = null;
                        return texture3;
                    }
                    multiTexture.setTexture(texture2, i);
                }
                if (mediaFrame.planeCount() == 3) {
                    Texture texture4 = this.createTexture(PixelFormat.BYTE_ALPHA, Texture.Usage.DYNAMIC, Texture.WrapMode.CLAMP_TO_EDGE, n3, n4);
                    if (texture4 == null) {
                        multiTexture.dispose();
                        Texture texture5 = null;
                        return texture5;
                    }
                    byte[] byArray = new byte[n3 * n4];
                    Arrays.fill(byArray, (byte)-1);
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                    texture4.update(byteBuffer, PixelFormat.BYTE_ALPHA, 0, 0, 0, 0, n3, n4, n3, true);
                    multiTexture.setTexture(texture4, 3);
                }
                MultiTexture multiTexture2 = multiTexture;
                return multiTexture2;
            }
            Texture texture6 = texture = this.createTexture(pixelFormat, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_TO_EDGE, n3, n4);
            return texture6;
        }
        finally {
            mediaFrame.releaseFrame();
        }
    }

    @Override
    public boolean isFormatSupported(PixelFormat pixelFormat) {
        return switch (pixelFormat) {
            default -> throw new MatchException(null, null);
            case PixelFormat.BYTE_RGB, PixelFormat.BYTE_GRAY, PixelFormat.BYTE_ALPHA, PixelFormat.BYTE_BGRA_PRE, PixelFormat.BYTE_APPLE_422, PixelFormat.INT_ARGB_PRE, PixelFormat.FLOAT_XYZW -> true;
            case PixelFormat.MULTI_YCbCr_420 -> false;
        };
    }

    @Override
    public int getMaximumTextureSize() {
        return 16384;
    }

    @Override
    public int getRTTWidth(int n, Texture.WrapMode wrapMode) {
        return n;
    }

    @Override
    public int getRTTHeight(int n, Texture.WrapMode wrapMode) {
        return n;
    }

    @Override
    public RTTexture createRTTexture(int n, int n2, Texture.WrapMode wrapMode) {
        return this.createRTTexture(n, n2, wrapMode, false);
    }

    static int nextPowerOf64(int n, int n2) {
        if (n > n2) {
            return 0;
        }
        int n3 = 64;
        if (n % n3 != 0) {
            int n4 = n / n3;
            n = n3 * (n4 + 1);
        }
        return n;
    }

    @Override
    public RTTexture createRTTexture(int n, int n2, Texture.WrapMode wrapMode, boolean bl) {
        long l;
        int n3 = n;
        int n4 = n2;
        if (PrismSettings.forcePow2) {
            n3 = MTLResourceFactory.nextPowerOfTwo(n3, Integer.MAX_VALUE);
            n4 = MTLResourceFactory.nextPowerOfTwo(n4, Integer.MAX_VALUE);
        }
        this.checkTextureSize(n3, n4);
        PixelFormat pixelFormat = PixelFormat.INT_ARGB_PRE;
        int n5 = pixelFormat.getBytesPerPixelUnit();
        if (n3 >= Integer.MAX_VALUE / n4 / n5) {
            throw new RuntimeException("Illegal texture dimensions (" + n3 + "x" + n4 + ")");
        }
        MTLVramPool mTLVramPool = MTLVramPool.getInstance();
        if (!mTLVramPool.prepareForAllocation(l = mTLVramPool.estimateRTTextureSize(n3, n4, false))) {
            return null;
        }
        MTLRTTexture mTLRTTexture = MTLRTTexture.create(this.context, n3, n4, n, n2, wrapMode, bl, l);
        return mTLRTTexture;
    }

    @Override
    public boolean isCompatibleTexture(Texture texture) {
        return texture instanceof MTLTexture;
    }

    @Override
    public Presentable createPresentable(PresentableState presentableState) {
        if (this.checkDisposed()) {
            return null;
        }
        this.checkTextureSize(presentableState.getRenderWidth(), presentableState.getRenderHeight());
        return new MTLSwapChain(this.getContext(), presentableState);
    }

    @Override
    public void dispose() {
        this.context.dispose();
        super.dispose();
    }

    @Override
    public PhongMaterial createPhongMaterial() {
        if (this.checkDisposed()) {
            return null;
        }
        return MTLPhongMaterial.create(this.context);
    }

    @Override
    public MeshView createMeshView(Mesh mesh) {
        if (this.checkDisposed()) {
            return null;
        }
        return MTLMeshView.create(this.context, (MTLMesh)mesh);
    }

    @Override
    public Mesh createMesh() {
        if (this.checkDisposed()) {
            return null;
        }
        return MTLMesh.create(this.context);
    }

    static void releaseTexture(long l) {
        MTLResourceFactory.nReleaseTexture(l);
    }

    static native long nCreateTexture(long var0, int var2, int var3, boolean var4, int var5, int var6, int var7, boolean var8);

    static native void nReleaseTexture(long var0);
}

