/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media.expression;

import com.sun.javafx.css.media.ContextAwareness;
import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.MediaQueryCache;
import com.sun.javafx.css.media.MediaQueryContext;
import java.util.Objects;
import java.util.function.Function;

public final class FunctionExpression<T>
implements MediaQuery {
    private final String featureName;
    private final String featureValue;
    private final Function<MediaQueryContext, T> function;
    private final int contextAwareness;
    private final T value;

    private FunctionExpression(String string, String string2, Function<MediaQueryContext, T> function, T t, ContextAwareness ... contextAwarenessArray) {
        this.featureName = Objects.requireNonNull(string, "featureName cannot be null");
        this.featureValue = string2;
        this.function = Objects.requireNonNull(function, "function cannot be null");
        this.contextAwareness = ContextAwareness.combine(contextAwarenessArray);
        this.value = t;
    }

    public static <T> FunctionExpression<T> of(String string, String string2, Function<MediaQueryContext, T> function, T t, ContextAwareness ... contextAwarenessArray) {
        return MediaQueryCache.getCachedMediaQuery(new FunctionExpression<T>(string, string2, function, t, contextAwarenessArray));
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getFeatureValue() {
        return this.featureValue;
    }

    @Override
    public int getContextAwareness() {
        return this.contextAwareness;
    }

    @Override
    public boolean evaluate(MediaQueryContext mediaQueryContext) {
        return Objects.equals(this.function.apply(mediaQueryContext), this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof FunctionExpression)) return false;
        FunctionExpression functionExpression = (FunctionExpression)object;
        if (!functionExpression.featureName.equals(this.featureName)) return false;
        if (!Objects.equals(functionExpression.featureValue, this.featureValue)) return false;
        if (!Objects.equals(functionExpression.value, this.value)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.featureName, this.featureValue, this.value);
    }

    public String toString() {
        return "(" + (String)(this.featureValue != null ? this.featureName + ": " + this.featureValue : this.featureName) + ")";
    }
}

