/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media.expression;

import com.sun.javafx.css.media.ContextAwareness;
import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.SizeQueryType;
import com.sun.javafx.css.media.expression.EqualExpression;
import com.sun.javafx.css.media.expression.GreaterExpression;
import com.sun.javafx.css.media.expression.GreaterOrEqualExpression;
import com.sun.javafx.css.media.expression.LessExpression;
import com.sun.javafx.css.media.expression.LessOrEqualExpression;
import java.util.Objects;
import javafx.css.Size;
import javafx.css.SizeUnits;

public abstract sealed class RangeExpression
implements MediaQuery
permits EqualExpression, GreaterExpression, GreaterOrEqualExpression, LessExpression, LessOrEqualExpression {
    private final SizeQueryType featureType;
    private final Size sizeValue;
    private final double numberValue;

    RangeExpression(SizeQueryType sizeQueryType, Size size) {
        this.featureType = Objects.requireNonNull(sizeQueryType, "featureType cannot be null");
        this.sizeValue = Objects.requireNonNull(size, "sizeValue cannot be null");
        this.numberValue = size.pixels();
    }

    RangeExpression(SizeQueryType sizeQueryType, double d) {
        this.featureType = Objects.requireNonNull(sizeQueryType, "featureType cannot be null");
        this.numberValue = d;
        this.sizeValue = null;
    }

    public final SizeQueryType getFeatureType() {
        return this.featureType;
    }

    public final String getFeatureName() {
        return this.featureType.getFeatureName();
    }

    public final double getFeatureValue() {
        return this.sizeValue != null ? this.sizeValue.getValue() : this.numberValue;
    }

    public final double getValue() {
        return this.numberValue;
    }

    public final SizeUnits getUnit() {
        return this.sizeValue != null ? this.sizeValue.getUnits() : null;
    }

    @Override
    public final int getContextAwareness() {
        return ContextAwareness.VIEWPORT_SIZE.value();
    }

    public final boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RangeExpression rangeExpression = (RangeExpression)object;
        return rangeExpression.featureType == this.featureType && rangeExpression.numberValue == this.numberValue && Objects.equals(rangeExpression.sizeValue, this.sizeValue);
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.featureType, this.sizeValue, this.numberValue});
    }

    final String getFormattedValue() {
        return this.sizeValue != null ? this.sizeValue.toString() : Double.toString(this.numberValue);
    }

    public static interface Supplier {
        public RangeExpression getSizeExpression(SizeQueryType var1, Size var2);

        public RangeExpression getNumberExpression(SizeQueryType var1, double var2);
    }
}

