/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext.rtf;

import com.sun.jfx.incubator.scene.control.richtext.rtf.AttrSet;
import com.sun.jfx.incubator.scene.control.richtext.rtf.RTFAttribute;
import java.util.HashMap;
import jfx.incubator.scene.control.richtext.model.StyleAttribute;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;

class RTFAttributes {
    private static final RTFAttribute[] attributes = new RTFAttribute[]{new BooleanAttribute(0, StyleAttributeMap.ITALIC, "i"), new BooleanAttribute(0, StyleAttributeMap.BOLD, "b"), new BooleanAttribute(0, StyleAttributeMap.UNDERLINE, "ul"), new BooleanAttribute(0, StyleAttributeMap.STRIKE_THROUGH, "strike")};

    RTFAttributes() {
    }

    public static HashMap<String, RTFAttribute> attributesByKeyword() {
        HashMap<String, RTFAttribute> hashMap = new HashMap<String, RTFAttribute>(attributes.length);
        for (RTFAttribute rTFAttribute : attributes) {
            hashMap.put(rTFAttribute.rtfName(), rTFAttribute);
        }
        return hashMap;
    }

    static class BooleanAttribute
    extends RTFAttribute {
        private final boolean rtfDefault;
        private final boolean defaultValue;

        public BooleanAttribute(int n, StyleAttribute styleAttribute, String string, boolean bl, boolean bl2) {
            super(n, styleAttribute, string);
            this.defaultValue = bl;
            this.rtfDefault = bl2;
        }

        public BooleanAttribute(int n, StyleAttribute styleAttribute, String string) {
            super(n, styleAttribute, string);
            this.defaultValue = false;
            this.rtfDefault = false;
        }

        @Override
        public boolean set(AttrSet attrSet) {
            attrSet.addAttribute(this.attribute, Boolean.TRUE);
            return true;
        }

        @Override
        public boolean set(AttrSet attrSet, int n) {
            Boolean bl = n != 0;
            attrSet.addAttribute(this.attribute, bl);
            return true;
        }

        @Override
        public boolean setDefault(AttrSet attrSet) {
            if (this.defaultValue != this.rtfDefault || attrSet.getAttribute(this.attribute) != null) {
                attrSet.addAttribute(this.getStyleAttribute(), this.rtfDefault);
            }
            return true;
        }
    }

    static class NumericAttribute
    extends RTFAttribute {
        private final int rtfDefault;
        private final Number defaultValue;
        private final float scale;

        protected NumericAttribute(int n, StyleAttribute styleAttribute, String string) {
            super(n, styleAttribute, string);
            this.rtfDefault = 0;
            this.defaultValue = null;
            this.scale = 1.0f;
        }

        public NumericAttribute(int n, StyleAttribute styleAttribute, String string, int n2, int n3) {
            this(n, styleAttribute, string, n2, n3, 1.0f);
        }

        public NumericAttribute(int n, StyleAttribute styleAttribute, String string, Number number, int n2, float f) {
            super(n, styleAttribute, string);
            this.defaultValue = number;
            this.rtfDefault = n2;
            this.scale = f;
        }

        @Override
        public boolean set(AttrSet attrSet) {
            return false;
        }

        @Override
        public boolean set(AttrSet attrSet, int n) {
            Number number = this.scale == 1.0f ? (Number)n : (Number)Float.valueOf((float)n / this.scale);
            attrSet.addAttribute(this.attribute, number);
            return true;
        }

        @Override
        public boolean setDefault(AttrSet attrSet) {
            Number number = (Number)attrSet.getAttribute(this.attribute);
            if (number == null) {
                number = this.defaultValue;
            }
            if (number != null && (this.scale == 1.0f && number.intValue() == this.rtfDefault || Math.round(number.floatValue() * this.scale) == this.rtfDefault)) {
                return true;
            }
            this.set(attrSet, this.rtfDefault);
            return true;
        }
    }

    static class AssertiveAttribute
    extends RTFAttribute {
        private final Object value;

        public AssertiveAttribute(int n, StyleAttribute styleAttribute, String string) {
            super(n, styleAttribute, string);
            this.value = true;
        }

        public AssertiveAttribute(int n, StyleAttribute styleAttribute, String string, Object object) {
            super(n, styleAttribute, string);
            this.value = object;
        }

        public AssertiveAttribute(int n, StyleAttribute styleAttribute, String string, int n2) {
            super(n, styleAttribute, string);
            this.value = n2;
        }

        @Override
        public boolean set(AttrSet attrSet) {
            if (this.value == null) {
                attrSet.removeAttribute(this.attribute);
            } else {
                attrSet.addAttribute(this.attribute, this.value);
            }
            return true;
        }

        @Override
        public boolean set(AttrSet attrSet, int n) {
            return false;
        }

        @Override
        public boolean setDefault(AttrSet attrSet) {
            attrSet.removeAttribute(this.attribute);
            return true;
        }
    }
}

