/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.media;

import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.MediaQueryContext;
import com.sun.javafx.css.media.expression.RangeExpression;
import com.sun.javafx.css.parser.CssParserHelper;
import com.sun.javafx.css.parser.Token;
import javafx.css.Size;

public enum SizeQueryType {
    WIDTH("width", SizeQueryType::sizeExpression, MediaQueryContext::getWidth),
    HEIGHT("height", SizeQueryType::sizeExpression, MediaQueryContext::getHeight),
    ASPECT_RATIO("aspect-ratio", SizeQueryType::numberExpression, mediaQueryContext -> mediaQueryContext.getWidth() / mediaQueryContext.getHeight());

    private final String featureName;
    private final QueryEvaluator evaluator;
    private final QuerySupplier supplier;
    private static final SizeQueryType[] VALUES;

    private SizeQueryType(String string2, QuerySupplier querySupplier, QueryEvaluator queryEvaluator) {
        this.featureName = string2;
        this.evaluator = queryEvaluator;
        this.supplier = querySupplier;
    }

    public static SizeQueryType of(String string) {
        for (SizeQueryType sizeQueryType : VALUES) {
            if (!sizeQueryType.featureName.equals(string)) continue;
            return sizeQueryType;
        }
        throw new IllegalArgumentException(String.format("Unknown media feature <%s>", string));
    }

    private static MediaQuery numberExpression(SizeQueryType sizeQueryType, Token token, RangeExpression.Supplier supplier) {
        try {
            if (token.getType() != 13) {
                throw SizeQueryType.invalidValue(sizeQueryType.getFeatureName(), token.getText());
            }
            return supplier.getNumberExpression(sizeQueryType, Double.parseDouble(token.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            throw SizeQueryType.invalidValue(sizeQueryType.getFeatureName(), token.getText());
        }
    }

    private static MediaQuery sizeExpression(SizeQueryType sizeQueryType, Token token, RangeExpression.Supplier supplier) {
        try {
            Size size = CssParserHelper.parseSize(token);
            if (size == null) {
                throw SizeQueryType.invalidValue(sizeQueryType.getFeatureName(), token.getText());
            }
            return supplier.getSizeExpression(sizeQueryType, size);
        }
        catch (NumberFormatException numberFormatException) {
            throw SizeQueryType.invalidValue(sizeQueryType.getFeatureName(), token.getText());
        }
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public MediaQuery getQueryExpression(Token token, RangeExpression.Supplier supplier) {
        return this.supplier.get(this, token, supplier);
    }

    public double evaluate(MediaQueryContext mediaQueryContext) {
        return this.evaluator.get(mediaQueryContext);
    }

    private static RuntimeException invalidValue(String string, String string2) {
        return new IllegalArgumentException(String.format("Invalid value <%s> for media feature <%s>", string2, string));
    }

    static {
        VALUES = SizeQueryType.values();
    }

    private static interface QueryEvaluator {
        public double get(MediaQueryContext var1);
    }

    private static interface QuerySupplier {
        public MediaQuery get(SizeQueryType var1, Token var2, RangeExpression.Supplier var3);
    }
}

