/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.prism.impl.BaseMesh;
import com.sun.prism.impl.Disposer;
import com.sun.prism.mtl.MTLContext;

class MTLMesh
extends BaseMesh {
    static int count = 0;
    private final MTLContext context;
    private final long nativeHandle;

    private MTLMesh(MTLContext mTLContext, long l, Disposer.Record record) {
        super(record);
        this.context = mTLContext;
        this.nativeHandle = l;
        ++count;
    }

    static MTLMesh create(MTLContext mTLContext) {
        long l = mTLContext.createMTLMesh();
        return new MTLMesh(mTLContext, l, new MTLMeshDisposerRecord(mTLContext, l));
    }

    long getNativeHandle() {
        return this.nativeHandle;
    }

    @Override
    public boolean isValid() {
        return !this.context.isDisposed();
    }

    @Override
    public void dispose() {
        this.disposerRecord.dispose();
        --count;
    }

    @Override
    public int getCount() {
        return count;
    }

    @Override
    public boolean buildNativeGeometry(float[] fArray, int n, int[] nArray, int n2) {
        return this.context.buildNativeGeometry(this.nativeHandle, fArray, n, nArray, n2);
    }

    @Override
    public boolean buildNativeGeometry(float[] fArray, int n, short[] sArray, int n2) {
        return this.context.buildNativeGeometry(this.nativeHandle, fArray, n, sArray, n2);
    }

    private static class MTLMeshDisposerRecord
    implements Disposer.Record {
        private final MTLContext context;
        private long nativeHandle;

        MTLMeshDisposerRecord(MTLContext mTLContext, long l) {
            this.context = mTLContext;
            this.nativeHandle = l;
        }

        void traceDispose() {
        }

        @Override
        public void dispose() {
            if (this.nativeHandle != 0L && !this.context.isDisposed()) {
                this.traceDispose();
                this.context.releaseMTLMesh(this.nativeHandle);
                this.nativeHandle = 0L;
            }
        }
    }
}

