/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.control.ConstrainedColumnResize;
import java.util.BitSet;
import java.util.List;
import javafx.scene.Scene;
import javafx.scene.control.ResizeFeaturesBase;
import javafx.scene.control.TableColumnBase;
import javafx.scene.layout.Region;
import javafx.stage.Window;

public class ResizeHelper {
    private static final int SMALL_DELTA = 32;
    private static final double EPSILON = 1.0E-6;
    private final ResizeFeaturesBase rf;
    private final double target;
    private final List<? extends TableColumnBase<?, ?>> columns;
    private final int count;
    private final ConstrainedColumnResize.ResizeMode mode;
    private final double[] size;
    private final double[] min;
    private final double[] pref;
    private final double[] max;
    private final BitSet skip;
    private final Region snap;

    public ResizeHelper(ResizeFeaturesBase resizeFeaturesBase, double d, List<? extends TableColumnBase<?, ?>> list, ConstrainedColumnResize.ResizeMode resizeMode) {
        this.rf = resizeFeaturesBase;
        this.snap = resizeFeaturesBase.getTableControl().isSnapToPixel() ? resizeFeaturesBase.getTableControl() : null;
        this.columns = list;
        this.mode = resizeMode;
        this.target = this.snapRound(d);
        this.count = list.size();
        this.size = new double[this.count];
        this.min = new double[this.count];
        this.pref = new double[this.count];
        this.max = new double[this.count];
        this.skip = new BitSet(this.count);
        for (int i = 0; i < this.count; ++i) {
            TableColumnBase<?, ?> tableColumnBase = list.get(i);
            this.size[i] = this.snapCeil(tableColumnBase.getWidth());
            if (tableColumnBase.isResizable()) {
                double d2 = this.snapCeil(tableColumnBase.getMinWidth());
                double d3 = this.snapCeil(tableColumnBase.getMaxWidth());
                this.min[i] = d2;
                this.max[i] = d3;
                this.pref[i] = ResizeHelper.clip(this.snapCeil(tableColumnBase.getPrefWidth()), d2, d3);
                if (d2 != d3) continue;
                this.skip.set(i, true);
                continue;
            }
            this.skip.set(i, true);
        }
    }

    public void resizeToContentWidth() {
        if (this.skip.cardinality() == this.count) {
            return;
        }
        double d = this.sum(this.size);
        double d2 = this.sum(this.pref);
        double d3 = this.target - d;
        if (d3 < 0.0) {
            if (this.target < d2) {
                this.distribute(d3, this.min);
            } else {
                this.distribute(d3, this.pref);
            }
        } else if (d3 > 0.0) {
            if (this.target > d2) {
                this.distribute(d3, this.max);
            } else {
                this.distribute(d3, this.pref);
            }
        }
    }

    private void distribute(double d, double[] dArray) {
        if (Math.abs(d) > 32.0) {
            this.distributeLargeDelta(d, dArray);
        } else {
            this.distributeSmallDelta(d, dArray);
        }
    }

    private void distributeLargeDelta(double d, double[] dArray) {
        boolean bl = d > 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.count; ++i) {
            if (this.skip.get(i)) continue;
            d2 += this.avail(bl, dArray, i);
        }
        if (ResizeHelper.isZero(d2)) {
            return;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.count; ++i) {
            double d5;
            if (this.skip.get(i)) continue;
            double d6 = d * this.avail(bl, dArray, i) / d2;
            double d7 = d3 + this.size[i] + d6;
            this.size[i] = d5 = this.snapRound(d7) - d4;
            d3 = d7;
            d4 += d5;
        }
    }

    private void distributeSmallDelta(double d) {
        double[] dArray = d < 0.0 ? this.min : this.max;
        this.distributeSmallDelta(d, dArray);
    }

    private void distributeSmallDelta(double d, double[] dArray) {
        double d2 = 1.0 / this.snapScale();
        double d3 = d2 / 2.0;
        if (d < 0.0) {
            while (d < -d3) {
                double d4 = -d2;
                if (this.smallShrink(d4, dArray)) {
                    return;
                }
                d -= d4;
            }
        } else {
            while (d > d3) {
                double d5 = d2;
                if (this.smallGrow(d5, dArray)) {
                    return;
                }
                d -= d5;
            }
        }
    }

    private boolean smallShrink(double d, double[] dArray) {
        double d2 = Double.NEGATIVE_INFINITY;
        int n = -1;
        for (int i = 0; i < this.count; ++i) {
            double d3;
            if (this.skip.get(i) || !((d3 = this.size[i] - dArray[i]) > d2)) continue;
            d2 = d3;
            n = i;
        }
        if (n < 0) {
            return true;
        }
        int n2 = n;
        this.size[n2] = this.size[n2] + d;
        return false;
    }

    private boolean smallGrow(double d, double[] dArray) {
        double d2 = Double.NEGATIVE_INFINITY;
        int n = -1;
        for (int i = 0; i < this.count; ++i) {
            double d3;
            if (this.skip.get(i) || !((d3 = dArray[i] - this.size[i]) > d2)) continue;
            d2 = d3;
            n = i;
        }
        if (n < 0) {
            return true;
        }
        int n2 = n;
        this.size[n2] = this.size[n2] + d;
        return false;
    }

    private double avail(boolean bl, double[] dArray, int n) {
        double d = dArray[n];
        double d2 = this.size[n];
        if (bl ? d < d2 : d > d2) {
            return 0.0;
        }
        return d - d2;
    }

    public boolean applySizes() {
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            TableColumnBase<?, ?> tableColumnBase = this.columns.get(i);
            double d2 = this.size[i];
            if (tableColumnBase.isResizable()) {
                this.rf.setColumnWidth(tableColumnBase, d2);
            }
            d += tableColumnBase.getWidth();
        }
        return d > this.target;
    }

    private static double clip(double d, double d2, double d3) {
        if (d < d2) {
            return d2;
        }
        if (d > d3) {
            return d3;
        }
        return d;
    }

    public boolean resizeColumn(TableColumnBase<?, ?> tableColumnBase) {
        boolean bl;
        double d = this.rf.getDelta();
        TableColumnBase tableColumnBase2 = tableColumnBase;
        while (tableColumnBase2.getColumns().size() > 0) {
            tableColumnBase2 = (TableColumnBase)tableColumnBase2.getColumns().get(tableColumnBase2.getColumns().size() - 1);
        }
        if (!tableColumnBase2.isResizable()) {
            return false;
        }
        int n = this.columns.indexOf(tableColumnBase2);
        double d2 = this.getAllowedDelta(n, bl = d > 0.0);
        if (ResizeHelper.isZero(d2)) {
            return false;
        }
        int n2 = this.markOppositeColumns(n);
        if (n2 == 0) {
            return false;
        }
        double d3 = this.computeAllowedDelta(!bl);
        if (ResizeHelper.isZero(d3)) {
            return false;
        }
        d2 = this.snapRound(Math.min(Math.abs(d), Math.min(d2, d3)));
        if (!bl) {
            d2 = -d2;
        }
        if (this.isCornerCase(d2, n)) {
            return false;
        }
        return this.distributeDelta(n, d2);
    }

    private boolean isCornerCase(double d, int n) {
        int n2;
        boolean bl;
        boolean bl2 = bl = n == this.count - 2;
        return bl && d > 0.0 && this.size[n2 = this.count - 1] <= this.min[n2];
    }

    private double getAllowedDelta(int n, boolean bl) {
        if (bl) {
            return Math.abs(this.max[n] - this.size[n]);
        }
        return Math.abs(this.min[n] - this.size[n]);
    }

    private int markOppositeColumns(int n) {
        switch (this.mode) {
            case AUTO_RESIZE_NEXT_COLUMN: {
                this.setSkip(0, n + 1);
                this.setSkip(n + 2, this.columns.size());
                break;
            }
            case AUTO_RESIZE_FLEX_HEAD: 
            case AUTO_RESIZE_FLEX_TAIL: 
            case AUTO_RESIZE_SUBSEQUENT_COLUMNS: {
                this.setSkip(0, n + 1);
                break;
            }
            case AUTO_RESIZE_LAST_COLUMN: {
                this.setSkip(0, Math.max(n + 1, this.columns.size() - 1));
                break;
            }
            default: {
                this.setSkip(n, n + 1);
            }
        }
        return this.count - this.skip.cardinality();
    }

    private void setSkip(int n, int n2) {
        if (n < 0) {
            n = 0;
        } else if (n >= this.count) {
            return;
        }
        int n3 = Math.min(this.count, n2);
        if (n < n3) {
            this.skip.set(n, n3);
        }
    }

    private double computeAllowedDelta(boolean bl) {
        double d = 0.0;
        int n = 0;
        while ((n = this.skip.nextClearBit(n)) < this.count) {
            d = bl ? (d += this.max[n] - this.size[n]) : (d += this.size[n] - this.min[n]);
            ++n;
        }
        return d;
    }

    private boolean distributeDelta(int n, double d) {
        int n2 = this.count - this.skip.cardinality();
        switch (n2) {
            case 0: {
                return false;
            }
            case 1: {
                int n3 = this.skip.nextClearBit(0);
                int n4 = n;
                this.size[n4] = this.size[n4] + d;
                int n5 = n3;
                this.size[n5] = this.size[n5] - d;
                return true;
            }
        }
        int n6 = n;
        this.size[n6] = this.size[n6] + d;
        double d2 = switch (this.mode) {
            case ConstrainedColumnResize.ResizeMode.AUTO_RESIZE_FLEX_HEAD -> this.distributeDeltaFlexHead(-d);
            case ConstrainedColumnResize.ResizeMode.AUTO_RESIZE_FLEX_TAIL -> this.distributeDeltaFlexTail(-d);
            default -> {
                this.distributeDeltaRemainingColumns(-d);
                yield 0.0;
            }
        };
        int n7 = n;
        this.size[n7] = this.size[n7] + d2;
        return true;
    }

    private void distributeDeltaRemainingColumns(double d) {
        double[] dArray = d < 0.0 ? this.min : this.max;
        this.distribute(d, dArray);
    }

    private double distributeDeltaFlexHead(double d) {
        int n;
        if (d < 0.0) {
            for (n = 0; !(n >= this.count || !this.skip.get(n) && this.size[n] > this.pref[n] && ResizeHelper.isZero(d = this.resize(n, d))); ++n) {
            }
        } else {
            for (n = 0; !(n >= this.count || !this.skip.get(n) && this.size[n] < this.pref[n] && ResizeHelper.isZero(d = this.resize(n, d))); ++n) {
            }
        }
        for (n = 0; n < this.count && (this.skip.get(n) || !ResizeHelper.isZero(d = this.resize(n, d))); ++n) {
        }
        return d;
    }

    private double distributeDeltaFlexTail(double d) {
        int n;
        if (d < 0.0) {
            for (n = this.count - 1; !(n < 0 || !this.skip.get(n) && this.size[n] > this.pref[n] && ResizeHelper.isZero(d = this.resize(n, d))); --n) {
            }
        } else {
            for (n = this.count - 1; !(n < 0 || !this.skip.get(n) && this.size[n] < this.pref[n] && ResizeHelper.isZero(d = this.resize(n, d))); --n) {
            }
        }
        for (n = this.count - 1; n >= 0 && (this.skip.get(n) || !ResizeHelper.isZero(d = this.resize(n, d))); --n) {
        }
        return d;
    }

    private double resize(int n, double d) {
        double d2 = this.size[n] + d;
        if (d2 < this.min[n]) {
            d = d2 - this.min[n];
            d2 = this.min[n];
        } else if (d2 > this.max[n]) {
            d = d2 - this.max[n];
            d2 = this.max[n];
        } else {
            d = 0.0;
        }
        this.size[n] = d2;
        return d;
    }

    private double sumSizes() {
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            d += this.size[i];
        }
        return d;
    }

    private double sum(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            d += dArray[i];
        }
        return d;
    }

    private static boolean isZero(double d) {
        return Math.abs(d) < 1.0E-6;
    }

    private double snapCeil(double d) {
        if (this.snap != null) {
            return this.snap.snapSizeX(d);
        }
        return d;
    }

    private double snapRound(double d) {
        if (this.snap != null) {
            return this.snap.snapPositionX(d);
        }
        return d;
    }

    private double snapScale() {
        Window window;
        Scene scene;
        if (this.snap != null && (scene = this.snap.getScene()) != null && (window = scene.getWindow()) != null) {
            return window.getRenderScaleX();
        }
        return 1.0;
    }
}

