/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import java.util.Objects;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListPropertyBase;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class ReadOnlyListWrapper<E>
extends SimpleListProperty<E> {
    private ReadOnlyPropertyImpl readOnlyProperty;

    public ReadOnlyListWrapper() {
    }

    public ReadOnlyListWrapper(ObservableList<E> observableList) {
        super(observableList);
    }

    public ReadOnlyListWrapper(Object object, String string) {
        super(object, string);
    }

    public ReadOnlyListWrapper(Object object, String string, ObservableList<E> observableList) {
        super(object, string, observableList);
    }

    public ReadOnlyListProperty<E> getReadOnlyProperty() {
        if (this.readOnlyProperty == null) {
            this.readOnlyProperty = new ReadOnlyPropertyImpl(this);
        }
        return this.readOnlyProperty;
    }

    @Override
    protected void fireValueChangedEvent() {
        super.fireValueChangedEvent();
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.fireValueChangedEvent();
        }
    }

    @Override
    protected void fireValueChangedEvent(ListChangeListener.Change<? extends E> change) {
        super.fireValueChangedEvent(change);
        if (this.readOnlyProperty != null) {
            change.reset();
            this.readOnlyProperty.fireValueChangedEvent(change);
        }
    }

    private class ReadOnlyPropertyImpl
    extends ReadOnlyListPropertyBase<E> {
        final /* synthetic */ ReadOnlyListWrapper this$0;

        private ReadOnlyPropertyImpl(ReadOnlyListWrapper readOnlyListWrapper) {
            ReadOnlyListWrapper readOnlyListWrapper2 = readOnlyListWrapper;
            Objects.requireNonNull(readOnlyListWrapper2);
            this.this$0 = readOnlyListWrapper2;
        }

        @Override
        public ObservableList<E> get() {
            return this.this$0.get();
        }

        @Override
        public Object getBean() {
            return this.this$0.getBean();
        }

        @Override
        public String getName() {
            return this.this$0.getName();
        }

        @Override
        public ReadOnlyIntegerProperty sizeProperty() {
            return this.this$0.sizeProperty();
        }

        @Override
        public ReadOnlyBooleanProperty emptyProperty() {
            return this.this$0.emptyProperty();
        }
    }
}

