/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext;

import com.sun.jfx.incubator.scene.control.input.InputMapHelper;
import com.sun.jfx.incubator.scene.control.richtext.CssStyles;
import com.sun.jfx.incubator.scene.control.richtext.Params;
import com.sun.jfx.incubator.scene.control.richtext.RTAccessibilityHelper;
import com.sun.jfx.incubator.scene.control.richtext.RichTextAreaHelper;
import com.sun.jfx.incubator.scene.control.richtext.RichTextAreaSkinHelper;
import com.sun.jfx.incubator.scene.control.richtext.StringBuilderStyledOutput;
import com.sun.jfx.incubator.scene.control.richtext.VFlow;
import com.sun.jfx.incubator.scene.control.richtext.util.RichUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.DurationConverter;
import javafx.css.converter.InsetsConverter;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point2D;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Control;
import javafx.scene.input.DataFormat;
import javafx.util.Duration;
import jfx.incubator.scene.control.input.FunctionTag;
import jfx.incubator.scene.control.input.InputMap;
import jfx.incubator.scene.control.richtext.LineEnding;
import jfx.incubator.scene.control.richtext.SelectionModel;
import jfx.incubator.scene.control.richtext.SelectionSegment;
import jfx.incubator.scene.control.richtext.SideDecorator;
import jfx.incubator.scene.control.richtext.SingleSelectionModel;
import jfx.incubator.scene.control.richtext.StyleAttributeHandler;
import jfx.incubator.scene.control.richtext.StyleHandlerRegistry;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.RichTextModel;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledInput;
import jfx.incubator.scene.control.richtext.model.StyledTextModel;
import jfx.incubator.scene.control.richtext.skin.RichTextAreaSkin;

public class RichTextArea
extends Control {
    private SimpleObjectProperty<StyledTextModel> model;
    private final SelectionModel selectionModel = new SingleSelectionModel();
    private SimpleBooleanProperty editableProperty;
    private SimpleObjectProperty<StyleAttributeMap> insertStyles;
    private SimpleObjectProperty<SideDecorator> leftDecorator;
    private SimpleObjectProperty<SideDecorator> rightDecorator;
    private ReadOnlyBooleanWrapper undoable;
    private ReadOnlyBooleanWrapper redoable;
    private SimpleStyleableObjectProperty<Duration> caretBlinkPeriod;
    private SimpleStyleableObjectProperty<Insets> contentPadding;
    private StyleableBooleanProperty displayCaret;
    private StyleableBooleanProperty highlightCurrentParagraph;
    private StyleableBooleanProperty useContentHeight;
    private StyleableBooleanProperty useContentWidth;
    private StyleableBooleanProperty wrapText;
    private RTAccessibilityHelper accessibilityHelper;
    private final InputMap inputMap = new InputMap((Control)this);
    protected static final StyleHandlerRegistry styleHandlerRegistry = RichTextArea.initStyleHandlerRegistry();

    public RichTextArea() {
        this(new RichTextModel());
    }

    public RichTextArea(StyledTextModel styledTextModel) {
        this.setFocusTraversable(true);
        this.getStyleClass().add((Object)"rich-text-area");
        this.setAccessibleRole(AccessibleRole.TEXT_AREA);
        this.setAccessibleRoleDescription("Rich Text Area");
        this.selectionModel.selectionProperty().addListener((observableValue, selectionSegment, selectionSegment2) -> {
            TextPos textPos;
            TextPos textPos2 = selectionSegment == null ? null : selectionSegment.getMin();
            TextPos textPos3 = selectionSegment == null ? null : selectionSegment.getMax();
            TextPos textPos4 = selectionSegment2 == null ? null : selectionSegment2.getMin();
            TextPos textPos5 = textPos = selectionSegment2 == null ? null : selectionSegment2.getMax();
            if (this.accessibilityHelper != null && this.accessibilityHelper.handleSelectionChange((SelectionSegment)selectionSegment2)) {
                this.notifyAccessibleAttributeChanged(AccessibleAttribute.TEXT);
            }
            if (!Objects.equals(textPos2, textPos4)) {
                this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_START);
            }
            if (!Objects.equals(textPos3, textPos)) {
                this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_END);
            }
        });
        this.setModel(styledTextModel);
    }

    public final ReadOnlyProperty<TextPos> anchorPositionProperty() {
        return this.selectionModel.anchorPositionProperty();
    }

    public final TextPos getAnchorPosition() {
        return (TextPos)this.anchorPositionProperty().getValue();
    }

    public final ObjectProperty<Duration> caretBlinkPeriodProperty() {
        if (this.caretBlinkPeriod == null) {
            this.caretBlinkPeriod = new SimpleStyleableObjectProperty<Duration>(this, StyleableProperties.CARET_BLINK_PERIOD, (Object)this, "caretBlinkPeriod", Params.DEFAULT_CARET_BLINK_PERIOD){
                private Duration old;
                {
                    Objects.requireNonNull(richTextArea);
                    super(cssMetaData, object, string, (Object)duration);
                }

                public void invalidated() {
                    Duration duration = (Duration)this.get();
                    if (duration == null) {
                        this.set(this.old);
                        throw new NullPointerException("cannot set caretBlinkPeriodProperty to null");
                    }
                    this.old = duration;
                }
            };
        }
        return this.caretBlinkPeriod;
    }

    public final void setCaretBlinkPeriod(Duration duration) {
        this.caretBlinkPeriodProperty().set((Object)duration);
    }

    public final Duration getCaretBlinkPeriod() {
        return this.caretBlinkPeriod == null ? Params.DEFAULT_CARET_BLINK_PERIOD : (Duration)this.caretBlinkPeriod.get();
    }

    public final ReadOnlyProperty<TextPos> caretPositionProperty() {
        return this.selectionModel.caretPositionProperty();
    }

    public final TextPos getCaretPosition() {
        return (TextPos)this.caretPositionProperty().getValue();
    }

    public final ObjectProperty<Insets> contentPaddingProperty() {
        if (this.contentPadding == null) {
            this.contentPadding = new SimpleStyleableObjectProperty(StyleableProperties.CONTENT_PADDING, (Object)this, "contentPadding");
        }
        return this.contentPadding;
    }

    public final void setContentPadding(Insets insets) {
        this.contentPaddingProperty().set((Object)insets);
    }

    public final Insets getContentPadding() {
        return this.contentPadding == null ? null : (Insets)this.contentPadding.get();
    }

    public final BooleanProperty displayCaretProperty() {
        if (this.displayCaret == null) {
            this.displayCaret = new StyleableBooleanProperty(this, true){
                final /* synthetic */ RichTextArea this$0;
                {
                    RichTextArea richTextArea2 = richTextArea;
                    Objects.requireNonNull(richTextArea2);
                    this.this$0 = richTextArea2;
                    super(bl);
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "displayCaret";
                }

                public CssMetaData<RichTextArea, Boolean> getCssMetaData() {
                    return StyleableProperties.DISPLAY_CARET;
                }
            };
        }
        return this.displayCaret;
    }

    public final void setDisplayCaret(boolean bl) {
        this.displayCaretProperty().set(bl);
    }

    public final boolean isDisplayCaret() {
        return this.displayCaret == null ? true : this.displayCaret.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editableProperty == null) {
            this.editableProperty = new SimpleBooleanProperty((Object)this, "editable", true);
        }
        return this.editableProperty;
    }

    public final boolean isEditable() {
        if (this.editableProperty == null) {
            return true;
        }
        return this.editableProperty().get();
    }

    public final void setEditable(boolean bl) {
        this.editableProperty().set(bl);
    }

    public final BooleanProperty highlightCurrentParagraphProperty() {
        if (this.highlightCurrentParagraph == null) {
            this.highlightCurrentParagraph = new StyleableBooleanProperty(this, false){
                final /* synthetic */ RichTextArea this$0;
                {
                    RichTextArea richTextArea2 = richTextArea;
                    Objects.requireNonNull(richTextArea2);
                    this.this$0 = richTextArea2;
                    super(bl);
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "highlightCurrentParagraph";
                }

                public CssMetaData<RichTextArea, Boolean> getCssMetaData() {
                    return StyleableProperties.HIGHLIGHT_CURRENT_PARAGRAPH;
                }
            };
        }
        return this.highlightCurrentParagraph;
    }

    public final boolean isHighlightCurrentParagraph() {
        return this.highlightCurrentParagraph == null ? false : this.highlightCurrentParagraph.get();
    }

    public final void setHighlightCurrentParagraph(boolean bl) {
        this.highlightCurrentParagraphProperty().set(bl);
    }

    public final ObjectProperty<StyleAttributeMap> insertStylesProperty() {
        if (this.insertStyles == null) {
            this.insertStyles = new SimpleObjectProperty((Object)this, "insertStyles");
        }
        return this.insertStyles;
    }

    public final StyleAttributeMap getInsertStyles() {
        if (this.insertStyles == null) {
            return null;
        }
        return (StyleAttributeMap)this.insertStyles.get();
    }

    public final void setInsertStyles(StyleAttributeMap styleAttributeMap) {
        this.insertStylesProperty().set((Object)styleAttributeMap);
    }

    public final ObjectProperty<SideDecorator> leftDecoratorProperty() {
        if (this.leftDecorator == null) {
            this.leftDecorator = new SimpleObjectProperty((Object)this, "leftDecorator");
        }
        return this.leftDecorator;
    }

    public final SideDecorator getLeftDecorator() {
        if (this.leftDecorator == null) {
            return null;
        }
        return (SideDecorator)this.leftDecorator.get();
    }

    public final void setLeftDecorator(SideDecorator sideDecorator) {
        this.leftDecoratorProperty().set((Object)sideDecorator);
    }

    public final LineEnding getLineEnding() {
        StyledTextModel styledTextModel = this.getModel();
        return styledTextModel == null ? LineEnding.system() : styledTextModel.getLineEnding();
    }

    public final void setLineEnding(LineEnding lineEnding) {
        Objects.requireNonNull(lineEnding, "line ending must not be null");
        StyledTextModel styledTextModel = this.getModel();
        if (styledTextModel != null) {
            styledTextModel.setLineEnding(lineEnding);
        }
    }

    public final ObjectProperty<StyledTextModel> modelProperty() {
        if (this.model == null) {
            this.model = new SimpleObjectProperty<StyledTextModel>(this, (Object)this, "model"){
                private final StyledTextModel.Listener li;
                private StyledTextModel old;
                final /* synthetic */ RichTextArea this$0;
                {
                    RichTextArea richTextArea2 = richTextArea;
                    Objects.requireNonNull(richTextArea2);
                    this.this$0 = richTextArea2;
                    super(object, string);
                    this.li = contentChange -> {
                        if (contentChange.isEdit() && this.this$0.accessibilityHelper != null && this.this$0.accessibilityHelper.handleTextUpdate(contentChange.getStart(), contentChange.getEnd())) {
                            this.this$0.notifyAccessibleAttributeChanged(AccessibleAttribute.TEXT);
                        }
                    };
                }

                protected void invalidated() {
                    StyledTextModel styledTextModel = (StyledTextModel)this.get();
                    try {
                        this.this$0.validateModel(styledTextModel);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (this.isBound()) {
                            this.unbind();
                        }
                        this.set(this.old);
                        throw illegalArgumentException;
                    }
                    if (this.this$0.undoable != null) {
                        this.this$0.undoable.unbind();
                        if (styledTextModel != null) {
                            this.this$0.undoable.bind((ObservableValue)styledTextModel.undoableProperty());
                        }
                    }
                    if (this.this$0.redoable != null) {
                        this.this$0.redoable.unbind();
                        if (styledTextModel != null) {
                            this.this$0.redoable.bind((ObservableValue)styledTextModel.redoableProperty());
                        }
                    }
                    if (this.old != null) {
                        this.old.removeListener(this.li);
                    }
                    if (styledTextModel != null) {
                        styledTextModel.addListener(this.li);
                    }
                    this.old = styledTextModel;
                    if (this.this$0.accessibilityHelper != null) {
                        this.this$0.accessibilityHelper.handleModelChange();
                    }
                    this.this$0.selectionModel.clear();
                    this.this$0.notifyAccessibleAttributeChanged(AccessibleAttribute.TEXT);
                }
            };
        }
        return this.model;
    }

    public final void setModel(StyledTextModel styledTextModel) {
        this.modelProperty().set((Object)styledTextModel);
    }

    public final StyledTextModel getModel() {
        return this.model == null ? null : (StyledTextModel)this.model.get();
    }

    protected void validateModel(StyledTextModel styledTextModel) {
    }

    public final ReadOnlyBooleanProperty redoableProperty() {
        if (this.redoable == null) {
            this.redoable = new ReadOnlyBooleanWrapper((Object)this, "redoable", false);
            StyledTextModel styledTextModel = this.getModel();
            if (styledTextModel != null) {
                this.redoable.bind((ObservableValue)styledTextModel.redoableProperty());
            }
        }
        return this.redoable.getReadOnlyProperty();
    }

    public final boolean isRedoable() {
        return this.redoableProperty().get();
    }

    public final ObjectProperty<SideDecorator> rightDecoratorProperty() {
        if (this.rightDecorator == null) {
            this.rightDecorator = new SimpleObjectProperty((Object)this, "rightDecorator");
        }
        return this.rightDecorator;
    }

    public final SideDecorator getRightDecorator() {
        if (this.rightDecorator == null) {
            return null;
        }
        return (SideDecorator)this.rightDecorator.get();
    }

    public final void setRightDecorator(SideDecorator sideDecorator) {
        this.rightDecoratorProperty().set((Object)sideDecorator);
    }

    public final ReadOnlyProperty<SelectionSegment> selectionProperty() {
        return this.selectionModel.selectionProperty();
    }

    public final SelectionSegment getSelection() {
        return this.selectionModel.getSelection();
    }

    public final ReadOnlyBooleanProperty undoableProperty() {
        if (this.undoable == null) {
            this.undoable = new ReadOnlyBooleanWrapper((Object)this, "undoable", false);
            StyledTextModel styledTextModel = this.getModel();
            if (styledTextModel != null) {
                this.undoable.bind((ObservableValue)styledTextModel.undoableProperty());
            }
        }
        return this.undoable.getReadOnlyProperty();
    }

    public final boolean isUndoable() {
        return this.undoableProperty().get();
    }

    public final boolean isUndoRedoEnabled() {
        StyledTextModel styledTextModel = this.getModel();
        return styledTextModel == null ? false : styledTextModel.isUndoRedoEnabled();
    }

    public final void setUndoRedoEnabled(boolean bl) {
        StyledTextModel styledTextModel = this.getModel();
        if (styledTextModel != null) {
            styledTextModel.setUndoRedoEnabled(bl);
        }
    }

    public final BooleanProperty useContentHeightProperty() {
        if (this.useContentHeight == null) {
            this.useContentHeight = new StyleableBooleanProperty(this, false){
                final /* synthetic */ RichTextArea this$0;
                {
                    RichTextArea richTextArea2 = richTextArea;
                    Objects.requireNonNull(richTextArea2);
                    this.this$0 = richTextArea2;
                    super(bl);
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "useContentHeight";
                }

                public CssMetaData<RichTextArea, Boolean> getCssMetaData() {
                    return StyleableProperties.USE_CONTENT_HEIGHT;
                }
            };
        }
        return this.useContentHeight;
    }

    public final boolean isUseContentHeight() {
        return this.useContentHeight == null ? false : this.useContentHeight.get();
    }

    public final void setUseContentHeight(boolean bl) {
        this.useContentHeightProperty().set(bl);
    }

    public final BooleanProperty useContentWidthProperty() {
        if (this.useContentWidth == null) {
            this.useContentWidth = new StyleableBooleanProperty(this, false){
                final /* synthetic */ RichTextArea this$0;
                {
                    RichTextArea richTextArea2 = richTextArea;
                    Objects.requireNonNull(richTextArea2);
                    this.this$0 = richTextArea2;
                    super(bl);
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "useContentWidth";
                }

                public CssMetaData<RichTextArea, Boolean> getCssMetaData() {
                    return StyleableProperties.USE_CONTENT_WIDTH;
                }
            };
        }
        return this.useContentWidth;
    }

    public final boolean isUseContentWidth() {
        return this.useContentWidth == null ? false : this.useContentWidth.get();
    }

    public final void setUseContentWidth(boolean bl) {
        this.useContentWidthProperty().set(bl);
    }

    public final BooleanProperty wrapTextProperty() {
        if (this.wrapText == null) {
            this.wrapText = new StyleableBooleanProperty(this, false){
                final /* synthetic */ RichTextArea this$0;
                {
                    RichTextArea richTextArea2 = richTextArea;
                    Objects.requireNonNull(richTextArea2);
                    this.this$0 = richTextArea2;
                    super(bl);
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "wrapText";
                }

                public CssMetaData<RichTextArea, Boolean> getCssMetaData() {
                    return StyleableProperties.WRAP_TEXT;
                }
            };
        }
        return this.wrapText;
    }

    public final boolean isWrapText() {
        return this.wrapText == null ? false : this.wrapText.getValue();
    }

    public final void setWrapText(boolean bl) {
        this.wrapTextProperty().setValue(Boolean.valueOf(bl));
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return RichTextArea.getClassCssMetaData();
    }

    public final TextPos appendText(String string, StyleAttributeMap styleAttributeMap) {
        TextPos textPos = this.getDocumentEnd();
        return this.insertText(textPos, string, styleAttributeMap);
    }

    public final TextPos appendText(String string) {
        return this.appendText(string, StyleAttributeMap.EMPTY);
    }

    public final TextPos appendText(StyledInput styledInput) {
        TextPos textPos = this.getDocumentEnd();
        return this.insertText(textPos, styledInput);
    }

    public void applyStyle(TextPos textPos, TextPos textPos2, StyleAttributeMap styleAttributeMap) {
        StyledTextModel styledTextModel = this.getModel();
        styledTextModel.applyStyle(textPos, textPos2, styleAttributeMap, true);
    }

    public void backspace() {
        this.execute(Tag.BACKSPACE);
    }

    public final void clear() {
        TextPos textPos = this.getDocumentEnd();
        this.replaceText(TextPos.ZERO, textPos, StyledInput.EMPTY);
    }

    public final void clearSelection() {
        this.selectionModel.clear();
    }

    public final void clearUndoRedo() {
        StyledTextModel styledTextModel = this.getModel();
        if (styledTextModel != null) {
            styledTextModel.clearUndoRedo();
        }
    }

    public void copy() {
        this.execute(Tag.COPY);
    }

    public final void copy(DataFormat dataFormat) {
        RichTextAreaSkin richTextAreaSkin = this.richTextAreaSkin();
        if (richTextAreaSkin != null) {
            richTextAreaSkin.copyText(dataFormat);
        }
    }

    public void cut() {
        this.execute(Tag.CUT);
    }

    public void delete() {
        this.execute(Tag.DELETE);
    }

    public void deleteParagraph() {
        this.execute(Tag.DELETE_PARAGRAPH);
    }

    public void deleteParagraphStart() {
        this.execute(Tag.DELETE_PARAGRAPH_START);
    }

    public void deleteWordNextEnd() {
        this.execute(Tag.DELETE_WORD_NEXT_END);
    }

    public void deleteWordNextStart() {
        this.execute(Tag.DELETE_WORD_NEXT_START);
    }

    public void deleteWordPrevious() {
        this.execute(Tag.DELETE_WORD_PREVIOUS);
    }

    public void deselect() {
        this.execute(Tag.DESELECT);
    }

    public void errorFeedback() {
        this.execute(Tag.ERROR_FEEDBACK);
    }

    public final void execute(FunctionTag functionTag) {
        InputMapHelper.execute((Object)((Object)this), (InputMap)this.getInputMap(), (FunctionTag)functionTag);
    }

    public final void executeDefault(FunctionTag functionTag) {
        InputMapHelper.executeDefault((Object)((Object)this), (InputMap)this.getInputMap(), (FunctionTag)functionTag);
    }

    public final void extendSelection(TextPos textPos) {
        StyledTextModel styledTextModel = this.getModel();
        if (styledTextModel != null) {
            this.selectionModel.extendSelection(styledTextModel, textPos);
        }
    }

    public final StyleAttributeMap getActiveStyleAttributeMap() {
        StyleResolver styleResolver = this.resolver();
        return this.getModelStyleAttrs(styleResolver);
    }

    public final TextPos getDocumentEnd() {
        StyledTextModel styledTextModel = this.getModel();
        return styledTextModel == null ? TextPos.ZERO : styledTextModel.getDocumentEnd();
    }

    public final InputMap getInputMap() {
        return this.inputMap;
    }

    public final int getParagraphCount() {
        StyledTextModel styledTextModel = this.getModel();
        return styledTextModel == null ? 0 : styledTextModel.size();
    }

    public final TextPos getParagraphEnd(int n) {
        StyledTextModel styledTextModel = this.getModel();
        return styledTextModel == null ? TextPos.ZERO : styledTextModel.getEndOfParagraphTextPos(n);
    }

    public final String getPlainText(int n) {
        if (n < 0 || n >= this.getParagraphCount()) {
            throw new IndexOutOfBoundsException("index=" + n);
        }
        return this.getModel().getPlainText(n);
    }

    public StyleHandlerRegistry getStyleHandlerRegistry() {
        return styleHandlerRegistry;
    }

    private final boolean getText(TextPos textPos, TextPos textPos2, StringBuilder stringBuilder, int n) {
        Object object;
        StyledTextModel styledTextModel = this.getModel();
        if (styledTextModel == null) {
            return true;
        }
        if (textPos.compareTo(textPos2) > 0) {
            object = textPos;
            textPos = textPos2;
            textPos2 = object;
        }
        object = styledTextModel.getLineEnding();
        StringBuilderStyledOutput stringBuilderStyledOutput = new StringBuilderStyledOutput(stringBuilder, (LineEnding)((Object)object), n);
        try {
            styledTextModel.export(textPos, textPos2, stringBuilderStyledOutput);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public final TextPos getTextPosition(double d, double d2) {
        Point2D point2D = this.vflow().getContentPane().screenToLocal(d, d2);
        return this.vflow().getTextPosLocal(point2D.getX(), point2D.getY());
    }

    public final boolean hasNonEmptySelection() {
        TextPos textPos;
        TextPos textPos2 = this.getCaretPosition();
        if (textPos2 != null && (textPos = this.getAnchorPosition()) != null) {
            return !textPos2.isSameInsertionIndex(textPos);
        }
        return false;
    }

    public void insertLineBreak() {
        this.execute(Tag.INSERT_LINE_BREAK);
    }

    public void insertTab() {
        this.execute(Tag.INSERT_TAB);
    }

    public final TextPos insertText(TextPos textPos, String string, StyleAttributeMap styleAttributeMap) {
        StyledInput styledInput = StyledInput.of(string, styleAttributeMap);
        return this.replaceText(textPos, textPos, styledInput);
    }

    public final TextPos insertText(TextPos textPos, StyledInput styledInput) {
        return this.replaceText(textPos, textPos, styledInput);
    }

    public void moveDocumentEnd() {
        this.execute(Tag.MOVE_TO_DOCUMENT_END);
    }

    public void moveDocumentStart() {
        this.execute(Tag.MOVE_TO_DOCUMENT_START);
    }

    public void moveDown() {
        this.execute(Tag.MOVE_DOWN);
    }

    public void moveLeft() {
        this.execute(Tag.MOVE_LEFT);
    }

    public void moveLineEnd() {
        this.execute(Tag.MOVE_TO_LINE_END);
    }

    public void moveLineStart() {
        this.execute(Tag.MOVE_TO_LINE_START);
    }

    public void moveParagraphDown() {
        this.execute(Tag.MOVE_PARAGRAPH_DOWN);
    }

    public void moveParagraphEnd() {
        this.execute(Tag.MOVE_TO_PARAGRAPH_END);
    }

    public void moveParagraphStart() {
        this.execute(Tag.MOVE_TO_PARAGRAPH_START);
    }

    public void moveParagraphUp() {
        this.execute(Tag.MOVE_PARAGRAPH_UP);
    }

    public void moveRight() {
        this.execute(Tag.MOVE_RIGHT);
    }

    public void moveUp() {
        this.execute(Tag.MOVE_UP);
    }

    public void moveWordLeft() {
        this.execute(Tag.MOVE_WORD_LEFT);
    }

    public void moveWordNextEnd() {
        this.execute(Tag.MOVE_WORD_NEXT_END);
    }

    public void moveWordNextStart() {
        this.execute(Tag.MOVE_WORD_NEXT_START);
    }

    public void moveWordPrevious() {
        this.execute(Tag.MOVE_WORD_PREVIOUS);
    }

    public void moveWordRight() {
        this.execute(Tag.MOVE_WORD_RIGHT);
    }

    public void pageDown() {
        this.execute(Tag.PAGE_DOWN);
    }

    public void pageUp() {
        this.execute(Tag.PAGE_UP);
    }

    public void paste() {
        this.execute(Tag.PASTE);
    }

    public void paste(DataFormat dataFormat) {
        RichTextAreaSkin richTextAreaSkin = this.richTextAreaSkin();
        if (richTextAreaSkin != null) {
            richTextAreaSkin.pasteText(dataFormat);
        }
    }

    public final void pastePlainText() {
        this.execute(Tag.PASTE_PLAIN_TEXT);
    }

    public final void read(DataFormat dataFormat, InputStream inputStream) throws IOException {
        StyledTextModel styledTextModel = this.getModel();
        if (styledTextModel != null) {
            StyleResolver styleResolver = this.resolver();
            styledTextModel.read(styleResolver, dataFormat, inputStream);
            this.select(TextPos.ZERO, TextPos.ZERO);
        }
    }

    public final void read(InputStream inputStream) throws IOException {
        DataFormat dataFormat = this.bestDataFormat(false);
        if (dataFormat != null) {
            this.read(dataFormat, inputStream);
        }
    }

    public void redo() {
        this.execute(Tag.REDO);
    }

    public final TextPos replaceText(TextPos textPos, TextPos textPos2, String string) {
        StyledTextModel styledTextModel = this.getModel();
        return styledTextModel.replace((StyleResolver)this.vflow(), textPos, textPos2, string);
    }

    public final TextPos replaceText(TextPos textPos, TextPos textPos2, StyledInput styledInput) {
        StyledTextModel styledTextModel = this.getModel();
        return styledTextModel.replace((StyleResolver)this.vflow(), textPos, textPos2, styledInput);
    }

    public final void select(TextPos textPos) {
        this.select(textPos, textPos);
    }

    public final void select(TextPos textPos, TextPos textPos2) {
        StyledTextModel styledTextModel = this.getModel();
        if (styledTextModel != null) {
            this.selectionModel.setSelection(styledTextModel, textPos, textPos2);
        }
    }

    public void selectAll() {
        this.execute(Tag.SELECT_ALL);
    }

    public void selectDown() {
        this.execute(Tag.SELECT_DOWN);
    }

    public void selectLeft() {
        this.execute(Tag.SELECT_LEFT);
    }

    public void selectPageDown() {
        this.execute(Tag.SELECT_PAGE_DOWN);
    }

    public void selectPageUp() {
        this.execute(Tag.SELECT_PAGE_UP);
    }

    public void selectParagraph() {
        this.execute(Tag.SELECT_PARAGRAPH);
    }

    public void selectParagraphDown() {
        this.execute(Tag.SELECT_PARAGRAPH_DOWN);
    }

    public void selectParagraphEnd() {
        this.execute(Tag.SELECT_PARAGRAPH_END);
    }

    public void selectParagraphStart() {
        this.execute(Tag.SELECT_PARAGRAPH_START);
    }

    public void selectParagraphUp() {
        this.execute(Tag.SELECT_PARAGRAPH_UP);
    }

    public void selectRight() {
        this.execute(Tag.SELECT_RIGHT);
    }

    public void selectToDocumentEnd() {
        this.execute(Tag.SELECT_TO_DOCUMENT_END);
    }

    public void selectToDocumentStart() {
        this.execute(Tag.SELECT_TO_DOCUMENT_START);
    }

    public void selectToLineEnd() {
        this.execute(Tag.SELECT_TO_LINE_END);
    }

    public void selectToLineStart() {
        this.execute(Tag.SELECT_TO_LINE_START);
    }

    public void selectUp() {
        this.execute(Tag.SELECT_UP);
    }

    public void selectWord() {
        this.execute(Tag.SELECT_WORD);
    }

    public void selectWordLeft() {
        this.execute(Tag.SELECT_WORD_LEFT);
    }

    public void selectWordNextEnd() {
        this.execute(Tag.SELECT_WORD_NEXT_END);
    }

    public void selectWordNextStart() {
        this.execute(Tag.SELECT_WORD_NEXT);
    }

    public void selectWordPrevious() {
        this.execute(Tag.SELECT_WORD_PREVIOUS);
    }

    public void selectWordRight() {
        this.execute(Tag.SELECT_WORD_RIGHT);
    }

    public final void setStyle(TextPos textPos, TextPos textPos2, StyleAttributeMap styleAttributeMap) {
        StyledTextModel styledTextModel = this.getModel();
        styledTextModel.applyStyle(textPos, textPos2, styleAttributeMap, false);
    }

    public void undo() {
        this.execute(Tag.UNDO);
    }

    public final void write(DataFormat dataFormat, OutputStream outputStream) throws IOException {
        StyledTextModel styledTextModel = this.getModel();
        if (styledTextModel != null) {
            StyleResolver styleResolver = this.resolver();
            styledTextModel.write(styleResolver, dataFormat, outputStream);
        }
    }

    public final void write(OutputStream outputStream) throws IOException {
        if (this.getModel() != null) {
            DataFormat dataFormat = this.bestDataFormat(true);
            if (dataFormat == null) {
                throw new UnsupportedOperationException("no suitable format can be found");
            }
            this.write(dataFormat, outputStream);
        }
    }

    protected RichTextAreaSkin createDefaultSkin() {
        return new RichTextAreaSkin(this);
    }

    VFlow vflow() {
        return RichTextAreaSkinHelper.getVFlow(this);
    }

    private RichTextAreaSkin richTextAreaSkin() {
        return (RichTextAreaSkin)this.getSkin();
    }

    private StyleResolver resolver() {
        RichTextAreaSkin richTextAreaSkin = this.richTextAreaSkin();
        if (richTextAreaSkin != null) {
            return richTextAreaSkin.getStyleResolver();
        }
        return null;
    }

    private StyleAttributeMap getModelStyleAttrs(StyleResolver styleResolver) {
        SelectionSegment selectionSegment;
        StyledTextModel styledTextModel = this.getModel();
        if (styledTextModel != null && (selectionSegment = this.getSelection()) != null) {
            TextPos textPos = selectionSegment.getMax();
            return styledTextModel.getStyleAttributeMap(styleResolver, textPos);
        }
        return StyleAttributeMap.EMPTY;
    }

    private static StyleHandlerRegistry initStyleHandlerRegistry() {
        StyleHandlerRegistry.Builder builder = StyleHandlerRegistry.builder(null);
        builder.setParHandler(StyleAttributeMap.BACKGROUND, (richTextArea, cellContext, color) -> {
            String string = RichUtils.toCssColor(color);
            cellContext.addStyle("-fx-background-color:" + string + ";");
        });
        builder.setSegHandler(StyleAttributeMap.BOLD, (richTextArea, cellContext, bl) -> cellContext.addStyle(bl != false ? "-fx-font-weight:bold;" : "-fx-font-weight:normal;"));
        builder.setSegHandler(CssStyles.CSS, (richTextArea, cellContext, cssStyles) -> {
            Object[] objectArray;
            String string = cssStyles.style();
            if (string != null) {
                cellContext.addStyle(string);
            }
            if ((objectArray = cssStyles.names()) != null) {
                cellContext.getNode().getStyleClass().addAll(objectArray);
            }
        });
        builder.setSegHandler(StyleAttributeMap.FONT_FAMILY, (richTextArea, cellContext, string) -> cellContext.addStyle("-fx-font-family:'" + string + "';"));
        builder.setSegHandler(StyleAttributeMap.FONT_SIZE, (richTextArea, cellContext, d) -> cellContext.addStyle("-fx-font-size:" + d + ";"));
        builder.setSegHandler(StyleAttributeMap.ITALIC, (richTextArea, cellContext, bl) -> {
            if (bl.booleanValue()) {
                cellContext.addStyle("-fx-font-style:italic;");
            }
        });
        builder.setParHandler(StyleAttributeMap.LINE_SPACING, (richTextArea, cellContext, d) -> cellContext.addStyle("-fx-line-spacing:" + d + ";"));
        builder.setParHandler(StyleAttributeMap.PARAGRAPH_DIRECTION, (richTextArea, cellContext, paragraphDirection) -> {
            if (richTextArea.isWrapText()) {
                switch (paragraphDirection) {
                    case LEFT_TO_RIGHT: {
                        cellContext.getNode().setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
                        break;
                    }
                    case RIGHT_TO_LEFT: {
                        cellContext.getNode().setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
                    }
                }
            }
        });
        StyleAttributeHandler<RichTextArea, Double> styleAttributeHandler = (richTextArea, cellContext, d) -> {
            StyleAttributeMap styleAttributeMap = cellContext.getAttributes();
            double d2 = styleAttributeMap.getDouble(StyleAttributeMap.SPACE_ABOVE, 0.0);
            double d3 = styleAttributeMap.getDouble(StyleAttributeMap.SPACE_RIGHT, 0.0);
            double d4 = styleAttributeMap.getDouble(StyleAttributeMap.SPACE_BELOW, 0.0);
            double d5 = styleAttributeMap.getDouble(StyleAttributeMap.SPACE_LEFT, 0.0);
            cellContext.addStyle("-fx-padding:" + d2 + " " + d3 + " " + d4 + " " + d5 + ";");
        };
        builder.setParHandler(StyleAttributeMap.SPACE_ABOVE, styleAttributeHandler);
        builder.setParHandler(StyleAttributeMap.SPACE_RIGHT, styleAttributeHandler);
        builder.setParHandler(StyleAttributeMap.SPACE_BELOW, styleAttributeHandler);
        builder.setParHandler(StyleAttributeMap.SPACE_LEFT, styleAttributeHandler);
        builder.setSegHandler(StyleAttributeMap.STRIKE_THROUGH, (richTextArea, cellContext, bl) -> {
            if (bl.booleanValue()) {
                cellContext.addStyle("-fx-strikethrough:true;");
            }
        });
        builder.setParHandler(StyleAttributeMap.TEXT_ALIGNMENT, (richTextArea, cellContext, textAlignment) -> {
            if (richTextArea.isWrapText()) {
                String string = RichUtils.toCss(textAlignment);
                cellContext.addStyle("-fx-text-alignment:" + string + ";");
            }
        });
        builder.setSegHandler(StyleAttributeMap.TEXT_COLOR, (richTextArea, cellContext, color) -> {
            String string = RichUtils.toCssColor(color);
            cellContext.addStyle("-fx-fill:" + string + ";");
        });
        builder.setSegHandler(StyleAttributeMap.UNDERLINE, (richTextArea, cellContext, bl) -> {
            if (bl.booleanValue()) {
                cellContext.addStyle("-fx-underline:true;");
            }
        });
        return builder.build();
    }

    private DataFormat bestDataFormat(boolean bl) {
        List<DataFormat> list;
        StyledTextModel styledTextModel = this.getModel();
        if (styledTextModel != null && (list = styledTextModel.getSupportedDataFormats(bl)).size() > 0) {
            return list.get(0);
        }
        return null;
    }

    private RTAccessibilityHelper accessibilityHelper() {
        if (this.accessibilityHelper == null) {
            this.accessibilityHelper = new RTAccessibilityHelper(this);
        }
        return this.accessibilityHelper;
    }

    public void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
        switch (accessibleAction) {
            case SET_TEXT: {
                String string = (String)objectArray[0];
                if (string != null) {
                    // empty if block
                }
                return;
            }
            case SET_TEXT_SELECTION: {
                Integer n = (Integer)objectArray[0];
                Integer n2 = (Integer)objectArray[1];
                if (n == null || n2 != null) {
                    // empty if block
                }
                return;
            }
            case SHOW_TEXT_RANGE: {
                return;
            }
        }
        super.executeAccessibleAction(accessibleAction, objectArray);
    }

    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case EDITABLE: {
                return this.isEditable();
            }
            case TEXT: {
                String string = this.getAccessibleText();
                if (string != null && !string.isEmpty()) {
                    return string;
                }
                return this.accessibilityHelper().getText();
            }
            case SELECTION_START: {
                return this.accessibilityHelper().selectionStart();
            }
            case SELECTION_END: {
                return this.accessibilityHelper().selectionEnd();
            }
            case CARET_OFFSET: {
                return this.accessibilityHelper().caretOffset();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    static {
        RichTextAreaHelper.setAccessor(new RichTextAreaHelper.Accessor(){

            @Override
            public boolean getText(RichTextArea richTextArea, TextPos textPos, TextPos textPos2, StringBuilder stringBuilder, int n) {
                return richTextArea.getText(textPos, textPos2, stringBuilder, n);
            }
        });
    }

    private static class StyleableProperties {
        private static final CssMetaData<RichTextArea, Duration> CARET_BLINK_PERIOD = new CssMetaData<RichTextArea, Duration>("-fx-caret-blink-period", DurationConverter.getInstance()){

            public boolean isSettable(RichTextArea richTextArea) {
                return richTextArea.caretBlinkPeriod == null || !richTextArea.caretBlinkPeriod.isBound();
            }

            public StyleableProperty<Duration> getStyleableProperty(RichTextArea richTextArea) {
                return (StyleableProperty)richTextArea.caretBlinkPeriodProperty();
            }
        };
        private static final CssMetaData<RichTextArea, Insets> CONTENT_PADDING = new CssMetaData<RichTextArea, Insets>("-fx-content-padding", InsetsConverter.getInstance()){

            public boolean isSettable(RichTextArea richTextArea) {
                return richTextArea.contentPadding == null || !richTextArea.contentPadding.isBound();
            }

            public StyleableProperty<Insets> getStyleableProperty(RichTextArea richTextArea) {
                return (StyleableProperty)richTextArea.contentPaddingProperty();
            }
        };
        private static final CssMetaData<RichTextArea, Boolean> DISPLAY_CARET = new CssMetaData<RichTextArea, Boolean>("-fx-display-caret", StyleConverter.getBooleanConverter(), Boolean.valueOf(true)){

            public boolean isSettable(RichTextArea richTextArea) {
                return richTextArea.displayCaret == null || !richTextArea.displayCaret.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(RichTextArea richTextArea) {
                return (StyleableProperty)richTextArea.displayCaretProperty();
            }
        };
        private static final CssMetaData<RichTextArea, Boolean> HIGHLIGHT_CURRENT_PARAGRAPH = new CssMetaData<RichTextArea, Boolean>("-fx-highlight-current-paragraph", StyleConverter.getBooleanConverter(), Boolean.valueOf(false)){

            public boolean isSettable(RichTextArea richTextArea) {
                return richTextArea.highlightCurrentParagraph == null || !richTextArea.highlightCurrentParagraph.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(RichTextArea richTextArea) {
                return (StyleableProperty)richTextArea.highlightCurrentParagraphProperty();
            }
        };
        private static final CssMetaData<RichTextArea, Boolean> USE_CONTENT_HEIGHT = new CssMetaData<RichTextArea, Boolean>("-fx-use-content-height", StyleConverter.getBooleanConverter(), Boolean.valueOf(false)){

            public boolean isSettable(RichTextArea richTextArea) {
                return richTextArea.useContentHeight == null || !richTextArea.useContentHeight.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(RichTextArea richTextArea) {
                return (StyleableProperty)richTextArea.useContentHeightProperty();
            }
        };
        private static final CssMetaData<RichTextArea, Boolean> USE_CONTENT_WIDTH = new CssMetaData<RichTextArea, Boolean>("-fx-use-content-width", StyleConverter.getBooleanConverter(), Boolean.valueOf(false)){

            public boolean isSettable(RichTextArea richTextArea) {
                return richTextArea.useContentWidth == null || !richTextArea.useContentWidth.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(RichTextArea richTextArea) {
                return (StyleableProperty)richTextArea.useContentWidthProperty();
            }
        };
        private static final CssMetaData<RichTextArea, Boolean> WRAP_TEXT = new CssMetaData<RichTextArea, Boolean>("-fx-wrap-text", StyleConverter.getBooleanConverter(), Boolean.valueOf(false)){

            public boolean isSettable(RichTextArea richTextArea) {
                return richTextArea.wrapText == null || !richTextArea.wrapText.isBound();
            }

            public StyleableProperty<Boolean> getStyleableProperty(RichTextArea richTextArea) {
                return (StyleableProperty)richTextArea.wrapTextProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES = RichUtils.combine(Control.getClassCssMetaData(), CARET_BLINK_PERIOD, CONTENT_PADDING, DISPLAY_CARET, HIGHLIGHT_CURRENT_PARAGRAPH, USE_CONTENT_HEIGHT, USE_CONTENT_WIDTH, WRAP_TEXT);

        private StyleableProperties() {
        }
    }

    public static class Tag {
        public static final FunctionTag BACKSPACE = new FunctionTag();
        public static final FunctionTag COPY = new FunctionTag();
        public static final FunctionTag CUT = new FunctionTag();
        public static final FunctionTag DELETE = new FunctionTag();
        public static final FunctionTag DELETE_PARAGRAPH = new FunctionTag();
        public static final FunctionTag DELETE_PARAGRAPH_START = new FunctionTag();
        public static final FunctionTag DELETE_WORD_NEXT_END = new FunctionTag();
        public static final FunctionTag DELETE_WORD_NEXT_START = new FunctionTag();
        public static final FunctionTag DELETE_WORD_PREVIOUS = new FunctionTag();
        public static final FunctionTag DESELECT = new FunctionTag();
        public static final FunctionTag ERROR_FEEDBACK = new FunctionTag();
        public static final FunctionTag FOCUS_NEXT = new FunctionTag();
        public static final FunctionTag FOCUS_PREVIOUS = new FunctionTag();
        public static final FunctionTag INSERT_LINE_BREAK = new FunctionTag();
        public static final FunctionTag MOVE_DOWN = new FunctionTag();
        public static final FunctionTag MOVE_LEFT = new FunctionTag();
        public static final FunctionTag MOVE_PARAGRAPH_DOWN = new FunctionTag();
        public static final FunctionTag MOVE_PARAGRAPH_UP = new FunctionTag();
        public static final FunctionTag MOVE_RIGHT = new FunctionTag();
        public static final FunctionTag MOVE_TO_DOCUMENT_END = new FunctionTag();
        public static final FunctionTag MOVE_TO_DOCUMENT_START = new FunctionTag();
        public static final FunctionTag MOVE_TO_LINE_END = new FunctionTag();
        public static final FunctionTag MOVE_TO_LINE_START = new FunctionTag();
        public static final FunctionTag MOVE_TO_PARAGRAPH_END = new FunctionTag();
        public static final FunctionTag MOVE_TO_PARAGRAPH_START = new FunctionTag();
        public static final FunctionTag MOVE_UP = new FunctionTag();
        public static final FunctionTag MOVE_WORD_LEFT = new FunctionTag();
        public static final FunctionTag MOVE_WORD_NEXT_START = new FunctionTag();
        public static final FunctionTag MOVE_WORD_NEXT_END = new FunctionTag();
        public static final FunctionTag MOVE_WORD_PREVIOUS = new FunctionTag();
        public static final FunctionTag MOVE_WORD_RIGHT = new FunctionTag();
        public static final FunctionTag PAGE_DOWN = new FunctionTag();
        public static final FunctionTag PAGE_UP = new FunctionTag();
        public static final FunctionTag PASTE = new FunctionTag();
        public static final FunctionTag PASTE_PLAIN_TEXT = new FunctionTag();
        public static final FunctionTag REDO = new FunctionTag();
        public static final FunctionTag SELECT_ALL = new FunctionTag();
        public static final FunctionTag SELECT_DOWN = new FunctionTag();
        public static final FunctionTag SELECT_LEFT = new FunctionTag();
        public static final FunctionTag SELECT_PAGE_DOWN = new FunctionTag();
        public static final FunctionTag SELECT_PAGE_UP = new FunctionTag();
        public static final FunctionTag SELECT_PARAGRAPH = new FunctionTag();
        public static final FunctionTag SELECT_PARAGRAPH_DOWN = new FunctionTag();
        public static final FunctionTag SELECT_PARAGRAPH_END = new FunctionTag();
        public static final FunctionTag SELECT_PARAGRAPH_START = new FunctionTag();
        public static final FunctionTag SELECT_PARAGRAPH_UP = new FunctionTag();
        public static final FunctionTag SELECT_RIGHT = new FunctionTag();
        public static final FunctionTag SELECT_TO_DOCUMENT_END = new FunctionTag();
        public static final FunctionTag SELECT_TO_DOCUMENT_START = new FunctionTag();
        public static final FunctionTag SELECT_TO_LINE_END = new FunctionTag();
        public static final FunctionTag SELECT_TO_LINE_START = new FunctionTag();
        public static final FunctionTag SELECT_UP = new FunctionTag();
        public static final FunctionTag SELECT_WORD = new FunctionTag();
        public static final FunctionTag SELECT_WORD_LEFT = new FunctionTag();
        public static final FunctionTag SELECT_WORD_NEXT = new FunctionTag();
        public static final FunctionTag SELECT_WORD_NEXT_END = new FunctionTag();
        public static final FunctionTag SELECT_WORD_PREVIOUS = new FunctionTag();
        public static final FunctionTag SELECT_WORD_RIGHT = new FunctionTag();
        public static final FunctionTag INSERT_TAB = new FunctionTag();
        public static final FunctionTag UNDO = new FunctionTag();

        private Tag() {
        }
    }
}

