/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.geometry.Point2D;
import javafx.scene.text.Font;

public class InterpolatorConverter
extends StyleConverter<Object, Interpolator> {
    public static final Interpolator CSS_EASE = Interpolator.ofSpline(0.25, 0.1, 0.25, 1.0);
    public static final Interpolator CSS_EASE_IN = Interpolator.ofSpline(0.42, 0.0, 1.0, 1.0);
    public static final Interpolator CSS_EASE_OUT = Interpolator.ofSpline(0.0, 0.0, 0.58, 1.0);
    public static final Interpolator CSS_EASE_IN_OUT = Interpolator.ofSpline(0.42, 0.0, 0.58, 1.0);
    private static final Map<ParsedValue<?, ?>, Interpolator> CACHE = new LinkedHashMap<ParsedValue<?, ?>, Interpolator>(10, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<ParsedValue<?, ?>, Interpolator> entry) {
            return this.size() > 20;
        }
    };

    public static StyleConverter<Object, Interpolator> getInstance() {
        return Holder.INSTANCE;
    }

    private InterpolatorConverter() {
    }

    @Override
    public Interpolator convert(ParsedValue<Object, Interpolator> parsedValue2, Font font) {
        ParsedValue[] parsedValueArray;
        Object object = parsedValue2.getValue();
        if (object instanceof ParsedValue && (object = (parsedValueArray = (ParsedValue[])object).getValue()) instanceof String) {
            String string = (String)object;
            return switch (string) {
                case "ease" -> CSS_EASE;
                case "ease-in" -> CSS_EASE_IN;
                case "ease-out" -> CSS_EASE_OUT;
                case "ease-in-out" -> CSS_EASE_IN_OUT;
                case "step-start" -> Interpolator.STEP_START;
                case "step-end" -> Interpolator.STEP_END;
                case "linear" -> Interpolator.LINEAR;
                case "-fx-ease-in" -> Interpolator.EASE_IN;
                case "-fx-ease-out" -> Interpolator.EASE_OUT;
                case "-fx-ease-both" -> Interpolator.EASE_BOTH;
                default -> throw new AssertionError();
            };
        }
        object = parsedValue2.getValue();
        if (object instanceof ParsedValue[] && (object = (parsedValueArray = (ParsedValue[])object)[0].getValue()) instanceof String) {
            String string = (String)object;
            return switch (string) {
                case "cubic-bezier(" -> CACHE.computeIfAbsent(parsedValue2, parsedValue -> {
                    List list = this.arguments((ParsedValue<?, ?>)parsedValue);
                    return Interpolator.ofSpline((Double)list.get(0), (Double)list.get(1), (Double)list.get(2), (Double)list.get(3));
                });
                case "steps(" -> CACHE.computeIfAbsent(parsedValue2, parsedValue -> {
                    List list = this.arguments((ParsedValue<?, ?>)parsedValue);
                    String string = list.get(1) != null ? (String)list.get(1) : "end";
                    int n = (Integer)list.get(0);
                    return Interpolator.ofSteps(n, switch (string) {
                        case "jump-start", "start" -> Interpolator.StepPosition.START;
                        case "jump-both" -> Interpolator.StepPosition.BOTH;
                        case "jump-none" -> Interpolator.StepPosition.NONE;
                        default -> Interpolator.StepPosition.END;
                    });
                });
                case "linear(" -> CACHE.computeIfAbsent(parsedValue2, parsedValue -> {
                    List list = this.arguments((ParsedValue<?, ?>)parsedValue);
                    return Interpolator.ofLinear((Point2D[])list.toArray(Point2D[]::new));
                });
                default -> throw new AssertionError();
            };
        }
        throw new AssertionError();
    }

    private <T> List<T> arguments(ParsedValue<?, ?> parsedValue) {
        ParsedValue[] parsedValueArray = (ParsedValue[])parsedValue.getValue();
        return (List)parsedValueArray[1].getValue();
    }

    private static class Holder {
        static final InterpolatorConverter INSTANCE = new InterpolatorConverter();
        static final SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }

    public static final class SequenceConverter
    extends StyleConverter<ParsedValue<?, Interpolator>[], Interpolator[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public Interpolator[] convert(ParsedValue<ParsedValue<?, Interpolator>[], Interpolator[]> parsedValue, Font font) {
            ParsedValue<?, Interpolator>[] parsedValueArray = parsedValue.getValue();
            Interpolator[] interpolatorArray = new Interpolator[parsedValueArray.length];
            for (int i = 0; i < parsedValueArray.length; ++i) {
                interpolatorArray[i] = InterpolatorConverter.getInstance().convert(parsedValueArray[i], font);
            }
            return interpolatorArray;
        }
    }
}

