/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.text;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TabAdvancePolicy;
import com.sun.javafx.scene.text.TextFlowHelper;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextSpan;
import com.sun.javafx.text.DefaultTabAdvancePolicy;
import com.sun.javafx.text.PrismLayoutInfo;
import com.sun.javafx.text.TextUtils;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.shape.PathElement;
import javafx.scene.text.HitInfo;
import javafx.scene.text.LayoutInfo;
import javafx.scene.text.TabStopPolicy;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.TransformChangedEvent;

public class TextFlow
extends Pane {
    private TextLayout layout;
    private boolean needsContent;
    private boolean inLayout;
    private ObjectProperty<TextAlignment> textAlignment;
    private DoubleProperty lineSpacing;
    private IntegerProperty tabSize;
    private SimpleObjectProperty<TabStopPolicy> tabStopPolicy;

    public TextFlow() {
        this.effectiveNodeOrientationProperty().addListener(observable -> this.checkOrientation());
        this.setAccessibleRole(AccessibleRole.TEXT);
    }

    public TextFlow(Node ... nodeArray) {
        this();
        this.getChildren().addAll((Object[])nodeArray);
    }

    private void checkOrientation() {
        NodeOrientation nodeOrientation = this.getEffectiveNodeOrientation();
        boolean bl = nodeOrientation == NodeOrientation.RIGHT_TO_LEFT;
        int n = bl ? 2048 : 1024;
        TextLayout textLayout = this.getTextLayout();
        if (textLayout.setDirection(n)) {
            this.requestLayout();
        }
    }

    @Deprecated(since="25")
    public final HitInfo hitTest(Point2D point2D) {
        if (point2D != null) {
            TextLayout textLayout = this.getTextLayout();
            double d = point2D.getX();
            double d2 = point2D.getY();
            TextLayout.Hit hit = textLayout.getHitInfo((float)d, (float)d2);
            return new HitInfo(hit.getCharIndex(), hit.getInsertionIndex(), hit.isLeading());
        }
        return null;
    }

    public final HitInfo getHitInfo(Point2D point2D) {
        if (point2D != null) {
            TextLayout textLayout = this.getTextLayout();
            double d = point2D.getX() - this.snappedLeftInset();
            double d2 = point2D.getY() - this.snappedTopInset();
            TextLayout.Hit hit = textLayout.getHitInfo((float)d, (float)d2);
            return new HitInfo(hit.getCharIndex(), hit.getInsertionIndex(), hit.isLeading());
        }
        return null;
    }

    @Deprecated(since="25")
    public PathElement[] caretShape(int n, boolean bl) {
        TextLayout.CaretGeometry caretGeometry = this.getTextLayout().getCaretGeometry(n, bl);
        return TextUtils.getCaretPathElements(caretGeometry, 0.0, 0.0);
    }

    public PathElement[] getCaretShape(int n, boolean bl) {
        TextLayout.CaretGeometry caretGeometry = this.getTextLayout().getCaretGeometry(n, bl);
        double d = this.snappedLeftInset();
        double d2 = this.snappedTopInset();
        return TextUtils.getCaretPathElements(caretGeometry, d, d2);
    }

    @Deprecated(since="25")
    public final PathElement[] rangeShape(int n, int n2) {
        return this.getRange(n, n2, 1, false, 0.0);
    }

    public final PathElement[] getRangeShape(int n, int n2, boolean bl) {
        double d = bl ? this.getLineSpacing() : 0.0;
        return this.getRange(n, n2, 1, true, d);
    }

    @Deprecated(since="25")
    public final PathElement[] underlineShape(int n, int n2) {
        return this.getRange(n, n2, 2, false, 0.0);
    }

    public final PathElement[] getUnderlineShape(int n, int n2) {
        return this.getRange(n, n2, 2, true, 0.0);
    }

    public final PathElement[] getStrikeThroughShape(int n, int n2) {
        return this.getRange(n, n2, 4, true, 0.0);
    }

    @Override
    public boolean usesMirroring() {
        return false;
    }

    @Override
    protected void setWidth(double d) {
        if (d != this.getWidth()) {
            TextLayout textLayout = this.getTextLayout();
            Insets insets = this.getInsets();
            double d2 = this.snapSpaceX(insets.getLeft());
            double d3 = this.snapSpaceX(insets.getRight());
            double d4 = Math.max(1.0, d - d2 - d3);
            textLayout.setWrapWidth((float)d4);
            super.setWidth(d);
        }
    }

    @Override
    protected double computePrefWidth(double d) {
        TextLayout textLayout = this.getTextLayout();
        textLayout.setWrapWidth(0.0f);
        double d2 = textLayout.getBounds().getWidth();
        Insets insets = this.getInsets();
        double d3 = this.snapSpaceX(insets.getLeft());
        double d4 = this.snapSpaceX(insets.getRight());
        double d5 = Math.max(1.0, this.getWidth() - d3 - d4);
        textLayout.setWrapWidth((float)d5);
        return d3 + d2 + d4;
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2;
        TextLayout textLayout = this.getTextLayout();
        Insets insets = this.getInsets();
        double d3 = this.snapSpaceX(insets.getLeft());
        double d4 = this.snapSpaceX(insets.getRight());
        if (d == -1.0) {
            textLayout.setWrapWidth(0.0f);
        } else {
            d2 = Math.max(1.0, d - d3 - d4);
            textLayout.setWrapWidth((float)d2);
        }
        d2 = textLayout.getBounds().getHeight();
        double d5 = Math.max(1.0, this.getWidth() - d3 - d4);
        textLayout.setWrapWidth((float)d5);
        double d6 = this.snapSpaceY(insets.getTop());
        double d7 = this.snapSpaceY(insets.getBottom());
        return d6 + d2 + d7;
    }

    @Override
    protected double computeMinHeight(double d) {
        return this.computePrefHeight(d);
    }

    @Override
    public void requestLayout() {
        if (this.inLayout) {
            return;
        }
        this.needsContent = true;
        super.requestLayout();
    }

    @Override
    public Orientation getContentBias() {
        return Orientation.HORIZONTAL;
    }

    @Override
    protected void layoutChildren() {
        Object object;
        Node node;
        this.inLayout = true;
        Insets insets = this.getInsets();
        double d = this.snapSpaceY(insets.getTop());
        double d2 = this.snapSpaceX(insets.getLeft());
        GlyphList[] glyphListArray = this.getTextLayout().getRuns();
        for (int i = 0; i < glyphListArray.length; ++i) {
            GlyphList glyphList = glyphListArray[i];
            Object object2 = glyphList.getTextSpan();
            if (!(object2 instanceof EmbeddedSpan)) continue;
            node = ((EmbeddedSpan)object2).getNode();
            object = glyphList.getLocation();
            double d3 = -glyphList.getLineBounds().getMinY();
            this.layoutInArea(node, d2 + (double)((com.sun.javafx.geom.Point2D)object).x, d + (double)((com.sun.javafx.geom.Point2D)object).y, glyphList.getWidth(), glyphList.getHeight(), d3, null, true, true, HPos.CENTER, VPos.BASELINE);
        }
        List list = this.getManagedChildren();
        for (Object object2 : list) {
            if (!(object2 instanceof Text)) continue;
            node = (Text)object2;
            ((Text)node).layoutSpan(glyphListArray);
            object = ((Text)node).getSpanBounds();
            node.relocate(d2 + (double)((BaseBounds)object).getMinX(), d + (double)((BaseBounds)object).getMinY());
        }
        this.inLayout = false;
    }

    private PathElement[] getRange(int n, int n2, int n3, boolean bl, double d) {
        double d2;
        double d3;
        if (bl) {
            d3 = this.snappedLeftInset();
            d2 = this.snappedTopInset();
        } else {
            d3 = 0.0;
            d2 = 0.0;
        }
        TextLayout textLayout = this.getTextLayout();
        return TextUtils.getRange(textLayout, n, n2, n3, d3, d2, d);
    }

    TextLayout getTextLayout() {
        Object object;
        if (this.layout == null) {
            object = Toolkit.getToolkit().getTextLayoutFactory();
            this.layout = object.createLayout();
            this.needsContent = true;
        }
        if (this.needsContent) {
            object = this.getManagedChildren();
            TextSpan[] textSpanArray = new TextSpan[object.size()];
            for (int i = 0; i < textSpanArray.length; ++i) {
                Node node = (Node)object.get(i);
                if (node instanceof Text) {
                    textSpanArray[i] = ((Text)node).getTextSpan();
                    continue;
                }
                double d = node.getBaselineOffset();
                if (d == Double.NEGATIVE_INFINITY) {
                    d = node.getLayoutBounds().getHeight();
                }
                double d2 = this.computeChildPrefAreaWidth(node, null);
                double d3 = this.computeChildPrefAreaHeight(node, null);
                textSpanArray[i] = new EmbeddedSpan(node, d, d2, d3);
            }
            this.layout.setContent(textSpanArray);
            this.layout.setTabAdvancePolicy(this.getTabSize(), this.getTabAdvancePolicy());
            this.needsContent = false;
        }
        return this.layout;
    }

    public final void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignmentProperty().set((Object)textAlignment);
    }

    public final TextAlignment getTextAlignment() {
        return this.textAlignment == null ? TextAlignment.LEFT : (TextAlignment)((Object)this.textAlignment.get());
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        if (this.textAlignment == null) {
            this.textAlignment = new StyleableObjectProperty<TextAlignment>(this, TextAlignment.LEFT){
                final /* synthetic */ TextFlow this$0;
                {
                    TextFlow textFlow2 = textFlow;
                    Objects.requireNonNull(textFlow2);
                    this.this$0 = textFlow2;
                    super(textAlignment);
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "textAlignment";
                }

                @Override
                public CssMetaData<TextFlow, TextAlignment> getCssMetaData() {
                    return StyleableProperties.TEXT_ALIGNMENT;
                }

                public void invalidated() {
                    TextAlignment textAlignment = (TextAlignment)((Object)this.get());
                    if (textAlignment == null) {
                        textAlignment = TextAlignment.LEFT;
                    }
                    TextLayout textLayout = this.this$0.getTextLayout();
                    textLayout.setAlignment(textAlignment.ordinal());
                    this.this$0.requestLayout();
                }
            };
        }
        return this.textAlignment;
    }

    public final void setLineSpacing(double d) {
        this.lineSpacingProperty().set(d);
    }

    public final double getLineSpacing() {
        return this.lineSpacing == null ? 0.0 : this.lineSpacing.get();
    }

    public final DoubleProperty lineSpacingProperty() {
        if (this.lineSpacing == null) {
            this.lineSpacing = new StyleableDoubleProperty(this, 0.0){
                final /* synthetic */ TextFlow this$0;
                {
                    TextFlow textFlow2 = textFlow;
                    Objects.requireNonNull(textFlow2);
                    this.this$0 = textFlow2;
                    super(d);
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "lineSpacing";
                }

                @Override
                public CssMetaData<TextFlow, Number> getCssMetaData() {
                    return StyleableProperties.LINE_SPACING;
                }

                public void invalidated() {
                    TextLayout textLayout = this.this$0.getTextLayout();
                    if (textLayout.setLineSpacing((float)this.get())) {
                        this.this$0.requestLayout();
                    }
                }
            };
        }
        return this.lineSpacing;
    }

    public final IntegerProperty tabSizeProperty() {
        if (this.tabSize == null) {
            this.tabSize = new StyleableIntegerProperty(this, 8){
                final /* synthetic */ TextFlow this$0;
                {
                    TextFlow textFlow2 = textFlow;
                    Objects.requireNonNull(textFlow2);
                    this.this$0 = textFlow2;
                    super(n);
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "tabSize";
                }

                @Override
                public CssMetaData getCssMetaData() {
                    return StyleableProperties.TAB_SIZE;
                }

                protected void invalidated() {
                    TextLayout textLayout = this.this$0.getTextLayout();
                    if (textLayout.setTabAdvancePolicy(this.this$0.getTabSize(), this.this$0.getTabAdvancePolicy())) {
                        this.this$0.requestLayout();
                    }
                }
            };
        }
        return this.tabSize;
    }

    public final int getTabSize() {
        return this.tabSize == null ? 8 : this.tabSize.get();
    }

    public final void setTabSize(int n) {
        this.tabSizeProperty().set(n);
    }

    public final ObjectProperty<TabStopPolicy> tabStopPolicyProperty() {
        if (this.tabStopPolicy == null) {
            this.tabStopPolicy = new SimpleObjectProperty<TabStopPolicy>(this){
                private Monitor monitor;
                private TabStopPolicy old;
                final /* synthetic */ TextFlow this$0;
                {
                    TextFlow textFlow2 = textFlow;
                    Objects.requireNonNull(textFlow2);
                    this.this$0 = textFlow2;
                    this.monitor = new Monitor(this);
                    this.this$0.sceneProperty().addListener((InvalidationListener)this.monitor);
                    this.this$0.localToSceneTransformProperty().addListener((InvalidationListener)this.monitor);
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "tabStopPolicy";
                }

                protected void invalidated() {
                    TabStopPolicy tabStopPolicy;
                    if (this.old != null) {
                        this.old.tabStops().removeListener((InvalidationListener)this.monitor);
                        this.old.defaultIntervalProperty().removeListener((InvalidationListener)this.monitor);
                    }
                    if ((tabStopPolicy = (TabStopPolicy)this.get()) != null) {
                        tabStopPolicy.tabStops().addListener((InvalidationListener)this.monitor);
                        tabStopPolicy.defaultIntervalProperty().addListener((InvalidationListener)this.monitor);
                    }
                    this.old = tabStopPolicy;
                    this.updateTabAdvancePolicy();
                }

                private void updateTabAdvancePolicy() {
                    TextLayout textLayout = this.this$0.getTextLayout();
                    if (textLayout.setTabAdvancePolicy(this.this$0.getTabSize(), this.this$0.getTabAdvancePolicy())) {
                        this.this$0.requestLayout();
                    }
                }

                class Monitor
                implements InvalidationListener,
                EventHandler<TransformChangedEvent> {
                    final /* synthetic */ 4 this$1;

                    Monitor(4 var1_1) {
                        4 v0 = var1_1;
                        Objects.requireNonNull(v0);
                        this.this$1 = v0;
                    }

                    public void invalidated(Observable observable) {
                        this.this$1.updateTabAdvancePolicy();
                    }

                    public void handle(TransformChangedEvent transformChangedEvent) {
                        this.this$1.updateTabAdvancePolicy();
                    }
                }
            };
        }
        return this.tabStopPolicy;
    }

    public final TabStopPolicy getTabStopPolicy() {
        return this.tabStopPolicy == null ? null : (TabStopPolicy)this.tabStopPolicy.get();
    }

    public final void setTabStopPolicy(TabStopPolicy tabStopPolicy) {
        this.tabStopPolicyProperty().set((Object)tabStopPolicy);
    }

    private TabAdvancePolicy getTabAdvancePolicy() {
        TabStopPolicy tabStopPolicy = this.getTabStopPolicy();
        return tabStopPolicy == null ? null : DefaultTabAdvancePolicy.of(this, tabStopPolicy);
    }

    @Override
    public final double getBaselineOffset() {
        Insets insets = this.getInsets();
        double d = this.snapSpaceY(insets.getTop());
        return d - (double)this.getTextLayout().getBounds().getMinY();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TextFlow.getClassCssMetaData();
    }

    static double boundedSize(double d, double d2, double d3) {
        double d4 = d2 >= d ? d2 : d;
        double d5 = d >= d3 ? d : d3;
        return d4 <= d5 ? d4 : d5;
    }

    double computeChildPrefAreaWidth(Node node, Insets insets) {
        return this.computeChildPrefAreaWidth(node, insets, -1.0);
    }

    double computeChildPrefAreaWidth(Node node, Insets insets, double d) {
        double d2 = insets != null ? this.snapSpaceY(insets.getTop()) : 0.0;
        double d3 = insets != null ? this.snapSpaceY(insets.getBottom()) : 0.0;
        double d4 = insets != null ? this.snapSpaceX(insets.getLeft()) : 0.0;
        double d5 = insets != null ? this.snapSpaceX(insets.getRight()) : 0.0;
        double d6 = -1.0;
        if (node.getContentBias() == Orientation.VERTICAL) {
            d6 = this.snapSizeY(TextFlow.boundedSize(node.minHeight(-1.0), d != -1.0 ? d - d2 - d3 : node.prefHeight(-1.0), node.maxHeight(-1.0)));
        }
        return d4 + this.snapSizeX(TextFlow.boundedSize(node.minWidth(d6), node.prefWidth(d6), node.maxWidth(d6))) + d5;
    }

    double computeChildPrefAreaHeight(Node node, Insets insets) {
        return this.computeChildPrefAreaHeight(node, insets, -1.0);
    }

    double computeChildPrefAreaHeight(Node node, Insets insets, double d) {
        double d2 = insets != null ? this.snapSpaceY(insets.getTop()) : 0.0;
        double d3 = insets != null ? this.snapSpaceY(insets.getBottom()) : 0.0;
        double d4 = insets != null ? this.snapSpaceX(insets.getLeft()) : 0.0;
        double d5 = insets != null ? this.snapSpaceX(insets.getRight()) : 0.0;
        double d6 = -1.0;
        if (node.getContentBias() == Orientation.HORIZONTAL) {
            d6 = this.snapSizeX(TextFlow.boundedSize(node.minWidth(-1.0), d != -1.0 ? d - d4 - d5 : node.prefWidth(-1.0), node.maxWidth(-1.0)));
        }
        return d2 + this.snapSizeY(TextFlow.boundedSize(node.minHeight(d6), node.prefHeight(d6), node.maxHeight(d6))) + d3;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case TEXT: {
                String string = this.getAccessibleText();
                if (string != null && !string.isEmpty()) {
                    return string;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (Node node : this.getChildren()) {
                    Object object = node.queryAccessibleAttribute(AccessibleAttribute.TEXT, objectArray);
                    if (object == null) continue;
                    stringBuilder.append(object.toString());
                }
                return stringBuilder.toString();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    private static void initAccessor() {
        TextFlowHelper.setAccessor(new TextFlowHelper.Accessor(){

            @Override
            public TextLayout getTextLayout(TextFlow textFlow) {
                return textFlow.getTextLayout();
            }
        });
    }

    public final LayoutInfo getLayoutInfo() {
        return new PrismLayoutInfo(this, this.getTextLayout()){
            final /* synthetic */ TextFlow this$0;
            {
                TextFlow textFlow2 = textFlow;
                Objects.requireNonNull(textFlow2);
                this.this$0 = textFlow2;
                super(textLayout);
            }

            @Override
            public double lineSpacing() {
                return this.this$0.getLineSpacing();
            }

            @Override
            protected double dx() {
                return this.this$0.snappedLeftInset();
            }

            @Override
            protected double dy() {
                return this.this$0.snappedTopInset();
            }
        };
    }

    static {
        TextFlow.initAccessor();
    }

    private static class EmbeddedSpan
    implements TextSpan {
        RectBounds bounds;
        Node node;

        public EmbeddedSpan(Node node, double d, double d2, double d3) {
            this.node = node;
            this.bounds = new RectBounds(0.0f, (float)(-d), (float)d2, (float)(d3 - d));
        }

        @Override
        public String getText() {
            return "\ufffc";
        }

        @Override
        public Object getFont() {
            return null;
        }

        @Override
        public RectBounds getBounds() {
            return this.bounds;
        }

        public Node getNode() {
            return this.node;
        }

        @Override
        public Region getLayoutRootRegion() {
            Parent parent = this.node.getParent();
            if (parent instanceof TextFlow) {
                TextFlow textFlow = (TextFlow)parent;
                return textFlow;
            }
            return null;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<TextFlow, TextAlignment> TEXT_ALIGNMENT = new CssMetaData<TextFlow, TextAlignment>("-fx-text-alignment", new EnumConverter<TextAlignment>(TextAlignment.class), TextAlignment.LEFT){

            @Override
            public boolean isSettable(TextFlow textFlow) {
                return textFlow.textAlignment == null || !textFlow.textAlignment.isBound();
            }

            @Override
            public StyleableProperty<TextAlignment> getStyleableProperty(TextFlow textFlow) {
                return (StyleableProperty)textFlow.textAlignmentProperty();
            }
        };
        private static final CssMetaData<TextFlow, Number> LINE_SPACING = new CssMetaData<TextFlow, Number>("-fx-line-spacing", SizeConverter.getInstance(), (Number)0){

            @Override
            public boolean isSettable(TextFlow textFlow) {
                return textFlow.lineSpacing == null || !textFlow.lineSpacing.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TextFlow textFlow) {
                return (StyleableProperty)textFlow.lineSpacingProperty();
            }
        };
        private static final CssMetaData<TextFlow, Number> TAB_SIZE = new CssMetaData<TextFlow, Number>("-fx-tab-size", SizeConverter.getInstance(), (Number)8){

            @Override
            public boolean isSettable(TextFlow textFlow) {
                return textFlow.tabSize == null || !textFlow.tabSize.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TextFlow textFlow) {
                return (StyleableProperty)textFlow.tabSizeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(Pane.getClassCssMetaData());
            arrayList.add(TEXT_ALIGNMENT);
            arrayList.add(LINE_SPACING);
            arrayList.add(TAB_SIZE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

