/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.TrackableObservableList;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.StyleableProperty;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.TitledPane;
import javafx.scene.control.skin.AccordionSkin;

public class Accordion
extends Control {
    private boolean biasDirty = true;
    private Orientation bias;
    private final ObservableList<TitledPane> panes = new TrackableObservableList<TitledPane>(this){
        final /* synthetic */ Accordion this$0;
        {
            Accordion accordion2 = accordion;
            Objects.requireNonNull(accordion2);
            this.this$0 = accordion2;
        }

        protected void onChanged(ListChangeListener.Change<TitledPane> change) {
            block0: while (change.next()) {
                if (!change.wasRemoved() || this.this$0.expandedPane.isBound()) continue;
                for (TitledPane titledPane : change.getRemoved()) {
                    if (change.getAddedSubList().contains(titledPane) || this.this$0.getExpandedPane() != titledPane) continue;
                    this.this$0.setExpandedPane(null);
                    continue block0;
                }
            }
        }
    };
    private ObjectProperty<TitledPane> expandedPane = new ObjectPropertyBase<TitledPane>(this){
        private TitledPane oldValue;
        final /* synthetic */ Accordion this$0;
        {
            Accordion accordion2 = accordion;
            Objects.requireNonNull(accordion2);
            this.this$0 = accordion2;
        }

        protected void invalidated() {
            TitledPane titledPane = (TitledPane)this.get();
            if (titledPane != null) {
                titledPane.setExpanded(true);
            } else if (this.oldValue != null) {
                this.oldValue.setExpanded(false);
            }
            this.oldValue = titledPane;
        }

        public String getName() {
            return "expandedPane";
        }

        public Object getBean() {
            return this.this$0;
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "accordion";

    public Accordion() {
        this(null);
    }

    public Accordion(TitledPane ... titledPaneArray) {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        if (titledPaneArray != null) {
            this.getPanes().addAll((Object[])titledPaneArray);
        }
        ((StyleableProperty)this.focusTraversableProperty()).applyStyle(null, (Object)Boolean.FALSE);
    }

    public final void setExpandedPane(TitledPane titledPane) {
        this.expandedPaneProperty().set((Object)titledPane);
    }

    public final TitledPane getExpandedPane() {
        return (TitledPane)this.expandedPane.get();
    }

    public final ObjectProperty<TitledPane> expandedPaneProperty() {
        return this.expandedPane;
    }

    public final ObservableList<TitledPane> getPanes() {
        return this.panes;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new AccordionSkin(this);
    }

    public void requestLayout() {
        this.biasDirty = true;
        this.bias = null;
        super.requestLayout();
    }

    public Orientation getContentBias() {
        if (this.biasDirty) {
            this.bias = null;
            List list = this.getManagedChildren();
            for (Node node : list) {
                Orientation orientation = node.getContentBias();
                if (orientation == null) continue;
                this.bias = orientation;
                if (orientation != Orientation.HORIZONTAL) continue;
                break;
            }
            this.biasDirty = false;
        }
        return this.bias;
    }

    @Override
    protected Boolean getInitialFocusTraversable() {
        return Boolean.FALSE;
    }
}

