/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.beans.IDProperty;
import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.scene.control.ContextMenuContent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.skin.ContextMenuSkin;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.VBox;

@IDProperty(value="id")
public class MenuItem
implements EventTarget,
Styleable {
    private final ObservableList<String> styleClass = FXCollections.observableArrayList();
    final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);
    private Object userData;
    private ObservableMap<Object, Object> properties;
    private StringProperty id;
    private StringProperty style;
    private ReadOnlyObjectWrapper<Menu> parentMenu;
    private ReadOnlyObjectWrapper<ContextMenu> parentPopup;
    private StringProperty text;
    private ObjectProperty<Node> graphic;
    private ObjectProperty<EventHandler<ActionEvent>> onAction;
    public static final EventType<Event> MENU_VALIDATION_EVENT = new EventType(Event.ANY, "MENU_VALIDATION_EVENT");
    private ObjectProperty<EventHandler<Event>> onMenuValidation;
    private BooleanProperty disable;
    private BooleanProperty visible;
    private ObjectProperty<KeyCombination> accelerator;
    private BooleanProperty mnemonicParsing;
    private static final String DEFAULT_STYLE_CLASS = "menu-item";

    public MenuItem() {
        this(null, null);
    }

    public MenuItem(String string) {
        this(string, null);
    }

    public MenuItem(String string, Node node) {
        this.setText(string);
        this.setGraphic(node);
        this.styleClass.add((Object)DEFAULT_STYLE_CLASS);
    }

    public final void setId(String string) {
        this.idProperty().set((Object)string);
    }

    public final String getId() {
        return this.id == null ? null : (String)this.id.get();
    }

    public final StringProperty idProperty() {
        if (this.id == null) {
            this.id = new SimpleStringProperty((Object)this, "id");
        }
        return this.id;
    }

    public final void setStyle(String string) {
        this.styleProperty().set((Object)string);
    }

    public final String getStyle() {
        return this.style == null ? null : (String)this.style.get();
    }

    public final StringProperty styleProperty() {
        if (this.style == null) {
            this.style = new SimpleStringProperty((Object)this, "style");
        }
        return this.style;
    }

    protected final void setParentMenu(Menu menu) {
        this.parentMenuPropertyImpl().set((Object)menu);
    }

    public final Menu getParentMenu() {
        return this.parentMenu == null ? null : (Menu)this.parentMenu.get();
    }

    public final ReadOnlyObjectProperty<Menu> parentMenuProperty() {
        return this.parentMenuPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Menu> parentMenuPropertyImpl() {
        if (this.parentMenu == null) {
            this.parentMenu = new ReadOnlyObjectWrapper((Object)this, "parentMenu");
        }
        return this.parentMenu;
    }

    protected final void setParentPopup(ContextMenu contextMenu) {
        this.parentPopupPropertyImpl().set((Object)contextMenu);
    }

    public final ContextMenu getParentPopup() {
        return this.parentPopup == null ? null : (ContextMenu)this.parentPopup.get();
    }

    public final ReadOnlyObjectProperty<ContextMenu> parentPopupProperty() {
        return this.parentPopupPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<ContextMenu> parentPopupPropertyImpl() {
        if (this.parentPopup == null) {
            this.parentPopup = new ReadOnlyObjectWrapper((Object)this, "parentPopup");
        }
        return this.parentPopup;
    }

    public final void setText(String string) {
        this.textProperty().set((Object)string);
    }

    public final String getText() {
        return this.text == null ? null : (String)this.text.get();
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new SimpleStringProperty((Object)this, "text");
        }
        return this.text;
    }

    public final void setGraphic(Node node) {
        this.graphicProperty().set((Object)node);
    }

    public final Node getGraphic() {
        return this.graphic == null ? null : (Node)this.graphic.get();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new SimpleObjectProperty((Object)this, "graphic");
        }
        return this.graphic;
    }

    public final void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.onActionProperty().set(eventHandler);
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return this.onAction == null ? null : (EventHandler)this.onAction.get();
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        if (this.onAction == null) {
            this.onAction = new ObjectPropertyBase<EventHandler<ActionEvent>>(this){
                final /* synthetic */ MenuItem this$0;
                {
                    MenuItem menuItem2 = menuItem;
                    Objects.requireNonNull(menuItem2);
                    this.this$0 = menuItem2;
                }

                protected void invalidated() {
                    this.this$0.eventHandlerManager.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "onAction";
                }
            };
        }
        return this.onAction;
    }

    public final void setOnMenuValidation(EventHandler<Event> eventHandler) {
        this.onMenuValidationProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnMenuValidation() {
        return this.onMenuValidation == null ? null : (EventHandler)this.onMenuValidation.get();
    }

    public final ObjectProperty<EventHandler<Event>> onMenuValidationProperty() {
        if (this.onMenuValidation == null) {
            this.onMenuValidation = new ObjectPropertyBase<EventHandler<Event>>(this){
                final /* synthetic */ MenuItem this$0;
                {
                    MenuItem menuItem2 = menuItem;
                    Objects.requireNonNull(menuItem2);
                    this.this$0 = menuItem2;
                }

                protected void invalidated() {
                    this.this$0.eventHandlerManager.setEventHandler(MENU_VALIDATION_EVENT, (EventHandler)this.get());
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "onMenuValidation";
                }
            };
        }
        return this.onMenuValidation;
    }

    public final void setDisable(boolean bl) {
        this.disableProperty().set(bl);
    }

    public final boolean isDisable() {
        return this.disable == null ? false : this.disable.get();
    }

    public final BooleanProperty disableProperty() {
        if (this.disable == null) {
            this.disable = new SimpleBooleanProperty((Object)this, "disable");
        }
        return this.disable;
    }

    public final void setVisible(boolean bl) {
        this.visibleProperty().set(bl);
    }

    public final boolean isVisible() {
        return this.visible == null ? true : this.visible.get();
    }

    public final BooleanProperty visibleProperty() {
        if (this.visible == null) {
            this.visible = new SimpleBooleanProperty((Object)this, "visible", true);
        }
        return this.visible;
    }

    public final void setAccelerator(KeyCombination keyCombination) {
        this.acceleratorProperty().set((Object)keyCombination);
    }

    public final KeyCombination getAccelerator() {
        return this.accelerator == null ? null : (KeyCombination)this.accelerator.get();
    }

    public final ObjectProperty<KeyCombination> acceleratorProperty() {
        if (this.accelerator == null) {
            this.accelerator = new SimpleObjectProperty((Object)this, "accelerator");
        }
        return this.accelerator;
    }

    public final void setMnemonicParsing(boolean bl) {
        this.mnemonicParsingProperty().set(bl);
    }

    public final boolean isMnemonicParsing() {
        return this.mnemonicParsing == null ? true : this.mnemonicParsing.get();
    }

    public final BooleanProperty mnemonicParsingProperty() {
        if (this.mnemonicParsing == null) {
            this.mnemonicParsing = new SimpleBooleanProperty((Object)this, "mnemonicParsing", true);
        }
        return this.mnemonicParsing;
    }

    public ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    public void fire() {
        Event.fireEvent((EventTarget)this, (Event)new ActionEvent((Object)this, (EventTarget)this));
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        if (this.getParentPopup() != null) {
            this.getParentPopup().buildEventDispatchChain(eventDispatchChain);
        }
        if (this.getParentMenu() != null) {
            this.getParentMenu().buildEventDispatchChain(eventDispatchChain);
        }
        return eventDispatchChain.prepend((EventDispatcher)this.eventHandlerManager);
    }

    public <E extends Event> void addEventHandler(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    public <E extends Event> void removeEventHandler(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    public <E extends Event> void addEventFilter(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.addEventFilter(eventType, eventHandler);
    }

    public <E extends Event> void removeEventFilter(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.removeEventFilter(eventType, eventHandler);
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public String getTypeSelector() {
        return "MenuItem";
    }

    public Styleable getStyleableParent() {
        if (this.getParentMenu() == null) {
            return this.getParentPopup();
        }
        return this.getParentMenu();
    }

    public final ObservableSet<PseudoClass> getPseudoClassStates() {
        return FXCollections.emptyObservableSet();
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Collections.emptyList();
    }

    public Node getStyleableNode() {
        ContextMenu contextMenu = this.getParentPopup();
        if (contextMenu == null || !(contextMenu.getSkin() instanceof ContextMenuSkin)) {
            return null;
        }
        ContextMenuSkin contextMenuSkin = (ContextMenuSkin)contextMenu.getSkin();
        if (!(contextMenuSkin.getNode() instanceof ContextMenuContent)) {
            return null;
        }
        ContextMenuContent contextMenuContent = (ContextMenuContent)contextMenuSkin.getNode();
        VBox vBox = contextMenuContent.getItemsContainer();
        MenuItem menuItem = this;
        ObservableList observableList = vBox.getChildrenUnmodifiable();
        for (int i = 0; i < observableList.size(); ++i) {
            ContextMenuContent.MenuItemContainer menuItemContainer;
            if (!(observableList.get(i) instanceof ContextMenuContent.MenuItemContainer) || !menuItem.equals((menuItemContainer = (ContextMenuContent.MenuItemContainer)((Object)observableList.get(i))).getItem())) continue;
            return menuItemContainer;
        }
        return null;
    }

    public String toString() {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        boolean bl2 = this.id != null && !"".equals(this.getId());
        boolean bl3 = bl = !this.getStyleClass().isEmpty();
        if (!bl2) {
            stringBuilder.append('@');
            stringBuilder.append(Integer.toHexString(this.hashCode()));
        } else {
            stringBuilder.append("[id=");
            stringBuilder.append(this.getId());
            if (!bl) {
                stringBuilder.append("]");
            }
        }
        if (bl) {
            if (!bl2) {
                stringBuilder.append('[');
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append("styleClass=");
            stringBuilder.append(this.getStyleClass());
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }
}

