/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.Objects;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.css.PseudoClass;
import javafx.css.StyleableProperty;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ProgressIndicatorSkin;

public class ProgressIndicator
extends Control {
    public static final double INDETERMINATE_PROGRESS = -1.0;
    private ReadOnlyBooleanWrapper indeterminate;
    private DoubleProperty progress;
    private static final String DEFAULT_STYLE_CLASS = "progress-indicator";
    private static final PseudoClass PSEUDO_CLASS_DETERMINATE = PseudoClass.getPseudoClass((String)"determinate");
    private static final PseudoClass PSEUDO_CLASS_INDETERMINATE = PseudoClass.getPseudoClass((String)"indeterminate");

    public ProgressIndicator() {
        this(-1.0);
    }

    public ProgressIndicator(double d) {
        ((StyleableProperty)this.focusTraversableProperty()).applyStyle(null, (Object)Boolean.FALSE);
        this.setProgress(d);
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.PROGRESS_INDICATOR);
        int n = Double.compare(-1.0, d);
        this.pseudoClassStateChanged(PSEUDO_CLASS_INDETERMINATE, n == 0);
        this.pseudoClassStateChanged(PSEUDO_CLASS_DETERMINATE, n != 0);
    }

    private void setIndeterminate(boolean bl) {
        this.indeterminatePropertyImpl().set(bl);
    }

    public final boolean isIndeterminate() {
        return this.indeterminate == null ? true : this.indeterminate.get();
    }

    public final ReadOnlyBooleanProperty indeterminateProperty() {
        return this.indeterminatePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper indeterminatePropertyImpl() {
        if (this.indeterminate == null) {
            this.indeterminate = new ReadOnlyBooleanWrapper(this, true){
                final /* synthetic */ ProgressIndicator this$0;
                {
                    ProgressIndicator progressIndicator2 = progressIndicator;
                    Objects.requireNonNull(progressIndicator2);
                    this.this$0 = progressIndicator2;
                    super(bl);
                }

                protected void invalidated() {
                    boolean bl = this.get();
                    this.this$0.pseudoClassStateChanged(PSEUDO_CLASS_INDETERMINATE, bl);
                    this.this$0.pseudoClassStateChanged(PSEUDO_CLASS_DETERMINATE, !bl);
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "indeterminate";
                }
            };
        }
        return this.indeterminate;
    }

    public final void setProgress(double d) {
        this.progressProperty().set(d);
    }

    public final double getProgress() {
        return this.progress == null ? -1.0 : this.progress.get();
    }

    public final DoubleProperty progressProperty() {
        if (this.progress == null) {
            this.progress = new DoublePropertyBase(this, -1.0){
                final /* synthetic */ ProgressIndicator this$0;
                {
                    ProgressIndicator progressIndicator2 = progressIndicator;
                    Objects.requireNonNull(progressIndicator2);
                    this.this$0 = progressIndicator2;
                    super(d);
                }

                protected void invalidated() {
                    this.this$0.setIndeterminate(this.this$0.getProgress() < 0.0);
                }

                public Object getBean() {
                    return this.this$0;
                }

                public String getName() {
                    return "progress";
                }
            };
        }
        return this.progress;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ProgressIndicatorSkin(this);
    }

    @Override
    protected Boolean getInitialFocusTraversable() {
        return Boolean.FALSE;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case VALUE: {
                return this.getProgress();
            }
            case MAX_VALUE: {
                return 1.0;
            }
            case MIN_VALUE: {
                return 0.0;
            }
            case INDETERMINATE: {
                return this.isIndeterminate();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }
}

