/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.LambdaMultiplePropertyChangeListenerHandler;
import com.sun.javafx.scene.control.Properties;
import com.sun.javafx.scene.control.TabObservableList;
import com.sun.javafx.scene.control.behavior.TabPaneBehavior;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import com.sun.javafx.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;
import javafx.util.Pair;

public class TabPaneSkin
extends SkinBase<TabPane> {
    static int CLOSE_BTN_SIZE = 16;
    private static final double ANIMATION_SPEED = 150.0;
    private static final int SPACER = 10;
    private TabHeaderArea tabHeaderArea;
    private ObservableList<TabContentRegion> tabContentRegions;
    private Rectangle clipRect;
    private Rectangle tabHeaderAreaClipRect;
    private Tab selectedTab;
    private final TabPaneBehavior behavior;
    private ObjectProperty<TabAnimation> openTabAnimation = new StyleableObjectProperty<TabAnimation>(this, TabAnimation.GROW){
        final /* synthetic */ TabPaneSkin this$0;
        {
            TabPaneSkin tabPaneSkin2 = tabPaneSkin;
            Objects.requireNonNull(tabPaneSkin2);
            this.this$0 = tabPaneSkin2;
            super((Object)tabAnimation);
        }

        public CssMetaData<TabPane, TabAnimation> getCssMetaData() {
            return StyleableProperties.OPEN_TAB_ANIMATION;
        }

        public Object getBean() {
            return this.this$0;
        }

        public String getName() {
            return "openTabAnimation";
        }
    };
    private ObjectProperty<TabAnimation> closeTabAnimation = new StyleableObjectProperty<TabAnimation>(this, TabAnimation.GROW){
        final /* synthetic */ TabPaneSkin this$0;
        {
            TabPaneSkin tabPaneSkin2 = tabPaneSkin;
            Objects.requireNonNull(tabPaneSkin2);
            this.this$0 = tabPaneSkin2;
            super((Object)tabAnimation);
        }

        public CssMetaData<TabPane, TabAnimation> getCssMetaData() {
            return StyleableProperties.CLOSE_TAB_ANIMATION;
        }

        public Object getBean() {
            return this.this$0;
        }

        public String getName() {
            return "closeTabAnimation";
        }
    };
    private SelectionModel<Tab> selectionModel;
    private InvalidationListener selectionChangeListener = observable -> {
        this.tabHeaderArea.invalidateScrollOffset();
        this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        ((TabPane)this.getSkinnable()).requestLayout();
    };
    private WeakInvalidationListener weakSelectionChangeListener = new WeakInvalidationListener(this.selectionChangeListener);
    ListChangeListener<Tab> tabsListener;
    WeakListChangeListener<Tab> weakTabsListener;
    private static final PseudoClass SELECTED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"selected");
    private static final PseudoClass TOP_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"top");
    private static final PseudoClass BOTTOM_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"bottom");
    private static final PseudoClass LEFT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"left");
    private static final PseudoClass RIGHT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"right");
    private static final PseudoClass DISABLED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"disabled");
    private EventHandler<MouseEvent> headerDraggedHandler = this::handleHeaderDragged;
    private EventHandler<MouseEvent> headerMousePressedHandler = this::handleHeaderMousePressed;
    private EventHandler<MouseEvent> headerMouseReleasedHandler = this::handleHeaderMouseReleased;
    private int dragTabHeaderStartIndex;
    private int dragTabHeaderIndex;
    private TabHeaderSkin dragTabHeader;
    private TabHeaderSkin dropTabHeader;
    private StackPane headersRegion;
    private DragState dragState;
    private final int MIN_TO_MAX = 1;
    private final int MAX_TO_MIN = -1;
    private int xLayoutDirection;
    private double dragEventPrevLoc;
    private int prevDragDirection = 1;
    private final double DRAG_DIST_THRESHOLD = 0.75;
    private final double ANIM_DURATION = 120.0;
    private TabHeaderSkin dropAnimHeader;
    private double dropHeaderSourceX;
    private double dropHeaderTransitionX;
    private final Animation dropHeaderAnim = new Transition(this){
        final /* synthetic */ TabPaneSkin this$0;
        {
            TabPaneSkin tabPaneSkin2 = tabPaneSkin;
            Objects.requireNonNull(tabPaneSkin2);
            this.this$0 = tabPaneSkin2;
            this.setInterpolator(Interpolator.EASE_BOTH);
            this.setCycleDuration(Duration.millis((double)120.0));
            this.setOnFinished(actionEvent -> this.this$0.completeHeaderReordering());
        }

        protected void interpolate(double d) {
            this.this$0.dropAnimHeader.setLayoutX(this.this$0.dropHeaderSourceX + this.this$0.dropHeaderTransitionX * d);
        }
    };
    private double dragHeaderDestX;
    private double dragHeaderSourceX;
    private double dragHeaderTransitionX;
    private final Animation dragHeaderAnim = new Transition(this){
        final /* synthetic */ TabPaneSkin this$0;
        {
            TabPaneSkin tabPaneSkin2 = tabPaneSkin;
            Objects.requireNonNull(tabPaneSkin2);
            this.this$0 = tabPaneSkin2;
            this.setInterpolator(Interpolator.EASE_OUT);
            this.setCycleDuration(Duration.millis((double)120.0));
            this.setOnFinished(actionEvent -> {
                this.this$0.reorderTabs();
                this.this$0.resetDrag();
            });
        }

        protected void interpolate(double d) {
            this.this$0.dragTabHeader.setLayoutX(this.this$0.dragHeaderSourceX + this.this$0.dragHeaderTransitionX * d);
        }
    };
    private ListChangeListener childListener = new ListChangeListener<Node>(this){
        final /* synthetic */ TabPaneSkin this$0;
        {
            TabPaneSkin tabPaneSkin2 = tabPaneSkin;
            Objects.requireNonNull(tabPaneSkin2);
            this.this$0 = tabPaneSkin2;
        }

        public void onChanged(ListChangeListener.Change<? extends Node> change) {
            while (change.next()) {
                if (change.wasAdded()) {
                    for (Node node : change.getAddedSubList()) {
                        this.this$0.addReorderListeners(node);
                    }
                }
                if (!change.wasRemoved()) continue;
                for (Node node : change.getRemoved()) {
                    this.this$0.removeReorderListeners(node);
                }
            }
        }
    };

    public TabPaneSkin(TabPane tabPane) {
        super(tabPane);
        this.behavior = new TabPaneBehavior(tabPane);
        this.clipRect = new Rectangle(tabPane.getWidth(), tabPane.getHeight());
        ((TabPane)this.getSkinnable()).setClip((Node)this.clipRect);
        this.tabContentRegions = FXCollections.observableArrayList();
        for (Tab tab : ((TabPane)this.getSkinnable()).getTabs()) {
            this.addTabContent(tab);
        }
        this.tabHeaderAreaClipRect = new Rectangle();
        this.tabHeaderArea = new TabHeaderArea(this);
        this.tabHeaderArea.setClip((Node)this.tabHeaderAreaClipRect);
        this.getChildren().add((Object)this.tabHeaderArea);
        if (((TabPane)this.getSkinnable()).getTabs().size() == 0) {
            this.tabHeaderArea.setVisible(false);
        }
        this.initializeTabListener();
        this.updateSelectionModel();
        this.registerChangeListener((ObservableValue<?>)tabPane.selectionModelProperty(), observableValue -> this.updateSelectionModel());
        this.registerChangeListener((ObservableValue<?>)tabPane.sideProperty(), observableValue -> this.updateTabPosition());
        this.registerChangeListener((ObservableValue<?>)tabPane.widthProperty(), observableValue -> {
            this.tabHeaderArea.invalidateScrollOffset();
            this.clipRect.setWidth(((TabPane)this.getSkinnable()).getWidth());
        });
        this.registerChangeListener((ObservableValue<?>)tabPane.heightProperty(), observableValue -> {
            this.tabHeaderArea.invalidateScrollOffset();
            this.clipRect.setHeight(((TabPane)this.getSkinnable()).getHeight());
        });
        this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        if (this.selectedTab == null && ((TabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex() != -1) {
            ((TabPane)this.getSkinnable()).getSelectionModel().select(((TabPane)this.getSkinnable()).getSelectionModel().getSelectedIndex());
            this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        }
        if (this.selectedTab == null) {
            ((TabPane)this.getSkinnable()).getSelectionModel().selectFirst();
        }
        this.selectedTab = (Tab)((TabPane)this.getSkinnable()).getSelectionModel().getSelectedItem();
        this.initializeSwipeHandlers();
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        if (this.selectionModel != null) {
            this.selectionModel.selectedItemProperty().removeListener((InvalidationListener)this.weakSelectionChangeListener);
            this.selectionModel = null;
        }
        ((TabPane)this.getSkinnable()).getTabs().removeListener(this.weakTabsListener);
        this.tabHeaderArea.dispose();
        this.getChildren().remove((Object)this.tabHeaderArea);
        for (Tab tab : ((TabPane)this.getSkinnable()).getTabs()) {
            this.removeTabContent(tab);
        }
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        double d6 = 0.0;
        for (TabContentRegion tabContentRegion : this.tabContentRegions) {
            double d7 = tabContentRegion.getContentBias() == Orientation.VERTICAL ? Math.max(0.0, tabContentRegion.prefHeight(-1.0) - d2 - d4) : -1.0;
            d6 = Math.max(d6, this.snapSizeX(tabContentRegion.prefWidth(d7)));
        }
        boolean bl = this.isHorizontal();
        double d8 = bl ? this.snapSizeX(this.tabHeaderArea.prefWidth(-1.0)) : this.snapSizeY(this.tabHeaderArea.prefHeight(-1.0));
        double d9 = bl ? Math.max(d6, d8) : d6 + d8;
        return this.snapSizeX(d9) + d3 + d5;
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        double d6 = 0.0;
        for (TabContentRegion tabContentRegion : this.tabContentRegions) {
            double d7 = tabContentRegion.getContentBias() == Orientation.HORIZONTAL ? Math.max(0.0, tabContentRegion.prefWidth(-1.0) - d5 - d3) : -1.0;
            d6 = Math.max(d6, this.snapSizeY(tabContentRegion.prefHeight(d7)));
        }
        boolean bl = this.isHorizontal();
        double d8 = bl ? this.snapSizeY(this.tabHeaderArea.prefHeight(-1.0)) : this.snapSizeX(this.tabHeaderArea.prefWidth(-1.0));
        double d9 = bl ? d6 + this.snapSizeY(d8) : Math.max(d6, d8);
        return this.snapSizeY(d9) + d2 + d4;
    }

    @Override
    public double computeBaselineOffset(double d, double d2, double d3, double d4) {
        Side side = ((TabPane)this.getSkinnable()).getSide();
        if (side == Side.TOP) {
            return this.tabHeaderArea.getBaselineOffset() + d;
        }
        return 0.0;
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        TabPane tabPane = (TabPane)this.getSkinnable();
        Side side = tabPane.getSide();
        double d5 = side.isHorizontal() ? this.snapSizeY(this.tabHeaderArea.prefHeight(-1.0)) : this.snapSizeX(this.tabHeaderArea.prefHeight(-1.0));
        double d6 = side.equals((Object)Side.RIGHT) ? d + d3 - d5 : d;
        double d7 = side.equals((Object)Side.BOTTOM) ? d2 + d4 - d5 : d2;
        double d8 = this.snappedLeftInset();
        double d9 = this.snappedTopInset();
        if (side == Side.TOP) {
            this.tabHeaderArea.resize(d3, d5);
            this.tabHeaderArea.relocate(d6, d7);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add((Object)new Rotate((double)TabPaneSkin.getRotation(Side.TOP)));
        } else if (side == Side.BOTTOM) {
            this.tabHeaderArea.resize(d3, d5);
            this.tabHeaderArea.relocate(d3 + d8, d7 - d5);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add((Object)new Rotate((double)TabPaneSkin.getRotation(Side.BOTTOM), 0.0, d5));
        } else if (side == Side.LEFT) {
            this.tabHeaderArea.resize(d4, d5);
            this.tabHeaderArea.relocate(d6 + d5, d4 - d5 + d9);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add((Object)new Rotate((double)TabPaneSkin.getRotation(Side.LEFT), 0.0, d5));
        } else if (side == Side.RIGHT) {
            this.tabHeaderArea.resize(d4, d5);
            this.tabHeaderArea.relocate(d6, d2 - d5);
            this.tabHeaderArea.getTransforms().clear();
            this.tabHeaderArea.getTransforms().add((Object)new Rotate((double)TabPaneSkin.getRotation(Side.RIGHT), 0.0, d5));
        }
        this.tabHeaderAreaClipRect.setX(0.0);
        this.tabHeaderAreaClipRect.setY(0.0);
        if (this.isHorizontal()) {
            this.tabHeaderAreaClipRect.setWidth(d3);
        } else {
            this.tabHeaderAreaClipRect.setWidth(d4);
        }
        this.tabHeaderAreaClipRect.setHeight(d5);
        double d10 = 0.0;
        double d11 = 0.0;
        if (side == Side.TOP) {
            d10 = d;
            d11 = d2 + d5;
            if (this.isFloatingStyleClass()) {
                d11 -= 1.0;
            }
        } else if (side == Side.BOTTOM) {
            d10 = d;
            d11 = d2 + d9;
            if (this.isFloatingStyleClass()) {
                d11 = 1.0 + d9;
            }
        } else if (side == Side.LEFT) {
            d10 = d + d5;
            d11 = d2;
            if (this.isFloatingStyleClass()) {
                d10 -= 1.0;
            }
        } else if (side == Side.RIGHT) {
            d10 = d + d8;
            d11 = d2;
            if (this.isFloatingStyleClass()) {
                d10 = 1.0 + d8;
            }
        }
        double d12 = d3 - (this.isHorizontal() ? 0.0 : d5);
        double d13 = d4 - (this.isHorizontal() ? d5 : 0.0);
        int n = this.tabContentRegions.size();
        for (int i = 0; i < n; ++i) {
            TabContentRegion tabContentRegion = (TabContentRegion)((Object)this.tabContentRegions.get(i));
            tabContentRegion.setAlignment(Pos.TOP_LEFT);
            if (tabContentRegion.getClip() != null) {
                ((Rectangle)tabContentRegion.getClip()).setWidth(d12);
                ((Rectangle)tabContentRegion.getClip()).setHeight(d13);
            }
            tabContentRegion.resize(d12, d13);
            tabContentRegion.relocate(d10, d11);
        }
    }

    private void updateSelectionModel() {
        if (this.selectionModel != null) {
            this.selectionModel.selectedItemProperty().removeListener((InvalidationListener)this.weakSelectionChangeListener);
        }
        this.selectionModel = ((TabPane)this.getSkinnable()).getSelectionModel();
        if (this.selectionModel != null) {
            this.selectionModel.selectedItemProperty().addListener((InvalidationListener)this.weakSelectionChangeListener);
        }
    }

    private static int getRotation(Side side) {
        switch (side) {
            case TOP: {
                return 0;
            }
            case BOTTOM: {
                return 180;
            }
            case LEFT: {
                return -90;
            }
            case RIGHT: {
                return 90;
            }
        }
        return 0;
    }

    private static Node clone(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ImageView) {
            ImageView imageView = (ImageView)node;
            ImageView imageView2 = new ImageView();
            imageView2.imageProperty().bind((ObservableValue)imageView.imageProperty());
            return imageView2;
        }
        if (node instanceof Label) {
            Label label = (Label)node;
            Label label2 = new Label(label.getText(), TabPaneSkin.clone(label.getGraphic()));
            label2.textProperty().bind((ObservableValue)label.textProperty());
            return label2;
        }
        return null;
    }

    private void removeTabs(List<? extends Tab> list) {
        for (Tab tab : list) {
            this.stopCurrentAnimation(tab);
            TabHeaderSkin tabHeaderSkin = this.tabHeaderArea.getTabHeaderSkin(tab);
            if (tabHeaderSkin == null) continue;
            tabHeaderSkin.isClosing = true;
            tabHeaderSkin.dispose();
            this.removeTabContent(tab);
            EventHandler eventHandler = actionEvent -> {
                tabHeaderSkin.animationState = TabAnimationState.NONE;
                this.tabHeaderArea.removeTab(tab);
                this.tabHeaderArea.requestLayout();
                if (((TabPane)this.getSkinnable()).getTabs().isEmpty()) {
                    this.tabHeaderArea.setVisible(false);
                }
            };
            if (Platform.isFxApplicationThread() && this.closeTabAnimation.get() == TabAnimation.GROW) {
                tabHeaderSkin.animationState = TabAnimationState.HIDING;
                Timeline timeline = tabHeaderSkin.currentAnimation = this.createTimeline(tabHeaderSkin, Duration.millis((double)150.0), 0.0, (EventHandler<ActionEvent>)eventHandler);
                timeline.play();
                continue;
            }
            eventHandler.handle(null);
        }
    }

    private void stopCurrentAnimation(Tab tab) {
        Timeline timeline;
        TabHeaderSkin tabHeaderSkin = this.tabHeaderArea.getTabHeaderSkin(tab);
        if (tabHeaderSkin != null && (timeline = tabHeaderSkin.currentAnimation) != null && timeline.getStatus() == Animation.Status.RUNNING) {
            timeline.getOnFinished().handle(null);
            timeline.stop();
            tabHeaderSkin.currentAnimation = null;
        }
    }

    private void addTabs(List<? extends Tab> list, int n) {
        int n2 = 0;
        ArrayList arrayList = new ArrayList(this.tabHeaderArea.headersRegion.getChildren());
        for (Node object : arrayList) {
            TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)object;
            if (tabHeaderSkin.animationState != TabAnimationState.HIDING) continue;
            this.stopCurrentAnimation(tabHeaderSkin.tab);
        }
        for (Tab tab : list) {
            this.stopCurrentAnimation(tab);
            if (!this.tabHeaderArea.isVisible()) {
                this.tabHeaderArea.setVisible(true);
            }
            int n3 = n + n2++;
            this.tabHeaderArea.addTab(tab, n3);
            this.addTabContent(tab);
            TabHeaderSkin tabHeaderSkin = this.tabHeaderArea.getTabHeaderSkin(tab);
            if (tabHeaderSkin == null) continue;
            if (Platform.isFxApplicationThread() && this.openTabAnimation.get() == TabAnimation.GROW) {
                tabHeaderSkin.animationState = TabAnimationState.SHOWING;
                tabHeaderSkin.animationTransition.setValue((Number)0.0);
                tabHeaderSkin.setVisible(true);
                tabHeaderSkin.currentAnimation = this.createTimeline(tabHeaderSkin, Duration.millis((double)150.0), 1.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
                    tabHeaderSkin.animationState = TabAnimationState.NONE;
                    tabHeaderSkin.setVisible(true);
                    tabHeaderSkin.inner.requestLayout();
                }));
                tabHeaderSkin.currentAnimation.play();
                continue;
            }
            tabHeaderSkin.setVisible(true);
            tabHeaderSkin.inner.requestLayout();
        }
    }

    private void initializeTabListener() {
        this.tabsListener = change -> {
            Object object;
            Tab tab;
            Object object2;
            Object object3;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            while (change.next()) {
                if (change.wasPermutated() && this.dragState != DragState.REORDER) {
                    object3 = (TabPane)this.getSkinnable();
                    object2 = ((TabPane)object3).getTabs();
                    int n = change.getTo() - change.getFrom();
                    tab = (Tab)((TabPane)object3).getSelectionModel().getSelectedItem();
                    object = new ArrayList(n);
                    ((TabPane)this.getSkinnable()).getSelectionModel().clearSelection();
                    TabAnimation tabAnimation = (TabAnimation)((Object)((Object)this.openTabAnimation.get()));
                    TabAnimation tabAnimation2 = (TabAnimation)((Object)((Object)this.closeTabAnimation.get()));
                    this.openTabAnimation.set((Object)TabAnimation.NONE);
                    this.closeTabAnimation.set((Object)TabAnimation.NONE);
                    for (int i = change.getFrom(); i < change.getTo(); ++i) {
                        object.add((Tab)object2.get(i));
                    }
                    this.removeTabs((List<? extends Tab>)object);
                    this.addTabs((List<? extends Tab>)object, change.getFrom());
                    this.openTabAnimation.set((Object)tabAnimation);
                    this.closeTabAnimation.set((Object)tabAnimation2);
                    ((TabPane)this.getSkinnable()).getSelectionModel().select(tab);
                }
                if (change.wasRemoved()) {
                    arrayList.addAll(change.getRemoved());
                }
                if (!change.wasAdded()) continue;
                arrayList2.addAll(change.getAddedSubList());
            }
            arrayList.removeAll(arrayList2);
            this.removeTabs(arrayList);
            object3 = new ArrayList();
            if (!arrayList2.isEmpty()) {
                for (TabContentRegion tabContentRegion : this.tabContentRegions) {
                    int n;
                    tab = tabContentRegion.getTab();
                    object = this.tabHeaderArea.getTabHeaderSkin(tab);
                    if (((TabHeaderSkin)((Object)((Object)object))).isClosing || !arrayList2.contains(tabContentRegion.getTab())) continue;
                    arrayList2.remove(tabContentRegion.getTab());
                    int n2 = ((TabPane)this.getSkinnable()).getTabs().indexOf((Object)tab);
                    if (n2 == (n = this.tabHeaderArea.headersRegion.getChildren().indexOf(object))) continue;
                    object3.add(new Pair((Object)n2, object));
                }
                if (!arrayList2.isEmpty()) {
                    this.addTabs(arrayList2, ((TabPane)this.getSkinnable()).getTabs().indexOf(arrayList2.get(0)));
                }
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    Pair pair = (Pair)object2.next();
                    this.tabHeaderArea.moveTab((Integer)pair.getKey(), (TabHeaderSkin)((Object)((Object)pair.getValue())));
                }
            }
            ((TabPane)this.getSkinnable()).requestLayout();
        };
        this.weakTabsListener = new WeakListChangeListener(this.tabsListener);
        ((TabPane)this.getSkinnable()).getTabs().addListener(this.weakTabsListener);
    }

    private void addTabContent(Tab tab) {
        TabContentRegion tabContentRegion = new TabContentRegion(tab);
        tabContentRegion.setClip((Node)new Rectangle());
        this.tabContentRegions.add((Object)tabContentRegion);
        this.getChildren().add(0, (Object)tabContentRegion);
    }

    private void removeTabContent(Tab tab) {
        for (TabContentRegion tabContentRegion : this.tabContentRegions) {
            if (!tabContentRegion.getTab().equals(tab)) continue;
            this.removeTabContent(tabContentRegion);
            break;
        }
    }

    private void removeTabContent(TabContentRegion tabContentRegion) {
        tabContentRegion.dispose();
        this.tabContentRegions.remove((Object)tabContentRegion);
        this.getChildren().remove((Object)tabContentRegion);
    }

    private void updateTabPosition() {
        this.tabHeaderArea.invalidateScrollOffset();
        ((TabPane)this.getSkinnable()).applyCss();
        ((TabPane)this.getSkinnable()).requestLayout();
    }

    private Timeline createTimeline(TabHeaderSkin tabHeaderSkin, Duration duration, double d, EventHandler<ActionEvent> eventHandler) {
        Timeline timeline = new Timeline();
        timeline.setCycleCount(1);
        KeyValue keyValue = new KeyValue((WritableValue)tabHeaderSkin.animationTransition, (Object)d, Interpolator.LINEAR);
        timeline.getKeyFrames().clear();
        timeline.getKeyFrames().add((Object)new KeyFrame(duration, new KeyValue[]{keyValue}));
        timeline.setOnFinished(eventHandler);
        return timeline;
    }

    private boolean isHorizontal() {
        Side side = ((TabPane)this.getSkinnable()).getSide();
        return Side.TOP.equals((Object)side) || Side.BOTTOM.equals((Object)side);
    }

    private void initializeSwipeHandlers() {
        if (Properties.IS_TOUCH_SUPPORTED) {
            ((TabPane)this.getSkinnable()).addEventHandler(SwipeEvent.SWIPE_LEFT, swipeEvent -> this.behavior.selectNextTab());
            ((TabPane)this.getSkinnable()).addEventHandler(SwipeEvent.SWIPE_RIGHT, swipeEvent -> this.behavior.selectPreviousTab());
        }
    }

    private boolean isFloatingStyleClass() {
        return ((TabPane)this.getSkinnable()).getStyleClass().contains((Object)"floating");
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TabPaneSkin.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case FOCUS_ITEM: {
                return this.tabHeaderArea.getTabHeaderSkin(this.selectedTab);
            }
            case ITEM_COUNT: {
                return this.tabHeaderArea.headersRegion.getChildren().size();
            }
            case ITEM_AT_INDEX: {
                Integer n = (Integer)objectArray[0];
                if (n == null) {
                    return null;
                }
                return this.tabHeaderArea.headersRegion.getChildren().get(n.intValue());
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    private void addReorderListeners(Node node) {
        node.addEventHandler(MouseEvent.MOUSE_PRESSED, this.headerMousePressedHandler);
        node.addEventHandler(MouseEvent.MOUSE_RELEASED, this.headerMouseReleasedHandler);
        node.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.headerDraggedHandler);
    }

    private void removeReorderListeners(Node node) {
        node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.headerMousePressedHandler);
        node.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.headerMouseReleasedHandler);
        node.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.headerDraggedHandler);
    }

    private void updateListeners() {
        if (((TabPane)this.getSkinnable()).getTabDragPolicy() == TabPane.TabDragPolicy.FIXED || ((TabPane)this.getSkinnable()).getTabDragPolicy() == null) {
            for (Node node : this.headersRegion.getChildren()) {
                this.removeReorderListeners(node);
            }
            this.headersRegion.getChildren().removeListener(this.childListener);
        } else if (((TabPane)this.getSkinnable()).getTabDragPolicy() == TabPane.TabDragPolicy.REORDER) {
            for (Node node : this.headersRegion.getChildren()) {
                this.addReorderListeners(node);
            }
            this.headersRegion.getChildren().addListener(this.childListener);
        }
    }

    private void setupReordering(StackPane stackPane) {
        this.dragState = DragState.NONE;
        this.headersRegion = stackPane;
        this.updateListeners();
        this.registerChangeListener((ObservableValue<?>)((TabPane)this.getSkinnable()).tabDragPolicyProperty(), observableValue -> this.updateListeners());
    }

    private void handleHeaderMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.startDrag(mouseEvent);
        }
    }

    private void handleHeaderMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.stopDrag();
            mouseEvent.consume();
        }
    }

    private void handleHeaderDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.performDrag(mouseEvent);
        }
    }

    private double getDragDelta(double d, double d2) {
        if (((TabPane)this.getSkinnable()).getSide().equals((Object)Side.TOP) || ((TabPane)this.getSkinnable()).getSide().equals((Object)Side.RIGHT)) {
            return d - d2;
        }
        return d2 - d;
    }

    private int deriveTabHeaderLayoutXDirection() {
        if (((TabPane)this.getSkinnable()).getSide().equals((Object)Side.TOP) || ((TabPane)this.getSkinnable()).getSide().equals((Object)Side.RIGHT)) {
            return 1;
        }
        return -1;
    }

    private void performDrag(MouseEvent mouseEvent) {
        double d;
        if (this.dragState == DragState.NONE) {
            return;
        }
        int n = 0;
        double d2 = this.getHeaderRegionLocalX(mouseEvent);
        double d3 = this.getDragDelta(d2, this.dragEventPrevLoc);
        if (d3 > 0.0) {
            n = 1;
        } else if (d3 < 0.0) {
            n = -1;
        }
        if (n != 0 && this.prevDragDirection != n) {
            this.stopAnim(this.dropHeaderAnim);
            this.prevDragDirection = n;
        }
        if ((d = this.dragTabHeader.getLayoutX() + (double)this.xLayoutDirection * d3) >= 0.0 && d + this.dragTabHeader.getWidth() <= this.headersRegion.getWidth()) {
            this.dragState = DragState.REORDER;
            this.dragTabHeader.setLayoutX(d);
            Bounds bounds = this.dragTabHeader.getBoundsInParent();
            if (n == 1) {
                for (int i = this.dragTabHeaderIndex + 1; i < this.headersRegion.getChildren().size(); ++i) {
                    Bounds bounds2;
                    this.dropTabHeader = (TabHeaderSkin)((Object)this.headersRegion.getChildren().get(i));
                    if (this.dropAnimHeader == this.dropTabHeader) continue;
                    double d4 = this.xLayoutDirection == 1 ? bounds.getMaxX() - bounds2.getMinX() : bounds2.getMaxX() - bounds.getMinX();
                    if (d4 > (bounds2 = this.dropTabHeader.getBoundsInParent()).getWidth() * 0.75) {
                        this.stopAnim(this.dropHeaderAnim);
                        this.dropHeaderTransitionX = (double)this.xLayoutDirection * -bounds.getWidth();
                        this.dragHeaderDestX = this.xLayoutDirection == 1 ? bounds2.getMaxX() - bounds.getWidth() : bounds2.getMinX();
                        this.startHeaderReorderingAnim();
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = this.dragTabHeaderIndex - 1; i >= 0; --i) {
                    Bounds bounds3;
                    this.dropTabHeader = (TabHeaderSkin)((Object)this.headersRegion.getChildren().get(i));
                    if (this.dropAnimHeader == this.dropTabHeader) continue;
                    double d5 = this.xLayoutDirection == 1 ? bounds3.getMaxX() - bounds.getMinX() : bounds.getMaxX() - bounds3.getMinX();
                    if (d5 > (bounds3 = this.dropTabHeader.getBoundsInParent()).getWidth() * 0.75) {
                        this.stopAnim(this.dropHeaderAnim);
                        this.dropHeaderTransitionX = (double)this.xLayoutDirection * bounds.getWidth();
                        this.dragHeaderDestX = this.xLayoutDirection == 1 ? bounds3.getMinX() : bounds3.getMaxX() - bounds.getWidth();
                        this.startHeaderReorderingAnim();
                        continue;
                    }
                    break;
                }
            }
        }
        this.dragEventPrevLoc = d2;
        mouseEvent.consume();
    }

    private void startDrag(MouseEvent mouseEvent) {
        this.stopAnim(this.dropHeaderAnim);
        this.stopAnim(this.dragHeaderAnim);
        this.dragTabHeader = (TabHeaderSkin)((Object)mouseEvent.getSource());
        if (this.dragTabHeader != null) {
            this.dragState = DragState.START;
            this.xLayoutDirection = this.deriveTabHeaderLayoutXDirection();
            this.dragEventPrevLoc = this.getHeaderRegionLocalX(mouseEvent);
            this.dragTabHeaderStartIndex = this.dragTabHeaderIndex = this.headersRegion.getChildren().indexOf((Object)this.dragTabHeader);
            this.dragTabHeader.setViewOrder(0.0);
            this.dragHeaderDestX = this.dragTabHeader.getLayoutX();
        }
    }

    private double getHeaderRegionLocalX(MouseEvent mouseEvent) {
        Point2D point2D = this.headersRegion.sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY());
        return point2D.getX();
    }

    private void stopDrag() {
        if (this.dragState == DragState.START) {
            this.resetDrag();
        } else if (this.dragState == DragState.REORDER) {
            this.dragHeaderSourceX = this.dragTabHeader.getLayoutX();
            this.dragHeaderTransitionX = this.dragHeaderDestX - this.dragHeaderSourceX;
            this.dragHeaderAnim.playFromStart();
        }
        this.tabHeaderArea.invalidateScrollOffset();
    }

    private void reorderTabs() {
        if (this.dragTabHeaderIndex != this.dragTabHeaderStartIndex) {
            ((TabObservableList)((TabPane)this.getSkinnable()).getTabs()).reorder((Tab)((TabPane)this.getSkinnable()).getTabs().get(this.dragTabHeaderStartIndex), (Tab)((TabPane)this.getSkinnable()).getTabs().get(this.dragTabHeaderIndex));
        }
    }

    private void resetDrag() {
        this.dragState = DragState.NONE;
        this.dragTabHeader.setViewOrder(1.0);
        this.dragTabHeader = null;
        this.dropTabHeader = null;
        this.headersRegion.requestLayout();
    }

    private void startHeaderReorderingAnim() {
        this.dropAnimHeader = this.dropTabHeader;
        this.dropHeaderSourceX = this.dropAnimHeader.getLayoutX();
        this.dropHeaderAnim.playFromStart();
    }

    private void completeHeaderReordering() {
        if (this.dropAnimHeader != null) {
            this.headersRegion.getChildren().remove((Object)this.dropAnimHeader);
            this.headersRegion.getChildren().add(this.dragTabHeaderIndex, (Object)this.dropAnimHeader);
            this.dropAnimHeader = null;
            this.headersRegion.requestLayout();
            this.dragTabHeaderIndex = this.headersRegion.getChildren().indexOf((Object)this.dragTabHeader);
        }
    }

    private void stopAnim(Animation animation) {
        if (animation.getStatus() == Animation.Status.RUNNING) {
            animation.getOnFinished().handle(null);
            animation.stop();
        }
    }

    ContextMenu test_getTabsMenu() {
        return this.tabHeaderArea.controlButtons.popup;
    }

    void test_disableAnimations() {
        this.closeTabAnimation.set((Object)TabAnimation.NONE);
        this.openTabAnimation.set((Object)TabAnimation.NONE);
    }

    double test_getHeaderAreaScrollOffset() {
        return this.tabHeaderArea.getScrollOffset();
    }

    void test_setHeaderAreaScrollOffset(double d) {
        this.tabHeaderArea.setScrollOffset(d);
    }

    boolean test_isTabsFit() {
        return this.tabHeaderArea.tabsFit();
    }

    private static enum TabAnimation {
        NONE,
        GROW;

    }

    class TabHeaderArea
    extends StackPane {
        private Rectangle headerClip;
        private StackPane headersRegion;
        private StackPane headerBackground;
        private TabControlButtons controlButtons;
        private boolean measureClosingTabs;
        private double scrollOffset;
        private boolean scrollOffsetDirty;
        final /* synthetic */ TabPaneSkin this$0;

        public TabHeaderArea(TabPaneSkin tabPaneSkin) {
            TabPaneSkin tabPaneSkin2 = tabPaneSkin;
            Objects.requireNonNull(tabPaneSkin2);
            this.this$0 = tabPaneSkin2;
            this.measureClosingTabs = false;
            this.scrollOffsetDirty = true;
            this.getStyleClass().setAll((Object[])new String[]{"tab-header-area"});
            this.setManaged(false);
            TabPane tabPane = (TabPane)tabPaneSkin.getSkinnable();
            this.headerClip = new Rectangle();
            this.headersRegion = new StackPane(this){
                final /* synthetic */ TabHeaderArea this$1;
                {
                    TabHeaderArea tabHeaderArea2 = tabHeaderArea;
                    Objects.requireNonNull(tabHeaderArea2);
                    this.this$1 = tabHeaderArea2;
                }

                protected double computePrefWidth(double d) {
                    double d2 = 0.0;
                    for (Node node : this.getChildren()) {
                        TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)node;
                        if (!tabHeaderSkin.isVisible() || !this.this$1.measureClosingTabs && tabHeaderSkin.isClosing) continue;
                        d2 += tabHeaderSkin.prefWidth(d);
                    }
                    return this.snapSizeX(d2) + this.snappedLeftInset() + this.snappedRightInset();
                }

                protected double computePrefHeight(double d) {
                    double d2 = 0.0;
                    for (Node node : this.getChildren()) {
                        TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)node;
                        d2 = Math.max(d2, tabHeaderSkin.prefHeight(d));
                    }
                    return this.snapSizeY(d2) + this.snappedTopInset() + this.snappedBottomInset();
                }

                protected void layoutChildren() {
                    if (this.this$1.tabsFit()) {
                        this.this$1.setScrollOffset(0.0);
                    } else {
                        if (this.this$1.scrollOffsetDirty) {
                            this.this$1.ensureSelectedTabIsVisible();
                            this.this$1.scrollOffsetDirty = false;
                        }
                        this.this$1.validateScrollOffset();
                    }
                    Side side = ((TabPane)this.this$1.this$0.getSkinnable()).getSide();
                    double d = this.snapSizeY(this.prefHeight(-1.0));
                    double d2 = side.equals((Object)Side.LEFT) || side.equals((Object)Side.BOTTOM) ? this.snapSizeX(this.getWidth()) - this.this$1.getScrollOffset() : this.this$1.getScrollOffset();
                    this.this$1.updateHeaderClip();
                    for (Node node : this.getChildren()) {
                        double d3;
                        TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)node;
                        double d4 = this.snapSizeX(tabHeaderSkin.prefWidth(-1.0) * tabHeaderSkin.animationTransition.get());
                        double d5 = this.snapSizeY(tabHeaderSkin.prefHeight(-1.0));
                        tabHeaderSkin.resize(d4, d5);
                        double d6 = d3 = side.equals((Object)Side.BOTTOM) ? 0.0 : d - d5 - this.snappedBottomInset();
                        if (side.equals((Object)Side.LEFT) || side.equals((Object)Side.BOTTOM)) {
                            d2 -= d4;
                            if (this.this$1.this$0.dragState == DragState.REORDER && (tabHeaderSkin == this.this$1.this$0.dragTabHeader || tabHeaderSkin == this.this$1.this$0.dropAnimHeader)) continue;
                            tabHeaderSkin.relocate(d2, d3);
                            continue;
                        }
                        if (this.this$1.this$0.dragState != DragState.REORDER || tabHeaderSkin != this.this$1.this$0.dragTabHeader && tabHeaderSkin != this.this$1.this$0.dropAnimHeader) {
                            tabHeaderSkin.relocate(d2, d3);
                        }
                        d2 += d4;
                    }
                }
            };
            this.headersRegion.getStyleClass().setAll((Object[])new String[]{"headers-region"});
            this.headersRegion.setClip((Node)this.headerClip);
            tabPaneSkin.setupReordering(this.headersRegion);
            this.headerBackground = new StackPane();
            this.headerBackground.getStyleClass().setAll((Object[])new String[]{"tab-header-background"});
            int n = 0;
            for (Tab tab : tabPane.getTabs()) {
                this.addTab(tab, n++);
            }
            this.controlButtons = new TabControlButtons(tabPaneSkin);
            this.controlButtons.setVisible(false);
            if (this.controlButtons.isVisible()) {
                this.controlButtons.setVisible(true);
            }
            this.getChildren().addAll((Object[])new Node[]{this.headerBackground, this.headersRegion, this.controlButtons});
            this.addEventHandler(ScrollEvent.SCROLL, scrollEvent -> {
                double d = scrollEvent.getDeltaX();
                double d2 = scrollEvent.getDeltaY();
                Side side = ((TabPane)tabPaneSkin.getSkinnable()).getSide();
                side = side == null ? Side.TOP : side;
                switch (side) {
                    default: {
                        d = Math.abs(d2) > Math.abs(d) ? d2 : d;
                        this.setScrollOffset(this.scrollOffset + d);
                        break;
                    }
                    case LEFT: 
                    case RIGHT: {
                        this.setScrollOffset(this.scrollOffset - d2);
                    }
                }
            });
        }

        private void updateHeaderClip() {
            Side side = ((TabPane)this.this$0.getSkinnable()).getSide();
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = this.firstTabIndent();
            double d8 = this.snapSizeX(this.controlButtons.prefWidth(-1.0));
            this.measureClosingTabs = true;
            double d9 = this.snapSizeX(this.headersRegion.prefWidth(-1.0));
            this.measureClosingTabs = false;
            double d10 = this.snapSizeY(this.headersRegion.prefHeight(-1.0));
            if (d8 > 0.0) {
                d8 += 10.0;
            }
            if (this.headersRegion.getEffect() instanceof DropShadow) {
                DropShadow dropShadow = (DropShadow)this.headersRegion.getEffect();
                d6 = dropShadow.getRadius();
            }
            d5 = this.snapSizeX(this.getWidth()) - d8 - d7;
            if (side.equals((Object)Side.LEFT) || side.equals((Object)Side.BOTTOM)) {
                if (d9 < d5) {
                    d3 = d9 + d6;
                } else {
                    d = d9 - d5;
                    d3 = d5 + d6;
                }
                d4 = d10;
            } else {
                d = -d6;
                d3 = (d9 < d5 ? d9 : d5) + d6;
                d4 = d10;
            }
            this.headerClip.setX(d);
            this.headerClip.setY(d2);
            this.headerClip.setWidth(d3);
            this.headerClip.setHeight(d4);
        }

        private void addTab(Tab tab, int n) {
            TabHeaderSkin tabHeaderSkin = new TabHeaderSkin(this.this$0, tab);
            this.headersRegion.getChildren().add(n, (Object)tabHeaderSkin);
            this.invalidateScrollOffset();
        }

        private void removeTab(Tab tab) {
            TabHeaderSkin tabHeaderSkin = this.getTabHeaderSkin(tab);
            if (tabHeaderSkin != null) {
                this.headersRegion.getChildren().remove((Object)tabHeaderSkin);
            }
            this.invalidateScrollOffset();
        }

        private void moveTab(int n, TabHeaderSkin tabHeaderSkin) {
            if (n != this.headersRegion.getChildren().indexOf((Object)tabHeaderSkin)) {
                this.headersRegion.getChildren().remove((Object)tabHeaderSkin);
                this.headersRegion.getChildren().add(n, (Object)tabHeaderSkin);
            }
            this.invalidateScrollOffset();
        }

        private TabHeaderSkin getTabHeaderSkin(Tab tab) {
            for (Node node : this.headersRegion.getChildren()) {
                TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)node;
                if (!tabHeaderSkin.getTab().equals(tab)) continue;
                return tabHeaderSkin;
            }
            return null;
        }

        private boolean tabsFit() {
            double d;
            double d2 = this.snapSizeX(this.headersRegion.prefWidth(-1.0));
            double d3 = d2 + (d = this.snapSizeX(this.controlButtons.prefWidth(-1.0))) + this.firstTabIndent() + 10.0;
            return d3 < this.getWidth();
        }

        private void ensureSelectedTabIsVisible() {
            double d = this.snapSizeX(this.this$0.isHorizontal() ? ((TabPane)this.this$0.getSkinnable()).getWidth() : ((TabPane)this.this$0.getSkinnable()).getHeight());
            double d2 = this.snapSizeX(this.controlButtons.getWidth());
            double d3 = d - d2 - this.firstTabIndent() - 10.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            for (Node node : this.headersRegion.getChildren()) {
                TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)node;
                double d7 = this.snapSizeX(tabHeaderSkin.prefWidth(-1.0));
                if (this.this$0.selectedTab != null && this.this$0.selectedTab.equals(tabHeaderSkin.getTab())) {
                    d5 = d4;
                    d6 = d7;
                }
                d4 += d7;
            }
            double d8 = this.getScrollOffset();
            double d9 = d5;
            double d10 = d5 + d6;
            double d11 = d3;
            if (d9 < -d8) {
                this.setScrollOffset(-d9);
            } else if (d10 > d11 - d8) {
                this.setScrollOffset(d11 - d10);
            }
        }

        public double getScrollOffset() {
            return this.scrollOffset;
        }

        public void invalidateScrollOffset() {
            this.scrollOffsetDirty = true;
        }

        private void validateScrollOffset() {
            this.setScrollOffset(this.getScrollOffset());
        }

        private void setScrollOffset(double d) {
            double d2 = this.snapSizeX(this.this$0.isHorizontal() ? ((TabPane)this.this$0.getSkinnable()).getWidth() : ((TabPane)this.this$0.getSkinnable()).getHeight());
            double d3 = this.snapSizeX(this.controlButtons.getWidth());
            double d4 = d2 - d3 - this.firstTabIndent() - 10.0;
            double d5 = 0.0;
            for (Node node : this.headersRegion.getChildren()) {
                TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)node;
                double d6 = this.snapSizeX(tabHeaderSkin.prefWidth(-1.0));
                d5 += d6;
            }
            double d7 = d4 - d > d5 && d < 0.0 ? d4 - d5 : (d > 0.0 ? 0.0 : d);
            if (Math.abs(d7 - this.scrollOffset) > 0.001) {
                this.scrollOffset = d7;
                this.headersRegion.requestLayout();
            }
        }

        private double firstTabIndent() {
            switch (((TabPane)this.this$0.getSkinnable()).getSide()) {
                case TOP: 
                case BOTTOM: {
                    return this.snappedLeftInset();
                }
                case LEFT: 
                case RIGHT: {
                    return this.snappedTopInset();
                }
            }
            return 0.0;
        }

        protected double computePrefWidth(double d) {
            double d2 = this.this$0.isHorizontal() ? this.snappedLeftInset() + this.snappedRightInset() : this.snappedTopInset() + this.snappedBottomInset();
            return this.snapSizeX(this.headersRegion.prefWidth(d)) + this.controlButtons.prefWidth(d) + this.firstTabIndent() + 10.0 + d2;
        }

        protected double computePrefHeight(double d) {
            double d2 = this.this$0.isHorizontal() ? this.snappedTopInset() + this.snappedBottomInset() : this.snappedLeftInset() + this.snappedRightInset();
            return this.snapSizeY(this.headersRegion.prefHeight(-1.0)) + d2;
        }

        public double getBaselineOffset() {
            if (((TabPane)this.this$0.getSkinnable()).getSide() == Side.TOP) {
                return this.headersRegion.getBaselineOffset() + this.snappedTopInset();
            }
            return 0.0;
        }

        protected void layoutChildren() {
            double d = this.snappedLeftInset();
            double d2 = this.snappedRightInset();
            double d3 = this.snappedTopInset();
            double d4 = this.snappedBottomInset();
            double d5 = this.snapSizeX(this.getWidth()) - (this.this$0.isHorizontal() ? d + d2 : d3 + d4);
            double d6 = this.snapSizeY(this.getHeight()) - (this.this$0.isHorizontal() ? d3 + d4 : d + d2);
            double d7 = this.snapSizeY(this.prefHeight(-1.0));
            double d8 = this.snapSizeX(this.headersRegion.prefWidth(-1.0));
            double d9 = this.snapSizeY(this.headersRegion.prefHeight(-1.0));
            this.controlButtons.showTabsMenu(!this.tabsFit());
            this.updateHeaderClip();
            this.headersRegion.requestLayout();
            double d10 = this.snapSizeX(this.controlButtons.prefWidth(-1.0));
            double d11 = this.controlButtons.prefHeight(d10);
            this.controlButtons.resize(d10, d11);
            this.headersRegion.resize(d8, d9);
            if (this.this$0.isFloatingStyleClass()) {
                this.headerBackground.setVisible(false);
            } else {
                this.headerBackground.resize(this.snapSizeX(this.getWidth()), this.snapSizeY(this.getHeight()));
                this.headerBackground.setVisible(true);
            }
            double d12 = 0.0;
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            Side side = ((TabPane)this.this$0.getSkinnable()).getSide();
            if (side.equals((Object)Side.TOP)) {
                d12 = d;
                d13 = d7 - d9 - d4;
                d14 = d5 - d10 + d;
                d15 = this.snapSizeY(this.getHeight()) - d11 - d4;
            } else if (side.equals((Object)Side.RIGHT)) {
                d12 = d3;
                d13 = d7 - d9 - d;
                d14 = d5 - d10 + d3;
                d15 = this.snapSizeY(this.getHeight()) - d11 - d;
            } else if (side.equals((Object)Side.BOTTOM)) {
                d12 = this.snapSizeX(this.getWidth()) - d8 - d;
                d13 = d7 - d9 - d3;
                d14 = d2;
                d15 = this.snapSizeY(this.getHeight()) - d11 - d3;
            } else if (side.equals((Object)Side.LEFT)) {
                d12 = this.snapSizeX(this.getWidth()) - d8 - d3;
                d13 = d7 - d9 - d2;
                d14 = d;
                d15 = this.snapSizeY(this.getHeight()) - d11 - d2;
            }
            if (this.headerBackground.isVisible()) {
                this.positionInArea((Node)this.headerBackground, 0.0, 0.0, this.snapSizeX(this.getWidth()), this.snapSizeY(this.getHeight()), 0.0, HPos.CENTER, VPos.CENTER);
            }
            this.positionInArea((Node)this.headersRegion, d12, d13, d5, d6, 0.0, HPos.LEFT, VPos.CENTER);
            this.positionInArea((Node)this.controlButtons, d14, d15, d10, d11, 0.0, HPos.CENTER, VPos.CENTER);
        }

        void dispose() {
            for (Node node : this.headersRegion.getChildren()) {
                TabHeaderSkin tabHeaderSkin = (TabHeaderSkin)node;
                tabHeaderSkin.dispose();
            }
            this.controlButtons.dispose();
        }
    }

    static class TabContentRegion
    extends StackPane {
        private Tab tab;
        private InvalidationListener tabContentListener = observable -> this.updateContent();
        private InvalidationListener tabSelectedListener = new InvalidationListener(this){
            final /* synthetic */ TabContentRegion this$0;
            {
                TabContentRegion tabContentRegion2 = tabContentRegion;
                Objects.requireNonNull(tabContentRegion2);
                this.this$0 = tabContentRegion2;
            }

            public void invalidated(Observable observable) {
                this.this$0.setVisible(this.this$0.tab.isSelected());
            }
        };
        private WeakInvalidationListener weakTabContentListener = new WeakInvalidationListener(this.tabContentListener);
        private WeakInvalidationListener weakTabSelectedListener = new WeakInvalidationListener(this.tabSelectedListener);

        public Tab getTab() {
            return this.tab;
        }

        public TabContentRegion(Tab tab) {
            this.getStyleClass().setAll((Object[])new String[]{"tab-content-area"});
            this.setManaged(false);
            this.tab = tab;
            this.updateContent();
            this.setVisible(tab.isSelected());
            tab.selectedProperty().addListener((InvalidationListener)this.weakTabSelectedListener);
            tab.contentProperty().addListener((InvalidationListener)this.weakTabContentListener);
        }

        private void updateContent() {
            Node node = this.getTab().getContent();
            if (node == null) {
                this.getChildren().clear();
            } else {
                this.getChildren().setAll((Object[])new Node[]{node});
            }
        }

        public void dispose() {
            this.tab.selectedProperty().removeListener((InvalidationListener)this.weakTabSelectedListener);
            this.tab.contentProperty().removeListener((InvalidationListener)this.weakTabContentListener);
        }
    }

    class TabHeaderSkin
    extends StackPane {
        private final Tab tab;
        private Label label;
        private StackPane closeBtn;
        private StackPane inner;
        private Tooltip oldTooltip;
        private Tooltip tooltip;
        private Rectangle clip;
        private boolean isClosing;
        private LambdaMultiplePropertyChangeListenerHandler listener;
        private final ListChangeListener<String> styleClassListener;
        private final WeakListChangeListener<String> weakStyleClassListener;
        private final DoubleProperty animationTransition;
        private TabAnimationState animationState;
        private Timeline currentAnimation;
        final /* synthetic */ TabPaneSkin this$0;

        public Tab getTab() {
            return this.tab;
        }

        public TabHeaderSkin(TabPaneSkin tabPaneSkin, Tab tab) {
            TabPaneSkin tabPaneSkin2 = tabPaneSkin;
            Objects.requireNonNull(tabPaneSkin2);
            this.this$0 = tabPaneSkin2;
            this.isClosing = false;
            this.listener = new LambdaMultiplePropertyChangeListenerHandler();
            this.styleClassListener = new ListChangeListener<String>(this){
                final /* synthetic */ TabHeaderSkin this$1;
                {
                    TabHeaderSkin tabHeaderSkin2 = tabHeaderSkin;
                    Objects.requireNonNull(tabHeaderSkin2);
                    this.this$1 = tabHeaderSkin2;
                }

                public void onChanged(ListChangeListener.Change<? extends String> change) {
                    this.this$1.getStyleClass().setAll(this.this$1.tab.getStyleClass());
                }
            };
            this.weakStyleClassListener = new WeakListChangeListener(this.styleClassListener);
            this.animationTransition = new SimpleDoubleProperty(this, (Object)this, "animationTransition", 1.0){
                final /* synthetic */ TabHeaderSkin this$1;
                {
                    TabHeaderSkin tabHeaderSkin2 = tabHeaderSkin;
                    Objects.requireNonNull(tabHeaderSkin2);
                    this.this$1 = tabHeaderSkin2;
                    super(object, string, d);
                }

                protected void invalidated() {
                    this.this$1.requestLayout();
                }
            };
            this.animationState = TabAnimationState.NONE;
            this.getStyleClass().setAll(tab.getStyleClass());
            this.setId(tab.getId());
            this.setStyle(tab.getStyle());
            this.setAccessibleRole(AccessibleRole.TAB_ITEM);
            this.setViewOrder(1.0);
            this.tab = tab;
            this.clip = new Rectangle();
            this.setClip((Node)this.clip);
            this.label = new Label(tab.getText(), tab.getGraphic());
            this.label.getStyleClass().setAll((Object[])new String[]{"tab-label"});
            this.closeBtn = new StackPane(this){
                final /* synthetic */ TabHeaderSkin this$1;
                {
                    TabHeaderSkin tabHeaderSkin2 = tabHeaderSkin;
                    Objects.requireNonNull(tabHeaderSkin2);
                    this.this$1 = tabHeaderSkin2;
                }

                protected double computePrefWidth(double d) {
                    return CLOSE_BTN_SIZE;
                }

                protected double computePrefHeight(double d) {
                    return CLOSE_BTN_SIZE;
                }

                public void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
                    switch (accessibleAction) {
                        case FIRE: {
                            Tab tab = this.this$1.getTab();
                            if (!this.this$1.this$0.behavior.canCloseTab(tab)) break;
                            this.this$1.this$0.behavior.closeTab(tab);
                            this.setOnMousePressed(null);
                            break;
                        }
                        default: {
                            super.executeAccessibleAction(accessibleAction, objectArray);
                        }
                    }
                }
            };
            this.closeBtn.setAccessibleRole(AccessibleRole.BUTTON);
            this.closeBtn.setAccessibleText(ControlResources.getString("Accessibility.title.TabPane.CloseButton"));
            this.closeBtn.getStyleClass().setAll((Object[])new String[]{"tab-close-button"});
            this.closeBtn.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(this){
                final /* synthetic */ TabHeaderSkin this$1;
                {
                    TabHeaderSkin tabHeaderSkin2 = tabHeaderSkin;
                    Objects.requireNonNull(tabHeaderSkin2);
                    this.this$1 = tabHeaderSkin2;
                }

                public void handle(MouseEvent mouseEvent) {
                    Tab tab = this.this$1.getTab();
                    if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && this.this$1.this$0.behavior.canCloseTab(tab)) {
                        this.this$1.this$0.behavior.closeTab(tab);
                        this.this$1.setOnMousePressed(null);
                        mouseEvent.consume();
                    }
                }
            });
            this.updateGraphicRotation();
            final Region region = new Region();
            region.setMouseTransparent(true);
            region.getStyleClass().add((Object)"focus-indicator");
            this.inner = new StackPane(this){
                final /* synthetic */ TabHeaderSkin this$1;
                {
                    TabHeaderSkin tabHeaderSkin2 = tabHeaderSkin;
                    Objects.requireNonNull(tabHeaderSkin2);
                    this.this$1 = tabHeaderSkin2;
                }

                protected void layoutChildren() {
                    TabPane tabPane = (TabPane)this.this$1.this$0.getSkinnable();
                    double d = this.snappedTopInset();
                    double d2 = this.snappedRightInset();
                    double d3 = this.snappedBottomInset();
                    double d4 = this.snappedLeftInset();
                    double d5 = this.getWidth() - (d4 + d2);
                    double d6 = this.getHeight() - (d + d3);
                    double d7 = this.snapSizeX(this.this$1.label.prefWidth(-1.0));
                    double d8 = this.snapSizeY(this.this$1.label.prefHeight(-1.0));
                    double d9 = this.this$1.showCloseButton() ? this.snapSizeX(this.this$1.closeBtn.prefWidth(-1.0)) : 0.0;
                    double d10 = this.this$1.showCloseButton() ? this.snapSizeY(this.this$1.closeBtn.prefHeight(-1.0)) : 0.0;
                    double d11 = this.snapSizeX(tabPane.getTabMinWidth());
                    double d12 = this.snapSizeX(tabPane.getTabMaxWidth());
                    double d13 = this.snapSizeY(tabPane.getTabMaxHeight());
                    double d14 = d7;
                    double d15 = d7;
                    double d16 = d8;
                    double d17 = d14 + d9;
                    double d18 = Math.max(d16, d10);
                    if (d17 > d12 && d12 != Double.MAX_VALUE) {
                        d14 = d12 - d9;
                        d15 = d12 - d9;
                    } else if (d17 < d11) {
                        d14 = d11 - d9;
                    }
                    if (d18 > d13 && d13 != Double.MAX_VALUE) {
                        d16 = d13;
                    }
                    if (this.this$1.animationState != TabAnimationState.NONE) {
                        d14 *= this.this$1.animationTransition.get();
                        this.this$1.closeBtn.setVisible(false);
                    } else {
                        this.this$1.closeBtn.setVisible(this.this$1.showCloseButton());
                    }
                    this.this$1.label.resize(d15, d16);
                    double d19 = d4;
                    double d20 = (d12 < Double.MAX_VALUE ? Math.min(d5, d12) : d5) - d2 - d9;
                    this.positionInArea((Node)this.this$1.label, d19, d, d14, d6, 0.0, HPos.CENTER, VPos.CENTER);
                    if (this.this$1.closeBtn.isVisible()) {
                        this.this$1.closeBtn.resize(d9, d10);
                        this.positionInArea((Node)this.this$1.closeBtn, d20, d, d9, d6, 0.0, HPos.CENTER, VPos.CENTER);
                    }
                    int n = Utils.isMac() ? 2 : 3;
                    int n2 = Utils.isMac() ? 2 : 1;
                    region.resizeRelocate(d4 - (double)n2, d + (double)n, d5 + (double)(2 * n2), d6 - (double)(2 * n));
                }
            };
            this.inner.getStyleClass().add((Object)"tab-container");
            this.inner.setRotate(((TabPane)tabPaneSkin.getSkinnable()).getSide().equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
            this.inner.getChildren().addAll((Object[])new Node[]{this.label, this.closeBtn, region});
            this.getChildren().addAll((Object[])new Node[]{this.inner});
            this.tooltip = tab.getTooltip();
            if (this.tooltip != null) {
                Tooltip.install((Node)this, this.tooltip);
                this.oldTooltip = this.tooltip;
            }
            this.listener.registerChangeListener((ObservableValue<?>)tab.closableProperty(), observableValue -> {
                this.inner.requestLayout();
                this.requestLayout();
            });
            this.listener.registerChangeListener((ObservableValue<?>)tab.selectedProperty(), observableValue -> {
                this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, tab.isSelected());
                this.inner.requestLayout();
                this.requestLayout();
            });
            this.listener.registerChangeListener((ObservableValue<?>)tab.textProperty(), observableValue -> this.label.setText(this.getTab().getText()));
            this.listener.registerChangeListener((ObservableValue<?>)tab.graphicProperty(), observableValue -> this.label.setGraphic(this.getTab().getGraphic()));
            this.listener.registerChangeListener((ObservableValue<?>)tab.tooltipProperty(), observableValue -> {
                if (this.oldTooltip != null) {
                    Tooltip.uninstall((Node)this, this.oldTooltip);
                }
                this.tooltip = tab.getTooltip();
                if (this.tooltip != null) {
                    Tooltip.install((Node)this, this.tooltip);
                    this.oldTooltip = this.tooltip;
                }
            });
            this.listener.registerChangeListener((ObservableValue<?>)tab.disabledProperty(), observableValue -> this.updateTabDisabledState());
            this.listener.registerChangeListener((ObservableValue<?>)tab.getTabPane().disabledProperty(), observableValue -> this.updateTabDisabledState());
            this.listener.registerChangeListener((ObservableValue<?>)tab.styleProperty(), observableValue -> this.setStyle(tab.getStyle()));
            tab.getStyleClass().addListener(this.weakStyleClassListener);
            this.listener.registerChangeListener((ObservableValue<?>)((TabPane)tabPaneSkin.getSkinnable()).tabClosingPolicyProperty(), observableValue -> {
                this.inner.requestLayout();
                this.requestLayout();
            });
            this.listener.registerChangeListener((ObservableValue<?>)((TabPane)tabPaneSkin.getSkinnable()).sideProperty(), observableValue -> {
                Side side = ((TabPane)tabPaneSkin.getSkinnable()).getSide();
                this.pseudoClassStateChanged(TOP_PSEUDOCLASS_STATE, side == Side.TOP);
                this.pseudoClassStateChanged(RIGHT_PSEUDOCLASS_STATE, side == Side.RIGHT);
                this.pseudoClassStateChanged(BOTTOM_PSEUDOCLASS_STATE, side == Side.BOTTOM);
                this.pseudoClassStateChanged(LEFT_PSEUDOCLASS_STATE, side == Side.LEFT);
                this.inner.setRotate(side == Side.BOTTOM ? 180.0 : 0.0);
                if (((TabPane)tabPaneSkin.getSkinnable()).isRotateGraphic()) {
                    this.updateGraphicRotation();
                }
            });
            this.listener.registerChangeListener((ObservableValue<?>)((TabPane)tabPaneSkin.getSkinnable()).rotateGraphicProperty(), observableValue -> this.updateGraphicRotation());
            this.listener.registerChangeListener((ObservableValue<?>)((TabPane)tabPaneSkin.getSkinnable()).tabMinWidthProperty(), observableValue -> {
                this.requestLayout();
                ((TabPane)tabPaneSkin.getSkinnable()).requestLayout();
            });
            this.listener.registerChangeListener((ObservableValue<?>)((TabPane)tabPaneSkin.getSkinnable()).tabMaxWidthProperty(), observableValue -> {
                this.requestLayout();
                ((TabPane)tabPaneSkin.getSkinnable()).requestLayout();
            });
            this.listener.registerChangeListener((ObservableValue<?>)((TabPane)tabPaneSkin.getSkinnable()).tabMinHeightProperty(), observableValue -> {
                this.requestLayout();
                ((TabPane)tabPaneSkin.getSkinnable()).requestLayout();
            });
            this.listener.registerChangeListener((ObservableValue<?>)((TabPane)tabPaneSkin.getSkinnable()).tabMaxHeightProperty(), observableValue -> {
                this.requestLayout();
                ((TabPane)tabPaneSkin.getSkinnable()).requestLayout();
            });
            this.getProperties().put(Tab.class, (Object)tab);
            this.getProperties().put(ContextMenu.class, (Object)tab.getContextMenu());
            this.setOnContextMenuRequested(contextMenuEvent -> {
                if (this.getTab().getContextMenu() != null) {
                    this.getTab().getContextMenu().show((Node)this.inner, contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY());
                    contextMenuEvent.consume();
                }
            });
            this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(this){
                final /* synthetic */ TabHeaderSkin this$1;
                {
                    TabHeaderSkin tabHeaderSkin2 = tabHeaderSkin;
                    Objects.requireNonNull(tabHeaderSkin2);
                    this.this$1 = tabHeaderSkin2;
                }

                public void handle(MouseEvent mouseEvent) {
                    Tab tab = this.this$1.getTab();
                    if (tab.isDisable()) {
                        return;
                    }
                    if ((mouseEvent.getButton().equals((Object)MouseButton.MIDDLE) || mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) && tab.getContextMenu() != null && tab.getContextMenu().isShowing()) {
                        tab.getContextMenu().hide();
                    }
                    if (mouseEvent.getButton().equals((Object)MouseButton.MIDDLE)) {
                        if (this.this$1.showCloseButton() && this.this$1.this$0.behavior.canCloseTab(tab)) {
                            this.this$1.dispose();
                            this.this$1.this$0.behavior.closeTab(tab);
                        }
                    } else if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
                        this.this$1.this$0.behavior.selectTab(tab);
                    }
                }
            });
            this.pseudoClassStateChanged(SELECTED_PSEUDOCLASS_STATE, tab.isSelected());
            this.pseudoClassStateChanged(DISABLED_PSEUDOCLASS_STATE, tab.isDisabled());
            Side side = ((TabPane)tabPaneSkin.getSkinnable()).getSide();
            this.pseudoClassStateChanged(TOP_PSEUDOCLASS_STATE, side == Side.TOP);
            this.pseudoClassStateChanged(RIGHT_PSEUDOCLASS_STATE, side == Side.RIGHT);
            this.pseudoClassStateChanged(BOTTOM_PSEUDOCLASS_STATE, side == Side.BOTTOM);
            this.pseudoClassStateChanged(LEFT_PSEUDOCLASS_STATE, side == Side.LEFT);
        }

        private void updateTabDisabledState() {
            this.pseudoClassStateChanged(DISABLED_PSEUDOCLASS_STATE, this.tab.isDisabled());
            this.inner.requestLayout();
            this.requestLayout();
        }

        private void updateGraphicRotation() {
            if (this.label.getGraphic() != null) {
                this.label.getGraphic().setRotate(((TabPane)this.this$0.getSkinnable()).isRotateGraphic() ? 0.0 : (double)(((TabPane)this.this$0.getSkinnable()).getSide().equals((Object)Side.RIGHT) ? -90.0f : (((TabPane)this.this$0.getSkinnable()).getSide().equals((Object)Side.LEFT) ? 90.0f : 0.0f)));
            }
        }

        private boolean showCloseButton() {
            return this.tab.isClosable() && (((TabPane)this.this$0.getSkinnable()).getTabClosingPolicy().equals((Object)TabPane.TabClosingPolicy.ALL_TABS) || ((TabPane)this.this$0.getSkinnable()).getTabClosingPolicy().equals((Object)TabPane.TabClosingPolicy.SELECTED_TAB) && this.tab.isSelected());
        }

        private void dispose() {
            this.tab.getStyleClass().removeListener(this.weakStyleClassListener);
            this.listener.dispose();
            this.setOnContextMenuRequested(null);
            this.setOnMousePressed(null);
        }

        protected double computePrefWidth(double d) {
            double d2 = this.snapSizeX(((TabPane)this.this$0.getSkinnable()).getTabMinWidth());
            double d3 = this.snapSizeX(((TabPane)this.this$0.getSkinnable()).getTabMaxWidth());
            double d4 = this.snappedRightInset();
            double d5 = this.snappedLeftInset();
            double d6 = this.snapSizeX(this.label.prefWidth(-1.0));
            if (this.showCloseButton()) {
                d6 += this.snapSizeX(this.closeBtn.prefWidth(-1.0));
            }
            if (d6 > d3) {
                d6 = d3;
            } else if (d6 < d2) {
                d6 = d2;
            }
            return d6 += d4 + d5;
        }

        protected double computePrefHeight(double d) {
            double d2 = this.snapSizeY(((TabPane)this.this$0.getSkinnable()).getTabMinHeight());
            double d3 = this.snapSizeY(((TabPane)this.this$0.getSkinnable()).getTabMaxHeight());
            double d4 = this.snappedTopInset();
            double d5 = this.snappedBottomInset();
            double d6 = this.snapSizeY(this.label.prefHeight(d));
            if (d6 > d3) {
                d6 = d3;
            } else if (d6 < d2) {
                d6 = d2;
            }
            return d6 += d4 + d5;
        }

        protected void layoutChildren() {
            double d = (this.snapSizeX(this.getWidth()) - this.snappedRightInset() - this.snappedLeftInset()) * this.animationTransition.getValue();
            this.inner.resize(d, this.snapSizeY(this.getHeight()) - this.snappedTopInset() - this.snappedBottomInset());
            this.inner.relocate(this.snappedLeftInset(), this.snappedTopInset());
        }

        protected void setWidth(double d) {
            super.setWidth(d);
            this.clip.setWidth(d);
        }

        protected void setHeight(double d) {
            super.setHeight(d);
            this.clip.setHeight(d);
        }

        public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
            switch (accessibleAttribute) {
                case TEXT: {
                    return this.getTab().getText();
                }
                case SELECTED: {
                    return this.this$0.selectedTab == this.getTab();
                }
            }
            return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
        }

        public void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
            switch (accessibleAction) {
                case REQUEST_FOCUS: {
                    ((TabPane)this.this$0.getSkinnable()).getSelectionModel().select(this.getTab());
                    break;
                }
                default: {
                    super.executeAccessibleAction(accessibleAction, objectArray);
                }
            }
        }
    }

    private static enum TabAnimationState {
        SHOWING,
        HIDING,
        NONE;

    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
        private static final CssMetaData<TabPane, TabAnimation> OPEN_TAB_ANIMATION;
        private static final CssMetaData<TabPane, TabAnimation> CLOSE_TAB_ANIMATION;

        private StyleableProperties() {
        }

        static {
            OPEN_TAB_ANIMATION = new CssMetaData<TabPane, TabAnimation>("-fx-open-tab-animation", (StyleConverter)new EnumConverter(TabAnimation.class), TabAnimation.GROW){

                public boolean isSettable(TabPane tabPane) {
                    return true;
                }

                public StyleableProperty<TabAnimation> getStyleableProperty(TabPane tabPane) {
                    TabPaneSkin tabPaneSkin = (TabPaneSkin)tabPane.getSkin();
                    return (StyleableProperty)tabPaneSkin.openTabAnimation;
                }
            };
            CLOSE_TAB_ANIMATION = new CssMetaData<TabPane, TabAnimation>("-fx-close-tab-animation", (StyleConverter)new EnumConverter(TabAnimation.class), TabAnimation.GROW){

                public boolean isSettable(TabPane tabPane) {
                    return true;
                }

                public StyleableProperty<TabAnimation> getStyleableProperty(TabPane tabPane) {
                    TabPaneSkin tabPaneSkin = (TabPaneSkin)tabPane.getSkin();
                    return (StyleableProperty)tabPaneSkin.closeTabAnimation;
                }
            };
            ArrayList arrayList = new ArrayList(SkinBase.getClassCssMetaData());
            arrayList.add(OPEN_TAB_ANIMATION);
            arrayList.add(CLOSE_TAB_ANIMATION);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    private static enum DragState {
        NONE,
        START,
        REORDER;

    }

    class TabControlButtons
    extends StackPane {
        private StackPane inner;
        private StackPane downArrow;
        private Pane downArrowBtn;
        private boolean showControlButtons;
        private ContextMenu popup;
        InvalidationListener sidePropListener;
        ListChangeListener<Tab> tabsListenerForPopup;
        WeakInvalidationListener weakSidePropListener;
        WeakListChangeListener weakTabsListenerForPopup;
        private boolean showTabsMenu;
        final /* synthetic */ TabPaneSkin this$0;

        public TabControlButtons(TabPaneSkin tabPaneSkin) {
            TabPaneSkin tabPaneSkin2 = tabPaneSkin;
            Objects.requireNonNull(tabPaneSkin2);
            this.this$0 = tabPaneSkin2;
            this.sidePropListener = observable -> {
                Side side = ((TabPane)this.this$0.getSkinnable()).getSide();
                this.downArrow.setRotate(side.equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
            };
            this.tabsListenerForPopup = change -> this.setupPopupMenu();
            this.weakSidePropListener = new WeakInvalidationListener(this.sidePropListener);
            this.weakTabsListenerForPopup = new WeakListChangeListener(this.tabsListenerForPopup);
            this.showTabsMenu = false;
            this.getStyleClass().setAll((Object[])new String[]{"control-buttons-tab"});
            TabPane tabPane = (TabPane)tabPaneSkin.getSkinnable();
            this.downArrowBtn = new Pane();
            this.downArrowBtn.getStyleClass().setAll((Object[])new String[]{"tab-down-button"});
            this.downArrowBtn.setVisible(this.isShowTabsMenu());
            this.downArrow = new StackPane();
            this.downArrow.setManaged(false);
            this.downArrow.getStyleClass().setAll((Object[])new String[]{"arrow"});
            this.downArrow.setRotate(tabPane.getSide().equals((Object)Side.BOTTOM) ? 180.0 : 0.0);
            this.downArrowBtn.getChildren().add((Object)this.downArrow);
            this.downArrowBtn.setOnMouseClicked(mouseEvent -> this.showPopupMenu());
            this.setupPopupMenu();
            this.inner = new StackPane(this){
                final /* synthetic */ TabControlButtons this$1;
                {
                    TabControlButtons tabControlButtons2 = tabControlButtons;
                    Objects.requireNonNull(tabControlButtons2);
                    this.this$1 = tabControlButtons2;
                }

                protected double computePrefWidth(double d) {
                    double d2 = !this.this$1.isShowTabsMenu() ? 0.0 : this.snapSizeX(this.this$1.downArrow.prefWidth(this.getHeight())) + this.snapSizeX(this.this$1.downArrowBtn.prefWidth(this.getHeight()));
                    double d3 = 0.0;
                    if (this.this$1.isShowTabsMenu()) {
                        d3 += d2;
                    }
                    if (d3 > 0.0) {
                        d3 += this.snappedLeftInset() + this.snappedRightInset();
                    }
                    return d3;
                }

                protected double computePrefHeight(double d) {
                    double d2 = 0.0;
                    if (this.this$1.isShowTabsMenu()) {
                        d2 = Math.max(d2, this.snapSizeY(this.this$1.downArrowBtn.prefHeight(d)));
                    }
                    if (d2 > 0.0) {
                        d2 += this.snappedTopInset() + this.snappedBottomInset();
                    }
                    return d2;
                }

                protected void layoutChildren() {
                    if (this.this$1.isShowTabsMenu()) {
                        double d = 0.0;
                        double d2 = this.snappedTopInset();
                        double d3 = this.snapSizeX(this.getWidth()) - d + this.snappedLeftInset();
                        double d4 = this.snapSizeY(this.getHeight()) - d2 + this.snappedBottomInset();
                        this.positionArrow(this.this$1.downArrowBtn, this.this$1.downArrow, d, d2, d3, d4);
                    }
                }

                private void positionArrow(Pane pane, StackPane stackPane, double d, double d2, double d3, double d4) {
                    pane.resize(d3, d4);
                    this.positionInArea((Node)pane, d, d2, d3, d4, 0.0, HPos.CENTER, VPos.CENTER);
                    double d5 = this.snapSizeX(stackPane.prefWidth(-1.0));
                    double d6 = this.snapSizeY(stackPane.prefHeight(-1.0));
                    stackPane.resize(d5, d6);
                    this.positionInArea((Node)stackPane, pane.snappedLeftInset(), pane.snappedTopInset(), d3 - pane.snappedLeftInset() - pane.snappedRightInset(), d4 - pane.snappedTopInset() - pane.snappedBottomInset(), 0.0, HPos.CENTER, VPos.CENTER);
                }
            };
            this.inner.getStyleClass().add((Object)"container");
            this.inner.getChildren().add((Object)this.downArrowBtn);
            this.getChildren().add((Object)this.inner);
            tabPane.sideProperty().addListener((InvalidationListener)this.weakSidePropListener);
            tabPane.getTabs().addListener((ListChangeListener)this.weakTabsListenerForPopup);
            this.showControlButtons = false;
            if (this.isShowTabsMenu()) {
                this.showControlButtons = true;
                this.requestLayout();
            }
            this.getProperties().put(ContextMenu.class, (Object)this.popup);
        }

        void dispose() {
            ((TabPane)this.this$0.getSkinnable()).sideProperty().removeListener((InvalidationListener)this.weakSidePropListener);
            ((TabPane)this.this$0.getSkinnable()).getTabs().removeListener((ListChangeListener)this.weakTabsListenerForPopup);
        }

        private void showTabsMenu(boolean bl) {
            boolean bl2 = this.isShowTabsMenu();
            this.showTabsMenu = bl;
            if (this.showTabsMenu && !bl2) {
                this.downArrowBtn.setVisible(true);
                this.showControlButtons = true;
                this.inner.requestLayout();
                this.this$0.tabHeaderArea.requestLayout();
            } else if (!this.showTabsMenu && bl2) {
                this.hideControlButtons();
            }
        }

        private boolean isShowTabsMenu() {
            return this.showTabsMenu;
        }

        protected double computePrefWidth(double d) {
            double d2 = this.snapSizeX(this.inner.prefWidth(d));
            if (d2 > 0.0) {
                d2 += this.snappedLeftInset() + this.snappedRightInset();
            }
            return d2;
        }

        protected double computePrefHeight(double d) {
            return Math.max(((TabPane)this.this$0.getSkinnable()).getTabMinHeight(), this.snapSizeY(this.inner.prefHeight(d))) + this.snappedTopInset() + this.snappedBottomInset();
        }

        protected void layoutChildren() {
            double d = this.snappedLeftInset();
            double d2 = this.snappedTopInset();
            double d3 = this.snapSizeX(this.getWidth()) - d + this.snappedRightInset();
            double d4 = this.snapSizeY(this.getHeight()) - d2 + this.snappedBottomInset();
            if (this.showControlButtons) {
                this.showControlButtons();
                this.showControlButtons = false;
            }
            this.inner.resize(d3, d4);
            this.positionInArea((Node)this.inner, d, d2, d3, d4, 0.0, HPos.CENTER, VPos.BOTTOM);
        }

        private void showControlButtons() {
            this.setVisible(true);
            if (this.popup == null) {
                this.setupPopupMenu();
            }
        }

        private void hideControlButtons() {
            if (this.isShowTabsMenu()) {
                this.showControlButtons = true;
            } else {
                this.setVisible(false);
                this.clearPopupMenu();
                this.popup = null;
            }
            this.requestLayout();
        }

        private void setupPopupMenu() {
            if (this.popup == null) {
                this.popup = new ContextMenu();
            }
            this.clearPopupMenu();
            ToggleGroup toggleGroup = new ToggleGroup();
            ObservableList observableList = FXCollections.observableArrayList();
            for (Tab tab : ((TabPane)this.this$0.getSkinnable()).getTabs()) {
                TabMenuItem tabMenuItem = new TabMenuItem(tab);
                tabMenuItem.setToggleGroup(toggleGroup);
                tabMenuItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)actionEvent -> ((TabPane)this.this$0.getSkinnable()).getSelectionModel().select(tab)));
                observableList.add((Object)tabMenuItem);
            }
            this.popup.getItems().addAll((Collection)observableList);
        }

        private void clearPopupMenu() {
            for (MenuItem menuItem : this.popup.getItems()) {
                ((TabMenuItem)menuItem).dispose();
            }
            this.popup.getItems().clear();
        }

        private void showPopupMenu() {
            for (MenuItem menuItem : this.popup.getItems()) {
                TabMenuItem tabMenuItem = (TabMenuItem)menuItem;
                if (!this.this$0.selectedTab.equals(tabMenuItem.getTab())) continue;
                tabMenuItem.setSelected(true);
                break;
            }
            this.popup.show((Node)this.downArrowBtn, Side.BOTTOM, 0.0, 0.0);
        }
    }

    static class TabMenuItem
    extends RadioMenuItem {
        Tab tab;
        private InvalidationListener disableListener = new InvalidationListener(this){
            final /* synthetic */ TabMenuItem this$0;
            {
                TabMenuItem tabMenuItem2 = tabMenuItem;
                Objects.requireNonNull(tabMenuItem2);
                this.this$0 = tabMenuItem2;
            }

            public void invalidated(Observable observable) {
                this.this$0.setDisable(this.this$0.tab.isDisable());
            }
        };
        private WeakInvalidationListener weakDisableListener = new WeakInvalidationListener(this.disableListener);

        public TabMenuItem(Tab tab) {
            super(tab.getText(), TabPaneSkin.clone(tab.getGraphic()));
            this.tab = tab;
            this.setDisable(tab.isDisable());
            tab.disableProperty().addListener((InvalidationListener)this.weakDisableListener);
            this.textProperty().bind((ObservableValue)tab.textProperty());
        }

        public Tab getTab() {
            return this.tab;
        }

        public void dispose() {
            this.textProperty().unbind();
            this.tab.disableProperty().removeListener((InvalidationListener)this.weakDisableListener);
            this.tab = null;
        }
    }
}

