/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.beans.property.NullCoalescingPropertyBase;
import com.sun.javafx.css.media.ContextAwareness;
import com.sun.javafx.css.media.MediaQuery;
import com.sun.javafx.css.media.MediaQueryContext;
import com.sun.javafx.scene.NodeHelper;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.application.ColorScheme;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;

public final class SceneContext
implements Scene.Preferences,
MediaQueryContext {
    private final Scene scene;
    private final Map<MediaQuery, Boolean> viewportSizeAwareQueries = new IdentityHashMap<MediaQuery, Boolean>();
    private final Map<MediaQuery, Boolean> fullScreenAwareQueries = new IdentityHashMap<MediaQuery, Boolean>();
    private final MediaProperty<ColorScheme> colorScheme = new MediaProperty<ColorScheme>(this, "colorScheme", (ObservableValue<ColorScheme>)PlatformImpl.getPlatformPreferences().colorSchemeProperty());
    private final MediaProperty<Boolean> persistentScrollBars = new MediaProperty(this, "persistentScrollBars", PlatformImpl.getPlatformPreferences().persistentScrollBarsProperty());
    private final MediaProperty<Boolean> reducedMotion = new MediaProperty(this, "reducedMotion", PlatformImpl.getPlatformPreferences().reducedMotionProperty());
    private final MediaProperty<Boolean> reducedTransparency = new MediaProperty(this, "reducedTransparency", PlatformImpl.getPlatformPreferences().reducedTransparencyProperty());
    private final MediaProperty<Boolean> reducedData = new MediaProperty(this, "reducedData", PlatformImpl.getPlatformPreferences().reducedDataProperty());

    public SceneContext(Scene scene) {
        this.scene = scene;
        scene.windowProperty().flatMap(Window::showingProperty).orElse((Object)false).subscribe(this::onShowingChanged);
        scene.windowProperty().map(window -> {
            Stage stage;
            return window instanceof Stage ? (stage = (Stage)window) : null;
        }).flatMap(Stage::fullScreenProperty).subscribe(this::onFullScreenChanged);
    }

    public void notifyReapplyCSS() {
        this.viewportSizeAwareQueries.clear();
        this.fullScreenAwareQueries.clear();
    }

    public void notifySizeChanged() {
        Parent parent;
        boolean bl = this.viewportSizeAwareQueries.entrySet().stream().anyMatch(entry -> ((MediaQuery)entry.getKey()).evaluate(this) != ((Boolean)entry.getValue()).booleanValue());
        if (bl && (parent = this.scene.getRoot()) instanceof Node) {
            Parent parent2 = parent;
            NodeHelper.scheduleReapplyCSS(parent2);
        }
    }

    @Override
    public void notifyQueryEvaluated(MediaQuery mediaQuery, boolean bl) {
        int n = mediaQuery.getContextAwareness();
        if (ContextAwareness.VIEWPORT_SIZE.isSet(n)) {
            this.viewportSizeAwareQueries.put(mediaQuery, bl);
        }
        if (ContextAwareness.FULLSCREEN.isSet(n)) {
            this.fullScreenAwareQueries.put(mediaQuery, bl);
        }
    }

    @Override
    public double getWidth() {
        return this.scene.getWidth();
    }

    @Override
    public double getHeight() {
        return this.scene.getHeight();
    }

    @Override
    public boolean isFullScreen() {
        Stage stage;
        Window window = this.scene.getWindow();
        return window instanceof Stage && (stage = (Stage)window).isFullScreen();
    }

    @Override
    public ObjectProperty<ColorScheme> colorSchemeProperty() {
        return this.colorScheme;
    }

    @Override
    public ColorScheme getColorScheme() {
        return (ColorScheme)((Object)this.colorScheme.get());
    }

    @Override
    public void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme.set((Object)colorScheme);
    }

    @Override
    public ObjectProperty<Boolean> persistentScrollBarsProperty() {
        return this.persistentScrollBars;
    }

    @Override
    public boolean isPersistentScrollBars() {
        return (Boolean)this.persistentScrollBars.get();
    }

    @Override
    public void setPersistentScrollBars(Boolean bl) {
        this.persistentScrollBars.set(bl);
    }

    @Override
    public ObjectProperty<Boolean> reducedMotionProperty() {
        return this.reducedMotion;
    }

    @Override
    public boolean isReducedMotion() {
        return (Boolean)this.reducedMotion.get();
    }

    @Override
    public void setReducedMotion(Boolean bl) {
        this.reducedMotion.set(bl);
    }

    @Override
    public ObjectProperty<Boolean> reducedTransparencyProperty() {
        return this.reducedTransparency;
    }

    @Override
    public boolean isReducedTransparency() {
        return (Boolean)this.reducedTransparency.get();
    }

    @Override
    public void setReducedTransparency(Boolean bl) {
        this.reducedTransparency.set(bl);
    }

    @Override
    public ObjectProperty<Boolean> reducedDataProperty() {
        return this.reducedData;
    }

    @Override
    public boolean isReducedData() {
        return (Boolean)this.reducedData.get();
    }

    @Override
    public void setReducedData(Boolean bl) {
        this.reducedData.set(bl);
    }

    private void onShowingChanged(Boolean bl) {
        for (MediaProperty<Boolean> mediaProperty : List.of(this.colorScheme, this.persistentScrollBars, this.reducedData, this.reducedMotion, this.reducedTransparency)) {
            if (bl.booleanValue()) {
                mediaProperty.connect();
                continue;
            }
            mediaProperty.disconnect();
        }
    }

    private void onFullScreenChanged(Boolean bl) {
        Parent parent;
        boolean bl2 = this.fullScreenAwareQueries.entrySet().stream().anyMatch(entry -> ((MediaQuery)entry.getKey()).evaluate(this) != ((Boolean)entry.getValue()).booleanValue());
        if (bl2 && (parent = this.scene.getRoot()) instanceof Node) {
            Parent parent2 = parent;
            NodeHelper.scheduleReapplyCSS(parent2);
        }
    }

    private class MediaProperty<T>
    extends NullCoalescingPropertyBase<T> {
        private final String name;
        final /* synthetic */ SceneContext this$0;

        MediaProperty(SceneContext sceneContext, String string, ObservableValue<T> observableValue) {
            SceneContext sceneContext2 = sceneContext;
            Objects.requireNonNull(sceneContext2);
            this.this$0 = sceneContext2;
            super(observableValue);
            this.name = string;
        }

        public Object getBean() {
            return this.this$0.scene;
        }

        public String getName() {
            return this.name;
        }

        @Override
        protected void onInvalidated() {
            Parent parent = this.this$0.scene.getRoot();
            if (parent != null) {
                NodeHelper.scheduleReapplyCSS(parent);
            }
        }
    }
}

